/*:
 * @target MZ
 * @plugindesc 全般共通処理
 *
 *
 */
// 体力関連
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.Param = {
            disableConsumeHp: false,
        };
        function getHP() {
            const actor = $gameActors.actor(1);
            if (actor) {
                return actor.mp;
            }
            return 0;
        }
        Life.getHP = getHP;
        function getMaxHp() {
            const actor = $gameActors.actor(1);
            if (actor) {
                return actor.mmp;
            }
            return 0;
        }
        Life.getMaxHp = getMaxHp;
        function getHpRate() {
            const actor = $gameActors.actor(1);
            if (actor) {
                return actor.mpRate();
            }
            return 1;
        }
        Life.getHpRate = getHpRate;
        function setHp(value) {
            const actor = $gameActors.actor(1);
            if (!actor)
                return;
            actor.setMp(value);
        }
        Life.setHp = setHp;
        function getConsumeHp(baseValue) {
            if (Life.Param.disableConsumeHp) {
                return 0;
            }
            // 特性効果
            const res = Life.Status.calcConsumeHp(baseValue);
            return res;
        }
        Life.getConsumeHp = getConsumeHp;
        function isConsumeHp() {
            return !Life.Param.disableConsumeHp;
        }
        Life.isConsumeHp = isConsumeHp;
        function consumeHP(amount, disableAddFatigue) {
            if (Life.Param.disableConsumeHp) {
                return;
            }
            // MPをHP扱いとする
            $gameActors.actor(1)?.gainMp(-amount);
            if (!disableAddFatigue) {
                Life.Status.addFatigueByConsumeHp(amount);
            }
            Life.Stats.status.consumeHp(amount);
        }
        Life.consumeHP = consumeHP;
        function initializeParam() {
            Life.Param.disableConsumeHp = false;
        }
        Life.initializeParam = initializeParam;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function initializeSystemParameter() {
            Life.initializeParam();
        }
        Life.initializeSystemParameter = initializeSystemParameter;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeSystemParameter();
    };
})();
// アイテム、グループ
(function (Iz) {
    var Life;
    (function (Life) {
        Life.ItemGroupMax = 3;
        function isDisposableItem(itemId) {
            if (Life.isKeyItem(itemId))
                return false;
            const data = $dataItemAttribute[itemId];
            if (data) {
                return !data.impossible_dispose;
            }
            return true;
        }
        Life.isDisposableItem = isDisposableItem;
        function canGiftItem(itemId) {
            if (Life.isKeyItem(itemId))
                return false;
            const data = $dataItemAttribute[itemId];
            if (data) {
                return !data.disable_gift;
            }
            return true;
        }
        Life.canGiftItem = canGiftItem;
        function getItemGroups(itemId) {
            const list = [];
            const data = $dataItems[itemId];
            if (data) {
                const groupData = $dataItemGroup[itemId];
                if (groupData) {
                    if (groupData.group_1 > 0)
                        list.push(groupData.group_1);
                    if (groupData.group_2 > 0)
                        list.push(groupData.group_2);
                    if (groupData.group_3 > 0)
                        list.push(groupData.group_3);
                }
            }
            return list;
        }
        Life.getItemGroups = getItemGroups;
        function getItemGroupName(groupId) {
            const group = $dataGroup[groupId];
            return group ? group.name : "";
        }
        Life.getItemGroupName = getItemGroupName;
        function includeGroup(itemId, groupId) {
            if (groupId <= 0) {
                return false;
            }
            return !!getItemGroups(itemId).find((group) => group === groupId);
        }
        Life.includeGroup = includeGroup;
        function getItemNumByGroup(groupId) {
            let num = 0;
            $gameParty
                .items()
                .filter((item) => getItemGroups(item.id).find((group) => group === groupId))
                .forEach((item) => {
                num += $gameParty.numItems(item);
            });
            return num;
        }
        Life.getItemNumByGroup = getItemNumByGroup;
        function consumeItemByGroup(groupId, consumeNum) {
            if (consumeNum <= 0)
                return;
            if (getItemNumByGroup(groupId) < consumeNum) {
                console.warn(`グループID:${groupId} のアイテムが足りません`);
                return;
            }
            const list = $gameParty
                .items()
                .filter((item) => getItemGroups(item.id).find((group) => group === groupId))
                .sort((a, b) => a.price - b.price);
            let total = 0;
            for (let i = 0; i < list.length; i++) {
                const item = list[i];
                const num = Math.min(Math.max($gameParty.numItems(item), 0), consumeNum - total);
                $gameParty.gainItem(item, -num);
                total += num;
                if (total >= consumeNum) {
                    break;
                }
            }
        }
        Life.consumeItemByGroup = consumeItemByGroup;
        function getItemDescription(itemId, excludeEffect) {
            const item = $dataItems[itemId];
            if (!item)
                return "";
            const texts = [];
            // 効果
            if (!excludeEffect) {
                Life.ItemEffect.effects(itemId).forEach((e) => {
                    const text = e.text();
                    if (text) {
                        texts.push(Iz.String.format(Iz.Text.get("MENU_ITEMSLOT_DETAIL_EFFECT"), text));
                    }
                });
            }
            // 種
            if (Life.isSeed(itemId)) {
                const plantItemId = Life.getPlantId(itemId);
                const crop = $dataCrops[plantItemId];
                const plant = $dataItems[plantItemId];
                if (crop && plant) {
                    texts.push(Iz.String.format(Iz.Text.get("MENU_ITEMSLOT_DETAIL_GROW_DAYS"), crop.days_min));
                    texts.push(Iz.String.format(Iz.Text.get("MENU_ITEMSLOT_DETAIL_HARVEST_PRICE"), plant.price));
                }
            }
            if (item.description) {
                texts.push(item.description);
            }
            return texts.join("\n");
        }
        Life.getItemDescription = getItemDescription;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    function isItemData(data) {
        return data && "itypeId" in data;
    }
    const _Window_Help_setItem = Window_Help.prototype.setItem;
    Window_Help.prototype.setItem = function (item) {
        if (isItemData(item)) {
            const desc = Iz.Life.getItemDescription(item.id, true);
            this.setText(desc);
            return;
        }
        _Window_Help_setItem.call(this, item);
    };
})();
// 場所、マップ関連
(function (Iz) {
    var Life;
    (function (Life) {
        function includePlaceGroup(option) {
            const list = $dataPlaceGroupContent
                .filter((c) => !!c)
                .filter((c) => c.id === option.placeGroupId);
            return !!list
                .filter((data) => data.type === Iz.Life.Data.PlaceGroupType.Map)
                .find((data) => data.type_id === option.map);
        }
        Life.includePlaceGroup = includePlaceGroup;
        function includePlaceGroupMap(placeGroupId, mapId) {
            return includePlaceGroup({ placeGroupId: placeGroupId, map: mapId });
        }
        Life.includePlaceGroupMap = includePlaceGroupMap;
        function includePlaceGroupCharacter(placeGroupId, actorId) {
            const character = $globalMap.character(actorId);
            if (!character)
                return false;
            let mapId = 0;
            if (Iz.GlobalMap.IsNPC(character)) {
                if (character.validity) {
                    mapId = character.mapId();
                }
            }
            else {
                mapId = $gameMap.mapId();
            }
            return includePlaceGroupMap(placeGroupId, mapId);
        }
        Life.includePlaceGroupCharacter = includePlaceGroupCharacter;
        function isOutdoor(mapId) {
            return Iz.GlobalMap.isOutdoor(mapId);
        }
        Life.isOutdoor = isOutdoor;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// ユーティリティ処理
(function (Iz) {
    var Life;
    (function (Life) {
        // 自動で拡張するリスト
        class ExpansionList {
            constructor(clone, funcLimit) {
                this._clone = clone;
                this._funcLimit = funcLimit;
                this._list = [];
                this.refresh();
            }
            get(index) {
                this.refresh();
                let data = this._list[index];
                if (!data && index >= 0 && index < this._funcLimit()) {
                    data = Object.assign({}, this._clone());
                    data.index = index;
                    this._list[index] = data;
                }
                return data;
            }
            set(index, data) {
                const existData = this.get(index);
                if (!existData)
                    return;
                Iz.Obj.apply(existData, data);
            }
            refresh() {
                // 現在の長さに応じて調整
                const limit = this._funcLimit();
                if (this._list.length !== limit) {
                    const existList = this._list;
                    this._list = [];
                    this._list.length = limit;
                    for (let i = 0; i < limit; i++) {
                        this._list[i] = Object.assign({}, this._clone());
                        this._list[i].index = i;
                    }
                    const applyLen = Math.min(existList.length, limit);
                    for (let i = 0; i < applyLen; i++) {
                        this._list[i] = existList[i];
                    }
                }
            }
            values() {
                this.refresh();
                return [...this._list.values()];
            }
        }
        Life.ExpansionList = ExpansionList;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var EventUtil;
        (function (EventUtil) {
            function rotateCharacter(eventId, targetRotation, duration) {
                const sprite = getCharacter(eventId);
                if (!sprite)
                    return;
                sprite._rotationFrame = 0;
                sprite._rotationDuration = duration;
                const startRotation = sprite.rotation;
                const endRotation = targetRotation * (Math.PI / 180);
                sprite._rotationStep = (endRotation - startRotation) / duration;
                sprite._rotationEnd = endRotation;
            }
            EventUtil.rotateCharacter = rotateCharacter;
            function stopRotateCharacter(eventId, rotation) {
                const sprite = getCharacter(eventId);
                if (!sprite)
                    return;
                sprite.initilaizeRotation();
                sprite.rotation = rotation;
            }
            EventUtil.stopRotateCharacter = stopRotateCharacter;
            function getCharacter(eventId) {
                const scene = SceneManager._scene;
                if (!scene)
                    return;
                if (!(scene instanceof Scene_Map))
                    return;
                if (!scene._spriteset)
                    return;
                const sprite = scene._spriteset._characterSprites.find((s) => s._character instanceof Game_Event && s._character.eventId() === eventId);
                if (!sprite)
                    return;
                return sprite;
            }
        })(EventUtil = Life.EventUtil || (Life.EventUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Sprite_Character_update = Sprite_Character.prototype.update;
    Sprite_Character.prototype.update = function () {
        _Sprite_Character_update.call(this);
        this.updateRotation();
    };
    Sprite_Character.prototype.initilaizeRotation = function () {
        this._rotationFrame = 0;
        this._rotationStep = 0;
        this._rotationDuration = 0;
        this._rotationEnd = 0;
    };
    Sprite_Character.prototype.updateRotation = function () {
        if (!this._rotationStep)
            return;
        if (this._rotationFrame < this._rotationDuration) {
            this.rotation += this._rotationStep;
            this._rotationFrame++;
            return;
        }
        this.rotation = this._rotationEnd;
        this.initilaizeRotation();
    };
})();
//# sourceMappingURL=Shared.js.map