/*:
 * @target MZ
 * @plugindesc 倉庫、出荷箱
 *
 * @help
 * ※このプラグインはNYA_PH_Warehouse.jsの機能を利用しています
 * 本プラグインより前に該当のプラグインをONに設定してください
 *
 *
 * @param title
 * @text 出荷箱の名前(倉庫名)
 * @desc
 *
 *
 * @command sell
 * @text sell
 * @desc 出荷箱内のアイテムを売却
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.WarehouseSortIdOrder = true;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
var WarehouseUtil;
(function (WarehouseUtil) {
    function getItem(title, itemId) {
        const res = { id: itemId, num: 0 };
        const manager = PHPlugins.PHWarehouse;
        if (!Object.hasOwn(manager._warehouses, title))
            return res;
        const warehouse = manager._warehouses[title];
        if (!warehouse)
            return res;
        const category = "item";
        const quantities = warehouse.qtty[category];
        const item = quantities[itemId];
        if (!item)
            return res;
        res.num = item;
        return res;
    }
    WarehouseUtil.getItem = getItem;
    function getItemAll(title) {
        const manager = PHPlugins.PHWarehouse;
        if (!Object.hasOwn(manager._warehouses, title))
            return [];
        const warehouse = manager._warehouses[title];
        if (!warehouse)
            return [];
        const category = "item";
        const quantities = warehouse.qtty[category];
        const list = [];
        quantities.forEach((item, i) => {
            if (item) {
                list.push({ id: i, num: item });
            }
        });
        return list;
    }
    WarehouseUtil.getItemAll = getItemAll;
    function depositItem(title, itemId, num) {
        const item = getItem(title, itemId);
        if (item.id <= 0)
            return undefined;
        const warehouse = PHPlugins.PHWarehouse._warehouses[title];
        const category = "item";
        const info = getWarehouseInfo(title);
        if (info.infinity) {
            const index = warehouse.items[category].indexOf(item.id);
            if (index < 0) {
                warehouse.items[category].push(item.id);
                warehouse.qtty[category][item.id] = 0;
            }
            warehouse.qtty[category][item.id] += num;
            warehouse.currentCapacity += num;
            return { id: item.id, num: num };
        }
        const res = { id: item.id, num: 0 };
        const depositNum = Math.min(num, info.maxCapactity - info.currentCapacity);
        if (depositNum <= 0)
            return res;
        const index = warehouse.items[category].indexOf(item.id);
        if (index < 0) {
            warehouse.items[category].push(item.id);
            warehouse.qtty[category][item.id] = 0;
        }
        warehouse.qtty[category][item.id] += depositNum;
        warehouse.currentCapacity += depositNum;
        res.num += depositNum;
        return res;
    }
    WarehouseUtil.depositItem = depositItem;
    function withdrawItem(title, itemId, num) {
        const item = getItem(title, itemId);
        if (item.id <= 0 || item.num <= 0)
            return undefined;
        const withdrawNum = Math.min(num, item.num);
        const warehouse = PHPlugins.PHWarehouse._warehouses[title];
        const category = "item";
        if (withdrawNum >= item.num) {
            // 削除
            const index = warehouse.items[category].indexOf(item.id);
            warehouse.items[category].splice(index, 1);
            delete warehouse.qtty[category][item.id];
        }
        else {
            warehouse.qtty[category][item.id] -= withdrawNum;
        }
        warehouse.currentCapacity -= withdrawNum;
        return { id: itemId, num: withdrawNum };
    }
    WarehouseUtil.withdrawItem = withdrawItem;
    function withdrawItemAll(title) {
        const list = getItemAll(title);
        const warehouse = PHPlugins.PHWarehouse._warehouses[title];
        const category = "item";
        //
        warehouse.items[category] = [];
        let capacity = 0;
        list.forEach((item) => {
            capacity += item.num;
            delete warehouse.qtty[category][item.id];
        });
        warehouse.currentCapacity -= capacity;
        return list;
    }
    WarehouseUtil.withdrawItemAll = withdrawItemAll;
    function getWarehouseInfo(title) {
        const warehouse = PHPlugins.PHWarehouse._warehouses[title];
        const info = {
            infinity: warehouse.infinity,
            maxCapactity: warehouse.maxCapactity,
            currentCapacity: warehouse.currentCapacity,
        };
        return info;
    }
    WarehouseUtil.getWarehouseInfo = getWarehouseInfo;
})(WarehouseUtil || (WarehouseUtil = {}));
class Game_ShippingBox {
    initialize(title) {
        this._title = title;
        this._rating = 1;
    }
    sell() {
        const ExchangePriceVariableId = 72;
        const TotalExchangePriceVariableId = 73;
        const list = WarehouseUtil.withdrawItemAll(this._title);
        const price = this.getTotalMoneyFromList(list);
        if (price > 0) {
            $gameParty.gainGold(price);
            Iz.System.playCoin();
            Iz.System.notify(Iz.Text.get("SHIPPINGBOX_EXCHANGE_MESSAGE"));
            const getMoneyText = Iz.String.format(Iz.Text.get("SHIPPINGBOX_EXCHANGE_GET_MONEY"), price);
            Iz.System.notify(getMoneyText);
            let totalValue = Number($gameVariables.value(TotalExchangePriceVariableId));
            if (!totalValue) {
                totalValue = 0;
            }
            totalValue += price;
            $gameVariables.setValue(TotalExchangePriceVariableId, totalValue);
        }
        $gameVariables.setValue(ExchangePriceVariableId, price);
        Iz.Life.Stats.shipping.addItems(list);
        Iz.Life.Stats.shipping.addMoney(price);
    }
    getTotalMoneyFromList(list) {
        let price = 0;
        list.forEach((item) => {
            price += Math.floor(this.calcSellPrice(item.id)) * item.num;
        });
        return price;
    }
    getTotalMoney() {
        const list = WarehouseUtil.getItemAll(this._title);
        return this.getTotalMoneyFromList(list);
    }
    setRating(rating) {
        const RatingMin = 0;
        const RatingMax = 1000;
        this._rating = Math.min(Math.max(rating, RatingMin), RatingMax);
    }
    calcSellPrice(itemId) {
        // 最低1G
        return Math.floor(Math.max(1, ($dataItems[itemId].price / 2) * this.rating));
    }
    get title() {
        return this._title;
    }
    get rating() {
        return this._rating;
    }
}
(function (Iz) {
    var Life;
    (function (Life) {
        var Shipping;
        (function (Shipping) {
            function hasItem(itemId) {
                return WarehouseUtil.getItem($gameShippingBox.title, itemId).num > 0;
            }
            Shipping.hasItem = hasItem;
            function withdrawItemAll(itemId) {
                const item = WarehouseUtil.getItem($gameShippingBox.title, itemId);
                const result = WarehouseUtil.withdrawItem($gameShippingBox.title, itemId, item.num);
                if (result) {
                    $gameParty.gainItem($dataItems[result.id], result.num);
                    Iz.System.notifyGainItem(result.id, result.num);
                }
            }
            Shipping.withdrawItemAll = withdrawItemAll;
            function haveShipped(itemId) {
                return Life.Stats.shipping.getNum(itemId) > 0;
            }
            Shipping.haveShipped = haveShipped;
        })(Shipping = Life.Shipping || (Life.Shipping = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const pluginName = "ShippingBox";
    const parameters = PluginManager.parameters(pluginName);
    PluginManager.registerCommand(pluginName, "sell", (args) => {
        $gameShippingBox.sell();
    });
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _DataManager_createGameObjects.call(this);
        window.$gameShippingBox = new Game_ShippingBox();
        window.$gameShippingBox.initialize(parameters.title);
    };
    function getInfoMessage(addSingle, addSingleValue) {
        let str = `${Iz.Text.get("WAREHOUSE_TOTAL_MONEY")} ${$gameShippingBox.getTotalMoney()}`;
        if (addSingle) {
            str += `  ${Iz.Text.get("WAREHOUSE_SINGLE_MONEY")} ${addSingleValue}`;
        }
        return str;
    }
    // クラスにアクセスできないのでシーン変化を監視する
    const _SceneManager_changeScene = SceneManager.changeScene;
    SceneManager.changeScene = function () {
        const scene = this._nextScene;
        if (!scene)
            return;
        const sceneName = scene.constructor.name;
        if (sceneName === "Scene_Warehouse" &&
            PHPlugins.PHWarehouse._lastActive === $gameShippingBox.title) {
            PHPlugins.Params.PHWarehouseInfoSpaceFormat = getInfoMessage(false, 0);
        }
        else {
            PHPlugins.Params.PHWarehouseInfoSpaceFormat = Iz.Text.get("WAREHOUSE_INFO_SPACE_FORMAT");
        }
        _SceneManager_changeScene.call(this);
    };
    // クラスにアクセスできないのでベースクラスから監視する
    const _Scene_MenuBase_update = Scene_MenuBase.prototype.update;
    Scene_MenuBase.prototype.update = function () {
        if (this.constructor.name === "Scene_Warehouse" &&
            PHPlugins.PHWarehouse._lastActive === $gameShippingBox.title) {
            const thisScene = this;
            const prevItemWindowActive = thisScene._itemWindow.active;
            _Scene_MenuBase_update.call(this);
            if (thisScene._itemWindow.active ||
                prevItemWindowActive !== thisScene._itemWindow.active) {
                if (thisScene._itemWindow.active) {
                    const item = thisScene._itemWindow.item();
                    let price = 0;
                    if (item) {
                        price = $gameShippingBox.calcSellPrice(item.id);
                    }
                    PHPlugins.Params.PHWarehouseInfoSpaceFormat = getInfoMessage(true, price);
                }
                else {
                    PHPlugins.Params.PHWarehouseInfoSpaceFormat = getInfoMessage(false, 0);
                }
                thisScene._infoLocationWindow.refresh();
            }
        }
        else {
            _Scene_MenuBase_update.call(this);
        }
    };
    const _Scene_Warehouse_createItemList = Scene_Warehouse.prototype.createItemList;
    Scene_Warehouse.prototype.createItemList = function () {
        _Scene_Warehouse_createItemList.call(this);
        this._itemWindow.setHandler(Iz.IO.KEY_NAME_ALL_SELECT, this.onItemOkAll.bind(this));
    };
    Scene_Warehouse.prototype.onItemOkAll = function () {
        this._itemWindow.activate();
        this._itemWindow.moveItemAll();
        if (this._infoLocationWindow)
            this._infoLocationWindow.refresh();
        this._itemWindow.refresh();
        // @ts-ignore (ADD)預けたり引き出す時にCPウィンドウを更新する
        if (Imported.PNDK_LuggageCapacity)
            this._cpWindow.refresh();
    };
    const _Window_WarehouseInfo_refresh = Window_WarehouseInfo.prototype.refresh;
    Window_WarehouseInfo.prototype.refresh = function () {
        _Window_WarehouseInfo_refresh.call(this);
        let text = "";
        const selectAll = Iz.Text.get("WAREHOUSE_SELECT_ALL");
        if (Iz.IO.getLastInputType() === Iz.IO.InputType.Keyboard) {
            text = `\\IL[${Iz.IO.KEY_NAME_SHIFT}]: ${selectAll}`;
        }
        else {
            text = `\\IL[${Iz.IO.PAD_NAME_X}]: ${selectAll}`;
        }
        const size = Math.floor(this.textSizeEx(text).width);
        const offset = 16;
        this.drawTextEx(text, this.innerWidth - size - offset, 0, 0);
    };
    const _Window_WarehouseItemList_processHandling = Window_WarehouseItemList.prototype.processHandling;
    Window_WarehouseItemList.prototype.processHandling = function () {
        _Window_WarehouseItemList_processHandling.call(this);
        if (this.isOpenAndActive()) {
            if (this.isHandled(Iz.IO.KEY_NAME_ALL_SELECT) &&
                Input.isTriggered(Iz.IO.KEY_NAME_ALL_SELECT)) {
                if (this.isCurrentItemEnabled()) {
                    this.playOkSound();
                    this.updateInputData();
                    this.deactivate();
                    this.callHandler(Iz.IO.KEY_NAME_ALL_SELECT);
                }
                else {
                    this.playBuzzerSound();
                }
            }
        }
    };
    Window_WarehouseItemList.prototype.moveItemAll = function () {
        const item = this.item();
        // Deposit(預ける)
        if (PHPlugins.PHWarehouse._lastOption === 0) {
            //(EDIT)DepositとWithdrawを入れ替えるべく1を0にしました
            if (PHPlugins.PHWarehouse.checkCapacity2(item) &&
                PHPlugins.PHWarehouse.verifyItem(item) &&
                PHPlugins.PHWarehouse.checkOverItemQuantity(item)) {
                //(EDIT)checkCapacityをcheckCapacity2にしました
                if (PHPlugins.Params.PHWarehouseDepositSoundFile) {
                    AudioManager.playStaticSe({
                        name: PHPlugins.Params.PHWarehouseDepositSoundFile,
                        volume: 90,
                        pitch: 100,
                        pan: 0,
                    });
                }
                else {
                    SoundManager.playEquip();
                }
                const num = $gameParty.numItems(item);
                for (let i = 0; i < num; i++) {
                    if (PHPlugins.PHWarehouse.checkOverItemQuantity(item)) {
                        PHPlugins.PHWarehouse.deposit(item);
                        $gameParty.loseItem(item, 1, false);
                    }
                    else {
                        break;
                    }
                }
            }
            else {
                if (PHPlugins.Params.PHWarehouseBuzzerSoundFile) {
                    AudioManager.playStaticSe({
                        name: PHPlugins.Params.PHWarehouseBuzzerSoundFile,
                        volume: 90,
                        pitch: 100,
                        pan: 0,
                    });
                }
                else {
                    SoundManager.playBuzzer();
                }
            }
        }
        // Withdraw(引き出す)
        else if (PHPlugins.PHWarehouse._lastOption === 1) {
            //(EDIT)DepositとWithdrawを入れ替えるべく0を1にしました
            if ((PHPlugins.PHWarehouse.verifyItem(item) && !Imported.PNDK_LuggageCapacity) ||
                (PHPlugins.PHWarehouse.verifyItem(item) &&
                    Imported.PNDK_LuggageCapacity &&
                    // @ts-ignore
                    $gameSystem.getSurplusCP() >= $gameSystem.getWeight(item, 1))) {
                // 所持上限まで引き出す
                let success = false;
                const quantity = PHPlugins.PHWarehouse.getQuantity(item);
                for (let i = 0; i < quantity; i++) {
                    const prevNum = $gameParty.numItems(item);
                    $gameParty.gainItem(item, 1);
                    if (prevNum < $gameParty.numItems(item)) {
                        PHPlugins.PHWarehouse.withdraw(item);
                        success = true;
                    }
                    else {
                        break;
                    }
                }
                if (success) {
                    if (PHPlugins.Params.PHWarehouseWithdrawSoundFile) {
                        AudioManager.playStaticSe({
                            name: PHPlugins.Params.PHWarehouseWithdrawSoundFile,
                            volume: 90,
                            pitch: 100,
                            pan: 0,
                        });
                    }
                    else {
                        SoundManager.playEquip();
                    }
                }
                else {
                    SoundManager.playBuzzer();
                }
            }
            else {
                if (PHPlugins.Params.PHWarehouseBuzzerSoundFile) {
                    AudioManager.playStaticSe({
                        name: PHPlugins.Params.PHWarehouseBuzzerSoundFile,
                        volume: 90,
                        pitch: 100,
                        pan: 0,
                    });
                }
                else {
                    SoundManager.playBuzzer();
                }
            }
        }
    };
    const _Window_WarehouseItemList_makeWarehouseItemList = Window_WarehouseItemList.prototype.makeWarehouseItemList;
    Window_WarehouseItemList.prototype.makeWarehouseItemList = function () {
        _Window_WarehouseItemList_makeWarehouseItemList.call(this);
        if (Iz.Life.WarehouseSortIdOrder) {
            this._data.sort((a, b) => {
                if (!a || !b) {
                    return 0;
                }
                return a.id - b.id;
            });
        }
    };
    Window_WarehouseTitle.prototype.refresh = function () {
        this.contents.clear();
        if (Utils.RPGMAKER_NAME === "MZ") {
            this.changeTextColor(ColorManager.textColor(17));
        }
        if (Utils.RPGMAKER_NAME === "MV") {
            this.changeTextColor(this.crisisColor());
        }
        if (!PHPlugins.Params.PHWarehouseTitleTextHide) {
            let title = PHPlugins.PHWarehouse._lastActive;
            const langText = Iz.Text.get(title);
            if (langText) {
                title = langText;
            }
            this.drawText(title, 0, 0, Graphics.boxWidth, "center");
        }
    };
})();
//# sourceMappingURL=ShippingBox.js.map