/*:
 * @target MZ
 * @plugindesc マップ上の生成物管理
 *
 * @help
 * ※このプラグインはTemplateEventとEventRespawnに依存します
 * ２つのプラグインより後ろに登録してください
 *
 * マップ上のイベントを動的に生成・管理します イベントはテンプレートを使い生成されます
 * 生成したイベントの状態は維持され、マップ間移動やゲームを終了しても保持されます
 *
 *
 * イベントにはセルフ変数も利用可能です
 * 設定するキーは number string、値は number string boolean が利用できますが、
 * formulaFlg をtrueにした計算式は動作対象外です
 *
 *
 *
 * [開発者向け]
 * セルフスイッチ・セルフ変数の情報も保持しますが、イベントを動的生成する
 * その他のプラグインに影響がないようにイベントIDには依存しません
 * イベントIDに依存する実装にしないように注意してください
 *
 *
 * @command Create
 * @text Create
 * @desc イベントを生成 削除する時はRemoveコマンドを使うこと
 *
 * @arg mapId
 * @text mapId
 * @desc マップID 省略時は現在のマップ
 * @type number
 *
 * @arg x
 * @text x
 * @desc x座標
 * @type number
 *
 * @arg y
 * @text y
 * @desc y座標
 * @type number
 *
 * @arg templateId
 * @text templateId
 * @desc テンプレートIDもしくは名前　数値を指定するとIDとして解釈されます
 *
 *
 * @command Remove
 * @text Remove
 * @desc イベントを削除
 *
 *
 * @command ControlVariableByTag
 * @text ControlVariableByTag
 * @desc 同じタグを持つイベントのセルフ変数を一括で操作する
 *
 * @arg tag
 * @text tag
 * @desc タグ名
 *
 * @arg key
 * @text key
 * @desc セルフ変数名
 *
 * @arg type
 * @text type
 * @desc 操作種別
 * @default 0
 * @type select
 * @option  0 : 代入
 * @value 0
 * @option  1 : 加算
 * @value 1
 * @option  2 : 減算
 * @value 2
 * @option  3 : 乗算
 * @value 3
 * @option  4 : 除算
 * @value 4
 * @option  5 : 剰余
 * @value 5
 *
 * @arg value
 * @text value
 * @desc 設定値
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.SelfSwitchCodeArray = ["A", "B", "C", "D"];
        class SpawnObject {
            constructor(objectData, selfSwitch, selfVariable) {
                this.clear();
                this._data.object = objectData;
                Object.assign(this._data.selfSwitch, selfSwitch);
                Object.assign(this._data.selfVariable, selfVariable);
            }
            get mapId() {
                return this._data.object.mapId;
            }
            get x() {
                return this._data.object.x;
            }
            get y() {
                return this._data.object.y;
            }
            get templateId() {
                return this._data.object.templateId;
            }
            get labels() {
                return this._data.object.labels;
            }
            get objectData() {
                return this._data.object;
            }
            set objectData(value) {
                this._data.object = value;
            }
            get selfSwitch() {
                return this._data.selfSwitch;
            }
            get selfVariable() {
                return this._data.selfVariable;
            }
            clear() {
                this._data = {
                    object: { x: 0, y: 0, mapId: 0, templateId: 0, labels: {} },
                    selfSwitch: { A: false, B: false, C: false, D: false },
                    selfVariable: {},
                };
            }
            isValid() {
                return this.mapId > 0;
            }
            includeLabel(labelName) {
                return Object.keys(this.labels).some((label) => label === labelName);
            }
            getSaveData() {
                return {
                    object: { ...this._data.object },
                    selfSwitch: { ...this._data.selfSwitch },
                    selfVariable: { ...this._data.selfVariable },
                };
            }
        }
        class SpawnController {
            constructor() {
                this._spawnObjects = [];
                this._spawnObjects.splice(0);
            }
            get objects() {
                return this._spawnObjects;
            }
            initialize() {
                this._spawnObjects.splice(0);
            }
            setup(list) {
                this._spawnObjects.splice(0);
                list.forEach((data, i) => {
                    this._spawnObjects[i] = new SpawnObject(data.object, data.selfSwitch, data.selfVariable);
                });
            }
            generateIndex() {
                const index = this._spawnObjects.findIndex((object) => !object.isValid());
                return index >= 0 ? index : this._spawnObjects.length;
            }
            // TODO:
            // 生成処理時のルール(イベントとの重複可否とか)などをパラメータで設定できればいいな
            createObject(data, index = this.generateIndex()) {
                const res = { success: false, index: -1, event: undefined };
                const template = this.getTemplate(data.templateId);
                if (!template)
                    return res;
                let event = undefined;
                if (!data.spawnDataOnly && data.mapId === $gameMap.mapId()) {
                    const originalEventId = template.id;
                    event = $gameMap.spawnEventAndGet(originalEventId, data.x, data.y, true);
                    if (!event) {
                        return res;
                    }
                }
                const object = this.objects[index];
                const objectData = {
                    mapId: data.mapId,
                    x: data.x,
                    y: data.y,
                    templateId: data.templateId,
                    labels: data.labels ? Object.assign({}, data.labels) : {},
                };
                if (object) {
                    object.objectData = objectData;
                }
                else {
                    this._spawnObjects[index] = new SpawnObject(objectData);
                }
                res.success = true;
                res.index = index;
                if (event) {
                    event.setSpawnObjectIndex(index);
                    res.event = event;
                }
                return res;
            }
            removeObject(index) {
                const object = this.objects[index];
                if (!object)
                    return;
                if (object.mapId === $gameMap.mapId()) {
                    const event = $gameMap.events().find((e) => e.getSpawnObjectIndex() === index);
                    if (event) {
                        $gameMap.eraseEvent(event.eventId());
                    }
                }
                object.clear();
            }
            getTemplate(templateId) {
                return TR.getTemplateMapEvents()[templateId];
            }
            getCollider(x, y, templateId) {
                const template = this.getTemplate(templateId ?? 0);
                return new HM.Collider({
                    x: x,
                    y: y,
                    expansionArea: HM.getExpansionArea(template?.meta),
                });
            }
            operateSelfSwitch(index, code, value, objectSwitchOnly) {
                const object = this.objects[index];
                if (!object || !object.isValid()) {
                    return;
                }
                object.selfSwitch[code] = value;
                if (!object.selfSwitch[code]) {
                    delete object.selfSwitch[code];
                }
                if (objectSwitchOnly)
                    return;
                if ($gameMap.mapId() === object.mapId) {
                    const event = $gameMap.events().find((e) => e.getSpawnObjectIndex() === index);
                    if (event) {
                        const key = [object.mapId, event.eventId(), code];
                        $gameSelfSwitches.setValue(key, value);
                    }
                }
            }
            operateVariable(index, code, type, value, objectVariableOnly) {
                const object = this.objects[index];
                if (!object || !object.isValid()) {
                    return;
                }
                if (type === TR.OperationType.Set) {
                    object.selfVariable[code] = value;
                }
                else {
                    if (typeof value !== "number")
                        return;
                    const oldValue = object.selfVariable[code] ?? 0;
                    let setValue = oldValue;
                    if (type === TR.OperationType.Add) {
                        setValue = setValue + value;
                    }
                    else if (type === TR.OperationType.Sub) {
                        setValue = setValue - value;
                    }
                    else if (type === TR.OperationType.Mul) {
                        setValue = setValue * value;
                    }
                    else if (type === TR.OperationType.Div) {
                        setValue = setValue / value;
                    }
                    else if (type === TR.OperationType.Mod) {
                        setValue = setValue % value;
                    }
                    else {
                    }
                    object.selfVariable[code] = setValue;
                }
                // 無効なデータの時は削除する セルフ変数と同じ仕様
                const current = object.selfVariable[code];
                if (current === undefined || current === 0) {
                    delete object.selfVariable[code];
                }
                if (objectVariableOnly)
                    return;
                if ($gameMap.mapId() === object.mapId) {
                    const event = $gameMap.events().find((e) => e.getSpawnObjectIndex() === index);
                    if (event) {
                        event.controlSelfVariable(code, type, value, false);
                    }
                }
            }
        }
        Life.Spawn = new SpawnController();
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function controlSpawnVariableByTag(tag, code, type, value) {
            Life.Spawn.objects.forEach((object, i) => {
                // 対象のタグを持っていれば設定
                const template = Life.Spawn.getTemplate(object.templateId);
                if (template && Object.hasOwn(template.meta, tag)) {
                    Life.Spawn.operateVariable(i, code, type, value, false);
                }
            });
        }
        Life.controlSpawnVariableByTag = controlSpawnVariableByTag;
        // 全てのオブジェクトのセルフスイッチを一括操作する
        function controlSpawnSelfSwitchAll(code, flg) {
            Life.Spawn.objects.forEach((object, i) => {
                Life.Spawn.operateSelfSwitch(i, code, flg, false);
            });
        }
        Life.controlSpawnSelfSwitchAll = controlSpawnSelfSwitchAll;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const script = document.currentScript;
    PluginManagerEx.registerCommand(script, "Create", (args) => {
        const templateId = TR.getTemplateId(args.templateId);
        const data = {
            mapId: args.mapId ? args.mapId : $gameMap.mapId(),
            x: args.x,
            y: args.y,
            templateId: templateId,
        };
        Iz.Life.Spawn.createObject(data);
    });
    PluginManagerEx.registerCommand(script, "Remove", function (args) {
        // @ts-ignore
        const thisObj = this;
        const index = thisObj.character(0).getSpawnObjectIndex();
        Iz.Life.Spawn.removeObject(index);
    });
    PluginManagerEx.registerCommand(script, "ControlVariableByTag", (args) => {
        Iz.Life.controlSpawnVariableByTag(args.tag, args.key, args.type, args.value);
    });
    const _Game_Event_initMembers = Game_Event.prototype.initMembers;
    Game_Event.prototype.initMembers = function () {
        _Game_Event_initMembers.call(this);
        this._spawnObjectIndex = -1;
    };
    Game_Event.prototype.getSpawnObjectIndex = function () {
        return this._spawnObjectIndex;
    };
    Game_Event.prototype.setSpawnObjectIndex = function (index) {
        this._spawnObjectIndex = index;
    };
    function isGame_PrefabEvent(event) {
        return event instanceof Game_PrefabEvent;
    }
    const _Game_Map_setupEvents = Game_Map.prototype.setupEvents;
    Game_Map.prototype.setupEvents = function () {
        _Game_Map_setupEvents.call(this);
        Iz.Life.Spawn.objects.forEach((data, i) => {
            if (data.mapId === this.mapId()) {
                const option = {
                    mapId: data.mapId,
                    x: data.x,
                    y: data.y,
                    templateId: data.templateId,
                    labels: data.labels,
                };
                const res = Iz.Life.Spawn.createObject(option, i);
                const event = res.event;
                if (isGame_PrefabEvent(event)) {
                    event.setSpritePrepared();
                }
            }
        });
    };
    const _Game_Map_resetSelfSwitchForPrefabEvent = Game_Map.prototype.resetSelfSwitchForPrefabEvent;
    Game_Map.prototype.resetSelfSwitchForPrefabEvent = function () {
        $gameSelfSwitches.disapplySpawnObject = true;
        _Game_Map_resetSelfSwitchForPrefabEvent.call(this);
        $gameSelfSwitches.disapplySpawnObject = false;
    };
    const _Scene_Map_onMapLoaded = Scene_Map.prototype.onMapLoaded;
    Scene_Map.prototype.onMapLoaded = function () {
        _Scene_Map_onMapLoaded.call(this);
        // セルフスイッチ
        // セルフ変数のデータを再設定
        Iz.Life.Spawn.objects
            .map((o, i) => {
            return { i: i, o: o };
        })
            .filter((data) => data.o.mapId === $gameMap.mapId())
            .forEach((data) => {
            const event = $gameMap.events().find((e) => e.getSpawnObjectIndex() === data.i);
            if (event) {
                // セルフスイッチ
                Iz.Life.SelfSwitchCodeArray.forEach((code) => {
                    const key = [data.o.mapId, event.eventId(), code];
                    $gameSelfSwitches.setValue(key, data.o.selfSwitch[code]);
                });
                // セルフ変数
                Object.keys(data.o.selfVariable).forEach((code) => {
                    const value = data.o.selfVariable[code];
                    event.controlSelfVariable(code, TR.OperationType.Set, value, false);
                });
            }
        });
    };
    const _Game_SelfSwitches_initialize = Game_SelfSwitches.prototype.initialize;
    Game_SelfSwitches.prototype.initialize = function (...args) {
        _Game_SelfSwitches_initialize.call(this, args);
        this.disapplySpawnObject = false;
    };
    const _Game_SelfSwitches_setValue = Game_SelfSwitches.prototype.setValue;
    Game_SelfSwitches.prototype.setValue = function (key, value) {
        _Game_SelfSwitches_setValue.call(this, key, value);
        if (this.disapplySpawnObject)
            return;
        const mapId = key[0];
        const eventId = key[1];
        const code = key[2];
        if ($gameMap.mapId() !== mapId)
            return;
        const event = $gameMap.events().find((e) => e.eventId() === eventId);
        if (!event)
            return;
        const index = event.getSpawnObjectIndex();
        Iz.Life.Spawn.operateSelfSwitch(index, code, value, true);
    };
    const _Game_SelfSwitches_setVariableValue = Game_SelfSwitches.prototype.setVariableValue;
    Game_SelfSwitches.prototype.setVariableValue = function (key, value) {
        _Game_SelfSwitches_setVariableValue.call(this, key, value);
        if (this.disapplySpawnObject)
            return;
        const mapId = key[0];
        const eventId = key[1];
        const code = key[2];
        if ($gameMap.mapId() !== mapId)
            return;
        const event = $gameMap.events().find((e) => e.eventId() === eventId);
        if (!event)
            return;
        const index = event.getSpawnObjectIndex();
        Iz.Life.Spawn.operateVariable(index, code, TR.OperationType.Set, value, true);
    };
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.Spawn.initialize();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.spawnDataList = Iz.Life.Spawn.objects.map((o) => o.getSaveData());
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.Spawn.setup(contents.spawnDataList);
    };
})();
//# sourceMappingURL=SpawnObject.js.map