// 出荷箱統計
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class ShippingStats {
                constructor() {
                    this._items = new Map();
                    this.initialize();
                }
                get money() {
                    return this._money;
                }
                initialize() {
                    this._items.clear();
                    this._money = 0;
                }
                addItems(items) {
                    items.forEach((item) => {
                        let data = this._items.get(item.id);
                        if (!data) {
                            data = { id: item.id, num: 0 };
                            this._items.set(item.id, data);
                        }
                        data.num = Math.min(Math.max(data.num + item.num, 0), 9999999);
                    });
                }
                addMoney(money) {
                    this._money = Math.min(Math.max(this._money + money, 0), 99999999);
                }
                getNum(itemId) {
                    return this._items.get(itemId)?.num ?? 0;
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.id - b.id),
                        money: this._money,
                    };
                }
                setData(data) {
                    this.initialize();
                    data.items.forEach((item) => {
                        if ($dataItems[item.id]) {
                            const newData = {
                                id: 0,
                                num: 0,
                            };
                            Iz.Obj.apply(newData, item);
                            this._items.set(newData.id, newData);
                        }
                    });
                    this._money = data.money;
                }
            }
            Stats.shipping = new ShippingStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// プレゼント統計
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class GiftItemStats {
                constructor(itemId) {
                    this._data = {
                        itemId: itemId,
                        num: 0,
                    };
                }
                get num() {
                    return this._data.num;
                }
                set num(value) {
                    this._data.num = value;
                }
                getData() {
                    return this._data;
                }
                setData(data) {
                    Iz.Obj.apply(this._data, data);
                }
            }
            class GiftActorStats {
                constructor(actorId) {
                    this._actorId = actorId;
                    this._items = new Map();
                    this._count = 0;
                }
                get count() {
                    return this._count;
                }
                initialize() {
                    this._items.clear();
                    this._count = 0;
                }
                addItem(itemId, num) {
                    let item = this._items.get(itemId);
                    if (!item) {
                        item = new GiftItemStats(itemId);
                        this._items.set(itemId, item);
                    }
                    item.num += num;
                }
                addCount(count) {
                    this._count += count;
                }
                getItem(itemId) {
                    return this._items.get(itemId);
                }
                getData() {
                    return {
                        actorId: this._actorId,
                        items: [...this._items.values()]
                            .map((i) => i.getData())
                            .sort((a, b) => a.itemId - b.itemId),
                        count: this._count,
                    };
                }
                setData(data) {
                    this.initialize();
                    this._actorId = data.actorId;
                    data.items.forEach((i) => {
                        if ($dataItems[i.itemId]) {
                            const stats = new GiftItemStats(i.itemId);
                            stats.setData(i);
                            this._items.set(i.itemId, stats);
                        }
                    });
                    this._count = data.count ?? 0;
                }
            }
            class GiftStats {
                constructor() {
                    this._actors = new Map();
                }
                initialize() {
                    this._actors.clear();
                    for (let i = 1; i < $dataActors.length; i++) {
                        this._actors.set(i, new GiftActorStats(i));
                    }
                }
                getActor(actorId) {
                    return this._actors.get(actorId);
                }
                add(actorId, itemId, num) {
                    const actor = this._actors.get(actorId);
                    if (actor) {
                        actor.addCount(1);
                        actor.addItem(itemId, num);
                    }
                }
                getTotalCount() {
                    return [...this._actors.values()].map((a) => a.count).reduce((a, b) => a + b, 0);
                }
                getData() {
                    return {
                        actors: [...this._actors.values()].map((a) => a.getData()),
                    };
                }
                setData(data) {
                    this.initialize();
                    data.actors.forEach((a) => {
                        if (this._actors.has(a.actorId)) {
                            const stats = new GiftActorStats(a.actorId);
                            stats.setData(a);
                            this._actors.set(a.actorId, stats);
                        }
                    });
                }
            }
            Stats.gift = new GiftStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// ステータス関連
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class ActorStats {
                constructor(id) {
                    this._data = {
                        id: id,
                        talkedCount: 0,
                        peekedCount: 0,
                    };
                }
                get id() {
                    return this._data.id;
                }
                get talkedCount() {
                    return this._data.talkedCount;
                }
                get peekedCount() {
                    return this._data.peekedCount;
                }
                initilaize() {
                    this._data.talkedCount = 0;
                }
                talk() {
                    this._data.talkedCount++;
                }
                peeked() {
                    this._data.peekedCount++;
                }
                getData() {
                    return this._data;
                }
                setData(data) {
                    Iz.Obj.apply(this._data, data);
                }
            }
            class StatusStats {
                constructor() {
                    this._actors = new Map();
                    this._oversleptCount = 0;
                    this._overExhaustedCount = 0;
                    this._bathCount = 0;
                    this._totalConsumeHp = 0;
                }
                get oversleptCount() {
                    return this._oversleptCount;
                }
                set oversleptCount(value) {
                    this._oversleptCount = value;
                }
                get overExhaustedCount() {
                    return this._overExhaustedCount;
                }
                set overExhaustedCount(value) {
                    this._overExhaustedCount = value;
                }
                get bathCount() {
                    return this._bathCount;
                }
                set bathCount(value) {
                    this._bathCount = value;
                }
                get totalConsumeHp() {
                    return this._totalConsumeHp;
                }
                set totalConsumeHp(value) {
                    this._totalConsumeHp = value;
                }
                initialize() {
                    this._actors.clear();
                    for (let i = 1; i < $dataActors.length; i++) {
                        this._actors.set(i, new ActorStats(i));
                    }
                    this._oversleptCount = 0;
                    this._overExhaustedCount = 0;
                    this._bathCount = 0;
                    this._totalConsumeHp = 0;
                }
                getActor(actorId) {
                    return this._actors.get(actorId);
                }
                consumeHp(value) {
                    this._totalConsumeHp += value;
                }
                mostTalkedActor() {
                    const list = [...this._actors.values()].sort((a, b) => {
                        if (a.talkedCount !== b.talkedCount)
                            return b.talkedCount - a.talkedCount;
                        return a.id - b.id;
                    });
                    return list[0]?.id ?? 0;
                }
                getTotalPeekedCount() {
                    return [...this._actors.values()].map((a) => a.peekedCount).reduce((a, b) => a + b, 0);
                }
                getTotalTalkedCount() {
                    return [...this._actors.values()].map((a) => a.talkedCount).reduce((a, b) => a + b, 0);
                }
                getData() {
                    return {
                        actors: [...this._actors.values()].map((a) => a.getData()),
                        oversleptCount: this._oversleptCount,
                        overExhaustedCount: this._overExhaustedCount,
                        bathCount: this._bathCount,
                        totalConsumeHp: this._totalConsumeHp,
                    };
                }
                setData(data) {
                    this.initialize();
                    data.actors?.forEach((actorData) => {
                        this._actors.get(actorData.id)?.setData(actorData);
                    });
                    this._oversleptCount = data.oversleptCount ?? 0;
                    this._overExhaustedCount = data.overExhaustedCount ?? 0;
                    this._bathCount = data.bathCount ?? 0;
                    this._totalConsumeHp = data.totalConsumeHp ?? 0;
                }
            }
            Stats.status = new StatusStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var StatsUtil;
        (function (StatsUtil) {
            function addBathCount() {
                Life.Stats.status.bathCount++;
            }
            StatsUtil.addBathCount = addBathCount;
            function addPeekedCount(actorId) {
                Life.Stats.status.getActor(actorId)?.peeked();
            }
            StatsUtil.addPeekedCount = addPeekedCount;
        })(StatsUtil = Life.StatsUtil || (Life.StatsUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 農作
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class FarmStats {
                constructor() {
                    this._crops = new Map();
                    this._hoedCount = 0;
                    this._wateredCount = 0;
                    this._plantedCount = 0;
                }
                get hoedCount() {
                    return this._hoedCount;
                }
                get wateredCount() {
                    return this._wateredCount;
                }
                get plantedCount() {
                    return this._plantedCount;
                }
                initialize() {
                    this._crops.clear();
                    this._hoedCount = 0;
                    this._wateredCount = 0;
                    this._plantedCount = 0;
                }
                addHarvest(itemId, num) {
                    if (!this._crops.has(itemId)) {
                        this._crops.set(itemId, {
                            itemId: itemId,
                            harvestNum: 0,
                        });
                    }
                    const data = this._crops.get(itemId);
                    if (!data)
                        return;
                    data.harvestNum += num;
                }
                addHoedCount(count) {
                    this._hoedCount += count;
                }
                addWateredCount(count) {
                    this._wateredCount += count;
                }
                addPlantedCount(count) {
                    this._plantedCount += count;
                }
                getHarvestNum(itemId) {
                    return this._crops.get(itemId)?.harvestNum ?? 0;
                }
                getTotalHarvestCount() {
                    return [...this._crops.values()].map((c) => c.harvestNum).reduce((a, b) => a + b, 0);
                }
                // get
                getMostCrop() {
                    const crops = [...this._crops.values()].sort((a, b) => {
                        if (a.harvestNum !== b.harvestNum)
                            return b.harvestNum - a.harvestNum;
                        return a.itemId - b.itemId;
                    });
                    return crops[0]?.itemId ?? 0;
                }
                getData() {
                    return {
                        crops: [...this._crops.values()].sort((a, b) => a.itemId - b.itemId),
                        hoedCount: this._hoedCount,
                        wateredCount: this._wateredCount,
                        plantedCount: this._plantedCount,
                    };
                }
                setData(data) {
                    this._crops.clear();
                    data.crops.forEach((c) => {
                        const newData = {
                            itemId: 0,
                            harvestNum: 0,
                        };
                        Iz.Obj.applyRecursive(newData, c);
                        this._crops.set(newData.itemId, newData);
                    });
                    this._hoedCount = data.hoedCount ?? 0;
                    this._wateredCount = data.wateredCount ?? 0;
                    this._plantedCount = data.plantedCount ?? 0;
                }
            }
            Stats.farm = new FarmStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 釣り
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class FishingStats {
                constructor() {
                    this._fishes = new Map();
                    this.initialize();
                }
                get bigFishNum() {
                    return this._bigFishNum;
                }
                get normalFishNum() {
                    return this._normalFishNum;
                }
                get totalTime() {
                    return this._totalTime;
                }
                initialize() {
                    this._fishes.clear();
                    this._totalTime = 0;
                    this._bigFishNum = 0;
                    this._normalFishNum = 0;
                }
                getFishNum(id) {
                    return this._fishes.get(id)?.num ?? 0;
                }
                addFish(id, num) {
                    if (!this._fishes.has(id)) {
                        this._fishes.set(id, { id: id, num: 0 });
                    }
                    const data = this._fishes.get(id);
                    if (!data)
                        return;
                    data.num += num;
                }
                addTotalTime(time) {
                    this._totalTime += time;
                }
                addBigFishNum(num) {
                    this._bigFishNum += num;
                }
                addNormalFishNum(num) {
                    this._normalFishNum += num;
                }
                getTotalFishNum() {
                    return [...this._fishes.values()].map((f) => f.num).reduce((a, b) => a + b, 0);
                }
                getMostFish() {
                    const fishes = [...this._fishes.values()].sort((a, b) => {
                        if (a.num !== b.num)
                            return b.num - a.num;
                        return a.id - b.id;
                    });
                    return fishes[0]?.id ?? 0;
                }
                getData() {
                    return {
                        fishes: [...this._fishes.values()].sort((a, b) => a.id - b.id),
                        totalTime: this._totalTime,
                        bigFishNum: this._bigFishNum,
                        normalFishNum: this._normalFishNum,
                    };
                }
                setData(data) {
                    this._fishes.clear();
                    data.fishes.forEach((fish) => {
                        const newData = {
                            id: 0,
                            num: 0,
                        };
                        Iz.Obj.applyRecursive(newData, fish);
                        this._fishes.set(newData.id, newData);
                    });
                    this._totalTime = data.totalTime;
                    this._bigFishNum = data?.bigFishNum ?? 0;
                    this._normalFishNum = data?.normalFishNum ?? 0;
                }
            }
            Stats.fishing = new FishingStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 酪農
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class ShedStats {
                constructor(shedId) {
                    this._shedId = shedId;
                    this._items = new Map();
                }
                initialize() {
                    this._items.clear();
                }
                addItem(itemId, num) {
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, getNum: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.getNum += num;
                }
                getItems() {
                    return [...this._items.values()];
                }
                getData() {
                    const shedData = {
                        shedId: this._shedId,
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                    };
                    return shedData;
                }
                setData(data) {
                    this._shedId = data.shedId;
                    this._items.clear();
                    data.items.forEach((item) => {
                        const newData = {
                            itemId: 0,
                            getNum: 0,
                        };
                        Iz.Obj.applyRecursive(newData, item);
                        this._items.set(newData.itemId, newData);
                    });
                }
            }
            class DairyStats {
                constructor() {
                    this._sheds = new Map();
                    this._talkedCount = 0;
                    this._brushedCount = 0;
                    this._totalHappiness = 0;
                }
                get talkedCount() {
                    return this._talkedCount;
                }
                get brushedCount() {
                    return this._brushedCount;
                }
                get totalHappiness() {
                    return this._totalHappiness;
                }
                initialize() {
                    this._sheds.clear();
                    $dataDairyShed
                        .filter((data) => data && !data.event)
                        .forEach((data) => {
                        const shedStats = new ShedStats(data.id);
                        this._sheds.set(data.id, shedStats);
                    });
                    this._talkedCount = 0;
                    this._brushedCount = 0;
                    this._totalHappiness = 0;
                }
                getShed(shedId) {
                    return this._sheds.get(shedId);
                }
                getEggAmount() {
                    let sum = 0;
                    const eggList = Life.getEggList().map((data) => data.id);
                    this._sheds.forEach((shed) => {
                        sum += shed
                            .getItems()
                            .filter((item) => eggList.includes(item.itemId))
                            .map((item) => item.getNum)
                            .reduce((a, b) => a + b, 0);
                    });
                    return sum;
                }
                getMilkAmount() {
                    let sum = 0;
                    const milkList = Life.getMilkList().map((data) => data.id);
                    this._sheds.forEach((shed) => {
                        sum += shed
                            .getItems()
                            .filter((item) => milkList.includes(item.itemId))
                            .map((item) => item.getNum)
                            .reduce((a, b) => a + b, 0);
                    });
                    return sum;
                }
                addTalkedCount(count) {
                    this._talkedCount += count;
                }
                addBrushedCount(count) {
                    this._brushedCount += count;
                }
                addTotalHappiness(happiness) {
                    this._totalHappiness += happiness;
                }
                getData() {
                    const data = {
                        sheds: [...this._sheds.values()].map((s) => s.getData()),
                        talkedCount: this._talkedCount,
                        brushedCount: this._brushedCount,
                        totalHappiness: this._totalHappiness,
                    };
                    return data;
                }
                setData(data) {
                    this.initialize();
                    data.sheds.forEach((shedData) => {
                        this._sheds.get(shedData.shedId)?.setData(shedData);
                    });
                    this._talkedCount = data.talkedCount ?? 0;
                    this._brushedCount = data.brushedCount ?? 0;
                    this._totalHappiness = data.totalHappiness ?? 0;
                }
            }
            Stats.dairy = new DairyStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 採鉱
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class MiningStats {
                constructor() {
                    this._items = new Map();
                    this._miningItems = new Map();
                    this._mineAreaCount = 0;
                    this._timeInMine = 0;
                    this._totalDamage = 0;
                }
                get mineAreaCount() {
                    return this._mineAreaCount;
                }
                get timeInMine() {
                    return this._timeInMine;
                }
                get totalDamage() {
                    return this._totalDamage;
                }
                get arrivedArea() {
                    return $gameVariables.value(23) ?? 0;
                }
                initialize() {
                    this._items.clear();
                    this._miningItems.clear();
                    this._mineAreaCount = 0;
                    this._timeInMine = 0;
                    this._totalDamage = 0;
                }
                addItem(itemId, num) {
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                addMiningItem(itemId, num) {
                    if (!this._miningItems.has(itemId)) {
                        this._miningItems.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._miningItems.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                addMineAreaCount(count = 1) {
                    this._mineAreaCount += count;
                }
                addTimeInMine(time) {
                    this._timeInMine += time;
                }
                addTotalDamage(damage) {
                    this._totalDamage += damage;
                }
                getNum(itemId, inMine) {
                    if (inMine) {
                        return this._miningItems.get(itemId)?.num ?? 0;
                    }
                    return this._items.get(itemId)?.num ?? 0;
                }
                getTotalMineItemNum() {
                    return [...this._miningItems.values()].map((m) => m.num).reduce((a, b) => a + b, 0);
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                        miningItems: [...this._miningItems.values()].sort((a, b) => a.itemId - b.itemId),
                        mineAreaCount: this._mineAreaCount,
                        timeInMine: this._timeInMine,
                        totalDamage: this._totalDamage,
                    };
                }
                setData(data) {
                    this._items.clear();
                    data.items.forEach((item) => {
                        const newData = {
                            itemId: 0,
                            num: 0,
                        };
                        Iz.Obj.applyRecursive(newData, item);
                        this._items.set(newData.itemId, newData);
                    });
                    this._miningItems.clear();
                    if (data.miningItems) {
                        data.miningItems.forEach((item) => {
                            const newData = {
                                itemId: 0,
                                num: 0,
                            };
                            Iz.Obj.applyRecursive(newData, item);
                            this._miningItems.set(newData.itemId, newData);
                        });
                    }
                    this._mineAreaCount = data.mineAreaCount;
                    this._timeInMine = data.timeInMine;
                    this._totalDamage = data.totalDamage ?? 0;
                }
            }
            Stats.mining = new MiningStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 採集
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class PickupStats {
                constructor() {
                    this._items = new Map();
                    this._totalCount = 0;
                }
                get totalCount() {
                    return this._totalCount;
                }
                initialize() {
                    this._items.clear();
                    this._totalCount = 0;
                }
                addItem(itemId, num) {
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                addTotalCount(count) {
                    this._totalCount += count;
                }
                getNum(itemId) {
                    return this._items.get(itemId)?.num ?? 0;
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                        totalCount: this._totalCount,
                    };
                }
                setData(data) {
                    this._items.clear();
                    data.items.forEach((item) => {
                        const newData = {
                            itemId: 0,
                            num: 0,
                        };
                        Iz.Obj.applyRecursive(newData, item);
                        this._items.set(newData.itemId, newData);
                    });
                    this._totalCount = data.totalCount;
                }
            }
            Stats.pickup = new PickupStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 伐採
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class FellingStats {
                constructor() {
                    this._items = new Map();
                    this._totalCount = 0;
                    this._totalDamage = 0;
                }
                get totalCount() {
                    return this._totalCount;
                }
                get totalDamage() {
                    return this._totalDamage;
                }
                initialize() {
                    this._items.clear();
                    this._totalCount = 0;
                    this._totalDamage = 0;
                }
                addItem(itemId, num) {
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                addTotalCount(count) {
                    this._totalCount += count;
                }
                addTotalDamage(damage) {
                    this._totalDamage += damage;
                }
                getItemNum(itemId) {
                    return this._items.get(itemId)?.num ?? 0;
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                        totalCount: this._totalCount,
                        totalDamage: this._totalDamage,
                    };
                }
                setData(data) {
                    this._items.clear();
                    data.items.forEach((item) => {
                        const newData = {
                            itemId: 0,
                            num: 0,
                        };
                        Iz.Obj.applyRecursive(newData, item);
                        this._items.set(newData.itemId, newData);
                    });
                    this._totalCount = data.totalCount;
                    this._totalDamage = data.totalDamage;
                }
            }
            Stats.felling = new FellingStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// NPC関連
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class NpcStats {
                constructor(characterId) {
                    this._data = {
                        characterId: characterId,
                        collidedCount: 0,
                        happeningCount: 0,
                    };
                }
                get collidedCount() {
                    return this._data.collidedCount;
                }
                set collidedCount(value) {
                    this._data.collidedCount = value;
                }
                get happeningCount() {
                    return this._data.happeningCount;
                }
                set happeningCount(value) {
                    this._data.happeningCount = value;
                }
                initialize() {
                    this._data.collidedCount = 0;
                }
                getData() {
                    return Object.assign({}, this._data);
                }
                setData(data) {
                    this.initialize();
                    Iz.Obj.applyRecursive(this._data, data);
                }
            }
            class GlobalMapStats {
                constructor() {
                    this._npcs = new Map();
                }
                initialize() {
                    this._npcs.clear();
                    $globalMap.nonPlayerIds(true).forEach((npc) => {
                        this._npcs.set(npc, new NpcStats(npc));
                    });
                }
                getNpc(id) {
                    return this._npcs.get(id);
                }
                getTotalCollidedCount() {
                    return [...this._npcs.values()].map((n) => n.collidedCount).reduce((a, b) => a + b, 0);
                }
                getTotalHappeningCount() {
                    return [...this._npcs.values()].map((n) => n.happeningCount).reduce((a, b) => a + b, 0);
                }
                getData() {
                    return {
                        npcs: [...this._npcs.values()]
                            .map((n) => n.getData())
                            .sort((a, b) => a.characterId - b.characterId),
                    };
                }
                setData(data) {
                    this.initialize();
                    data.npcs.forEach((npcData) => {
                        const npcStats = this._npcs.get(npcData.characterId);
                        npcStats?.setData(npcData);
                    });
                }
            }
            Stats.globalMap = new GlobalMapStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 交流
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class CommunicationStats {
                constructor() {
                    this._peekBathCount = 0;
                }
                get peekBathCount() {
                    return this._peekBathCount;
                }
                set peekBathCount(value) {
                    this._peekBathCount = value;
                }
                initialize() {
                    this._peekBathCount = 0;
                }
                peekBath() {
                    this._peekBathCount++;
                }
                getTotalLikability() {
                    return Life.Status.getLikabilities().reduce((a, b) => a + b, 0);
                }
                getCompletedHeartEventPeople() {
                    const set = new Set();
                    Life.Quest.getQuestDataList()
                        .filter((data) => Life.QuestUtil.isHeart(data.id))
                        .filter((data) => Life.QuestUtil.isCompleted(data.id))
                        .forEach((data) => {
                        const character = $dataQuest.get(data.id)?.character ?? 0;
                        if (character) {
                            set.add(character);
                        }
                    });
                    return set.size;
                }
                getData() {
                    return {
                        peekBathCount: this._peekBathCount,
                    };
                }
                setData(data) {
                    this._peekBathCount = data.peekBathCount;
                }
            }
            Stats.communication = new CommunicationStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 料理
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class CookingStats {
                constructor() {
                    this._items = new Map();
                    this._totalCount = 0;
                }
                get totalCount() {
                    return this._totalCount;
                }
                initialize() {
                    this._items.clear();
                    this._totalCount = 0;
                }
                addItem(itemId, num) {
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                addTotalCount(count) {
                    this._totalCount += count;
                }
                getNum(itemId) {
                    return this._items.get(itemId)?.num ?? 0;
                }
                getMostItem() {
                    const items = [...this._items.values()].sort((a, b) => {
                        if (a.num !== b.num)
                            return b.num - a.num;
                        return a.itemId - b.itemId;
                    });
                    return items[0]?.itemId ?? 0;
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                        totalCount: this._totalCount,
                    };
                }
                setData(data) {
                    this._items.clear();
                    data.items.forEach((item) => {
                        const newData = {
                            itemId: 0,
                            num: 0,
                        };
                        Iz.Obj.applyRecursive(newData, item);
                        this._items.set(newData.itemId, newData);
                    });
                    this._totalCount = data.totalCount;
                }
            }
            Stats.cooking = new CookingStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _dobuy = Scene_Shop.prototype.doBuy;
    Scene_Shop.prototype.doBuy = function (number) {
        _dobuy.call(this, number);
        if (this.getShopTags().includes("cooking")) {
            if (DataManager.isItem(this._item)) {
                Iz.Life.Stats.cooking.addTotalCount(1);
                Iz.Life.Stats.cooking.addItem(this._item.id, number);
            }
        }
    };
})();
// クラフト
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class CraftStats {
                constructor() {
                    this._items = new Map();
                    this._totalCount = 0;
                }
                get totalCount() {
                    return this._totalCount;
                }
                initialize() {
                    this._items.clear();
                    this._totalCount = 0;
                }
                addItem(itemId, num) {
                    if (!this._items.has(itemId)) {
                        this._items.set(itemId, { itemId: itemId, num: 0 });
                    }
                    const data = this._items.get(itemId);
                    if (!data)
                        return;
                    data.num += num;
                }
                addTotalCount(count) {
                    this._totalCount += count;
                }
                getData() {
                    return {
                        items: [...this._items.values()].sort((a, b) => a.itemId - b.itemId),
                        totalCount: this._totalCount,
                    };
                }
                setData(data) {
                    this._items.clear();
                    data.items.forEach((item) => {
                        const newData = {
                            itemId: 0,
                            num: 0,
                        };
                        Iz.Obj.applyRecursive(newData, item);
                        this._items.set(newData.itemId, newData);
                    });
                    this._totalCount = data.totalCount;
                }
            }
            Stats.craft = new CraftStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _dobuy = Scene_Shop.prototype.doBuy;
    Scene_Shop.prototype.doBuy = function (number) {
        _dobuy.call(this, number);
        if (this.getShopTags().includes("craft")) {
            if (DataManager.isItem(this._item)) {
                Iz.Life.Stats.craft.addTotalCount(1);
                Iz.Life.Stats.craft.addItem(this._item.id, number);
            }
        }
    };
})();
// システム
(function (Iz) {
    var Life;
    (function (Life) {
        var Stats;
        (function (Stats) {
            class SystemStats {
                constructor() {
                    this._totalConsumeMoney = 0;
                    this._proposeActor = 0;
                    this._proposeTime = 0;
                }
                get totalConsumeMoney() {
                    return this._totalConsumeMoney;
                }
                set totalConsumeMoney(value) {
                    this._totalConsumeMoney = value;
                }
                get proposeActor() {
                    return this._proposeActor;
                }
                get proposeTime() {
                    return this._proposeTime;
                }
                set proposeTime(value) {
                    this._proposeTime = value;
                }
                initialize() {
                    this._totalConsumeMoney = 0;
                    this._proposeActor = 0;
                    this._proposeTime = 0;
                }
                setupPropose(actorId) {
                    this._proposeActor = actorId;
                    this._proposeTime = Iz.System.getTotalTime();
                }
                getPlayTime() {
                    return $gameSystem.playtimeText();
                }
                getData() {
                    return {
                        totalConsumeMoney: this._totalConsumeMoney,
                        proposeActor: this._proposeActor,
                        proposeTime: this._proposeTime,
                    };
                }
                setData(data) {
                    this._totalConsumeMoney = data.totalConsumeMoney;
                    this._proposeActor = data.proposeActor;
                    this._proposeTime = data.proposeTime;
                }
            }
            Stats.system = new SystemStats();
        })(Stats = Life.Stats || (Life.Stats = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _dobuy = Scene_Shop.prototype.doBuy;
    Scene_Shop.prototype.doBuy = function (number) {
        _dobuy.call(this, number);
        if (!this.getShopTags().includes("goddess")) {
            const price = this.buyingPrice() * number;
            Iz.Life.Stats.system.totalConsumeMoney += price;
        }
    };
    const _Game_Interpreter_command125 = Game_Interpreter.prototype.command125;
    Game_Interpreter.prototype.command125 = function (params) {
        const value = this.operateValue(params[0], params[1], params[2]);
        if (value < 0) {
            Iz.Life.Stats.system.totalConsumeMoney += Math.abs(value);
        }
        return _Game_Interpreter_command125.call(this, params);
    };
})();
(function (Iz) {
    var Life;
    (function (Life) {
        function getStatsData() {
            const data = {
                shipping: Life.Stats.shipping.getData(),
                gift: Life.Stats.gift.getData(),
                status: Life.Stats.status.getData(),
                farm: Life.Stats.farm.getData(),
                fishing: Life.Stats.fishing.getData(),
                dairy: Life.Stats.dairy.getData(),
                mining: Life.Stats.mining.getData(),
                pickup: Life.Stats.pickup.getData(),
                felling: Life.Stats.felling.getData(),
                globalMap: Life.Stats.globalMap.getData(),
                communication: Life.Stats.communication.getData(),
                cooking: Life.Stats.cooking.getData(),
                craft: Life.Stats.craft.getData(),
                system: Life.Stats.system.getData(),
            };
            return data;
        }
        Life.getStatsData = getStatsData;
        function setStatsData(data) {
            Life.Stats.shipping.setData(data.shipping);
            Life.Stats.gift.setData(data.gift);
            Life.Stats.status.setData(data.status);
            Life.Stats.farm.setData(data.farm);
            Life.Stats.fishing.setData(data.fishing);
            Life.Stats.dairy.setData(data.dairy);
            Life.Stats.mining.setData(data.mining);
            if (data.pickup) {
                Life.Stats.pickup.setData(data.pickup);
            }
            if (data.felling) {
                Life.Stats.felling.setData(data.felling);
            }
            if (data.globalMap) {
                Life.Stats.globalMap.setData(data.globalMap);
            }
            if (data.communication) {
                Life.Stats.communication.setData(data.communication);
            }
            if (data.cooking) {
                Life.Stats.cooking.setData(data.cooking);
            }
            if (data.craft) {
                Life.Stats.craft.setData(data.craft);
            }
            if (data.system) {
                Life.Stats.system.setData(data.system);
            }
        }
        Life.setStatsData = setStatsData;
        function initializeStats() {
            Life.Stats.shipping.initialize();
            Life.Stats.gift.initialize();
            Life.Stats.status.initialize();
            Life.Stats.farm.initialize();
            Life.Stats.fishing.initialize();
            Life.Stats.dairy.initialize();
            Life.Stats.mining.initialize();
            Life.Stats.pickup.initialize();
            Life.Stats.felling.initialize();
            Life.Stats.globalMap.initialize();
            Life.Stats.communication.initialize();
            Life.Stats.cooking.initialize();
            Life.Stats.craft.initialize();
            Life.Stats.system.initialize();
        }
        Life.initializeStats = initializeStats;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var StatsUtil;
        (function (StatsUtil) {
            function gifted(actorId, itemId) {
                const actor = Life.Stats.gift.getActor(actorId);
                if (!actor)
                    return false;
                return (actor.getItem(itemId)?.num ?? 0) > 0;
            }
            StatsUtil.gifted = gifted;
        })(StatsUtil = Life.StatsUtil || (Life.StatsUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeStats();
    };
    const _setupNewGame = DataManager.setupNewGame;
    DataManager.setupNewGame = function () {
        _setupNewGame.call(this);
        // NOTE:
        // NPCのデータがsetupNewGame時に作成されるので
        Iz.Life.Stats.globalMap.initialize();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.stats = Iz.Life.getStatsData();
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.setStatsData(contents.stats);
    };
})();
//# sourceMappingURL=Stats.js.map