/*:
 * @target MZ
 * @plugindesc システム関連
 * @autho INAZUMA GAMES
 *
 * @help
 *
 *
 *
 */
// フォント関連
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Iz.NonParamEscapeCodeList.push("FRESET");
        function getFontSetting(key) {
            return $dataFontSetting.find((s) => s && s.id === key);
        }
        Life.getFontSetting = getFontSetting;
        function applyFont(bitmap, fontName) {
            if (fontName === "main") {
                bitmap.fontFace = $gameSystem.mainFontFace();
            }
            else if (fontName === "number") {
                bitmap.fontFace = $gameSystem.numberFontFace();
            }
            else {
                bitmap.fontFace = `${fontName}, ` + $dataSystem.advanced.fallbackFonts;
            }
        }
        Life.applyFont = applyFont;
        Window_Base.prototype.setFontSetting = function (key) {
            const setting = getFontSetting(key);
            if (!setting)
                return;
            applyFont(this.contents, setting.font);
            if (setting.size) {
                this.contents.fontSize = setting.size;
            }
            this.changeTextColor(setting.color);
            this.contents.outlineWidth = setting.outline_width;
            this.changeOutlineColor(setting.outline_color);
            if (setting.use_shadow) {
                const shadow = {
                    offsetX: setting.shadow_x,
                    offsetY: setting.shadow_y,
                    color: setting.shadow_color,
                    blur: setting.shadow_blur,
                };
                this.contents.setShadow(shadow);
            }
        };
        Window_Base.prototype.obtainEscapeCharacter = function (textState) {
            const regExp = /^\[\w+\]/;
            const s = textState.text.slice(textState.index);
            const arr = regExp.exec(s);
            if (arr) {
                textState.index += arr[0].length;
                return arr[0].substring(1, arr[0].length - 1);
            }
            return "";
        };
        const _Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
        Window_Base.prototype.processEscapeCharacter = function (code, textState) {
            switch (code) {
                case "FSET":
                    this.setFontSetting(this.obtainEscapeCharacter(textState));
                    break;
                case "FRESET":
                    this.obtainEscapeParam(textState);
                    this.resetFontSettings();
                    break;
            }
            _Window_Base_processEscapeCharacter.call(this, code, textState);
        };
        const _Window_Base_convertEscapeCharacters = Window_Base.prototype.convertEscapeCharacters;
        Window_Base.prototype.convertEscapeCharacters = function (text) {
            let res = _Window_Base_convertEscapeCharacters.call(this, text);
            res = res.replace(/\x1bNE\[(\d+)\]/gi, (_, p1) => {
                const actorName = this.actorName(Number.parseInt(p1));
                return actorName.slice(-1);
            });
            return res;
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function getFontList(lang) {
            return $dataFontList[lang + 1];
        }
        function loadFont(lang) {
            const fontList = getFontList(lang);
            FontManager._urls = {};
            FontManager._states = {};
            FontManager.load("rmmz-mainfont", fontList.mainFont);
            FontManager.load("rmmz-numberfont", fontList.numberFont);
        }
        Life.loadFont = loadFont;
        Scene_Boot.prototype.loadGameFonts = function () {
            loadFont(Iz.System.i18n.lang);
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 通知関連
(function (Iz) {
    var System;
    (function (System) {
        function plusTextFormat(text) {
            return `\\FSET[${Iz.Life.FONT_KEY_HUD_LOG_GREEN}]${text}\\FSET[${Iz.Life.FONT_KEY_HUD_LOG_WHITE}]`;
        }
        function minusTextFormat(text) {
            return `\\FSET[${Iz.Life.FONT_KEY_HUD_LOG_RED}]${text}\\FSET[${Iz.Life.FONT_KEY_HUD_LOG_WHITE}]`;
        }
        function notify(message, useSound = true) {
            const icon = "";
            const note = useSound ? "" : "<noSound>";
            const item = new Torigoya.NotifyMessage.NotifyItem({
                message,
                icon: Number.parseInt(icon, 10),
                note,
            });
            Torigoya.NotifyMessage.Manager.notify(item);
        }
        System.notify = notify;
        function notifyGainItem(itemId, value) {
            Torigoya.NotifyMessage.Addons.GetItem.notifyGainItem($dataItems[itemId], value);
        }
        System.notifyGainItem = notifyGainItem;
        function notifyChangeLikability(actorId, value) {
            const format = Iz.Text.get("SYSTEM_NOTIFY_CHANGE_LIKABILITY");
            const actorName = $gameActors.actor(actorId)?.name() ?? "";
            const valueText = value >= 0 ? plusTextFormat(`+${value}`) : minusTextFormat(`${value}`);
            const text = Iz.String.format(format, actorName, valueText);
            notify(text);
        }
        System.notifyChangeLikability = notifyChangeLikability;
        function notifyFirstBonusLikability(actorId, value) {
            const format = Iz.Text.get("SYSTEM_NOTIFY_FIRST_BONUS_LIKABILITY");
            const actorName = $gameActors.actor(actorId)?.name() ?? "";
            const valueText = value >= 0 ? plusTextFormat(`+${value}`) : minusTextFormat(`${value}`);
            const text = Iz.String.format(format, actorName, valueText);
            notify(text);
        }
        System.notifyFirstBonusLikability = notifyFirstBonusLikability;
        function notifyChangeHappiness(value) {
            const format = Iz.Text.get("DAIRY_CHANGE_HAPPINESS");
            const valueText = value >= 0 ? plusTextFormat(`+${value}`) : minusTextFormat(`${value}`);
            const text = Iz.String.format(format, valueText);
            notify(text);
        }
        System.notifyChangeHappiness = notifyChangeHappiness;
        function notifyFeedShortage() {
            const text = Iz.Text.get("DAIRY_FEED_SHORTAGE");
            notify(text);
        }
        System.notifyFeedShortage = notifyFeedShortage;
        function notifyHpShortage() {
            notify(Iz.Text.get("SYSTEM_HP_SHORTAGE"));
        }
        System.notifyHpShortage = notifyHpShortage;
        function notifyDamage(damage) {
            notify(Iz.String.format(Iz.Text.get("SYSTEM_NOTIFY_DAMAGE"), damage));
        }
        System.notifyDamage = notifyDamage;
        System.DelayNotifyList = [];
        function notifyDelay(message) {
            System.DelayNotifyList.push(message);
        }
        System.notifyDelay = notifyDelay;
        function initializeNotify() {
            System.DelayNotifyList.splice(0);
        }
        System.initializeNotify = initializeNotify;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.System.initializeNotify();
    };
    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
        _Scene_Map_updateMain.call(this);
        if (Iz.System.DelayNotifyList.length <= 0)
            return;
        if (!$gameMap._interpreter.isRunning()) {
            Iz.System.DelayNotifyList.forEach((message) => {
                Iz.System.notify(message);
            });
        }
        Iz.System.DelayNotifyList.splice(0);
    };
})();
// オーディオ関連
(function (Iz) {
    var System;
    (function (System) {
        const DefaultSe = {
            name: "",
            pan: 0,
            pitch: 100,
            volume: 90,
        };
        function playSe(name, option) {
            const se = Iz.Obj.apply(Object.assign({}, DefaultSe), option);
            se.name = name;
            AudioManager.playSe(se);
        }
        System.playSe = playSe;
        function playPickSe() {
            playSe("system/Pick");
        }
        System.playPickSe = playPickSe;
        function playCoin() {
            playSe("Coin");
        }
        System.playCoin = playCoin;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
// アイテム関連
(() => {
    "use strict";
    const ItemMax = 999;
    Game_Party.prototype.maxItems = function () {
        return ItemMax;
    };
})();
// オートセーブ
(function (Iz) {
    var System;
    (function (System) {
        System.EnableAutoSave_Transfer = false;
        System.EnableAutoSave_Battle = false;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_Map_shouldAutosave = Scene_Map.prototype.shouldAutosave;
    Scene_Map.prototype.shouldAutosave = function () {
        if (!Iz.System.EnableAutoSave_Transfer)
            return false;
        return _Scene_Map_shouldAutosave.call(this);
    };
    const _Scene_Battle_shouldAutosave = Scene_Battle.prototype.shouldAutosave;
    Scene_Battle.prototype.shouldAutosave = function () {
        if (!Iz.System.EnableAutoSave_Battle)
            return false;
        return _Scene_Battle_shouldAutosave.call(this);
    };
})();
// オプション
(function (Iz) {
    var System;
    (function (System) {
        System.Option = {
            alwaysDash: { enable: false, visible: false },
            commandRemember: { enable: false, visible: false },
            touchUI: { enable: false, visible: false },
        };
        System.WindowOptionCommandMax = 7;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    ConfigManager.alwaysDash = Iz.System.Option.alwaysDash.enable;
    ConfigManager.commandRemember = Iz.System.Option.commandRemember.enable;
    ConfigManager.touchUI = Iz.System.Option.touchUI.enable;
    Window_Options.prototype.addGeneralOptions = function () { };
    Window_Options.prototype.volumeOffset = function () {
        return 10;
    };
    Scene_Options.prototype.maxCommands = function () {
        return Iz.System.WindowOptionCommandMax;
    };
})();
// 透明度
(function (Iz) {
    var System;
    (function (System) {
        ConfigManager.windowOpacityVolume = 100;
        function windowOpacityRate() {
            return ConfigManager.windowOpacityVolume / 100;
        }
        System.windowOpacityRate = windowOpacityRate;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function () {
        const data = _ConfigManager_makeData.call(this);
        data.windowOpacityVolume = this.windowOpacityVolume;
        return data;
    };
    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function (config) {
        _ConfigManager_applyData.call(this, config);
        this.windowOpacityVolume = this.readVolume(config, "windowOpacityVolume");
    };
    const _Window_Option_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function () {
        _Window_Option_makeCommandList.call(this);
        this.addCommand(Iz.Text.get("OPTION_WINDOW_OPACITY"), "windowOpacityVolume");
    };
})();
// キーコンフィグ
(function (Iz) {
    var System;
    (function (System) {
        ConfigManager.wasd = false;
        function isWASD() {
            return ConfigManager.wasd;
        }
        System.isWASD = isWASD;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    ConfigManager.wasd = false;
    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function () {
        const data = _ConfigManager_makeData.call(this);
        data.wasd = this.wasd;
        return data;
    };
    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function (config) {
        _ConfigManager_applyData.call(this, config);
        this.wasd = this.readFlag(config, "wasd", false);
    };
    const _Window_Option_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function () {
        _Window_Option_makeCommandList.call(this);
        this.addCommand("WASD", "wasd");
    };
})();
// 時間関連
(function (Iz) {
    var System;
    (function (System) {
        System.DAY_OF_WEEK_MAX = 6;
        System.MONTH_MAX = 4;
        System.HoursPerDay = Iz.GlobalMap.HoursPerDay;
        System.MinutesPerHour = Iz.GlobalMap.MinutesPerHour;
        System.TimesPerDay = System.HoursPerDay * System.MinutesPerHour;
        const _autoAddTimeHandlers = [];
        function getTotalTime() {
            return $gameSystem.chronus().getTotalTime();
        }
        System.getTotalTime = getTotalTime;
        function getTotalDay() {
            return $gameSystem.chronus().getTotalDay();
        }
        System.getTotalDay = getTotalDay;
        function getYear() {
            return $gameSystem.chronus().getYear();
        }
        System.getYear = getYear;
        function getHour() {
            return $gameSystem.chronus().getHour();
        }
        System.getHour = getHour;
        function getMinute() {
            return $gameSystem.chronus().getMinute();
        }
        System.getMinute = getMinute;
        function getMonth() {
            return $gameSystem.chronus().getMonth();
        }
        System.getMonth = getMonth;
        function getDay() {
            return $gameSystem.chronus().getDay();
        }
        System.getDay = getDay;
        function getDayOfWeek() {
            // 1から開始
            return $gameSystem.chronus().getWeekIndex() + 1;
        }
        System.getDayOfWeek = getDayOfWeek;
        function getDayOfWeekName(index) {
            return Iz.Text.get(`CHRONUS_DAY_OF_WEEK_${index}`);
        }
        System.getDayOfWeekName = getDayOfWeekName;
        function getMonthName(month) {
            return Iz.Text.get(`CHRONUS_MONTH_${month}`);
        }
        System.getMonthName = getMonthName;
        function getDaysText(month, day) {
            const monthName = getMonthName(month);
            const format = Iz.Text.get("CHRONUS_FORMAT");
            return Iz.String.format(format, monthName, day);
        }
        System.getDaysText = getDaysText;
        function toChronusFormat(hour, minute) {
            const strHour = hour.toString().padStart(2, "0");
            const strminute = minute.toString().padStart(2, "0");
            return `${strHour}:${strminute}`;
        }
        System.toChronusFormat = toChronusFormat;
        function toChronusFormatByTime(time) {
            const obj = toHourAndMinute(time);
            return toChronusFormat(obj.hour, obj.minute);
        }
        System.toChronusFormatByTime = toChronusFormatByTime;
        function toChronusDurationFormat(beginTimeText, endTimeText) {
            return `${beginTimeText}～${endTimeText}`;
        }
        System.toChronusDurationFormat = toChronusDurationFormat;
        function toTime(hour, minute) {
            return Iz.GlobalMap.toTime(hour, minute);
        }
        System.toTime = toTime;
        function toHourAndMinute(time) {
            return Iz.GlobalMap.toHourAndMinute(time);
        }
        System.toHourAndMinute = toHourAndMinute;
        function getElapsedTime(beginTime, endTime) {
            if (endTime >= beginTime) {
                return endTime - beginTime;
            }
            return System.TimesPerDay - (beginTime - endTime);
        }
        System.getElapsedTime = getElapsedTime;
        function getDaysOfMonthList() {
            return $gameSystem.chronus().getDaysOfMonthList();
        }
        System.getDaysOfMonthList = getDaysOfMonthList;
        // 日数基準に変換
        function toDaysBase(month_, day_) {
            const daysofMonthList = getDaysOfMonthList();
            const month = ((month_ - 1) % monthesOfYear()) + 1;
            let total = 0;
            for (let i = 0; i < month; i++) {
                const m = i + 1;
                if (m < month) {
                    total += daysofMonthList[i];
                    continue;
                }
                if (m === month) {
                    total += day_;
                }
                break;
            }
            while (total > daysOfYear()) {
                total -= daysOfYear();
            }
            while (total < 1) {
                total += daysOfYear();
            }
            return total;
        }
        System.toDaysBase = toDaysBase;
        function timeToDate(time) {
            const timesOfYear = daysOfYear() * System.TimesPerDay;
            const daysOfMonth = getDaysOfMonthList();
            let temp = time;
            let year = 1;
            let month = 1;
            let day = 1;
            let hour = 0;
            // year
            while (true) {
                if (temp >= timesOfYear) {
                    temp -= timesOfYear;
                    year++;
                    continue;
                }
                break;
            }
            // month
            for (let i = 0; i < daysOfMonth.length; i++) {
                const timesOfMonth = daysOfMonth[i] * System.TimesPerDay;
                if (temp >= timesOfMonth) {
                    temp -= timesOfMonth;
                    month++;
                }
            }
            // day
            while (true) {
                if (temp >= System.TimesPerDay) {
                    temp -= System.TimesPerDay;
                    day++;
                    continue;
                }
                break;
            }
            // hour
            while (true) {
                if (temp >= System.MinutesPerHour) {
                    temp -= System.MinutesPerHour;
                    hour++;
                    continue;
                }
                break;
            }
            return {
                year: year,
                month: month,
                day: day,
                hour: hour,
                minute: temp,
            };
        }
        System.timeToDate = timeToDate;
        function monthesOfYear() {
            return getDaysOfMonthList().length;
        }
        System.monthesOfYear = monthesOfYear;
        function daysOfYear() {
            return getDaysOfMonthList().reduce((accu, value) => accu + value, 0);
        }
        System.daysOfYear = daysOfYear;
        //
        function updateAutoAddTimeHandler(addTime) {
            _autoAddTimeHandlers.forEach((h) => h(addTime));
        }
        System.updateAutoAddTimeHandler = updateAutoAddTimeHandler;
        function addAutoAddTimeHandler(handler) {
            _autoAddTimeHandlers.push(handler);
        }
        System.addAutoAddTimeHandler = addAutoAddTimeHandler;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
// 天候関連
(function (Iz) {
    var Life;
    (function (Life) {
        Life.WeatherType = {
            Sunny: 0,
            Rainy: 1,
        };
        const WeatherTypeVariableId = 1011;
        function getWeatherType() {
            switch ($gameVariables.value(WeatherTypeVariableId)) {
                case Life.WeatherType.Sunny:
                    return Life.WeatherType.Sunny;
                case Life.WeatherType.Rainy:
                    return Life.WeatherType.Rainy;
                default:
                    return Life.WeatherType.Sunny;
            }
        }
        Life.getWeatherType = getWeatherType;
        function getWeatherName(type) {
            switch (type) {
                case Life.WeatherType.Sunny:
                    return "晴れ";
                case Life.WeatherType.Rainy:
                    return "雨";
            }
        }
        Life.getWeatherName = getWeatherName;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// マップ関連
(function (Iz) {
    var System;
    (function (System) {
        function getMapName(mapId) {
            return $dataGlobalMapInfo[mapId]?.name ?? "";
        }
        System.getMapName = getMapName;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    const _Window_MenuCommand_addSaveCommand = Window_MenuCommand.prototype.addSaveCommand;
    Window_MenuCommand.prototype.addSaveCommand = function () {
        if (Iz.System.isTestMode()) {
            const enabled = this.isSaveEnabled();
            this.addCommand(TextManager.save, "save", enabled);
        }
        else {
            _Window_MenuCommand_addSaveCommand.call(this);
        }
    };
})();
// ポーズ、n倍速化、イベント差し込み
(function (Iz) {
    var Life;
    (function (Life) {
        let fastDisabled = false;
        let enableFastForwardTimes = false;
        let mainUpdateTimes = 1;
        function setFastDisabled(value) {
            fastDisabled = value;
        }
        Life.setFastDisabled = setFastDisabled;
        function getFastDisabled() {
            return fastDisabled;
        }
        Life.getFastDisabled = getFastDisabled;
        function setEnableFastForwardTimes(flg) {
            enableFastForwardTimes = flg;
        }
        Life.setEnableFastForwardTimes = setEnableFastForwardTimes;
        function getEnableFastForwadrTimes() {
            return enableFastForwardTimes;
        }
        Life.getEnableFastForwadrTimes = getEnableFastForwadrTimes;
        function getMainUpdateTimes() {
            return mainUpdateTimes;
        }
        Life.getMainUpdateTimes = getMainUpdateTimes;
        function setMainUpdateTimes(n) {
            if (!Number.isInteger(n))
                return;
            mainUpdateTimes = Math.max(1, n);
        }
        Life.setMainUpdateTimes = setMainUpdateTimes;
        function initializeFast() {
            setFastDisabled(false);
            setEnableFastForwardTimes(false);
            setMainUpdateTimes($parameter.system.skip_times);
        }
        Life.initializeFast = initializeFast;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeFast();
    };
    const _Scene_Map_initialize = Scene_Map.prototype.initialize;
    Scene_Map.prototype.initialize = function (...args) {
        _Scene_Map_initialize.call(this, ...args);
        this._pause = false;
    };
    const _Scene_Map_updateMainMultiply = Scene_Map.prototype.updateMainMultiply;
    Scene_Map.prototype.updateMainMultiply = function () {
        if (this._pause) {
            return;
        }
        if (this.isFastForwardTimes()) {
            const len = Iz.Life.getMainUpdateTimes() - 1;
            if (len > 0) {
                this.cancelMessageWait();
                for (let i = 0; i < len; i++) {
                    this.updateMain();
                }
            }
        }
        _Scene_Map_updateMainMultiply.call(this);
        this.updateMainMultipleAfter();
    };
    Scene_Map.prototype.updateMainMultipleAfter = function () {
        // NOTE:
        // requestMenu()を呼んだ直後にイベントが発火した時はイベントを優先させる
        // ※
        // this.updateMainMultiply(); と
        // if (this.isSceneChangeOk()) {
        // の間だとここくらいしか記載できそうになかったので
        if ($gameMap.isEventRunning()) {
            Iz.Life.requestMenuFlg = false;
        }
        // TODO:
        // イベント処理終了直後にもキーマッピングを更新
        // ※ callMenu()でメニューを開いてしまうケースがあったので
        this.updateInputMapper();
    };
    Scene_Map.prototype.setPause = function (flg) {
        this._pause = flg;
    };
    Scene_Map.prototype.isFastForwardTimes = function () {
        return ($gameMap.isEventRunning() &&
            !SceneManager.isSceneChanging() &&
            Iz.Life.getEnableFastForwadrTimes() &&
            !Iz.Life.getFastDisabled());
    };
    const _Scene_Map_isFastForward = Scene_Map.prototype.isFastForward;
    Scene_Map.prototype.isFastForward = function () {
        if (Iz.Life.getFastDisabled()) {
            return false;
        }
        if (Iz.Life.getEnableFastForwadrTimes()) {
            return false;
        }
        return _Scene_Map_isFastForward.call(this);
    };
})();
// 値段、通貨
(function (Iz) {
    var Life;
    (function (Life) {
        function formatMoney(money) {
            return `${money}${TextManager.currencyUnit}`;
        }
        Life.formatMoney = formatMoney;
        let _unit = "";
        function changeMoneyUnit(unit) {
            _unit = unit;
        }
        Life.changeMoneyUnit = changeMoneyUnit;
        function discardMoneyUnit() {
            _unit = "";
        }
        Life.discardMoneyUnit = discardMoneyUnit;
        Object.defineProperty(TextManager, "currencyUnit", {
            get: function () {
                if (_unit) {
                    return _unit;
                }
                return $dataSystem.currencyUnit;
            },
            configurable: true,
        });
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// テキスト差し替え
(function (Iz) {
    var Life;
    (function (Life) {
        const commands = [];
        function changeTextCommandBuy(name) {
            commands[24] = name;
        }
        Life.changeTextCommandBuy = changeTextCommandBuy;
        function discardTextCommandBuy() {
            commands[24] = "";
        }
        Life.discardTextCommandBuy = discardTextCommandBuy;
        function changeTextCommandSell(name) {
            commands[25] = name;
        }
        Life.changeTextCommandSell = changeTextCommandSell;
        function discardTextCommandSell() {
            commands[25] = "";
        }
        Life.discardTextCommandSell = discardTextCommandSell;
        function discardTextCommands() {
            commands.splice(0);
        }
        Life.discardTextCommands = discardTextCommands;
        TextManager.command = function (commandId) {
            if (commands[commandId]) {
                return commands[commandId];
            }
            return $dataSystem.terms.commands[commandId] || "";
        };
        const _Scene_Shop_terminate = Scene_Shop.prototype.terminate;
        Scene_Shop.prototype.terminate = function () {
            _Scene_Shop_terminate.call(this);
            discardTextCommandBuy();
            discardTextCommandSell();
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function changeTextCommandToExchange() {
            Life.changeTextCommandBuy(Iz.Text.get("SHOP_COMMAND_EXCHANGE"));
        }
        Life.changeTextCommandToExchange = changeTextCommandToExchange;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 健全モード
(function (Iz) {
    var System;
    (function (System) {
        ConfigManager.restrictedMode = false;
        function restrictedMode() {
            return ConfigManager.restrictedMode;
        }
        System.restrictedMode = restrictedMode;
        function setRestrictedMode(flg) {
            ConfigManager.restrictedMode = flg;
        }
        System.setRestrictedMode = setRestrictedMode;
        function isRestrictedImage(path) {
            return path.split("/").includes("h");
        }
        System.isRestrictedImage = isRestrictedImage;
        function updateGameTitle() {
            const restrictedTitle = System.restrictedMode()
                ? Iz.Text.get("OPTION_WINDOW_RESTRICTED_MODE")
                : "";
            document.title = `${$dataSystem.gameTitle} ${restrictedTitle}`;
        }
        System.updateGameTitle = updateGameTitle;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        Life.NPCCostume = {
            Naked: 1,
            Normal: 2,
            Pajama: 3,
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    Iz.GlobalMap.convertCostume = (costume) => {
        if (Iz.System.restrictedMode()) {
            if (costume === Iz.Life.NPCCostume.Naked) {
                return Iz.Life.NPCCostume.Pajama;
            }
        }
        return costume;
    };
    const _Game_Player_characterName = Game_Player.prototype.characterName;
    Game_Player.prototype.characterName = function () {
        const res = _Game_Player_characterName.call(this);
        if (Iz.System.restrictedMode()) {
            if (res.startsWith("chara001_01/")) {
                return res.replace("chara001_01/", "chara001_03/");
            }
        }
        return res;
    };
    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function () {
        const data = _ConfigManager_makeData.call(this);
        data.restrictedMode = this.restrictedMode;
        return data;
    };
    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function (config) {
        _ConfigManager_applyData.call(this, config);
        this.restrictedMode = this.readFlag(config, "restrictedMode", false);
    };
    const _Window_Option_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function () {
        _Window_Option_makeCommandList.call(this);
        const text = Iz.Text.get("OPTION_WINDOW_RESTRICTED_MODE");
        const enable = !Iz.Life.MemoryUtil.isMemoryMode();
        this.addCommand(text, "restrictedMode", enable);
    };
    const _Window_Options_activate = Window_Options.prototype.activate;
    Window_Options.prototype.activate = function () {
        _Window_Options_activate.call(this);
        this.refresh();
    };
    const _Sprite_Picture_update = Sprite_Picture.prototype.update;
    Sprite_Picture.prototype.update = function () {
        _Sprite_Picture_update.call(this);
        const picture = this.picture();
        if (!picture)
            return;
        if (!Iz.System.restrictedMode())
            return;
        if (Iz.System.isRestrictedImage(this._pictureName)) {
            this.visible = false;
        }
    };
    const _Game_Picture_showBust = Game_Picture.prototype.showBust;
    Game_Picture.prototype.showBust = function (skitActorName, name, origin, x, y, scaleX, scaleY, opacity, blendMode) {
        _Game_Picture_showBust.call(this, skitActorName, name, origin, x, y, scaleX, scaleY, opacity, blendMode);
        if (!Iz.System.restrictedMode())
            return;
        if (this._name === "naked") {
            this._name = "pajama";
        }
    };
    const _Window_Options_changeValue = Window_Options.prototype.changeValue;
    Window_Options.prototype.changeValue = function (symbol, value) {
        const index = this.findSymbol(symbol);
        if (!this.isCommandEnabled(index)) {
            return;
        }
        _Window_Options_changeValue.call(this, symbol, value);
        Iz.System.updateGameTitle();
    };
    Scene_Boot.prototype.updateDocumentTitle = function () {
        Iz.System.updateGameTitle();
    };
})();
// セーブ確認
(function (Iz) {
    var System;
    (function (System) {
        ConfigManager.saveDialog = true;
        function isEnableSaveDialog() {
            return ConfigManager.saveDialog;
        }
        System.isEnableSaveDialog = isEnableSaveDialog;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    const _ConfigManager_makeData = ConfigManager.makeData;
    ConfigManager.makeData = function () {
        const data = _ConfigManager_makeData.call(this);
        data.saveDialog = this.saveDialog;
        return data;
    };
    const _ConfigManager_applyData = ConfigManager.applyData;
    ConfigManager.applyData = function (config) {
        _ConfigManager_applyData.call(this, config);
        this.saveDialog = this.readFlag(config, "saveDialog", true);
    };
    const _Window_Option_makeCommandList = Window_Options.prototype.makeCommandList;
    Window_Options.prototype.makeCommandList = function () {
        _Window_Option_makeCommandList.call(this);
        this.addCommand(Iz.Text.get("OPTION_WINDOW_CONFIRM_SAVE"), "saveDialog");
    };
})();
// 体験版関連
(function (Iz) {
    var System;
    (function (System) {
        // NOTE:
        // マイページのウィッシュリストのURL一覧
        // 自動で登録される
        const urls = [
            "https://www.dlsite.com/maniax/mypage/wishlist/announce/=/product_id/RJ01271506.html",
            "https://www.dlsite.com/maniax/mypage/wishlist/announce/=/product_id/RJ01503167.html",
            "https://www.dlsite.com/maniax/mypage/wishlist/announce/=/product_id/RJ01503176.html",
            "https://www.dlsite.com/maniax/mypage/wishlist/announce/=/product_id/RJ01503183.html",
            "https://www.dlsite.com/maniax/mypage/wishlist/announce/=/product_id/RJ01503193.html",
        ];
        function getProductUrl(lang) {
            return urls[lang] ?? urls[0];
        }
        function launchProductUrl(lang = System.i18n.lang) {
            const url = getProductUrl(lang);
            if (Utils.isNwjs()) {
                const execSync = require("child_process").execSync;
                try {
                    switch (process.platform) {
                        case "win32":
                            execSync('rundll32.exe url.dll,FileProtocolHandler  "' + url + '"');
                            break;
                        default:
                            execSync('open "' + url + '"');
                            break;
                    }
                }
                catch (e) {
                    // TODO:
                    // エラーダイアログ
                }
            }
            else {
                window.open(url);
            }
        }
        System.launchProductUrl = launchProductUrl;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=System.js.map