/*:
 * @target MZ
 * @plugindesc Tips
 *
 * @help
 *
 *
 *
 * @command display
 * @text Tipsを表示
 * @desc Tipsを表示
 *
 * @arg index
 * @text Tipsのインデックス
 *
 * @arg text
 * @text 表示テキスト
 * @desc TipsTextのIDを指定した場合はマスターデータから参照します
 *
 * @arg baseX
 * @text 基準点X
 *
 * @arg baseY
 * @text 基準点Y
 *
 * @arg dir
 * @text Tipsの向き(2,4,6,8)
 *
 * @arg tailPos
 * @text しっぽの位置(0.0-1.0)
 * @desc 例：右向き(6)の場合、左上～左下の位置を0.0-1.0で表します
 *
 *
 * @command hidden
 * @text Tipsを非表示
 *
 * @arg index
 * @text Tipsのインデックス
 *
 *
 * @command terminate
 * @text 終了処理
 *
 * @command lottery
 * @text 抽選
 * @desc Tipsを抽選します
 *
 * @arg variableId
 * @text 抽選結果の代入先変数
 * @type variable
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class ConditionCheckQuestComplete {
            check(id) {
                const data = $dataTipsConditionQuestComplete.get(id);
                if (!data)
                    return true;
                return Life.QuestUtil.isCompleted(data.quest_id);
            }
        }
        class Condition {
            constructor() {
                this._conditions = new Map();
            }
            initialize() {
                this._conditions.clear();
                this._conditions.set(Life.Data.TipsConditionType.QuestComplete, new ConditionCheckQuestComplete());
            }
            check(tipsId) {
                const data = $dataTips.get(tipsId);
                if (!data)
                    return false;
                return this.checkCondition(data.condition);
            }
            checkCondition(conditionId) {
                return $dataTipsCondition
                    .filter((data) => data)
                    .filter((data) => data.id === conditionId)
                    .every((data) => this.checkConditionType(data.type, data.type_id));
            }
            checkConditionType(type, type_id) {
                const obj = this._conditions.get(type);
                return obj?.check(type_id) ?? true;
            }
        }
        class TipsWindow extends Sprite {
            constructor() {
                super();
                this.create();
                this._padding = {
                    left: 24,
                    top: 12,
                    right: 24,
                    bottom: 12,
                };
                this._data = EmptyData;
                this.resize();
            }
            create() {
                this.createBase();
                this.createTail();
                this.createText();
            }
            createBase() {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON);
                const frame = atlas.getFrame(Life.FRAME_KEY_COMMON_TIPS_BASE);
                this._base = new NineSliceSprite(atlas.getBitmap());
                this._base.setBitmapRect(frame.x, frame.y, frame.width, frame.height);
                this._base.setSlice(20, 20, 20, 20);
                this._base.setSize(4, 4);
                this.addChild(this._base);
            }
            createTail() {
                this._tail = new Sprite();
                this._tail.anchor.set(0.5, 0.5);
                this.addChild(this._tail);
            }
            createText() {
                this._text = new Sprite_TextEx();
                this._text.setFontSetting(Life.FONT_KEY_TIPS_TEXT);
                this.addChild(this._text);
            }
            set(data) {
                if (this.isSameData(this._data, data)) {
                    return;
                }
                this._data = data;
                this.setText(data.text);
                this.resize();
                const width = this.width;
                const height = this.height;
                if (data.dir === 2) {
                    this._tail.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_TIPS_SIPPO_UP);
                    this.y = data.baseY;
                    this._tail.y = 0;
                    const tailOffset = Math.floor(width * data.tailPos);
                    this._tail.x = tailOffset;
                    this.x += -tailOffset + data.baseX;
                }
                else if (data.dir === 4) {
                    this._tail.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_TIPS_SIPPO_RIGHT);
                    this.x = data.baseX - width;
                    this._tail.x = width;
                    const tailOffset = Math.floor(height * data.tailPos);
                    this._tail.y = tailOffset;
                    this.y += -tailOffset + data.baseY;
                }
                else if (data.dir === 6) {
                    this._tail.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_TIPS_SIPPO_LEFT);
                    this.x = data.baseX;
                    this._tail.x = 0;
                    const tailOffset = Math.floor(height * data.tailPos);
                    this._tail.y = tailOffset;
                    this.y += -tailOffset + data.baseY;
                }
                else if (data.dir === 8) {
                    this._tail.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_TIPS_SIPPO_DOWN);
                    this.y = data.baseY - height;
                    this._tail.y = height;
                    const tailOffset = Math.floor(width * data.tailPos);
                    this._tail.x = tailOffset;
                    this.x += -tailOffset + data.baseX;
                }
            }
            resize() {
                const textSize = this._text.textSizeEx(this._text.text);
                const width = textSize.width + this._padding.left + this._padding.right;
                const height = textSize.height + this._padding.top + this._padding.bottom;
                this._base.setSize(width, height);
                this.setFrame(0, 0, width, height);
                this._text.x = this._padding.left;
                this._text.y = this._padding.top;
            }
            setText(s) {
                const size = this._text.textSizeEx(s);
                this._text.createBitmap(size.width, size.height);
                this._text.setText(s);
            }
            isSameData(a, b) {
                if (a.index !== b.index)
                    return false;
                if (a.text !== b.text)
                    return false;
                if (a.baseX !== b.baseX)
                    return false;
                if (a.baseY !== b.baseY)
                    return false;
                if (a.dir !== b.dir)
                    return false;
                if (a.tailPos !== b.tailPos)
                    return false;
                return true;
            }
        }
        Life.TipsWindow = TipsWindow;
        const EmptyData = {
            index: 0,
            text: "",
            baseX: 0,
            baseY: 0,
            dir: 6,
            tailPos: 0.5,
        };
        Life.TipsMax = 2;
        class UI {
            constructor() {
                this._list = [];
            }
            initialize() {
                this._list = [];
                for (let i = 0; i < Life.TipsMax; i++) {
                    const info = {
                        visible: false,
                        data: EmptyData,
                    };
                    this._list.push(info);
                }
            }
            getInfo(index) {
                return this._list[index];
            }
            display(data) {
                const info = this._list[data.index];
                if (!info)
                    return;
                info.visible = true;
                const copy = {
                    index: data.index,
                    text: getTipsText(data.text),
                    baseX: data.baseX,
                    baseY: data.baseY,
                    dir: data.dir,
                    tailPos: data.tailPos,
                };
                info.data = copy;
            }
            hidden(index) {
                const info = this._list[index];
                if (!info)
                    return;
                info.visible = false;
            }
            terminate() {
                this._list.forEach((info) => {
                    info.visible = false;
                    info.data = EmptyData;
                });
            }
        }
        class Lottery {
            constructor(cond) {
                this._lotteries = new Map();
                this._cond = cond;
            }
            initialize() {
                this._lotteries.clear();
                [...$dataTips.keys()].forEach((id) => {
                    this._lotteries.set(id, { id: id, read: false });
                });
            }
            isRead(id) {
                return !!this._lotteries.get(id);
            }
            setRead(id, read) {
                const data = this._lotteries.get(id);
                if (!data)
                    return;
                data.read = read;
            }
            lottery() {
                const enableList = [...this._lotteries.keys()].filter((id) => this._cond.check(id));
                const noReadList = enableList.filter((id) => !this._lotteries.get(id)?.read);
                if (noReadList.length > 0) {
                    return noReadList[0];
                }
                const index = Math.randomInt(enableList.length);
                return enableList[index] ?? 0;
            }
            setData(id, data_) {
                const data = this._lotteries.get(id);
                if (!data)
                    return;
                Object.assign(data, data_);
            }
            getList() {
                return [...this._lotteries.values()];
            }
            setList(readList) {
                readList.forEach((data) => {
                    this.setData(data.id, data);
                });
            }
        }
        class TipsProxy {
            constructor() {
                this._ui = new UI();
                this._condition = new Condition();
                this._lottery = new Lottery(this._condition);
            }
            get ui() {
                return this._ui;
            }
            get lottery() {
                return this._lottery;
            }
            get condition() {
                return this._condition;
            }
            initialize() {
                this._ui.initialize();
                this._condition.initialize();
                this._lottery.initialize();
            }
            getData() {
                return {
                    lotteries: this._lottery.getList(),
                };
            }
            setData(data) {
                this._lottery.setList(data?.lotteries ?? []);
            }
        }
        Life.Tips = new TipsProxy();
        function initializeTips() {
            Life.Tips.initialize();
        }
        Life.initializeTips = initializeTips;
        function getTipsText(textOrId) {
            const data = $dataTipsText.get(textOrId);
            return data?.text ?? textOrId;
        }
        Life.getTipsText = getTipsText;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var TipsUtil;
        (function (TipsUtil) {
            function lottery(variableId) {
                const index = Iz.Life.Tips.lottery.lottery();
                Iz.Life.Tips.lottery.setRead(index, true);
                $gameVariables.setValue(variableId, index);
                return index;
            }
            TipsUtil.lottery = lottery;
            function lotteryTest() {
                for (let i = 0; i < 10; i++) {
                    const index = lottery(25);
                    console.log(index);
                }
            }
            TipsUtil.lotteryTest = lotteryTest;
        })(TipsUtil = Life.TipsUtil || (Life.TipsUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const script = document.currentScript;
    PluginManagerEx.registerCommand(script, "display", (args) => {
        const data = args;
        Iz.Life.Tips.ui.display(data);
    });
    PluginManagerEx.registerCommand(script, "hidden", (args) => {
        Iz.Life.Tips.ui.hidden(args.index);
    });
    PluginManagerEx.registerCommand(script, "terminate", (args) => {
        Iz.Life.Tips.ui.terminate();
    });
    PluginManagerEx.registerCommand(script, "lottery", (args) => {
        if (!args.variableId)
            return;
        Iz.Life.TipsUtil.lottery(args.variableId);
    });
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeTips();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.tips = Iz.Life.Tips.getData();
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.Tips.setData(contents.tips);
    };
    const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
    Scene_Map.prototype.createDisplayObjects = function () {
        _Scene_Map_createDisplayObjects.call(this);
        this._tips = [];
        for (let i = 0; i < Iz.Life.TipsMax; i++) {
            const w = new Iz.Life.TipsWindow();
            this._tips.push(w);
            this.addChild(w);
        }
        this.updateTips();
    };
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        this.updateTips();
    };
    Scene_Map.prototype.updateTips = function () {
        for (let i = 0; i < Iz.Life.TipsMax; i++) {
            const info = Iz.Life.Tips.ui.getInfo(i);
            if (!info)
                continue;
            const w = this._tips[i];
            if (!w)
                continue;
            w.visible = info.visible;
            if (w.visible) {
                w.set(info.data);
            }
        }
    };
})();
//# sourceMappingURL=Tips.js.map