/*:
 * @target MZ
 * @plugindesc タイトル
 *
 * @help
 * バージョン表記やタイトル画像の差し替え
 *
 */
(() => {
    const _Scene_Title_create = Scene_Title.prototype.create;
    Scene_Title.prototype.create = function () {
        _Scene_Title_create.call(this);
        this.createVersionSprite();
        this.createBuildVersionSprite();
    };
    Scene_Title.prototype.createBackground = function () {
        let title1Name = $dataSystem.title1Name;
        if (!Iz.System.i18n.isDefault()) {
            title1Name = `${title1Name}_lang`;
        }
        this._backSprite1 = new Sprite(ImageManager.loadTitle1(title1Name));
        this._backSprite2 = new Sprite(ImageManager.loadTitle2($dataSystem.title2Name));
        this.addChild(this._backSprite1);
        this.addChild(this._backSprite2);
    };
    const OffsetX = 16;
    Scene_Title.prototype.createVersionSprite = function () {
        this._versionSprite = new Sprite_Text(200, 32);
        this._versionSprite.setAlign("right");
        this._versionSprite.setFontSize(20);
        const versionCountStr = Iz.Life.env.version_count ? `-${Iz.Life.env.version_count}` : "";
        const version = Iz.String.format("ver. {0}{1}", `${Iz.Life.env.version}${versionCountStr} `, `${Iz.Life.isTrial() ? "(trial)" : ""}`);
        this._versionSprite.setText(version, true);
        this._versionSprite.x = Graphics.width - this._versionSprite.width - OffsetX;
        this._versionSprite.y = Graphics.height - 80;
        this.addChild(this._versionSprite);
    };
    Scene_Title.prototype.createBuildVersionSprite = function () {
        this._buildVersionSprite = new Sprite_Text(Graphics.width, 32);
        this._buildVersionSprite.setAlign("right");
        this._buildVersionSprite.setFontSize(20);
        const buildVersionText = Iz.Life.env.build;
        const buildVersion = Iz.String.format("build. {0}", buildVersionText);
        this._buildVersionSprite.setText(buildVersion, true);
        this._buildVersionSprite.x = Graphics.width - this._buildVersionSprite.width - OffsetX;
        this._buildVersionSprite.y = Graphics.height - 48;
        this.addChild(this._buildVersionSprite);
    };
})();
//# sourceMappingURL=Title.js.map