/*:
 * @target MZ
 * @plugindesc 起動ボタン拡張
 *
 * @help
 * [機能]
 * ・任意のキーでイベントを起動
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.TRIGGER_BUTTON_TAG = "trigger_input_key";
        let _triggeredKey = "";
        function setTriggeredKey(key) {
            _triggeredKey = key;
        }
        Life.setTriggeredKey = setTriggeredKey;
        function triggeredKey() {
            return _triggeredKey;
        }
        Life.triggeredKey = triggeredKey;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Game_Player_triggerButtonAction = Game_Player.prototype.triggerButtonAction;
    Game_Player.prototype.triggerButtonAction = function () {
        if (Iz.Life.isTouchOk()) {
            if (this.getOnOffVehicle()) {
                return true;
            }
            this.checkEventTriggerHere([0]);
            if ($gameMap.setupStartingEvent()) {
                return true;
            }
            this.checkEventTriggerThere([0, 1, 2]);
            if ($gameMap.setupStartingEvent()) {
                return true;
            }
        }
        return _Game_Player_triggerButtonAction.call(this);
    };
})();
(() => {
    "use strict";
    const _Game_Player_triggerButtonAction = Game_Player.prototype.triggerButtonAction;
    Game_Player.prototype.triggerButtonAction = function () {
        const res = _Game_Player_triggerButtonAction.call(this);
        if (res) {
            Iz.Life.setTriggeredKey(Iz.IO.KEY_NAME_OK);
            $gameMap._interpreter._triggeredFromButtonAction = true;
            return true;
        }
        const event = Iz.Life.getThereEvent();
        if (event) {
            const trigger = String(event.event().meta[Iz.Life.TRIGGER_BUTTON_TAG]);
            if (trigger) {
                // NOTE:
                // TouchInput時はsubaction固定
                // cancelなど動的に対応する必要あるかも
                if (Input.isTriggered(trigger) ||
                    (trigger === Iz.IO.KEY_NAME_SUB_ACTION && TouchInput.isCancelled())) {
                    this.checkEventTriggerThere([0, 1, 2]);
                    if ($gameMap.setupStartingMapEvent()) {
                        Iz.Life.setTriggeredKey(trigger);
                        $gameMap._interpreter._triggeredFromButtonAction = true;
                        return true;
                    }
                }
            }
        }
        return false;
    };
    const _Game_Interpreter_terminate = Game_Interpreter.prototype.terminate;
    Game_Interpreter.prototype.terminate = function () {
        _Game_Interpreter_terminate.call(this);
        if (this._triggeredFromButtonAction) {
            Iz.Life.setTriggeredKey("");
        }
        this._triggeredFromButtonAction = false;
    };
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.setTriggeredKey("");
    };
})();
//# sourceMappingURL=TriggerButtonEx.js.map