/*:
 * @target MZ
 * @plugindesc 農作・伐採・採掘などの共通処理
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        function getWorkTypeName(workType) {
            const textKey = `WORK_TYPE_NAME_${workType}`;
            return Iz.Text.get(textKey);
        }
        Life.getWorkTypeName = getWorkTypeName;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        Life.EventType = {
            None: 0,
            Soil: 1,
            Plant: 2,
            Sprinkler: 3,
            Incubator: 4,
        };
        Life.ActionType = {
            None: "none",
            Hoe: "hoe",
            Ax: "ax",
            Hammer: "hammer",
            FarmLeveling: "farmleveling",
            Plant: "plant",
            WaterPot: "waterpot",
            Fishing: "fishing",
            FishingSequence: "fishing_sequence",
            TakeWater: "takewater",
            PutSprinkler: "putsprinkler",
            ItemUse: "itemuse",
        };
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    Game_Character.prototype.setEventType = function (eventType) {
        this._eventType = eventType;
    };
    Game_Character.prototype.eventType = function () {
        return this._eventType;
    };
    const _Game_Event_initialize = Game_Event.prototype.initialize;
    Game_Event.prototype.initialize = function (...args) {
        // @ts-ignore
        _Game_Event_initialize.apply(this, arguments);
        this._eventType = Iz.Life.EventType.None;
    };
})();
(function (Iz) {
    var Life;
    (function (Life) {
        function getToolItems(toolName) {
            return $dataItems
                .filter((item) => item)
                .filter((item) => {
                const level = Number.parseInt(item.meta[toolName]?.toString());
                return Number.isInteger(level) && level > 0;
            })
                .map((item) => {
                return { id: item.id, level: Number.parseInt(item.meta[toolName].toString()) };
            })
                .sort((a, b) => a.level - b.level);
        }
        Life.getToolItems = getToolItems;
        function calcToolLevel(list) {
            for (let i = list.length - 1; i >= 0; i--) {
                const item = $dataItems[list[i]];
                if (item && $gameParty.hasItem(item)) {
                    return i + 1;
                }
            }
            return 0;
        }
        Life.calcToolLevel = calcToolLevel;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// アクション関連
(function (Iz) {
    var Life;
    (function (Life) {
        Life.TargetsMax = 25;
        function getTurnRight(d) {
            switch (d) {
                case 2:
                    return 4;
                case 4:
                    return 8;
                case 6:
                    return 2;
                case 8:
                    return 6;
            }
            return 0;
        }
        function getTurnLeft(d) {
            switch (d) {
                case 2:
                    return 6;
                case 4:
                    return 2;
                case 6:
                    return 8;
                case 8:
                    return 4;
            }
            return 0;
        }
        function getTherePositions(x, y, d) {
            const positions = [];
            if (d === 4) {
                if (Number.isInteger(x)) {
                    positions.push({ x: x - 1, y: Math.floor(y) });
                    positions.push({ x: x - 1, y: Math.ceil(y) });
                }
                else {
                    positions.push({ x: Math.floor(x), y: Math.floor(y) });
                    positions.push({ x: Math.floor(x), y: Math.ceil(y) });
                }
            }
            else if (d === 6) {
                if (Number.isInteger(x)) {
                    positions.push({ x: x + 1, y: Math.floor(y) });
                    positions.push({ x: x + 1, y: Math.ceil(y) });
                }
                else {
                    positions.push({ x: Math.ceil(x), y: Math.floor(y) });
                    positions.push({ x: Math.ceil(x), y: Math.ceil(y) });
                }
            }
            else if (d === 8) {
                if (Number.isInteger(y)) {
                    positions.push({ x: Math.floor(x), y: y - 1 });
                    positions.push({ x: Math.ceil(x), y: y - 1 });
                }
                else {
                    positions.push({ x: Math.floor(x), y: Math.floor(y) });
                    positions.push({ x: Math.ceil(x), y: Math.floor(y) });
                }
            }
            else if (d === 2) {
                if (Number.isInteger(y)) {
                    positions.push({ x: Math.floor(x), y: y + 1 });
                    positions.push({ x: Math.ceil(x), y: y + 1 });
                }
                else {
                    positions.push({ x: Math.floor(x), y: Math.ceil(y) });
                    positions.push({ x: Math.ceil(x), y: Math.ceil(y) });
                }
            }
            return positions.filter((val, i, self) => self.findIndex((e) => e.x === val.x && e.y === val.y) === i);
        }
        Life.getTherePositions = getTherePositions;
        // 現在の位置(半歩移動込み)と向きから対象となる位置を取得
        function getUsePosition(x_, y_, direction) {
            let x = x_;
            let y = y_;
            if (direction === 6) {
                x = $gameMap.xWithDirection(Math.floor(x), direction);
            }
            else if (direction === 4) {
                x = $gameMap.xWithDirection(Math.ceil(x), direction);
            }
            else {
                x = $gameMap.xWithDirection(Math.ceil(x), direction);
            }
            if (direction === 2) {
                y = $gameMap.yWithDirection(Math.floor(y), direction);
            }
            else if (direction === 8) {
                y = $gameMap.yWithDirection(Math.ceil(y), direction);
            }
            else {
                y = $gameMap.yWithDirection(Math.ceil(y), direction);
            }
            return { x: x, y: y };
        }
        Life.getUsePosition = getUsePosition;
        function getActionPosition(basePos, d) {
            return {
                x: $gameMap.roundXWithDirection(basePos.x, d),
                y: $gameMap.roundYWithDirection(basePos.y, d),
            };
        }
        Life.getActionPosition = getActionPosition;
        function getActionPositionList(basePos, level) {
            const dir = $gamePlayer.direction();
            const leftDir = getTurnLeft(dir);
            const rightDir = getTurnRight(dir);
            if (level <= 1) {
                return [basePos];
            }
            if (level === 2) {
                // 1x3
                return [
                    getActionPosition(basePos, leftDir),
                    basePos,
                    getActionPosition(basePos, rightDir),
                ];
            }
            if (level === 3) {
                // 2x3
                const leftPos = getActionPosition(basePos, leftDir);
                const rightPos = getActionPosition(basePos, rightDir);
                const leftPos2 = getActionPosition(leftPos, dir);
                const basePos2 = getActionPosition(basePos, dir);
                const rightPos2 = getActionPosition(rightPos, dir);
                return [leftPos, basePos, rightPos, leftPos2, basePos2, rightPos2];
            }
            if (level === 4) {
                // 3x3
                const leftPos = getActionPosition(basePos, leftDir);
                const rightPos = getActionPosition(basePos, rightDir);
                const leftPos2 = getActionPosition(leftPos, dir);
                const basePos2 = getActionPosition(basePos, dir);
                const rightPos2 = getActionPosition(rightPos, dir);
                const leftPos3 = getActionPosition(leftPos2, dir);
                const basePos3 = getActionPosition(basePos2, dir);
                const rightPos3 = getActionPosition(rightPos2, dir);
                return [
                    leftPos,
                    basePos,
                    rightPos,
                    leftPos2,
                    basePos2,
                    rightPos2,
                    leftPos3,
                    basePos3,
                    rightPos3,
                ];
            }
            // 5x5
            const list = [];
            let pos3 = basePos;
            let pos2 = getActionPosition(basePos, leftDir);
            let pos1 = getActionPosition(pos2, leftDir);
            let pos4 = getActionPosition(basePos, rightDir);
            let pos5 = getActionPosition(pos4, rightDir);
            list.push(pos1, pos2, pos3, pos4, pos5);
            for (let i = 0; i < 4; i++) {
                pos1 = getActionPosition(pos1, dir);
                pos2 = getActionPosition(pos2, dir);
                pos3 = getActionPosition(pos3, dir);
                pos4 = getActionPosition(pos4, dir);
                pos5 = getActionPosition(pos5, dir);
                list.push(pos1, pos2, pos3, pos4, pos5);
            }
            return list;
        }
        Life.getActionPositionList = getActionPositionList;
        function isCharging() {
            return $gamePlayer.getActionController().currentAction instanceof ChargeAction;
        }
        Life.isCharging = isCharging;
        function isToolForbidden(mapId) {
            return !!$dataGlobalMapInfo[mapId]?.tool_forbidden;
        }
        Life.isToolForbidden = isToolForbidden;
        class ChargeAction extends Iz.Action {
            constructor(levelFrameList) {
                super();
                this._levelFrameList = [...levelFrameList];
                this._execed = false;
                this._execedFrame = 0;
                this._frame = 0;
            }
            onBegin() {
                this._frame = 0;
                Life.ItemSlot.operator.setActive(false, true);
                // チャージレベルの維持
                if (this.getChargeType() === $gameTemp.actionType && $gameTemp.chargeKeepFrame > 0) {
                    this._frame = this._levelFrameList[$gameTemp.chargeLevel - 1] ?? 0;
                }
                $gameTemp.actionType = this.getChargeType();
                $gameTemp.chargeKeepFrame = 0;
                $gameTemp.chargeLevel = 1;
                Iz.setDashDisabled(true);
                Life.Chara2D.ActorAnimator.play(this.actor(), this.animation().begin);
            }
            onUpdate() {
                if (!this._execed) {
                    this._frame++;
                    // ゲージ表示・更新
                    $gameTemp.chargeLevel = this.getChargeLevel();
                    $gameTemp.chargeRate = this.getChargeRate();
                    const basePos = Iz.Life.getUsePosition($gamePlayer.x, $gamePlayer.y, $gamePlayer.direction());
                    const positionList = this.getPositionList(basePos, this.getChargeLevel());
                    $gameTemp.chargeTargets = positionList;
                    if (Input.isReleased("ok") || TouchInput.isReleased()) {
                        if (Life.getHP() <= 0 && this.getConsumeHp() > 0) {
                            Iz.System.notifyHpShortage();
                            return true;
                        }
                        if (this.onExec()) {
                            Life.Chara2D.ActorAnimator.play(this.actor(), this.animation().exec);
                            const consumeHp = this.getConsumeHp();
                            if (consumeHp > 0) {
                                Iz.Life.consumeHP(consumeHp);
                            }
                            this.initChargeParam();
                            if (this.enableExecWait()) {
                                this._execed = true;
                                Iz.Life.EnablePlayerMove = false;
                            }
                            else {
                                return true;
                            }
                        }
                        else {
                            return true;
                        }
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_SUB_ACTION)) {
                        return true;
                    }
                    // console.log(`frame: ${this._frame} chargeLevel: ${this.getChargeLevel()} rate: ${this.getChargeRate()}`);
                    return false;
                }
                this._execedFrame++;
                const res = this._execedFrame >= $parameter.charge.wait_frame &&
                    !Life.Chara2D.ActorAnimator.isPlaying(this.actor());
                if (res) {
                    $gameTemp.chargeKeepFrame = $parameter.charge.keep_frame ?? 0;
                }
                return res;
            }
            onEnd() {
                this.initChargeParam();
                this._execed = false;
                this._execedFrame = 0;
                Iz.Life.EnablePlayerMove = true;
                Life.ItemSlot.operator.setActive(true, false);
                if ($gameTemp.chargeKeepFrame <= 0) {
                    $gameTemp.actionType = Life.ActionType.None;
                    $gameTemp.chargeLevel = 1;
                }
                const data = Life.Chara2D.ActorAnimator.getAnimator(this.actor())?.data;
                if (data?.name !== this.animation().exec) {
                    Life.Chara2D.ActorAnimator.stop(this.actor());
                    Life.Chara2D.resetActor(this.actor());
                }
                Iz.setDashDisabled(false);
            }
            initChargeParam() {
                this._frame = 0;
                // $gameTemp.chargeLevel = 0;
                $gameTemp.chargeRate = 0;
                $gameTemp.chargeTargets = [];
            }
            enableExecWait() {
                return true;
            }
            getConsumeHp() {
                return Iz.Life.getConsumeHp(this.getConsumeToolHp());
            }
            getChargeLevel() {
                const maxLevel = this.getChargeLevelMax();
                for (let i = 0; i < maxLevel; i++) {
                    const target = this._levelFrameList[i];
                    if (this._frame < target) {
                        return i;
                    }
                }
                return maxLevel;
            }
            getChargeRate() {
                if (this._frame < this._levelFrameList[0]) {
                    return 0;
                }
                if (this._frame >= this._levelFrameList[this.getChargeLevelMax() - 1]) {
                    return 1;
                }
                const level = this.getChargeLevel();
                const prevLevelFrame = this._levelFrameList[level - 1];
                const levelFrame = this._levelFrameList[level];
                return ((Math.min(this._frame, levelFrame) - prevLevelFrame) / (levelFrame - prevLevelFrame));
            }
            getChargeLevelMax() {
                const level = this.getToolLevel();
                return Math.min(Math.max(level, 1), this._levelFrameList.length);
            }
            getPositionList(basePos, level) {
                return getActionPositionList(basePos, level);
            }
            animation() {
                return {
                    begin: "",
                    exec: "",
                };
            }
            actor() {
                return 1;
            }
        }
        Life.ChargeAction = ChargeAction;
        class Sprite_ChargeTarget extends Sprite {
            constructor() {
                const bitmap = ImageManager.loadSystem("target");
                super(bitmap);
                this.blendMode = 1;
                this.z = 10;
                this.scale.x = 1;
                this.scale.y = 1;
            }
        }
        Life.Sprite_ChargeTarget = Sprite_ChargeTarget;
        class Sprite_ObjHp extends Sprite {
            constructor() {
                super();
                this.createBarBg();
                this.createBar();
                this.createBarFrame();
                this._counter = 0;
                this.z = 9; // アニメーションより上にしとく
            }
            createBarBg() {
                const sprite = new Sprite();
                sprite.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GAUGE_OBJ_HP);
                this.addChild(sprite);
            }
            createBar() {
                const sprite = new Sprite();
                sprite.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_BAR_OBJ_HP);
                sprite.x = 2;
                sprite.y = 4;
                this.addChild(sprite);
                this._bar = sprite;
            }
            createBarFrame() {
                const sprite = new Sprite();
                sprite.setAtlas(Life.ATLAS_KEY_HUD, Life.FRAME_KEY_HUD_GAUGE_OBJ_FRAME);
                this.addChild(sprite);
            }
            start() {
                this._counter = 1;
            }
            update() {
                super.update();
                if (this._counter > 0) {
                    const event = $gameMap._events[$gameTemp.objHpTarget.eventId];
                    if (!event) {
                        this.clear();
                    }
                    if (!this.visible && event) {
                        this.visible = true;
                    }
                    if (event) {
                        const tileWidth = $gameMap.tileWidth();
                        const tileHeight = $gameMap.tileHeight();
                        this.setValue($gameTemp.objHpTarget.value);
                        this.x = $gameMap.adjustX(event.x) * tileWidth;
                        this.y = $gameMap.adjustY(event.y - 0.65) * tileHeight;
                    }
                    this._counter++;
                    if (this._counter > 120) {
                        this.clear();
                    }
                }
            }
            clear() {
                this._counter = 0;
                this.visible = false;
            }
            setValue(value_) {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_HUD).getFrame(Life.FRAME_KEY_HUD_BAR_OBJ_HP);
                const value = value_.clamp(0, 1);
                this._bar.setFrame(frame.x, frame.y, frame.width * value, frame.height);
            }
        }
        Life.Sprite_ObjHp = Sprite_ObjHp;
        class ChargeGauge extends Sprite {
            constructor() {
                super();
                this.createBarBg();
                this.createBar();
                this.createBarFrame();
                const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_HUD);
                const frame = atlas.getFrame(Iz.Life.FRAME_KEY_HUD_GAUGE_OBJ_FRAME);
                this.setFrame(0, 0, frame.width, frame.height);
            }
            createBarBg() {
                const sprite = new Sprite();
                sprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_GAUGE_OBJ_HP);
                this.addChild(sprite);
            }
            createBar() {
                const sprite = new Sprite();
                sprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_BAR_OBJ_HP);
                sprite.x = 2;
                sprite.y = 4;
                this.addChild(sprite);
                this._bar = sprite;
            }
            createBarFrame() {
                const sprite = new Sprite();
                sprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_GAUGE_OBJ_FRAME);
                this.addChild(sprite);
            }
            setValue(value_) {
                const frame = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_HUD).getFrame(Iz.Life.FRAME_KEY_HUD_BAR_OBJ_HP);
                const value = value_.clamp(0, 1);
                this._bar.setFrame(frame.x, frame.y, frame.width * value, frame.height);
            }
        }
        class ChargeInfoSprite extends Sprite {
            constructor(target) {
                super();
                this.blendMode = 1;
                this.createLevelSprite();
                this.createChargeGauge();
                this._target = target;
                this.z = 11;
            }
            createLevelSprite() {
                this._levelSprite = new Sprite_Text(64, 16);
                this._levelSprite.setFontSize(12);
                this._levelSprite.x = -32;
                this._levelSprite.y = -96;
                this.addChild(this._levelSprite);
            }
            createChargeGauge() {
                this._gaugeSprite = new ChargeGauge();
                this._gaugeSprite.x = -Math.floor(this._gaugeSprite.width / 2);
                this._gaugeSprite.y = -80;
                this.addChild(this._gaugeSprite);
            }
            update() {
                super.update();
                this._gaugeSprite.setValue($gameTemp.chargeRate);
                this._levelSprite.setText(`Lv.${$gameTemp.chargeLevel}`, true);
                if ($gameTemp.chargeLevel > 1) {
                    this.visible = true;
                }
                else {
                    this.visible = false;
                }
                this.updatePosition();
            }
            updatePosition() {
                if (!this._target)
                    return;
                this.x = this._target.x;
                this.y = this._target.y;
            }
        }
        Life.ChargeInfoSprite = ChargeInfoSprite;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    const _Game_Temp_initialize = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function (...args) {
        _Game_Temp_initialize.call(this, ...args);
        this.chargeLevel = 1;
        this.chargeRate = 0;
        this.chargeTargets = [];
        this.actionType = Iz.Life.ActionType.None;
        this.chargeKeepFrame = 0;
        this.clearObjHp();
    };
    Game_Temp.prototype.startObjHpDraw = function (eventId, value) {
        this.objHpTarget.start = true;
        this.objHpTarget.eventId = eventId;
        this.objHpTarget.value = value;
    };
    Game_Temp.prototype.clearObjHp = function () {
        this.objHpTarget = { start: false, eventId: 0, value: 1 };
    };
    const NullTarget = [];
    const _Game_Map_update = Game_Map.prototype.update;
    Game_Map.prototype.update = function (sceneActive) {
        _Game_Map_update.call(this, sceneActive);
        $gameTemp.chargeTargets = NullTarget;
        // isEventRunning()だと岩などが破壊される時のコマンド（イベントの一時消去など）
        // でも対象になってしまうので、メッセージ表示の時だけクリアする
        if ($gameMessage.isBusy()) {
            $gameTemp.chargeKeepFrame = 0;
            $gameTemp.actionType = Iz.Life.ActionType.None;
            $gameTemp.chargeLevel = 1;
        }
        else {
            if ($gameTemp.chargeKeepFrame > 0) {
                // console.log(`chargeKeepFrame: ${$gameTemp.chargeKeepFrame} level: ${$gameTemp.chargeLevel} type: ${$gameTemp.chargeType}`);
                $gameTemp.chargeKeepFrame--;
                if ($gamePlayer.isMoving()) {
                    $gameTemp.chargeKeepFrame = 0;
                }
                if ($gameTemp.chargeKeepFrame <= 0) {
                    $gameTemp.actionType = Iz.Life.ActionType.None;
                    $gameTemp.chargeLevel = 1;
                }
            }
        }
    };
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        _Scene_Map_terminate.call(this);
        $gameTemp.clearObjHp();
        $gameTemp.chargeKeepFrame = 0;
        $gameTemp.actionType = Iz.Life.ActionType.None;
        $gameTemp.chargeLevel = 1;
    };
    const _Spriteset_Map_CreateLowerLayer = Spriteset_Map.prototype.createLowerLayer;
    Spriteset_Map.prototype.createLowerLayer = function () {
        _Spriteset_Map_CreateLowerLayer.call(this);
        this._chargeTargetSprites = [];
        for (let i = 0; i < Iz.Life.TargetsMax; i++) {
            const sprite = new Iz.Life.Sprite_ChargeTarget();
            sprite.visible = false;
            this._tilemap.addChild(sprite);
            this._chargeTargetSprites.push(sprite);
        }
        {
            const target = this._characterSprites.find((s) => s.checkCharacter($gamePlayer));
            const sprite = new Iz.Life.ChargeInfoSprite(target);
            this._chargeInfoSprite = sprite;
            this._tilemap.addChild(sprite);
        }
        {
            const sprite = new Iz.Life.Sprite_ObjHp();
            sprite.visible = false;
            this._objHpSprite = sprite;
            this._tilemap.addChild(sprite);
        }
    };
    const _Spriteset_Map_update = Spriteset_Map.prototype.update;
    Spriteset_Map.prototype.update = function () {
        _Spriteset_Map_update.call(this);
        for (let i = 0; i < this._chargeTargetSprites.length; i++) {
            const sprite = this._chargeTargetSprites[i];
            const target = $gameTemp.chargeTargets[i];
            if (target) {
                sprite.visible = true;
                const tileWidth = $gameMap.tileWidth();
                const tileHeight = $gameMap.tileHeight();
                sprite.x = $gameMap.adjustX(target.x) * tileWidth;
                sprite.y = $gameMap.adjustY(target.y) * tileHeight;
            }
            else {
                sprite.visible = false;
            }
        }
        if ($gameTemp.objHpTarget.start) {
            this._objHpSprite.start();
            $gameTemp.objHpTarget.start = false;
        }
    };
    const _Game_Event_initMembers = Game_Event.prototype.initMembers;
    Game_Event.prototype.initMembers = function () {
        _Game_Event_initMembers.call(this);
        this._extinctEffect = { enable: false, opacity: 0, frame: 0 };
    };
    Game_Event.prototype.setExtinctEffect = function (opacity) {
        this._extinctEffect = { enable: true, opacity: opacity, frame: 0 };
    };
    Game_Event.prototype.isExtinctEffect = function () {
        return this._extinctEffect.enable;
    };
    const ExtinctFrameOffset = 4;
    const ExtinctEndOpacity = 16;
    const _Game_Event_update = Game_Event.prototype.update;
    Game_Event.prototype.update = function () {
        _Game_Event_update.call(this);
        if (this._extinctEffect.enable) {
            this._extinctEffect.frame++;
            if (this._extinctEffect.frame >= ExtinctFrameOffset) {
                this._extinctEffect.frame = 0;
                this._extinctEffect.opacity = Math.floor(this._extinctEffect.opacity / 2);
                if (this._extinctEffect.opacity <= ExtinctEndOpacity) {
                    this._extinctEffect.enable = false;
                    this._extinctEffect.opacity = 0;
                }
                this.setOpacity(this._extinctEffect.opacity);
                if (this.opacity() <= 0) {
                    this.refresh();
                }
            }
        }
    };
    const _Scene_Map_isMenuEnabled = Scene_Map.prototype.isMenuEnabled;
    Scene_Map.prototype.isMenuEnabled = function () {
        if (Iz.Life.isCharging()) {
            return false;
        }
        return _Scene_Map_isMenuEnabled.call(this);
    };
})();
//# sourceMappingURL=WorkShared.js.map