var Iz;
(function (Iz) {
    const EaseInQuint = {
        value(t) {
            return t * t * t * t * t;
        },
    };
    const EaseOutQuint = {
        value(t) {
            return 1 - Math.pow(1 - t, 5);
        },
    };
    // const EaseOutBack: IEasing = {
    //     value(t: number) {
    //         const c1 = 1.70158;
    //         const c3 = c1 + 1;
    //         return 1 + c3 * Math.pow(t - 1, 3) + c1 * Math.pow(t - 1, 2);
    //     },
    // };
    const EaseInBack = {
        value(t) {
            const c1 = 1.70158;
            const c3 = c1 + 1;
            return c3 * t * t * t - c1 * t * t;
        },
    };
    const EaseInOutBack = {
        value(t) {
            const c1 = 1.70158;
            const c2 = c1 * 1.525;
            return t < 0.5
                ? (Math.pow(2 * t, 2) * ((c2 + 1) * 2 * t - c2)) / 2
                : (Math.pow(2 * t - 2, 2) * ((c2 + 1) * (t * 2 - 2) + c2) + 2) / 2;
        },
    };
    const EaseOutBack_CubicBezier = {
        value(t) {
            return Iz.Maths.cubicBezier(0.175, 0.885, 0.32, 1.275)(t);
        },
    };
    const EaseInCubic = {
        value(t) {
            return t * t * t;
        },
    };
    const EaseInOutCubic = {
        value(t) {
            return t < 0.5 ? 4 * t * t * t : 1 - Math.pow(-2 * t + 2, 3) / 2;
        },
    };
    const EaseInOutSine = {
        value(t) {
            return -(Math.cos(Math.PI * t) - 1) / 2;
        },
    };
    class EasingContant {
        constructor(value) {
            this._value = value;
        }
        value(t) {
            return this._value;
        }
    }
    class EasingProxy {
        get easeInQuint() {
            return EaseInQuint;
        }
        get easeOutQuint() {
            return EaseOutQuint;
        }
        get easeInBack() {
            return EaseInBack;
        }
        get easeOutBack() {
            return EaseOutBack_CubicBezier;
        }
        get easeInOutBack() {
            return EaseInOutBack;
        }
        get easeInCubic() {
            return EaseInCubic;
        }
        get easeInOutCubic() {
            return EaseInOutCubic;
        }
        get easeInOutSine() {
            return EaseInOutSine;
        }
        get easeZero() {
            return this.easeConstant(0);
        }
        get easeOne() {
            return this.easeConstant(1);
        }
        easeConstant(value) {
            return new EasingContant(value);
        }
    }
    Iz.Easing = new EasingProxy();
})(Iz || (Iz = {}));
(function (Iz) {
    class TweenEasing {
        constructor() {
            this._frame = 0;
            this._active = false;
        }
        update() {
            if (!this._active)
                return;
            this._frame++;
            if (this.finished()) {
                this._active = false;
            }
        }
        easingValue(frame) {
            const rate = Math.min(Math.max(frame / this._param.duration, 0), 1);
            return this._param.easing.value(rate);
        }
        value() {
            const easingVal = this.easingValue(this._frame);
            return this._param.invert ? 1 - easingVal : easingVal;
        }
        set(tweenValue) {
            this._param = tweenValue;
        }
        start() {
            this._frame = 0;
            this._active = true;
        }
        stop() {
            this._frame = 0;
            this._active = false;
        }
        finished() {
            return this._frame >= this._param.duration;
        }
        isPlaying() {
            return this._active;
        }
    }
    Iz.TweenEasing = TweenEasing;
    class TweenAnim {
        constructor() {
            this._clips = [];
            this._index = 0;
            this._loop = false;
            this._active = false;
        }
        get current() {
            return this._clips[this._index];
        }
        get loop() {
            return this._loop;
        }
        set loop(value) {
            this._loop = value;
        }
        start() {
            this._index = 0;
            this._active = true;
            this.startTween(this.current);
        }
        update() {
            if (!this._active) {
                return;
            }
            this.current.tween.update();
            if (this.current.tween.finished()) {
                this.finishTween(this.current);
                this._index++;
                if (this._index >= this._clips.length) {
                    this._index = 0;
                    if (this.loop) {
                        this.startTween(this.current);
                    }
                    else {
                        this._active = false;
                    }
                }
                else {
                    this.startTween(this.current);
                }
            }
        }
        stop() {
            this._index = 0;
            this._active = false;
        }
        add(clip) {
            this._clips.push(clip);
        }
        value() {
            return this.current.tween.value();
        }
        finished() {
            return this._index >= this._clips.length - 1 && this.current.tween.finished();
        }
        isPlaying() {
            return this._active;
        }
        startTween(clip) {
            clip.tween.start();
            clip.event?.onStart?.();
        }
        finishTween(clip) {
            clip.event?.onFinish?.();
        }
    }
    Iz.TweenAnim = TweenAnim;
    class TweenProxy {
        create(param) {
            const anim = new TweenAnim();
            param.clips.forEach((data) => {
                const tween = new TweenEasing();
                tween.set(data.param);
                const clip = {
                    tween: tween,
                    event: data.event,
                };
                anim.add(clip);
            });
            anim.loop = param.loop ?? false;
            return anim;
        }
    }
    Iz.TweenProxy = TweenProxy;
    Iz.Tween = new TweenProxy();
})(Iz || (Iz = {}));
//# sourceMappingURL=Tween.js.map