/*:
 * @target MZ
 * @plugindesc 変数の切り替え処理
 * @author INAZUMA GAMES
 *
 *
 *
 * @param VariableList
 * @type struct<VariableData>[]
 * @desc 変数一覧
 * @default []
 *
 *
 * @help
 * 特定のタイミングで変数の値を切り替えます
 * タイミングは今後増えるかも
 *
 * [切り替えタイミング]
 * ・マップイベントが起動した時
 *
 *
 */
/*~struct~SwitchData:
 * @param id
 * @type switch
 * @desc スイッチ
 *
 * @param value
 * @type boolean
 * @desc ON,OFF
 *
 */
/*~struct~VariableData:
 * @param id
 * @type variable
 * @desc 変数
 *
 * @param value
 * @type string
 * @text 値
 * @desc string,numberのいずれかのみ有効
 *
 */
(() => {
    "use strict";
    function createVariableList() {
        const param = PluginManagerEx.createParameter(document.currentScript);
        const variableList = param.VariableList;
        for (let i = 0; i < variableList.length; i++) {
            const numberValue = Number(variableList[i].value);
            if (Number.isFinite(numberValue)) {
                variableList[i].value = numberValue;
            }
        }
        return variableList;
    }
    const variables = [...createVariableList()];
    const _Game_Map_setupStartingMapEvent = Game_Map.prototype.setupStartingMapEvent;
    Game_Map.prototype.setupStartingMapEvent = function () {
        const res = _Game_Map_setupStartingMapEvent.call(this);
        if (res) {
            variables.forEach((data) => {
                if (typeof data.value === "number") {
                    $gameVariables.setValueFloat(data.id, data.value);
                }
                else {
                    $gameVariables.setValue(data.id, data.value);
                }
            });
        }
        return res;
    };
    const _Game_Map_setupAutorunCommonEvent = Game_Map.prototype.setupAutorunCommonEvent;
    Game_Map.prototype.setupAutorunCommonEvent = function () {
        const res = _Game_Map_setupAutorunCommonEvent.call(this);
        if (res) {
            variables.forEach((data) => {
                if (typeof data.value === "number") {
                    $gameVariables.setValueFloat(data.id, data.value);
                }
                else {
                    $gameVariables.setValue(data.id, data.value);
                }
            });
        }
        return res;
    };
})();
//# sourceMappingURL=ValueSwitcher.js.map