/*:
 * @target MZ
 * @plugindesc アトラス管理
 * @author INAZUMA GAMES
 *
 * @help
 *
 * AtlasPathList(プラグインからの設定) と AtlasPathJson(外部JSON) の同時設定が可能です
 * ※atlasKeyが重複する場合は AtlasPathList の方が優先されます
 *
 *
 * @param AtlasPathList
 * @text AtlasPathList
 * @desc Atlasの参照情報一覧
 * @type struct<AtlasPath>[]
 *
 * @param AtlasPathJson
 * @text AtlasPathJson
 * @desc AtlasPathListの外部読み込み用JSONのパス   data/XXX.json のようにプロジェクトルートからの相対パスで設定します
 * <JSON例>
 * {
 *     "list": [
 *          {
 *              "atlasKey": "hud",
 *              "filePath": "img/system/hud/texture"
 *          },
 *          .
 *          .
 *          .
 *
 *     ]
 * }
 *
 */
/*~struct~AtlasPath:
 * @param atlasKey
 * @text atlasKey
 * @desc 参照キー
 *
 * @param filePath
 * @text filePath
 * @desc ファイルパス（拡張子除く）
 *
 *
 */
var Iz;
(function (Iz) {
    var Atlas;
    (function (Atlas_1) {
        Atlas_1.ScaleMode = {
            LINEAR: 0,
            NEAREST: 1,
        };
        class Atlas {
            constructor(atlasKey, info) {
                this._atlasKey = atlasKey;
                this._info = info;
            }
            getBitmap() {
                const atlasPath = getAtlasPath(this._atlasKey);
                const path = require("path");
                const bitmap = ImageManager.loadBitmap(`${path.dirname(atlasPath.filePath)}/`, `${path.basename(atlasPath.filePath)}`);
                bitmap.addLoadListener(() => {
                    bitmap.smooth = this._info.scale_mode !== Atlas_1.ScaleMode.NEAREST;
                });
                return bitmap;
            }
            getFrame(frameKey) {
                const pointFrame = { x: 0, y: 0, width: 0, height: 0 };
                const frame = this._info.frames.find((textureFrame) => {
                    const file = textureFrame.filename.replace(/^(.+)\..+$/, "$1");
                    return file === frameKey;
                });
                if (frame) {
                    pointFrame.x = frame.frame.x;
                    pointFrame.y = frame.frame.y;
                    pointFrame.width = frame.frame.w;
                    pointFrame.height = frame.frame.h;
                }
                return pointFrame;
            }
        }
        Atlas_1.Atlas = Atlas;
        const KeyMap = new Map();
        const AtlasMap = new Map();
        function getAtlasPath(atlasKey) {
            return KeyMap.get(atlasKey);
        }
        function getAtlas(atlasKey) {
            return AtlasMap.get(atlasKey);
        }
        Atlas_1.getAtlas = getAtlas;
        function createAtlas(keyMap) {
            const fs = require("fs");
            AtlasMap.clear();
            keyMap.forEach((v, k) => {
                const info = JSON.parse(fs.readFileSync(`${v.filePath}.json`, "utf8"));
                AtlasMap.set(k, new Atlas(k, info));
            });
        }
        function initializeAtlas(list) {
            KeyMap.clear();
            if (list) {
                list.forEach((data) => {
                    KeyMap.set(data.atlasKey, data);
                });
            }
            createAtlas(KeyMap);
        }
        Atlas_1.initializeAtlas = initializeAtlas;
    })(Atlas = Iz.Atlas || (Iz.Atlas = {}));
})(Iz || (Iz = {}));
(() => {
    const param = PluginManagerEx.createParameter(document.currentScript);
    const pathList = [];
    if (param.AtlasPathJson) {
        const fs = require("fs");
        const obj = JSON.parse(fs.readFileSync(param.AtlasPathJson, "utf-8"));
        pathList.push(...obj.list);
    }
    if (param.AtlasPathList && param.AtlasPathList.length > 0) {
        pathList.push(...param.AtlasPathList);
    }
    //
    const checker = new Set();
    pathList.forEach((atlasPath) => {
        if (checker.has(atlasPath.atlasKey)) {
            console.warn(`アトラスのキーが重複しています atlasKey:${atlasPath.atlasKey}`);
        }
        checker.add(atlasPath.atlasKey);
    });
    Iz.Atlas.initializeAtlas(pathList);
    Sprite.prototype.setAtlas = function (atlasKey, frameKey) {
        const atlas = Iz.Atlas.getAtlas(atlasKey);
        this.bitmap = atlas.getBitmap();
        const frame = atlas.getFrame(frameKey);
        this.setFrame(frame.x, frame.y, frame.width, frame.height);
    };
})();
//# sourceMappingURL=Atlas.js.map