/*:
 * @target MZ
 * @plugindesc ツクールに依存しないコード群
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var String;
    (function (String) {
        /**
         * JavaやC#のformatメソッドのように、特定の文字列のプレースホルダを引数で渡された文字で置き換える
         * ※ https://qiita.com/YOS0602/items/8eadf8f7743ebdc5946c#typescript%E3%81%A7%E3%81%AE%E5%AE%9F%E8%A3%85
         *
         * @param str 置換前文字列 プレースホルダを`{0}`, `{1}`の形式で埋め込む
         * @param ...args 第2引数以降で、置換する文字列を指定する
         *
         * 参考
         * - https://stackoverflow.com/questions/610406/javascript-equivalent-to-printf-string-format/4673436#4673436
         * - https://trueman-developer.blogspot.com/2015/11/typescriptjavascript.html
         *
         * ### Sample
         * ```ts
         * format('{0}とは、{1}までに身に付けた{2}の{3}である。', '常識', '18歳', '偏見', 'コレクション')
         * format('{0}とは、{1}までに身に付けた{2}の{3}である。', ...['常識', '18歳', '偏見', 'コレクション'])
         * ```
         * →`'常識とは、18歳までに身に付けた偏見のコレクションである。'`
         */
        String.format = (str_, ...args) => {
            let str = str_;
            for (const [i, arg] of args.entries()) {
                const regExp = new RegExp(`\\{${i}\\}`, "g");
                str = str.replace(regExp, arg);
            }
            return str;
        };
    })(String = Iz.String || (Iz.String = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Obj;
    (function (Obj) {
        // targetに存在するプロパティのみ反映する
        function apply(target, src) {
            if (!!target && !!src) {
                Object.keys(target).forEach((key) => {
                    if (Object.hasOwn(src, key)) {
                        // @ts-ignore
                        target[key] = src[key];
                    }
                });
            }
            return target;
        }
        Obj.apply = apply;
        function applyRecursive(target, src) {
            if (!target || !src) {
                return;
            }
            const applyObject = (t, s) => {
                // null or undefined
                if (t == null || s == null) {
                    return;
                }
                Object.keys(t).forEach((key) => {
                    if (Object.hasOwn(s, key)) {
                        // @ts-ignore
                        if (typeof t[key] !== "object") {
                            // @ts-ignore
                            t[key] = s[key];
                        }
                        // @ts-ignore
                        else if (t[key]) {
                            // @ts-ignore
                            applyRecursive(t[key], s[key]);
                        }
                    }
                });
            };
            if (Array.isArray(target) && Array.isArray(src)) {
                target.forEach((p, i) => {
                    if (typeof p === "object") {
                        applyObject(p, src[i]);
                    }
                    else if (!(target[i] == null || src[i] == null)) {
                        target[i] = src[i];
                    }
                });
                return;
            }
            applyObject(target, src);
        }
        Obj.applyRecursive = applyRecursive;
        // Object.keysのユニオン版
        // 参考: https://zenn.dev/ossamoon/articles/694a601ee62526
        //
        // 引数にインターフェイスのオブジェクトを使用する場合、
        // スプレッド構文で新しいオブジェクトにコピーすることで回避します
        // https://qiita.com/bearone236/items/b52261cc83b2d1026e75#%EF%B8%8F-interface-%E5%9E%8B%E3%81%AE%E5%A0%B4%E5%90%88
        function keys(obj) {
            return Object.keys(obj);
        }
        Obj.keys = keys;
    })(Obj = Iz.Obj || (Iz.Obj = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var PromiseEx;
    (function (PromiseEx) {
        function waitUntil(condition, checkInterval = 30) {
            return new Promise((resolve) => {
                const id = setInterval(() => {
                    if (!condition())
                        return;
                    clearInterval(id);
                    resolve();
                }, checkInterval);
            });
        }
        PromiseEx.waitUntil = waitUntil;
    })(PromiseEx = Iz.PromiseEx || (Iz.PromiseEx = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=core.js.map