/*:
 * @target MZ
 * @plugindesc 出現条件拡張
 *
 * @help
 * 出現条件を制御文字で拡張します
 *
 *
 *
 */
var Iz;
(function (Iz) {
    class Main {
        constructor() {
            this._handlers = new Map();
        }
        initialize() {
            this._handlers.clear();
        }
        register(key, handler) {
            this._handlers.set(key, handler);
        }
        call(key, data) {
            return !!this._handlers.get(key)?.(data);
        }
    }
    Iz.MeetCondition = new Main();
    function initializeMeetCondition() {
        Iz.MeetCondition.initialize();
    }
    Iz.initializeMeetCondition = initializeMeetCondition;
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.initializeMeetCondition();
    };
    const _Game_Event_meetsConditions = Game_Event.prototype.meetsConditions;
    Game_Event.prototype.meetsConditions = function (page) {
        return _Game_Event_meetsConditions.call(this, page) && this.meetsConditionForComment(page);
    };
    Game_Event.prototype.meetsConditionForComment = function (page) {
        const command = page.list[0];
        if (command && command.code === 108) {
            const comment = command.parameters[0];
            if (comment.startsWith("\\MC{")) {
                return this.meetsConditionDataCheck(comment);
            }
        }
        return true;
    };
    Game_Event.prototype.meetsConditionDataCheck = function (comment) {
        const regex = /\\MC{(.+?)}/;
        const res = regex.exec(comment);
        if (!res)
            return false;
        const [key, ...args] = res[1].split(",");
        const data = {};
        args.forEach((a) => {
            const [p, v] = a.split(":");
            const n = Number(v);
            if (Number.isFinite(n)) {
                data[p] = n;
            }
            else {
                data[p] = v;
            }
        });
        return Iz.MeetCondition.call(key, data);
    };
})();
//# sourceMappingURL=MeetCondition.js.map