/*:
 * @target MZ
 * @plugindesc Window_XXX拡張
 *
 * @help
 *
 *
 */
// 制御文字関連
var Iz;
(function (Iz) {
    Iz.NonParamEscapeCodeList = [];
    function obtainEscapeCharacter(textState) {
        const regExp = /^\[([a-zA-Z0-9_#]+)\]/;
        const res = regExp.exec(textState.text.slice(textState.index));
        if (res) {
            textState.index += res[0].length;
            return res[1];
        }
        return "";
    }
    Iz.obtainEscapeCharacter = obtainEscapeCharacter;
    function obtainEscapeCodeNonParam(textState) {
        // NOTE:
        // パラメータが無い制御文字を正しく処理する
        const text = textState.text.slice(textState.index);
        for (let i = 0; i < Iz.NonParamEscapeCodeList.length; i++) {
            const code = Iz.NonParamEscapeCodeList[i];
            const re = new RegExp(`^${code}`);
            if (re.exec(text)) {
                textState.index += code.length;
                return code;
            }
        }
        return "";
    }
    Iz.obtainEscapeCodeNonParam = obtainEscapeCodeNonParam;
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
    Window_Base.prototype.processEscapeCharacter = function (code, textState) {
        _Window_Base_processEscapeCharacter.call(this, code, textState);
        switch (code) {
            case "CC": {
                const colorCode = Iz.obtainEscapeCharacter(textState);
                const colorCodeInt = Number.parseInt(colorCode);
                if (Number.isInteger(colorCodeInt)) {
                    this.processColorChange(colorCodeInt);
                }
                else {
                    this.changeTextColor(colorCode);
                }
                break;
            }
        }
    };
    const _Window_Base_obtainEscapeCode = Window_Base.prototype.obtainEscapeCode;
    Window_Base.prototype.obtainEscapeCode = function (textState) {
        const code = Iz.obtainEscapeCodeNonParam(textState);
        if (code) {
            return code;
        }
        return _Window_Base_obtainEscapeCode.call(this, textState);
    };
})();
//# sourceMappingURL=CoreWindowEx.js.map