/*:
 * @target MZ
 * @plugindesc インタプリタ拡張
 *
 * @help
 *
 *
 *
 * @command waitOk
 * @text 決定キー待機
 *
 */
// 決定キー待機
(() => {
    "use strict";
    const WaitModeName = "trigger_ok";
    const script = document.currentScript;
    PluginManagerEx.registerCommand(script, "waitOk", (args) => {
        $gameMap._interpreter.setWaitMode(WaitModeName);
    });
    const _Game_Interpreter_updateWaitMode = Game_Interpreter.prototype.updateWaitMode;
    Game_Interpreter.prototype.updateWaitMode = function () {
        if (this._waitMode === WaitModeName) {
            const res = Input.isTriggered("ok");
            if (res) {
                this._waitMode = "";
                // 決定キーが連続検知されないように1フレーム待機する
                this.wait(1);
            }
            return !res;
        }
        return _Game_Interpreter_updateWaitMode.call(this);
    };
})();
// イベント処理中判定
(() => {
    "use strict";
    Game_Interpreter.prototype.isProcessing = function () {
        return this.isRunning() && this._index > 0;
    };
})();
//# sourceMappingURL=Game_InterpreterEx.js.map