/*:
 * @target MZ
 * @plugindesc Game_XXX拡張
 *
 *
 */
// Game_Temp
(() => {
    "use strict";
    const _Game_Temp_init = Game_Temp.prototype.initialize;
    Game_Temp.prototype.initialize = function (...args) {
        _Game_Temp_init.call(this, ...args);
        this._delayAnimationQueue = [];
    };
    Game_Temp.prototype.requestDelayAnimation = function (targets, animationId, delay, mirror) {
        if ($dataAnimations[animationId]) {
            if (delay > 0) {
                const BaseDelay = 1; // 更新順番の都合上、必ず1以上にする
                const request = {
                    targets: targets,
                    animationId: animationId,
                    delay: delay + BaseDelay,
                    mirror: mirror,
                };
                this._delayAnimationQueue.push(request);
            }
            else {
                this.requestAnimation(targets, animationId, mirror);
            }
        }
    };
    Game_Temp.prototype.updateDelayAnimation = function () {
        const removeList = [];
        this._delayAnimationQueue.forEach((request, i) => {
            request.delay--;
            if (request.delay <= 0) {
                this.requestAnimation(request.targets, request.animationId, request.mirror);
                removeList.push(i);
            }
        });
        if (removeList.length > 0) {
            for (let i = removeList.length - 1; i >= 0; i--) {
                this._delayAnimationQueue.splice(i, 1);
            }
        }
    };
    const _Spriteset_Base_processAnimationRequests = Spriteset_Base.prototype.processAnimationRequests;
    Spriteset_Base.prototype.processAnimationRequests = function () {
        _Spriteset_Base_processAnimationRequests.call(this);
        $gameTemp.updateDelayAnimation();
    };
})();
(() => {
    "use strict";
    Game_Variables.prototype.setValueFloat = function (variableId, value) {
        if (variableId > 0 && variableId < $dataSystem.variables.length) {
            this._data[variableId] = value;
            this.onChange();
        }
    };
})();
(() => {
    "use strict";
    Game_Switches.prototype.setValueIfChanged = function (switchId, value) {
        const current = this.value(switchId);
        if (current !== value) {
            this.setValue(switchId, value);
        }
    };
})();
(() => {
    // NOTE:
    // 画面から遠く離れても動くように
    Game_CharacterBase.prototype.isNearTheScreen = function () {
        return true;
    };
})();
Game_CharacterBase.prototype.mapId = function () {
    return 0;
};
Game_Character.prototype.requestAnimation = function (animationId) {
    if (animationId <= 0)
        return;
    $gameTemp.requestAnimation([this], animationId);
};
// Game_Event
Game_Event.prototype.mapId = function () {
    return this._mapId;
};
const DisableTurnPlayerTag = "disable_turn_player";
const _Game_Event_turnTowardPlayer = Game_Event.prototype.turnTowardPlayer;
Game_Event.prototype.turnTowardPlayer = function () {
    const meta = this.event().meta;
    if (Object.hasOwn(meta, DisableTurnPlayerTag)) {
        return;
    }
    _Game_Event_turnTowardPlayer.call(this);
};
// Game_Player
Game_Player.prototype.mapId = function () {
    return $gameMap.mapId();
};
(() => {
    "use strict";
    Game_Screen.prototype.startFadeOutColor = function (option) {
        this._fadeOutDuration = option?.duration ?? 24;
        this._fadeInDuration = 0;
        if (option?.color) {
            this._flashColor[0] = option.color[0];
            this._flashColor[1] = option.color[1];
            this._flashColor[2] = option.color[2];
        }
        this._customFade = true;
    };
    Game_Screen.prototype.startFadeInColor = function (option) {
        this._fadeInDuration = option?.duration ?? 24;
        this._fadeOutDuration = 0;
        if (option?.color) {
            this._flashColor[0] = option.color[0];
            this._flashColor[1] = option.color[1];
            this._flashColor[2] = option.color[2];
        }
        this._customFade = true;
    };
    const _Game_Screen_updateFadeOut = Game_Screen.prototype.updateFadeOut;
    Game_Screen.prototype.updateFadeOut = function () {
        if (this._customFade && this._fadeOutDuration > 0) {
            const d = this._fadeOutDuration;
            this._flashColor[3] += (255 - this._flashColor[3]) / d;
            this._fadeOutDuration--;
            if (this._fadeOutDuration <= 0) {
                this._customFade = false;
            }
            return;
        }
        _Game_Screen_updateFadeOut.call(this);
    };
    const _Game_Screen_updateFadeIn = Game_Screen.prototype.updateFadeIn;
    Game_Screen.prototype.updateFadeIn = function () {
        if (this._customFade && this._fadeInDuration > 0) {
            const d = this._fadeInDuration;
            this._flashColor[3] -= this._flashColor[3] / d;
            this._fadeInDuration--;
            if (this._fadeInDuration <= 0) {
                this._customFade = false;
            }
            return;
        }
        _Game_Screen_updateFadeIn.call(this);
    };
})();
(() => {
    "use strict";
    Game_CharacterBase.prototype.isUpdatedColorTone = function () {
        return this._updateColorTone;
    };
    Game_CharacterBase.prototype.clearUpdatedColorTone = function () {
        this._updateColorTone = false;
    };
    Game_CharacterBase.prototype.setColorTone = function (tone) {
        this._updateColorTone = true;
        this._colorTone = tone;
    };
    Game_CharacterBase.prototype.getColorTone = function () {
        return this._colorTone;
    };
    const _Sprite_Character_updateOther = Sprite_Character.prototype.updateOther;
    Sprite_Character.prototype.updateOther = function () {
        _Sprite_Character_updateOther.call(this);
        if (this._character.isUpdatedColorTone()) {
            this.setColorTone(this._character.getColorTone());
            this._character.clearUpdatedColorTone();
        }
    };
})();
//# sourceMappingURL=Game_ObjectEx.js.map