/*:
 * @target MZ
 * @plugindesc Input拡張
 *
 * @help
 * Input拡張
 *
 * [機能]
 * キーマッピング
 * Input.isReleased()の提供
 *
 * [その他]
 * ※Inputの処理を書き換えているので競合の可能性あり
 *
 *
 */
var Iz;
(function (Iz) {
    var IO;
    (function (IO) {
        // 必要に応じて追加してください
        IO.KEY_CODE_BACKSPACE = 8;
        IO.KEY_CODE_ENTER = 13;
        IO.KEY_CODE_SHIFT = 16;
        IO.KEY_CODE_CTRL = 17;
        IO.KEY_CODE_ESCAPE = 27;
        IO.KEY_CODE_SPACE = 32;
        IO.KEY_CODE_END = 35;
        IO.KEY_CODE_HOME = 36;
        IO.KEY_CODE_LEFT_ARROW = 37;
        IO.KEY_CODE_UP_ARROW = 38;
        IO.KEY_CODE_RIGHT_ARROW = 39;
        IO.KEY_CODE_DOWN_ARROW = 40;
        IO.KEY_CODE_INSERT = 45;
        IO.KEY_CODE_DELETE = 46;
        IO.KEY_CODE_DIGIT_0 = 48;
        IO.KEY_CODE_DIGIT_1 = 49;
        IO.KEY_CODE_DIGIT_2 = 50;
        IO.KEY_CODE_DIGIT_3 = 51;
        IO.KEY_CODE_DIGIT_4 = 52;
        IO.KEY_CODE_DIGIT_5 = 53;
        IO.KEY_CODE_DIGIT_6 = 54;
        IO.KEY_CODE_DIGIT_7 = 55;
        IO.KEY_CODE_DIGIT_8 = 56;
        IO.KEY_CODE_DIGIT_9 = 57;
        IO.KEY_CODE_A = 65;
        IO.KEY_CODE_B = 66;
        IO.KEY_CODE_C = 67;
        IO.KEY_CODE_D = 68;
        IO.KEY_CODE_E = 69;
        IO.KEY_CODE_F = 70;
        IO.KEY_CODE_M = 77;
        IO.KEY_CODE_N = 78;
        IO.KEY_CODE_Q = 81;
        IO.KEY_CODE_R = 82;
        IO.KEY_CODE_S = 83;
        IO.KEY_CODE_V = 86;
        IO.KEY_CODE_W = 87;
        IO.KEY_CODE_X = 88;
        IO.KEY_CODE_Z = 90;
        IO.KEY_CODE_NUMPAD_0 = 96;
        IO.KEY_CODE_SMALLER = 188; // <
        IO.KEY_CODE_BRACKETLEFT = 219; // [
        IO.KEY_CODE_BRACKETRIGHT = 221; // ]
        IO.KEY_NAME_OK = "ok";
        IO.KEY_NAME_ESCAPE = "escape";
        IO.KEY_NAME_SHIFT = "shift";
        IO.KEY_NAME_TAB = "tab";
        IO.KEY_NAME_LEFT = "left";
        IO.KEY_NAME_UP = "up";
        IO.KEY_NAME_RIGHT = "right";
        IO.KEY_NAME_DOWN = "down";
        IO.KEY_NAME_MENU = "menu";
        IO.KEY_NAME_CANCEL = "cancel";
        IO.PAD_NAME_X = "pad_x";
        IO.PAD_NAME_Y = "pad_y";
        IO.PAD_A = 0;
        IO.PAD_B = 1;
        IO.PAD_X = 2;
        IO.PAD_Y = 3;
        IO.PAD_LB = 4;
        IO.PAD_RB = 5;
        IO.PAD_LT = 6;
        IO.PAD_RT = 7;
        IO.PAD_BACK = 8;
        IO.PAD_START = 9;
        IO.PAD_UP = 12;
        IO.PAD_DOWN = 13;
        IO.PAD_LEFT = 14;
        IO.PAD_RIGHT = 15;
        const DefaultKeyMapper = Object.assign({}, Input.keyMapper);
        const DefaultPadMapper = Object.assign({}, Input.gamepadMapper);
        function getDefaultKeyMapper() {
            return copyKeyMapper(DefaultKeyMapper);
        }
        IO.getDefaultKeyMapper = getDefaultKeyMapper;
        function checkDisableKeyCode() {
            // NOTE:
            // 現在押されているinputKeyのkeyCodeは、keyUp()が呼ばれるまで無効化
            Input._disableKeyMapper = {};
            Input._checkDisable = false;
            for (const inputKey in Input._currentState) {
                if (!Input._currentState[inputKey])
                    continue;
                const codes = Input._keyCodeMapper.get(inputKey);
                if (!codes)
                    continue;
                for (let i = 0; i < codes.length; i++) {
                    const code = codes[i];
                    if (!Input._keyCodeDownMapper[code])
                        continue;
                    Input._disableKeyMapper[code] = true;
                    Input._checkDisable = true;
                }
            }
        }
        IO.checkDisableKeyCode = checkDisableKeyCode;
        function setInputKeyMapper(keyMapper) {
            Input.keyMapper = keyMapper;
            Input._keyCodeMapper.clear();
            for (const keyCodeStr in keyMapper) {
                const keyCode = Number(keyCodeStr);
                const inputKey = keyMapper[keyCode];
                let codes = Input._keyCodeMapper.get(inputKey);
                if (!codes) {
                    codes = [];
                    Input._keyCodeMapper.set(inputKey, codes);
                }
                codes.push(keyCode);
            }
        }
        IO.setInputKeyMapper = setInputKeyMapper;
        function copyKeyMapper(keyMapper) {
            return Object.assign({}, keyMapper);
        }
        IO.copyKeyMapper = copyKeyMapper;
        function getDefaultPadMapper() {
            return copyPadMapper(DefaultPadMapper);
        }
        IO.getDefaultPadMapper = getDefaultPadMapper;
        function setInputPadMapper(keyMapper) {
            Input.gamepadMapper = keyMapper;
        }
        IO.setInputPadMapper = setInputPadMapper;
        function copyPadMapper(keyMapper) {
            return Object.assign({}, keyMapper);
        }
        IO.copyPadMapper = copyPadMapper;
        IO.InputType = {
            Keyboard: 0,
            GamePad: 1,
        };
        let lastInputType = IO.InputType.Keyboard;
        function getLastInputType() {
            return lastInputType;
        }
        IO.getLastInputType = getLastInputType;
        function setLastInputType(type) {
            lastInputType = type;
        }
        IO.setLastInputType = setLastInputType;
    })(IO = Iz.IO || (Iz.IO = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Input_initialize = Input.initialize;
    Input.initialize = function () {
        _Input_initialize.call(this);
        this._keyCodeMapper = new Map();
        this._keyCodeDownMapper = {};
        this._disableKeyMapper = {};
        this._checkDisable = false;
        document.addEventListener("keydown", (event) => {
            Iz.IO.setLastInputType(Iz.IO.InputType.Keyboard);
        });
    };
    Input._updateGamepadState = function (gamepad) {
        const lastState = this._gamepadStates[gamepad.index] || [];
        const newState = [];
        const buttons = gamepad.buttons;
        const axes = gamepad.axes;
        const threshold = 0.5;
        newState[12] = false;
        newState[13] = false;
        newState[14] = false;
        newState[15] = false;
        for (let i = 0; i < buttons.length; i++) {
            newState[i] = buttons[i].pressed;
        }
        if (axes[1] < -threshold) {
            newState[12] = true; // up
        }
        else if (axes[1] > threshold) {
            newState[13] = true; // down
        }
        if (axes[0] < -threshold) {
            newState[14] = true; // left
        }
        else if (axes[0] > threshold) {
            newState[15] = true; // right
        }
        for (let j = 0; j < newState.length; j++) {
            if (newState[j] !== lastState[j]) {
                const buttonName = this.gamepadMapper[j];
                if (buttonName) {
                    this._currentState[buttonName] = newState[j];
                }
            }
        }
        this._gamepadStates[gamepad.index] = newState;
        if (newState.some((s) => s)) {
            Iz.IO.setLastInputType(Iz.IO.InputType.GamePad);
        }
    };
    Input.update = function () {
        if (this._disableCount > 0) {
            this._disableCount--;
        }
        this._triggeredOneshot = false;
        this._pollGamepads();
        // @ts-ignore
        if (this._currentState[this._latestButton]) {
            this._pressedTime++;
        }
        else {
            this._latestButton = null;
        }
        for (const name in this._currentState) {
            if (this._currentState[name] && !this._previousState[name]) {
                this._latestButton = name;
                this._pressedTime = 0;
                this._date = Date.now();
            }
            this._upState[name] = this._previousState[name] && !this._currentState[name];
            this._previousState[name] = this._currentState[name];
        }
        if (this._virtualButton) {
            this._latestButton = this._virtualButton;
            this._pressedTime = 0;
            this._virtualButton = null;
        }
        this._updateDirection();
    };
    const _Input_clear = Input.clear;
    Input.clear = function () {
        _Input_clear.call(this);
        this._upState = {};
        this._disableCount = 0;
        this._keyCodeDownMapper = {};
        this._disableKeyMapper = {};
        this._checkDisable = false;
    };
    const _Input_isTriggered = Input.isTriggered;
    Input.isTriggered = function (keyName) {
        if (this._disableCount > 0) {
            return false;
        }
        if (this._checkDisable) {
            const codes = this._keyCodeMapper.get(keyName);
            if (codes) {
                if (codes.findIndex((code) => this._disableKeyMapper[code]) >= 0) {
                    return false;
                }
            }
        }
        return _Input_isTriggered.call(this, keyName);
    };
    Input.isTriggeredOneshot = function (keyName) {
        if (!this._triggeredOneshot &&
            this._isEscapeCompatible(keyName) &&
            this.isTriggered("escape")) {
            this._triggeredOneshot = true;
            return true;
        }
        const res = this._latestButton === keyName && this._pressedTime === 0 && !this._triggeredOneshot;
        if (res) {
            this._triggeredOneshot = true;
        }
        return res;
    };
    Input.isReleased = function (keyName) {
        if (this._isEscapeCompatible(keyName) && this.isReleased("escape"))
            return true;
        return this._upState[keyName];
    };
    Input.isCancelled = function (oneshot) {
        const triggered = oneshot
            ? Input.isTriggeredOneshot(Iz.IO.KEY_NAME_CANCEL)
            : Input.isTriggered(Iz.IO.KEY_NAME_CANCEL);
        if (triggered)
            return true;
        const canncelld = oneshot ? TouchInput.isCancelledOneshot() : TouchInput.isCancelled();
        return canncelld;
    };
    Input.isPressedSkip = function () {
        // NOTE:
        // [前提]
        // 誤動作防止のために、InputMapperの変更時にcurrentStateを初期化している
        //
        // パッドの場合、currentStateを更新するタイミングがパッドの押下状態が変更された時のため、
        // 押し続けでInputMapperが変更されてもcurrentStateが更新されない
        // ※キーボードの場合はkeyDownとkeyUpで別々のイベントのため問題がない
        //
        // パッドの時はcurrentStateでなくstateを検知する方法で対応する
        //
        if (Iz.IO.getLastInputType() === Iz.IO.InputType.GamePad) {
            for (let i = 0; i < this._gamepadStates.length; i++) {
                const states = this._gamepadStates[i];
                if (!states)
                    continue;
                if (states[Iz.IO.PAD_RT])
                    return true;
            }
            return false;
        }
        return Input.isPressed(Iz.IO.KEY_NAME_MESSAGE_SKIP);
    };
    const _Input_onKeyDown = Input._onKeyDown;
    Input._onKeyDown = function (event) {
        _Input_onKeyDown.call(this, event);
        this._keyCodeDownMapper[event.keyCode] = true;
    };
    const _Input_onKeyUp = Input._onKeyUp;
    Input._onKeyUp = function (event) {
        _Input_onKeyUp.call(this, event);
        this._keyCodeDownMapper[event.keyCode] = false;
        this._disableKeyMapper[event.keyCode] = false;
        let existDisable = false;
        for (const keyCode in this._disableKeyMapper) {
            if (this._disableKeyMapper[keyCode]) {
                existDisable = true;
            }
        }
        if (!existDisable) {
            this._checkDisable = false;
        }
    };
    const _TouchInput_update = TouchInput.update;
    TouchInput.update = function () {
        _TouchInput_update.call(this);
        this._cancelledOneshot = false;
    };
    TouchInput.isCancelledOneshot = function () {
        const res = !this._cancelledOneshot && TouchInput.isCancelled();
        if (res) {
            this._cancelledOneshot = true;
        }
        return res;
    };
    TouchInput.isMiddleTriggered = function () {
        return this._currentState.middleTriggered;
    };
    TouchInput._onMiddleButtonDown = function (event) {
        const x = Graphics.pageToCanvasX(event.pageX);
        const y = Graphics.pageToCanvasY(event.pageY);
        if (Graphics.isInsideCanvas(x, y)) {
            this._onMiddleTrigger(x, y);
        }
    };
    TouchInput._onMiddleTrigger = function (x, y) {
        this._newState.middleTriggered = true;
        this._x = x;
        this._y = y;
    };
    const _TouchInput_createNewState = TouchInput._createNewState;
    TouchInput._createNewState = function () {
        const state = _TouchInput_createNewState.call(this);
        state.middleTriggered = false;
        state.cancelReleased = false;
        return state;
    };
    const _TouchInput_onMouseUp = TouchInput._onMouseUp;
    TouchInput._onMouseUp = function (event) {
        _TouchInput_onMouseUp.call(this, event);
        if (event.button === 2) {
            const x = Graphics.pageToCanvasX(event.pageX);
            const y = Graphics.pageToCanvasY(event.pageY);
            this._onCancelRelease(x, y);
        }
    };
    TouchInput._onCancelRelease = function (x, y) {
        this._newState.cancelReleased = true;
        this._x = x;
        this._y = y;
    };
    TouchInput.isCancelReleased = function () {
        return this._currentState.cancelReleased;
    };
    const _Window_Message_terminateMessage = Window_Message.prototype.terminateMessage;
    Window_Message.prototype.terminateMessage = function () {
        _Window_Message_terminateMessage.call(this);
        // NOTE:
        // イベントの連続起動防止
        // Window_Message.prototype.updateInput()では
        // Input.update()しか対応していないので
        TouchInput.update();
    };
})();
(() => {
    "usse strict";
    const _SceneManager_onSceneCreate = SceneManager.onSceneCreate;
    SceneManager.onSceneCreate = function () {
        _SceneManager_onSceneCreate.call(this);
        // NOTE:
        // シーン遷移直後に連続実行されない程度の時間
        Input._disableCount = 3;
    };
})();
//# sourceMappingURL=InputEx.js.map