/*:
 * @target MZ
 * @plugindesc Sprite_Animation(MV)拡張
 *
 * @help
 * [機能]
 * ・アニメーションの表示位置の調整
 * イベントのメモ欄に<animationPoint:>タグを使い、アニメーション表示時の位置を調整
 *
 * <animationPoint:[left,top,right,bottom]>
 * 座標はUV座標系です 指定した矩形が基準位置となります
 *
 * 例：
 * <animationPoint:[0.0,0.0,1.0,1.0]> 画像全体
 * <animationPoint:[0.0,0.5,1.0,1.0]> 下側半分
 *
 *
 */
(() => {
    /*
    // メタ情報を取得、設定
    const MetaName = "meta";
    const PositionRatioName = "positionRatio";
    function extractMetadata(target: Object, source: string, propertyName: string) {
        if(target.hasOwnProperty(propertyName))
            return;

        const regExp = /<([^<>:]+)(:?)([^>]*)>/g;
        const meta: MZ.Metadata = {};
        for (;;) {
            const match = regExp.exec(source);
            if (match) {
                if (match[2] === ":") {
                    meta[match[1]] = match[3];
                } else {
                    meta[match[1]] = true;
                }
            } else {
                break;
            }
        }

        Object.defineProperty(target, propertyName, {
            value: meta,
            writable: true,
            configurable: true,
        });
    }
    */
    const AnimationPointTag = "animationPoint";
    Game_Event.prototype.getAnimationPosition = function () {
        return PluginManagerEx.findMetaObject(this.event(), [AnimationPointTag]);
    };
    Sprite_Character.prototype.getAnimationPosition = function () {
        if (this._character instanceof Game_Event) {
            return this._character.getAnimationPosition();
        }
        return undefined;
    };
    const _Sprite_AnimationMV_updatePosition = Sprite_AnimationMV.prototype.updatePosition;
    Sprite_AnimationMV.prototype.updatePosition = function () {
        if (this._targets.length > 0) {
            const target = this._targets[0];
            // 設定がある場合は上書き
            let uv = undefined;
            if (target instanceof Sprite_Character) {
                uv = target.getAnimationPosition();
            }
            if (uv) {
                const target = this._targets[0];
                const parent = target.parent;
                const grandparent = parent ? parent.parent : null;
                let baseX = target.x;
                let baseY = target.y;
                if (this.parent === grandparent) {
                    baseX += parent.x;
                    baseY += parent.y;
                }
                const centerUvX = (uv[0] + uv[2]) * 0.5;
                const centerUvY = (uv[1] + uv[3]) * 0.5;
                this.x = baseX + (0.5 - centerUvX) * target.width;
                this.y = baseY + (-1.0 + centerUvY) * target.height;
                return;
            }
        }
        _Sprite_AnimationMV_updatePosition.call(this);
    };
    const _Sprite_Balloon_updatePosition = Sprite_Balloon.prototype.updatePosition;
    Sprite_Balloon.prototype.updatePosition = function () {
        // 設定がある場合は上書き
        if (this._target) {
            let uv = undefined;
            uv = this._target.getAnimationPosition();
            if (uv) {
                const centerUvX = (uv[0] + uv[2]) * 0.5;
                const topUvY = uv[1];
                this.x = this._target.x + (0.5 - centerUvX) * this._target.width;
                this.y = this._target.y + (-1.0 + topUvY) * this._target.height;
                return;
            }
        }
        _Sprite_Balloon_updatePosition.call(this);
    };
})();
//# sourceMappingURL=Sprite_AnimationEx.js.map