var Iz;
(function (Iz) {
    var Maths;
    (function (Maths) {
        // https://web.analogstd.com/tips/posts/js/cubic-bezier.php
        // Cubic-Bezierの値を計算する関数を生成する関数	
        function cubicBezier($x1, $y1, $x2, $y2) {
            // Refer: http://www.moshplant.com/direct-or/bezier/math.html
            var cx = 3 * $x1, bx = 3 * ($x2 - $x1) - cx, ax = 1 - cx - bx;
            var cy = 3 * $y1, by = 3 * ($y2 - $y1) - cy, ay = 1 - cy - by;
            // 媒介変数表示したX座標
            var bezierX = function ($t) {
                return $t * (cx + $t * (bx + $t * ax));
            };
            // X座標のt微分
            var bezierDX = function ($t) {
                return cx + $t * (2 * bx + 3 * ax * $t);
            };
            // ニュートン法で数値解析する
            var newtonRaphson = function ($x) {
                if ($x <= 0) {
                    return 0;
                }
                if ($x >= 1) {
                    return 1;
                }
                var prev, t = $x;
                do {
                    prev = t;
                    t = t - ((bezierX(t) - $x) / bezierDX(t));
                } while (Math.abs(t - prev) > 1e-4); // 1e-2 程度でも良い
                return t;
            };
            return function ($t) {
                // X座標(時刻)に対応する媒介変数tの値を取得する
                var t = newtonRaphson($t);
                // Y座標(Easing量)を計算する
                return t * (cy + t * (by + t * ay));
            };
        }
        Maths.cubicBezier = cubicBezier;
        ;
        // min以上max未満のランダムな整数値
        function getRandomInt(min, max) {
            min = Math.ceil(min);
            max = Math.floor(max);
            return Math.floor(Math.random() * (max - min) + min);
        }
        Maths.getRandomInt = getRandomInt;
        function round(value, digits) {
            if (!digits || digits <= 0) {
                return Math.round(value);
            }
            let digitsVal = 1;
            for (let i = 0; i < digits - 1; i++) {
                digitsVal *= 10;
            }
            return Math.round(value * digitsVal) / digitsVal;
        }
        Maths.round = round;
    })(Maths = Iz.Maths || (Iz.Maths = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=Maths.js.map