var Iz;
(function (Iz) {
    class TouchButton extends Sprite_Clickable {
        constructor() {
            super();
            this._enable = true;
            this._selected = false;
            this._bitmaps = {};
        }
        get enable() {
            return this._enable;
        }
        set enable(value) {
            this._enable = value;
            if (!value) {
                this._pressed = false;
                this._hovered = false;
            }
        }
        get selected() {
            return this._selected;
        }
        set selected(value) {
            this._selected = value;
        }
        get bitmaps() {
            return this._bitmaps;
        }
        get hovered() {
            return this._hovered;
        }
        update() {
            super.update();
            if (this._enable) {
                this.onUpdate();
            }
            this.updateButtonBitmap();
        }
        onUpdate() {
            //
        }
        processTouch() {
            if (!this._enable)
                return;
            super.processTouch();
        }
        updateButtonBitmap() {
            if (this._pressed && this._bitmaps.pressed) {
                this.refreshButton(this._bitmaps.pressed);
            }
            else if (this._hovered && this._bitmaps.hovered) {
                this.refreshButton(this._bitmaps.hovered);
            }
            else if (this._selected && this._bitmaps.selected) {
                this.refreshButton(this._bitmaps.selected);
            }
            else if (this._bitmaps.default) {
                this.refreshButton(this._bitmaps.default);
            }
        }
        refreshButton(data) {
            this.bitmap = data.bitmap;
            this.setFrame(data.frame.x, data.frame.y, data.frame.width, data.frame.height);
        }
        setBitmaps(bitmaps) {
            this._bitmaps = Object.assign({}, bitmaps);
            this.updateButtonBitmap();
        }
    }
    Iz.TouchButton = TouchButton;
    class InputButton extends TouchButton {
        get inputKey() {
            return this._inputKey;
        }
        setInputKey(inputKey) {
            this._inputKey = inputKey;
        }
        isTriggered() {
            if (this._inputKey) {
                if (Input.isTriggered(this._inputKey)) {
                    return true;
                }
            }
            return this.isTouchTriggered();
        }
        isTouchTriggered() {
            return this._pressed && TouchInput.isTriggered();
        }
    }
    Iz.InputButton = InputButton;
    class PushButton extends InputButton {
        onUpdate() {
            this.updateInputKey();
        }
        updateInputKey() {
            if (!this.inputKey)
                return;
            if (Input.isPressed(this.inputKey)) {
                this._pressed = true;
            }
            else if (Input.isReleased(this.inputKey)) {
                this.onClick();
            }
        }
        setHandler(handler) {
            this._onclickHandler = handler;
        }
        onClick() {
            this._pressed = false;
            this._onclickHandler?.();
        }
    }
    Iz.PushButton = PushButton;
    class SwitchButton extends InputButton {
        constructor(on, off) {
            super();
            this._on = false;
            this._bitmapOn = on;
            this._bitmapOff = off;
        }
        get isOn() {
            return this._on;
        }
        set isOn(value) {
            this._on = value;
        }
        onUpdate() {
            this.updateInputKey();
            this.updateDefaultBitmap();
        }
        updateInputKey() {
            if (!this.inputKey)
                return;
            if (Input.isTriggered(this.inputKey)) {
                this.onClick();
            }
        }
        updateDefaultBitmap() {
            if (this._on) {
                this.bitmaps.default = this._bitmapOn;
            }
            else {
                this.bitmaps.default = this._bitmapOff;
            }
        }
        setHandler(_onClick) {
            this._onClickHandler = _onClick;
        }
        onClick() {
            this._onClickHandler?.(this._on);
        }
    }
    Iz.SwitchButton = SwitchButton;
})(Iz || (Iz = {}));
(function (Iz) {
    function createButtonBitmapData(atlasKey, frameKey) {
        const atlas = Iz.Atlas.getAtlas(atlasKey);
        const f = atlas.getFrame(frameKey);
        const data = {
            bitmap: atlas.getBitmap(),
            frame: {
                x: f.x,
                y: f.y,
                width: f.width,
                height: f.height,
            },
        };
        return data;
    }
    Iz.createButtonBitmapData = createButtonBitmapData;
    class Creator {
        createPushButton(param) {
            const button = new Iz.PushButton();
            if (param.images) {
                button.setBitmaps(param.images);
            }
            if (param.inputKey) {
                button.setInputKey(param.inputKey);
            }
            return button;
        }
        createSwitchButton(param) {
            const button = new Iz.SwitchButton(param.on, param.off);
            if (param.inputKey) {
                button.setInputKey(param.inputKey);
            }
            return button;
        }
    }
    Iz.ButtonCreator = new Creator();
})(Iz || (Iz = {}));
//# sourceMappingURL=Buttons.js.map