// namespace Iz {
//     export function createNineSliceBitmap() {
//     }
// }
class NineSliceSprite extends Sprite {
    constructor(bitmap) {
        super();
        this._sleft = 0;
        this._sright = 0;
        this._stop = 0;
        this._sbottom = 0;
        this._drawW = 0;
        this._drawH = 0;
        this.resetBitmapRect();
        this._sliceBitmap = bitmap;
        this.createParts(bitmap);
        this._loadedBitmap = false;
        this._sliceBitmap.addLoadListener(this.onLoadedBitmap.bind(this));
    }
    createParts(bitmap) {
        // 左下
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 下
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 右下
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 左
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 中央
        {
            const sprite = new TilingSprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 右
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 左上
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 上
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        // 右上
        {
            const sprite = new Sprite();
            sprite.bitmap = bitmap;
            this.addChild(sprite);
        }
        this.children.forEach((c) => {
            c.visible = false;
        });
    }
    setSlice(left, right, top, bottom) {
        this._sleft = left;
        this._sright = right;
        this._stop = top;
        this._sbottom = bottom;
        this.refresh();
    }
    setSize(width, height) {
        // 領域確認用
        // const bitmap = new Bitmap(width,height);
        // bitmap.fillAll("red");
        // this.bitmap = bitmap;
        this._drawW = width;
        this._drawH = height;
        this.refresh();
    }
    setBitmapRect(left, top, width, height) {
        this._useBitmapRect = true;
        this._bitmapRect = new Rectangle(left, top, width, height);
    }
    resetBitmapRect() {
        this._useBitmapRect = false;
        this._bitmapRect = new Rectangle(0, 0, 0, 0);
    }
    get bitmapRect() {
        if (this._useBitmapRect) {
            return this._bitmapRect;
        }
        return new Rectangle(0, 0, this._sliceBitmap.width, this._sliceBitmap.height);
    }
    onLoadedBitmap() {
        this._loadedBitmap = true;
        this.children.forEach((c) => {
            c.visible = true;
        });
        this.refresh();
    }
    refresh() {
        if (!this._loadedBitmap)
            return;
        this._drawW = Math.max(this._drawW, this._sleft + this._sright);
        this._drawH = Math.max(this._drawH, this._stop + this._sbottom);
        const cw = this._drawW - this._sleft - this._sright;
        const ch = this._drawH - this._stop - this._sbottom;
        const bitmapRect = this.bitmapRect;
        const cfw = bitmapRect.width - this._sright - this._sleft;
        const cfh = bitmapRect.height - this._sbottom - this._stop;
        const scaleX = cw / cfw;
        const scaleY = ch / cfh;
        // 左上
        const topleft = this.children[6];
        topleft.setFrame(bitmapRect.left, bitmapRect.top, this._sleft, this._stop);
        topleft.move(0, 0);
        // 上
        const top = this.children[7];
        top.setFrame(bitmapRect.left + this._sleft, bitmapRect.top, cfw, this._stop);
        top.scale.x = scaleX;
        top.move(this._sleft, 0);
        // 右上
        const topright = this.children[8];
        topright.setFrame(bitmapRect.left + this._sleft + cfw, bitmapRect.top, this._sright, this._stop);
        topright.move(this._sleft + cw, 0);
        // 左
        const left = this.children[3];
        left.setFrame(bitmapRect.left, bitmapRect.top + this._stop, this._sleft, cfh);
        left.scale.y = scaleY;
        left.move(0, this._stop);
        // 中央
        const center = this.children[4];
        center.setFrame(bitmapRect.left + this._sleft, bitmapRect.top + this._stop, cfw, cfh);
        center.move(this._sleft, this._stop, cw, ch);
        // 右
        const right = this.children[5];
        right.setFrame(bitmapRect.left + this._sleft + cfw, bitmapRect.top + this._stop, this._sright, cfh);
        right.scale.y = scaleY;
        right.move(this._sleft + cw, this._stop);
        // 左下
        const bottomleft = this.children[0];
        bottomleft.setFrame(bitmapRect.left, bitmapRect.top + this._stop + cfh, this._sleft, this._sbottom);
        bottomleft.move(0, this._stop + ch);
        // 下
        const bottom = this.children[1];
        bottom.setFrame(bitmapRect.left + this._sleft, bitmapRect.top + this._stop + cfh, cfw, this._sbottom);
        bottom.scale.x = scaleX;
        bottom.move(this._sleft, this._stop + ch);
        // 右下
        const bottomright = this.children[2];
        bottomright.setFrame(bitmapRect.left + this._stop + cfw, bitmapRect.top + this._sleft + cfh, this._sright, this._sbottom);
        bottomright.move(this._sleft + cw, this._stop + ch);
        // 親と同じ位置に調整
        const anchorOffset = { x: -this.anchor.x * this._drawW, y: -this.anchor.y * this._drawH };
        this.children.forEach((c) => {
            if (c instanceof TilingSprite) {
                const sprite = c;
                sprite.move(this._sleft + anchorOffset.x, this._stop + anchorOffset.y, cw, ch);
            }
            else {
                const sprite = c;
                sprite.move(sprite.x + anchorOffset.x, sprite.y + anchorOffset.y);
            }
        });
        this.setFrame(0, 0, this._drawW, this._drawH);
    }
}
//# sourceMappingURL=NineSliceSprite.js.map