/*:
 * @target MZ
 * @plugindesc 相対座標
 *
 * @help
 *
 *
 *
 */
(() => {
    const _Sprite_initialize = Sprite.prototype.initialize;
    Sprite.prototype.initialize = function (...args) {
        _Sprite_initialize.call(this, ...args);
        this.relativeAnchor = {
            enable: false,
            ratio: { x: 0, y: 0 },
            offset: { x: 0, y: 0 },
        };
    };
    const _Sprite_update = Sprite.prototype.update;
    Sprite.prototype.update = function () {
        _Sprite_update.call(this);
        if (this.relativeAnchor.enable && this.parent && this.parent instanceof Sprite) {
            const leftTop = {
                x: -this.parent.anchor.x * this.parent.width,
                y: -this.parent.anchor.y * this.parent.height,
            };
            // NOTE:
            // Bitmapは通常(smoothがtrue)はLINEAR補間がかかるので、ぼやけてしまうことがある
            // 整数値にすることで回避する（小数点以下は扱わない）
            this.position.set(Math.floor(leftTop.x +
                this.relativeAnchor.ratio.x * this.parent.width +
                this.relativeAnchor.offset.x), Math.floor(leftTop.y +
                this.relativeAnchor.ratio.y * this.parent.height +
                this.relativeAnchor.offset.y));
        }
    };
})();
/*
(() => {
    class Scene_Grid extends Scene_Base {
        _root: Sprite;
        _grid: Iz.Life.ItemIconGrid;
        create() {
            super.create();
            this.createRoot();
            this.createGrid();
        }

        createRoot() {
            const bitmap = new Bitmap(512,384);
            bitmap.fillAll("yellow");
            this._root = new Sprite(bitmap);
            // this._root.anchor.set(0.5,0.5);
            this.addChild(this._root);
        }

        createGrid() {
            const option: Iz.LoopGridOption<Iz.Life.Sprite_ItemIcon> = {
                emptyCellCreator: () => new Iz.Life.Sprite_ItemIcon(),
                cellUpdater: this.onUpdateCell.bind(this),
                maxItems: 10,
                frameWidth: 64,
                frameHeight: 64,
                col: 3,
                row: 2
            };
            this._grid = new Iz.Life.SelectableGrid(option);
            this._grid.bitmap = new Bitmap(this._grid.width,this._grid.height);
            this._grid.bitmap.fillAll("green");
            // this._grid.anchor.set(0.2,0.2);
            this._grid.position.set(100,100);
            this._grid.refresh();
            this._grid.activate();
            this._root.addChild(this._grid);
        }

        update() {
            super.update();
            this._grid.updateMain();
        }

        onUpdateCell(cell: Iz.Life.Sprite_ItemIcon, index: number) {
            cell.set(index+1);
            cell.text.setText(`${index+101}`);
        }
    }
    // Scene_Boot.prototype.startNormalGame = function() {
    //     this.checkPlayerLocation();
    //     DataManager.setupNewGame();
    //     SceneManager.goto(Scene_Grid);
    //     Window_TitleCommand.initCommandPosition();
    // };

})();
*/
//# sourceMappingURL=RelativeAnchor.js.map