/*:
 * @target MZ
 * @plugindesc スナップショット
 *
 * @help
 * 背景のスナップショットを撮り、ピクチャとして扱えるようにします
 *
 *
 * @command snapshot
 *
 * @arg pictureId
 * @type number
 * @text ピクチャID
 *
 * @arg disablePicture
 * @type boolean
 * @text ピクチャを対象外
 * @default false
 *
 * @arg disableUi
 * @type boolean
 * @text UIを対象外
 * @default false
 *
 * @arg blur
 * @type boolean
 * @text ブラー有効化
 * @default false
 *
 * @arg center
 * @type boolean
 * @text 原点を中心にする(falseは左上)
 * @default false
 *
 * @arg x
 * @type number
 * @text X座標
 * @default 0
 *
 * @arg y
 * @type number
 * @text Y座標
 * @default 0
 *
 * @arg scaleX
 * @type number
 * @text 拡大率(X)
 * @default 100
 *
 * @arg scaleY
 * @type number
 * @text 拡大率(Y)
 * @default 100
 *
 * @arg opacity
 * @type number
 * @text 不透明度
 * @default 255
 *
 * @arg blendMode
 * @type number
 * @text 合成方法
 * @desc 0:通常 1:加算 2:乗算 3:スクリーン
 * @default 0
 *
 */
var Iz;
(function (Iz) {
    function snapshot(option) {
        const scene = SceneManager._scene;
        if (!scene) {
            return;
        }
        if (option.pictureId <= 0) {
            return;
        }
        const bitmap = scene.snapshot(option);
        const origin = option.center ? 1 : 0;
        const x = option?.x ?? 0;
        const y = option?.y ?? 0;
        const scaleX = option?.scaleX ?? 100;
        const scaleY = option?.scaleY ?? 100;
        const opacity = option?.opacity ?? 255;
        const blendMode = option?.blendMode ?? 0;
        $gameScreen.showPicture(option.pictureId, "", origin, x, y, scaleX, scaleY, opacity, blendMode);
        const gamePicture = $gameScreen.picture(option.pictureId);
        if (gamePicture) {
            gamePicture.snapshotBitmap = bitmap;
            gamePicture.blur = option.blur;
            gamePicture._name = "";
        }
    }
    Iz.snapshot = snapshot;
    class PIXIContainerRunner {
        constructor(container) {
            this._container = container;
        }
        get container() {
            return this._container;
        }
        visible() {
            return !!this._container?.visible;
        }
        setVisible(flg) {
            if (!this._container) {
                return;
            }
            this._container.visible = flg;
        }
    }
    class SnapshotUIRunner extends PIXIContainerRunner {
        executableHide(option) {
            return !!option.disableUi && !!this.container;
        }
    }
    Iz.SnapshotUIRunner = SnapshotUIRunner;
    class SnapshotPictureRunner extends PIXIContainerRunner {
        executableHide(option) {
            return !!option.disablePicture && !!this.container;
        }
    }
    Iz.SnapshotPictureRunner = SnapshotPictureRunner;
})(Iz || (Iz = {}));
(() => {
    "use strict";
    PluginManagerEx.registerCommand(document.currentScript, "snapshot", (args) => {
        const stringValue = (value, defaultValue) => {
            if (typeof value === "string") {
                return defaultValue;
            }
            return value;
        };
        const option = {
            pictureId: stringValue(args.pictureId, 0),
            disablePicture: !!args.disablePicture,
            disableUi: !!args.disableUi,
            blur: !!args.blur,
            center: !!args.center,
            x: stringValue(args.x, 0),
            y: stringValue(args.y, 0),
            scaleX: stringValue(args.scaleX, 100),
            scaleY: stringValue(args.scaleY, 100),
            opacity: stringValue(args.opacity, 255),
            blendMode: stringValue(args.blendMode, 0),
        };
        Iz.snapshot(option);
    });
    Scene_Base.prototype.snapshot = function (option) {
        return Bitmap.snap(this);
    };
    Scene_Base.prototype.createSnapshotRunnerList = function () {
        return [];
    };
    Scene_Map.prototype.createSnapshotRunnerList = function () {
        const list = [];
        if (this._spriteset) {
            list.push(new Iz.SnapshotPictureRunner(this._spriteset._pictureContainer));
        }
        list.push(new Iz.SnapshotUIRunner(this._hudWindow));
        list.push(new Iz.SnapshotUIRunner(this._itemSlotWindow));
        list.push(new Iz.SnapshotUIRunner(this._footerWindow));
        list.push(new Iz.SnapshotUIRunner(this._messageWindow));
        list.push(new Iz.SnapshotUIRunner(this._nameBoxWindow));
        list.push(new Iz.SnapshotUIRunner(this._chronusWindow));
        return list;
    };
    Scene_Map.prototype.snapshot = function (option) {
        const list = this.createSnapshotRunnerList();
        const cacheList = new Array(list.length);
        list.forEach((r, i) => {
            cacheList[i] = r.visible();
        });
        list.forEach((r, i) => {
            cacheList[i] = r.visible();
            if (r.executableHide(option)) {
                r.setVisible(false);
            }
        });
        const bitmap = Bitmap.snap(this);
        list.forEach((r, i) => {
            if (r.executableHide(option)) {
                r.setVisible(cacheList[i]);
            }
        });
        return bitmap;
    };
    const _Sprite_Picture_updateBitmap = Sprite_Picture.prototype.updateBitmap;
    Sprite_Picture.prototype.updateBitmap = function () {
        const picture = this.picture();
        if (picture?.blur) {
            if (!this._blurFilter) {
                this._blurFilter = new PIXI.filters.BlurFilter();
                if (!this.filters) {
                    this.filters = [];
                }
                this.filters.push(this._blurFilter);
            }
        }
        else {
            if (this._blurFilter && this.filters) {
                this.filters.remove(this._blurFilter);
                this._blurFilter = undefined;
            }
        }
        if (picture?.snapshotBitmap) {
            this.bitmap = picture.snapshotBitmap;
            picture.snapshotBitmap = undefined;
            return;
        }
        _Sprite_Picture_updateBitmap.call(this);
    };
})();
//# sourceMappingURL=Snapshot.js.map