class Sprite_SimpleGauge extends Sprite {
    constructor(width, height) {
        super();
        this.create(width, height);
    }
    create(width, height) {
        this.createBackSprite(width, height);
        this.createFrameSprite(width, height);
        this.createGaugeSprite(width, height);
    }
    createBackSprite(width, height) {
        const bitmap = new Bitmap(width, height);
        // bitmap.fillRect(0,0,width,height,"white");
        this.bitmap = bitmap;
    }
    createFrameSprite(width, height) {
        const bitmap = new Bitmap(width, height);
        bitmap.fillRect(0, 0, width, height, "black");
        const sprite = new Sprite(bitmap);
        this.addChild(sprite);
        this._frameSprite = sprite;
    }
    createGaugeSprite(width, height) {
        const bitmap = new Bitmap(width, height);
        bitmap.fillRect(0, 0, width, height, "green");
        const sprite = new Sprite(bitmap);
        this.addChild(sprite);
        this._gaugeSprite = sprite;
    }
    /**
     *
     * @param value range: 0.0-1.0
     */
    setValue(value) {
        const rate = Math.min(Math.max(value, 0), 1);
        this._gaugeSprite.setFrame(0, 0, rate * this.width, this.height);
    }
    setGaugeColor(cssColor) {
        this._gaugeSprite.bitmap?.fillRect(0, 0, this.width, this.height, cssColor);
    }
}
//# sourceMappingURL=Sprite_Gauge.js.map