var Iz;
(function (Iz) {
    class OverheadProxy {
        constructor() {
            this._list = new Map();
        }
        playOneshot(key, balloonId) {
            const data = this.checkAndGetData(key);
            data.oneshotStart = true;
            if (balloonId) {
                data.oneshotBalloonId = balloonId;
            }
        }
        setParam(key, param) {
            const data = this.checkAndGetData(key);
            Object.assign(data, param);
        }
        getData(key) {
            return this._list.get(key);
        }
        delete(key) {
            this._list.delete(key);
        }
        clear() {
            this._list.clear();
        }
        checkAndGetData(key) {
            if (!this.exist(key)) {
                this.createData(key);
            }
            return this._list.get(key);
        }
        exist(key) {
            return this._list.has(key);
        }
        createData(key) {
            const param = {
                balloonId: 0,
                duration: 0,
                oneshotStart: false,
                oneshotBalloonId: 0,
            };
            this._list.set(key, param);
        }
    }
    Iz.OverheadProxy = OverheadProxy;
    Iz.Overhead = new OverheadProxy();
})(Iz || (Iz = {}));
class Sprite_OverheadBalloon extends Sprite {
    constructor(target, key) {
        super();
        this._duration = 0;
        this._waitTime = 12;
        this._speed = 8;
        this.anchor.x = 0.5;
        this.anchor.y = 1;
        this.z = 7;
        this._target = target;
        this._balloonId = 0;
        this._duration = 0;
        this._oneshot = false;
        this._key = key;
        this._uv = this._target.getAnimationPosition();
        this.loadBitmap();
    }
    loadBitmap() {
        this.bitmap = ImageManager.loadSystem("Balloon");
        this.setFrame(0, 0, 0, 0);
    }
    update() {
        super.update();
        this.updatePosition();
        this.updateDuration();
        this.updateFrame();
        this.polling();
    }
    updatePosition() {
        const uv = this._uv;
        if (uv) {
            const centerUvX = (uv[0] + uv[2]) * 0.5;
            const topUvY = uv[1];
            this.x = this._target.x + (0.5 - centerUvX) * this._target.width;
            this.y = this._target.y + (-1.0 + topUvY) * this._target.height;
        }
        else {
            this.x = this._target.x;
            this.y = this._target.y - this._target.height;
        }
    }
    updateDuration() {
        if (this._oneshot) {
            if (this._duration > 0) {
                this._duration--;
            }
            if (this._duration <= 0) {
                this._oneshot = false;
            }
        }
        else {
            const param = $gameMap.getOverhead().getData(this._key);
            this._balloonId = param ? param.balloonId : 0;
            this._duration = param ? param.duration : 0;
        }
    }
    updateFrame() {
        const w = 48;
        const h = 48;
        const sx = this.frameIndex() * w;
        const sy = (this._balloonId - 1) * h;
        this.setFrame(sx, sy, w, h);
    }
    polling() {
        if (!this._key)
            return;
        const param = $gameMap.getOverhead().getData(this._key);
        if (!param)
            return;
        if (param.oneshotStart) {
            this._oneshot = true;
            this._balloonId = param.oneshotBalloonId;
            this._duration = 8 * this._speed + this._waitTime;
            param.oneshotStart = false;
            param.oneshotBalloonId = 0;
        }
    }
    frameIndex() {
        const index = (this._duration - this._waitTime) / this._speed;
        return 7 - Math.max(Math.floor(index), 0);
    }
}
(() => {
    const _Game_Map_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function (mapId) {
        this.getOverhead().clear();
        _Game_Map_setup.call(this, mapId);
    };
    Game_Map.prototype.getOverhead = function () {
        return Iz.Overhead;
    };
})();
//# sourceMappingURL=Sprite_Overhead.js.map