var Iz;
(function (Iz) {
    const OpennessOffsetDefault = 0.125;
    class WindowOpeness {
        constructor(win, handler) {
            this._win = win;
            this._handler = handler;
            this._t = 1;
            this._opennessOffset = OpennessOffsetDefault;
        }
        get openness() {
            return this._t;
        }
        set openness(value) {
            this._t = value.clamp(0, 1);
        }
        get opennessOffset() {
            return this._opennessOffset;
        }
        set opennessOffset(value) {
            this._opennessOffset = value.clamp(0, 1);
        }
        get handler() {
            return this._handler;
        }
        set handler(value) {
            this._handler = value;
        }
        isOpen() {
            return this._t >= 1;
        }
        isClosed() {
            return this._t <= 0;
        }
        isClosing() {
            return this._closing;
        }
        open(force = false) {
            if (force) {
                this._t = 0;
                this._handler.onUpdateOpen(this._t, this._win);
            }
            this._opening = true;
            this._closing = false;
        }
        close() {
            this._closing = true;
            this._opening = false;
        }
        closeImmediate() {
            this._closing = true;
            this._t = 0;
            this.updateClose();
        }
        update() {
            this.updateOpen();
            this.updateClose();
        }
        updateOpen() {
            if (this._opening) {
                this._t = (this._t + this._opennessOffset).clamp(0, 1);
                this._handler.onUpdateOpen(this._t, this._win);
                if (this.isOpen()) {
                    this._opening = false;
                    this._handler.onFinishOpen(this._t, this._win);
                    this._win.position.set(Math.floor(this._win.x), Math.floor(this._win.y));
                }
            }
        }
        updateClose() {
            if (this._closing) {
                this._t = (this._t - this._opennessOffset).clamp(0, 1);
                this._handler.onUpdateClose(this._t, this._win);
                if (this.isClosed()) {
                    this._closing = false;
                    this._handler.onFinishClose(this._t, this._win);
                    this._win.position.set(Math.floor(this._win.x), Math.floor(this._win.y));
                }
            }
        }
    }
    Iz.WindowOpeness = WindowOpeness;
    class OpennessBase {
        onUpdateOpen(openness, win) {
            throw new Error("Method not implemented.");
        }
        onUpdateClose(openness, win) {
            throw new Error("Method not implemented.");
        }
        onFinishOpen(openness, win) {
            win.scale.set(openness, openness);
            win.onOpen();
        }
        onFinishClose(openness, win) {
            win.scale.set(openness, openness);
            win.onClosed();
        }
    }
    class LinearOpenness extends OpennessBase {
        onUpdateOpen(openness, win) {
            win.scale.set(openness, openness);
        }
        onUpdateClose(openness, win) {
            win.scale.set(openness, openness);
        }
    }
    class Linear2Openness extends OpennessBase {
        onUpdateOpen(openness, win) {
            // win.scale.set(openness,openness);
            if (openness <= 0.5) {
                win.scale.x = 0.1;
                win.scale.y = openness * 2;
            }
            else {
                win.scale.x = (openness - 0.5) * 2;
                win.scale.y = 1;
            }
        }
        onUpdateClose(openness, win) {
            win.scale.set(openness, openness);
        }
    }
    class EasingOpenness extends OpennessBase {
        constructor(easingOpen, easingClose) {
            super();
            this._easingOpen = easingOpen;
            this._easingClose = easingClose;
        }
        onUpdateOpen(openness, win) {
            const value = this._easingOpen.value(openness) * 0.05 + 0.95;
            win.scale.set(value, value);
            // win.alpha = this._easingOpen.value(openness);
            win.opacity = this._easingOpen.value(openness) * 155 + 100;
        }
        onUpdateClose(openness, win) {
            // const value = this._easingClose.value(openness);
            const value = this._easingOpen.value(openness) * 0.5 + 0.5;
            win.scale.set(value, value);
            win.opacity = this._easingOpen.value(openness) * 255;
        }
    }
    Iz.EasingOpenness = EasingOpenness;
    class WindowBase extends Sprite {
        constructor(rect, handler) {
            const bitmap = new Bitmap(rect.width, rect.height);
            // bitmap.fillAll("red");  // 領域確認用
            super(bitmap);
            this.setFrame(rect.x, rect.y, rect.width, rect.height);
            this._opennessHandler = handler || new LinearOpenness();
            this._openness = new WindowOpeness(this, this._opennessHandler);
            this._opennessData = { openOffset: 0.075, closeOffset: 0.1 };
            this._active = true;
        }
        get opennessHandler() {
            return this._opennessHandler;
        }
        set opennessHandler(value) {
            this._opennessHandler = value;
            this._openness.handler = value;
        }
        get openness() {
            return this._openness.openness;
        }
        get opennessData() {
            return this._opennessData;
        }
        set onOpenHandler(value) {
            this._openHandler = value;
        }
        set onClosedHandler(value) {
            this._closedHandler = value;
        }
        update() {
            if (this._active) {
                super.update();
                this._openness.updateOpen();
                this._openness.updateClose();
                this.onUpdate();
            }
        }
        onUpdate() { }
        open(force = false) {
            this._openness.open(force);
            this._openness.opennessOffset = this._opennessData.openOffset;
        }
        close() {
            this._openness.close();
            this._openness.opennessOffset = this._opennessData.closeOffset;
        }
        closeImmediate() {
            this._openness.opennessOffset = this._opennessData.closeOffset;
            this._openness.closeImmediate();
        }
        isOpen() {
            return this._openness.isOpen();
        }
        isClosed() {
            return this._openness.isClosed();
        }
        isClosing() {
            return this._openness.isClosing();
        }
        activate() {
            this._active = true;
        }
        deactivate() {
            this._active = false;
        }
        isActive() {
            return this._active;
        }
        onOpen() {
            this._openHandler?.();
        }
        onClosed() {
            this._closedHandler?.();
        }
    }
    Iz.WindowBase = WindowBase;
    class EasingWindow extends WindowBase {
        constructor() {
            super(new Rectangle(0, 0, 640, 320));
            this.createSprite();
            this.anchor.set(0.5, 0.5);
            this.move(400, 200);
        }
        createSprite() {
            const bitmap = new Bitmap(64, 64);
            bitmap.fillAll("blue");
            const sprite = new Sprite(bitmap);
            sprite.anchor.set(0.5, 0.5);
            sprite.move(128, 32);
            // sprite.
            this.addChild(sprite);
        }
    }
    Iz.EasingWindow = EasingWindow;
})(Iz || (Iz = {}));
(function (Iz) {
    var Debug;
    (function (Debug) {
        function gotoTestScene() {
            SceneManager.push(EasingTestScene);
        }
        Debug.gotoTestScene = gotoTestScene;
        class EasingTestScene extends Scene_Base {
            create() {
                super.create();
                this.createEasingWindow();
                this.createSprite();
                this._t = 0;
                // this._easing = Iz.Easing.easeOutQuint;
                this._easing = Iz.Easing.easeOutBack;
            }
            createEasingWindow() {
                this._easingWin = new Iz.EasingWindow();
                this._easingWin.opennessHandler = new Iz.EasingOpenness(Iz.Easing.easeOutBack, Iz.Easing.easeOutQuint);
                // this._easingWin.openness.opennessOffset = 0.05;
                this._easingWin.bitmap?.fillAll("yellow");
                this.addChild(this._easingWin);
                console.log("aaa");
            }
            createSprite() {
                const bitmap = new Bitmap(16, 16);
                bitmap.fillAll("green");
                this._sprite = new Sprite(bitmap);
                this._sprite.move(0, 480);
                this.addChild(this._sprite);
            }
            update() {
                super.update();
                if (this._easing) {
                    this._t += 0.01;
                    this._sprite.x = this._easing.value(this._t) * 480;
                    if (this._t > 1) {
                        this._t -= 1;
                    }
                }
                if (Input.isTriggered("ok")) {
                    this._easingWin.open();
                }
                else if (Input.isTriggered("cancel")) {
                    this._easingWin.close();
                }
            }
        }
        Debug.EasingTestScene = EasingTestScene;
    })(Debug = Iz.Debug || (Iz.Debug = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
})();
//# sourceMappingURL=Windows.js.map