var Iz;
(function (Iz) {
    class Activator {
        constructor() {
            this._active = true;
        }
        update() {
            if (this._active) {
                this.onUpdate();
            }
        }
        onUpdate() { }
        isActive() {
            return this._active;
        }
        activate() {
            this._active = true;
        }
        deactivate() {
            this._active = false;
        }
    }
    Iz.Activator = Activator;
    class ActivateSwitcher {
        constructor() {
            this._list = [];
            this._request = undefined;
        }
        add(key, activator) {
            this._list.push({ key: key, activator: activator });
        }
        addList(list) {
            this._list.push(...list);
        }
        update() {
            if (this._request) {
                this._on(this._request.key);
                this._request = undefined;
            }
        }
        on(key, delay = false) {
            if (delay) {
                this._request = { key: key };
            }
            else {
                this._on(key);
            }
        }
        _on(key) {
            const data = this._list.find((data) => data.key === key);
            if (data) {
                data.activator.activate();
                this._list
                    .filter((data) => data.key !== key)
                    .forEach((data) => data.activator.deactivate());
            }
        }
        off() {
            this._list.forEach((data) => data.activator.deactivate());
        }
        isOn(key) {
            return !!this._list.find((data) => data.key === key && data.activator.isActive());
        }
    }
    Iz.ActivateSwitcher = ActivateSwitcher;
})(Iz || (Iz = {}));
/*
interface ActivateList {
    [key: string]: IActivate | null;
}

class Activator {
    private _current: IActivate;
    private _list: ActivateList;

    constructor(current: IActivate) {
        this._current = current;
        this._list = {};
    }

    setList(list: ActivateList) {
        this._list = list;
    }

    update() {
        let isInput = false;
        if(Input.isTriggered("up")) {
            if(!!this._list["up"]) {
                this._current?.deactivate();
                this._list["up"]?.activate();
                isInput = true;
            }
        }
        else if(Input.isTriggered("right")) {
            if(!!this._list["right"]) {
                this._current?.deactivate();
                this._list["right"]?.activate();
                isInput = true;
            }
        }
        else if(Input.isTriggered("down")) {
            if(!!this._list["down"]) {
                this._current?.deactivate();
                this._list["down"]?.activate();
                isInput = true;
            }
        }
        else if(Input.isTriggered("left")) {
            if(!!this._list["left"]) {
                this._current?.deactivate();
                this._list["left"]?.activate();
                isInput = true;
            }
        } else if(Input.isTriggered("ok")) {
            if(!!this._list["ok"]) {
                this._current?.deactivate();
                this._list["ok"]?.activate();
                isInput = true;
            }
        } else if(Input.isTriggered("slotleft")) {
            if(!!this._list["slotleft"]) {
                this._current?.deactivate();
                this._list["slotleft"]?.activate();
                isInput = true;
            }
        } else if(Input.isTriggered("slotright")) {
            if(!!this._list["slotright"]) {
                this._current?.deactivate();
                this._list["slotright"]?.activate();
                isInput = true;
            }
        }

        if(isInput) {
            this.updateInputData();
        }
    }

    private updateInputData() {
        Input.update();
        TouchInput.update();
    }
}

interface IHovered extends IActivate {
    isHovered(): boolean;
    isActive(): boolean;
}

class HoveredActivator {
    _list: IHovered[];

    constructor() {
        this._list = [];
    }

    setList(list: IHovered[]) {
        this._list = list;
    }

    update() {
        let index = -1;
        for(let i = 0; i < this._list.length; i++) {
            if(this._list[i].isHovered()) {
                index = i;
            }
        }
        if(index < 0)
            return;

        this._list.forEach((hovered,i) => {
            if(i === index) {
                if(!hovered.isActive()) {
                    hovered.activate();
                }
            } else {
                if(hovered.isActive()) {
                    hovered.deactivate();
                }
            }
        });
    }
}
*/
//# sourceMappingURL=Activator.js.map