/*:
 * @target MZ
 * @plugindesc BootPlugin
 *
 * @help
 *
 *
 *
 */
// ゲーム環境関連
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        function loadGameEnv() {
            const fs = require("fs");
            const path = require("path");
            const base = path.dirname(process.mainModule.filename);
            let gameEnv = undefined;
            if (!gameEnv) {
                const filePath = path.join(base, "gameenv.iz");
                if (fs.existsSync(filePath)) {
                    const encryptedText = fs.readFileSync(filePath, "utf-8");
                    const crypter = new Iz.Crypter();
                    gameEnv = JSON.parse(crypter.decrypt(encryptedText));
                }
            }
            if (!gameEnv) {
                const filePath = path.join(base, "gameenv.json");
                if (fs.existsSync(filePath)) {
                    gameEnv = JSON.parse(fs.readFileSync(filePath, "utf-8"));
                }
            }
            if (!gameEnv) {
                throw new Error("[GameEnv Error]: 設定ファイルを読み込めませんでした");
            }
            return gameEnv;
        }
        Life.env = loadGameEnv();
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        function isTrial() {
            return !!Life.env.trial;
        }
        Life.isTrial = isTrial;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// config初期設定
(function (Iz) {
    var Life;
    (function (Life) {
        ConfigManager.bgmVolume = 20;
        ConfigManager.bgsVolume = 20;
        ConfigManager.seVolume = 20;
        ConfigManager.meVolume = 20;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// デバッグ用
(function (Iz) {
    var System;
    (function (System) {
        function isTestMode() {
            const isTest = Utils.isOptionValid("test");
            if (isTest && Iz.Life.env.editor?.mode === "production") {
                return false;
            }
            return isTest;
        }
        System.isTestMode = isTestMode;
        function isWebGLDebug() {
            return Utils.isOptionValid("webgldebug");
        }
        System.isWebGLDebug = isWebGLDebug;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=BootPlugin.js.map