// 自動生成したい
var Iz;
(function (Iz) {
    const crypto = require("crypto");
    const ENCRYPTION_KEY_LENGTH = 32;
    const BUFFER_KEY_LENGTH = 16;
    const DEFAULT_ENCRYPTION_KEY = "cdef28400672ffa9a21e44bb19ee73d6"; // 32Byte
    const DEFAULT_BUFFER_KEY = "719a5320d77d4f37"; // 16Byte
    const DEFAULT_ENCRYPT_METHOD = "aes-256-cbc";
    const DEFAULT_ENCODING = "hex";
    class Crypter {
        constructor(option) {
            this._option = {
                encryptionKey: DEFAULT_ENCRYPTION_KEY,
                bufferKey: DEFAULT_BUFFER_KEY,
                encryptMethod: DEFAULT_ENCRYPT_METHOD,
                encoding: DEFAULT_ENCODING,
            };
            Object.assign(this._option, option);
            const encryptionKeyLength = this._option.encryptionKey.length;
            if (encryptionKeyLength !== ENCRYPTION_KEY_LENGTH) {
                throw new Error(`[Crypter Exception]: invalid encryption key length -> ${encryptionKeyLength}`);
            }
            const bufferKeyLength = this._option.bufferKey.length;
            if (bufferKeyLength !== BUFFER_KEY_LENGTH) {
                throw new Error(`[Crypter Exception]: invalid buffer key length -> ${bufferKeyLength}`);
            }
        }
        get encryptionKey() {
            return this._option.encryptionKey;
        }
        get bufferKey() {
            return this._option.bufferKey;
        }
        get encryptMethod() {
            return this._option.encryptMethod;
        }
        get encoding() {
            return this._option.encoding;
        }
        encrypt(raw) {
            const iv = Buffer.from(this.bufferKey);
            const cipher = crypto.createCipheriv(this.encryptMethod, Buffer.from(this.encryptionKey), iv);
            let encrypted = cipher.update(raw);
            encrypted = Buffer.concat([encrypted, cipher.final()]);
            return encrypted.toString(this.encoding);
        }
        decrypt(encrypted) {
            const iv = Buffer.from(this.bufferKey);
            const encryptedText = Buffer.from(encrypted, this.encoding);
            const decipher = crypto.createDecipheriv(this.encryptMethod, Buffer.from(this.encryptionKey), iv);
            let decrypted = decipher.update(encryptedText);
            decrypted = Buffer.concat([decrypted, decipher.final()]);
            return decrypted.toString();
        }
    }
    Iz.Crypter = Crypter;
})(Iz || (Iz = {}));
//# sourceMappingURL=Encrypt.js.map