/*:
 * @target MZ
 * @plugindesc バージョン
 *
 * @help
 *
 *
 *
 *
 */
var Iz;
(function (Iz) {
    function convertVersion(versionText) {
        if (typeof versionText !== "string") {
            throw new Error("1.バージョン形式が不正です");
        }
        const splits = versionText.split(".");
        if (splits.length !== 3) {
            throw new Error("2.バージョン形式が不正です");
        }
        const nums = splits.map((s) => Number(s));
        if (nums.some((n) => !Number.isInteger(n))) {
            throw new Error("3.バージョン形式が不正です");
        }
        const version = {
            major: nums[0],
            minor: nums[1],
            patch: nums[2],
        };
        return version;
    }
    Iz.convertVersion = convertVersion;
    function compareVersion(a, b) {
        if (a.major !== b.major) {
            if (a.major < b.major) {
                return -1;
            }
            return 1;
        }
        if (a.minor !== b.minor) {
            if (a.minor < b.minor) {
                return -1;
            }
            return 1;
        }
        if (a.patch !== b.patch) {
            if (a.patch < b.patch) {
                return -1;
            }
            return 1;
        }
        return 0;
    }
    Iz.compareVersion = compareVersion;
})(Iz || (Iz = {}));
//# sourceMappingURL=GameVersion.js.map