/*:
 * @target MZ
 * @plugindesc タッチ判定関連
 *
 * @help
 *
 *
 */
// マップ移動の判定
(() => {
    const mapTouch = false;
    const _Scene_Map_isMapTouchOk = Scene_Map.prototype.isMapTouchOk;
    Scene_Map.prototype.isMapTouchOk = function () {
        if (!mapTouch) {
            return false;
        }
        return _Scene_Map_isMapTouchOk.call(this);
    };
})();
// スプライト、ウィンドウの判定
(() => {
    Sprite.prototype.isTouched = function () {
        const touchPos = new Point(TouchInput.x, TouchInput.y);
        const localPos = this.worldTransform.applyInverse(touchPos);
        const hitTest = (x, y) => {
            const rect = new Rectangle(-this.anchor.x * this.width, -this.anchor.y * this.height, this.width, this.height);
            return rect.contains(x, y);
        };
        return hitTest(localPos.x, localPos.y);
    };
    Window_Base.prototype.isTouched = function () {
        const touchPos = new Point(TouchInput.x, TouchInput.y);
        const localPos = this.worldTransform.applyInverse(touchPos);
        const rect = new Rectangle(0, 0, this.width, this.height);
        return rect.contains(localPos.x, localPos.y);
    };
})();
(() => {
    "use strict";
    const _Window_Selectable_initialize = Window_Selectable.prototype.initialize;
    Window_Selectable.prototype.initialize = function (rect, ...args) {
        _Window_Selectable_initialize.call(this, rect, ...args);
        this._overrideTouchArea = [];
    };
    Window_Selectable.prototype.addOverrideTouchArea = function (area) {
        this._overrideTouchArea.push(area);
    };
    const _Window_Selectable_onTouchOk = Window_Selectable.prototype.onTouchOk;
    Window_Selectable.prototype.onTouchOk = function () {
        const target = this.hitTestOverrideTouchArea();
        if (target && target.index === this.index()) {
            this.processOverrideTouchArea(target.area);
            return;
        }
        _Window_Selectable_onTouchOk.call(this);
    };
    Window_Selectable.prototype.hitTestOverrideTouchArea = function () {
        const touchPos = new Point(TouchInput.x, TouchInput.y);
        const localPos = this.worldTransform.applyInverse(touchPos);
        const x = localPos.x;
        const y = localPos.y;
        if (this.innerRect.contains(x, y)) {
            const cx = this.origin.x + x - this.padding;
            const cy = this.origin.y + y - this.padding;
            const topIndex = this.topIndex();
            for (let i = 0; i < this.maxVisibleItems(); i++) {
                const index = topIndex + i;
                if (index < this.maxItems()) {
                    const rect = this.itemRect(index);
                    const target = this._overrideTouchArea.find((a) => {
                        const r = new Rectangle(rect.x + a.rect.x, rect.y + a.rect.y, a.rect.width, a.rect.height);
                        return r.contains(cx, cy);
                    });
                    if (target) {
                        return { index: index, area: target };
                    }
                }
            }
        }
        return undefined;
    };
    Window_Selectable.prototype.processOverrideTouchArea = function (area) {
        if (this.isCurrentItemEnabled()) {
            this.updateInputData();
            area.handler();
        }
    };
})();
//# sourceMappingURL=Touch.js.map