var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class ActivatorStack {
                constructor(list, initType) {
                    this._list = new Map();
                    list.forEach((data) => {
                        this._list.set(data.key, data.value);
                    });
                    this._stack = new Array();
                    this._list.forEach((v, k) => {
                        v.deactivate();
                        v.visible = false;
                    });
                    this.push(initType);
                }
                push(type) {
                    const currentType = this._stack[this._stack.length - 1];
                    if (currentType) {
                        const currentValue = this._list.get(currentType);
                        if (currentValue) {
                            currentValue.deactivate();
                        }
                    }
                    this._stack.push(type);
                    const value = this._list.get(type);
                    if (value) {
                        value.activate();
                        value.visible = true;
                    }
                }
                pop() {
                    if (!this.isPopable()) {
                        throw new Error("activator stack error");
                    }
                    const type = this._stack.pop();
                    const value = this._list.get(type);
                    if (value) {
                        value.deactivate();
                        value.visible = false;
                    }
                    const prevType = this._stack[this._stack.length - 1];
                    const prevValue = this._list.get(prevType);
                    if (prevValue) {
                        prevValue.activate();
                    }
                }
                isPopable() {
                    if (this.isFirst())
                        return false;
                    const type = this._stack[this._stack.length - 1];
                    const value = this._list.get(type);
                    if (!value)
                        return false;
                    if (!value.backable())
                        return false;
                    return true;
                }
                isFirst() {
                    return this._stack.length <= 1;
                }
            }
            Debug.ActivatorStack = ActivatorStack;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            Debug.StackKey = {
                Index: "index",
                Time: "time",
                WorkLevel: "worklevel",
                Status: "status",
                i18n: "i18n",
                Collision: "Collision",
                Profile: "Profile",
                Gift: "Gift",
                System: "System",
                Fishing: "Fishing",
                Npc: "Npc",
            };
            function requestStack(key) {
                Debug.nextStack = key;
            }
            Debug.requestStack = requestStack;
            function clearStack() {
                Debug.nextStack = "";
            }
            Debug.clearStack = clearStack;
            Debug.nextStack = "";
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class DebugElement extends Sprite {
                constructor(width, height) {
                    super(new Bitmap(width, height));
                }
                select(flg) {
                    if (flg) {
                        this.setColorTone([-68, -68, 0, 68]);
                    }
                    else {
                        this.setColorTone([0, 0, 0, 0]);
                    }
                }
            }
            Debug.DebugElement = DebugElement;
            class Element extends DebugElement {
                constructor(width, height) {
                    super(width, height);
                    this.create();
                }
                create() {
                    this._title = new Sprite_TextEx(this.width, this.height);
                    this.addChild(this._title);
                    this._value = new Sprite_TextEx(this.width, this.height);
                    this._value.relativeAnchor.enable = true;
                    this._value.relativeAnchor.ratio.x = 1;
                    this.addChild(this._value);
                }
                set(title, value) {
                    this._title.setText(title);
                    this._value.setText(value);
                    this._value.relativeAnchor.offset.x = -this._value.textSizeEx(value).width;
                }
            }
            class OptionGrid extends Life.SelectableGrid {
                constructor(elementWidth, elementHeight, padding, elements, elementHandler) {
                    const option = {
                        emptyCellCreator: () => new Element(elementWidth, elementHeight),
                        cellUpdater: (cell, index) => {
                            cell.set(elements[index].title(), elements[index].displays
                                ? elements[index].displays()[this.valueIndex(index)]
                                : elements[index].values()[this.valueIndex(index)]);
                        },
                        maxItems: elements.length,
                        frameWidth: elementWidth,
                        frameHeight: elementHeight,
                        col: 1,
                        row: 8,
                        padding: padding,
                    };
                    super(option);
                    this._elements = elements;
                    this._valueIndexList = new Array(elements.length);
                    this._valueIndexList.fill(0);
                    elements.forEach((e, i) => {
                        this._valueIndexList[i] = e.initialIndex();
                    });
                    this.setHandler(Iz.GridEventType.CursorOutRight, () => this.onCursorRight());
                    this.setHandler(Iz.GridEventType.CursorOutLeft, () => this.onCursorLeft());
                    this.setHandler(Iz.GridEventType.Ok, () => this.onOk());
                    this._elementHandler = elementHandler;
                }
                get element() {
                    return this._elements[this.index];
                }
                value(index = this.index) {
                    const e = this._elements[index];
                    return e.values()[this.valueIndex(index)];
                }
                valueIndex(index = this.index) {
                    return this._valueIndexList[index];
                }
                onCursorLeft() {
                    let next = this.valueIndex() - 1;
                    if (next < 0) {
                        next = this._elements[this.index].values().length - 1;
                    }
                    this._valueIndexList[this.index] = next;
                    this.updateElements(false);
                }
                onCursorRight() {
                    let next = this.valueIndex() + 1;
                    if (next >= this._elements[this.index].values().length) {
                        next = 0;
                    }
                    this._valueIndexList[this.index] = next;
                    this.updateElements(true);
                }
                onOk() {
                    this._okHandler?.();
                }
                setUpdateElementHandler(handler) {
                    this._elementHandler = handler;
                }
                setOkHandler(handler) {
                    this._okHandler = handler;
                }
                updateElements(right) {
                    this._elementHandler?.(right);
                    this.refresh();
                }
            }
            const CORNER_SIZE = 20;
            class DebugWindowBase extends Iz.WindowBase {
                constructor(rect) {
                    super(rect);
                    this.createBg();
                }
                createBg() {
                    const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON);
                    const frame = atlas.getFrame(Life.FRAME_KEY_COMMON_FRAME);
                    this._bg = new NineSliceSprite(atlas.getBitmap());
                    this._bg.setSlice(CORNER_SIZE, CORNER_SIZE, CORNER_SIZE, CORNER_SIZE);
                    this._bg.setBitmapRect(frame.x, frame.y, frame.width, frame.height);
                    this._bg.setSize(this.width, this.height);
                    this.addChild(this._bg);
                }
                get padding() {
                    return { left: 24, right: 24, top: 16, bottom: 16 };
                }
                get elementWidth() {
                    return this.width - this.padding.left - this.padding.right;
                }
                get elementHeight() {
                    return 36;
                }
            }
            Debug.DebugWindowBase = DebugWindowBase;
            class OptionWindow extends DebugWindowBase {
                constructor(rect, elements) {
                    super(rect);
                    this.createGrid(elements);
                }
                get grid() {
                    return this._grid;
                }
                createGrid(elements) {
                    this._grid = new OptionGrid(this.elementWidth, this.elementHeight, this.padding, elements);
                    this._grid.refresh();
                    this.addChild(this._grid);
                }
                onUpdate() {
                    this._grid.updateMain();
                }
                activate() {
                    super.activate();
                    this._grid.activate();
                }
                deactivate() {
                    super.deactivate();
                    this._grid.deactivate();
                }
            }
            Debug.OptionWindow = OptionWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class TableElement extends Debug.DebugElement {
                constructor(width, height) {
                    super(width, height);
                    this.createText(width, height);
                }
                createText(width, height) {
                    this._text = new Sprite_TextEx(width, height);
                    this.addChild(this._text);
                }
                set(text) {
                    this._text.setText(text);
                }
            }
            class TableWindow extends Debug.DebugWindowBase {
                constructor(rect) {
                    super(rect);
                    this._items = [
                        "時間",
                        "作業レベル",
                        "ステータス",
                        "i18n",
                        "Collision",
                        "Profile",
                        "プレゼント",
                        "System",
                        "釣り再現",
                        "NPC",
                    ];
                    this.createGrid();
                }
                get grid() {
                    return this._grid;
                }
                createGrid() {
                    const option = {
                        maxItems: this._items.length,
                        frameWidth: this.elementWidth,
                        frameHeight: this.elementHeight,
                        col: 1,
                        row: this._items.length,
                        padding: this.padding,
                        emptyCellCreator: () => new TableElement(this.elementWidth, this.elementHeight),
                        cellUpdater: this.updateCell.bind(this),
                    };
                    this._grid = new Life.SelectableGrid(option);
                    this._grid.refresh();
                    this.addChild(this._grid);
                }
                updateCell(cell, index) {
                    cell.set(this._items[index] ?? "");
                }
                onUpdate() {
                    this._grid.updateMain();
                }
                activate() {
                    super.activate();
                    this._grid.activate();
                }
                deactivate() {
                    super.deactivate();
                    this._grid.deactivate();
                }
                backable() {
                    return true;
                }
            }
            Debug.TableWindow = TableWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 時間
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            const AutoAddIntervals = [60, 30, 10, 4, 1];
            const AutoAddIntervalMax = AutoAddIntervals[AutoAddIntervals.length - 1];
            class TimeSpeedInfo {
                title() {
                    return "時間経過速度";
                }
                values() {
                    return AutoAddIntervals.map((s) => `x${60 / s}`);
                }
                initialIndex() {
                    const index = this.values().findIndex((v, i) => {
                        return AutoAddIntervals[i] === $gameSystem.chronus().getAutoAddInterval();
                    });
                    return index >= 0 ? index : 0;
                }
            }
            class StopInfo {
                title() {
                    return "時間停止";
                }
                values() {
                    return ["OFF", "ON"];
                }
                initialIndex() {
                    return $gameSystem.chronus().isStop() ? 1 : 0;
                }
            }
            class TimeWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 480, 320), [new TimeSpeedInfo(), new StopInfo()]);
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                }
                onUpdateElements() {
                    if (this.grid.index === 0) {
                        const value = AutoAddIntervals[this.grid.valueIndex()];
                        $gameSystem.chronus().setAutoAddInterval(value);
                        return;
                    }
                    if (this.grid.index === 1) {
                        const isStop = this.grid.valueIndex() === 1;
                        if (isStop) {
                            if (!$gameSystem.chronus().isStop()) {
                                $gameSystem.chronus().stop();
                            }
                        }
                        else {
                            if ($gameSystem.chronus().isStop()) {
                                $gameSystem.chronus().start();
                            }
                        }
                        return;
                    }
                }
                backable() {
                    return true;
                }
            }
            Debug.TimeWindow = TimeWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 作業レベル
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            const workTypeNames = ["農業", "酪農", "採掘", "採集", "釣り"];
            class WorkLevelInfo {
                constructor(type) {
                    this._type = type;
                }
                title() {
                    return workTypeNames[this._type - 1];
                }
                values() {
                    return $dataWorkLevelExp.filter((data) => data).map((data) => data.id.toString());
                }
                initialIndex() {
                    const level = Life.Status.getWorkLevel(this._type);
                    return Math.max(0, level - 1);
                }
            }
            class WorkLevelEditWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 240, 320), [
                        new WorkLevelInfo(Life.Data.WorkType.Farm),
                        new WorkLevelInfo(Life.Data.WorkType.Dairy),
                        new WorkLevelInfo(Life.Data.WorkType.Mining),
                        new WorkLevelInfo(Life.Data.WorkType.Pick),
                        new WorkLevelInfo(Life.Data.WorkType.Fishing),
                    ]);
                }
                get type() {
                    return (this.grid.index + 1);
                }
                onUpdateElements() {
                    for (let i = Life.Data.WorkType.Farm; i < Life.Data.WorkType.Felling; i++) {
                        const level = Number(this.grid.value(i - 1));
                        if (Life.Status.getWorkLevel(i) !== level) {
                            const data = $dataWorkLevelExp.find((data) => data && data.id === level);
                            if (data) {
                                Life.Status.setWorkLevelExp(i, data.exp_total);
                            }
                        }
                    }
                }
            }
            class WorkLevelExpWindow extends Sprite {
                constructor() {
                    super();
                    this.setFrame(0, 0, 480, 96);
                    this.create();
                }
                create() {
                    this.createTitle();
                    this.createContent();
                }
                createTitle() {
                    this._title = new Sprite_TextEx(480, 32);
                    this.addChild(this._title);
                }
                createContent() {
                    this._content = new Sprite_TextEx(480, 96);
                    this._content.y = 32;
                    this.addChild(this._content);
                }
                set(type) {
                    this._title.setText(`${workTypeNames[type - 1]}:`);
                    this._content.setText(`Lv:${Iz.Life.Status.getWorkLevel(type)}\n経験値:${Iz.Life.Status.getWorkLevelExp(type)}`);
                }
            }
            class WorkLevelWindow extends Sprite {
                constructor() {
                    super();
                    this.create();
                    this.updateExp();
                }
                create() {
                    this.createExpWindow();
                    this.createEditWindow();
                }
                createExpWindow() {
                    this._workLevelExpWindow = new WorkLevelExpWindow();
                    this._workLevelExpWindow.y = 32;
                    this.addChild(this._workLevelExpWindow);
                }
                createEditWindow() {
                    this._editWindow = new WorkLevelEditWindow();
                    this._editWindow.grid.setHandler(Iz.GridEventType.CursorMoved, () => {
                        this.updateExp();
                    });
                    this._editWindow.grid.setUpdateElementHandler(this.updateElements.bind(this));
                    this._editWindow.y = 160;
                    this.addChild(this._editWindow);
                }
                backable() {
                    return true;
                }
                activate() {
                    this._editWindow.activate();
                }
                deactivate() {
                    this._editWindow.deactivate();
                }
                isActive() {
                    return this._editWindow.isActive();
                }
                updateExp() {
                    this._workLevelExpWindow.set(this._editWindow.type);
                }
                updateElements() {
                    this._editWindow.onUpdateElements();
                    this.updateExp();
                }
            }
            Debug.WorkLevelWindow = WorkLevelWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// ステータス
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            const statusTypeNames = ["疲労度", "満腹度"];
            class StatusInfo {
                constructor(type) {
                    this._type = type;
                }
                title() {
                    return statusTypeNames[this._type];
                }
                values() {
                    if (this._type === 0) {
                        return ["< >"];
                    }
                    if (this._type === 1) {
                        return ["< >"];
                    }
                    return [""];
                }
                initialIndex() {
                    return 0;
                }
            }
            class StatusEditWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 240, 320), [new StatusInfo(0), new StatusInfo(1)]);
                }
                onUpdateElements(right) {
                    if (this.grid.index === 0) {
                        const value = Life.Status.getFatigue();
                        Life.Status.setFatigue(value + (right ? 50 : -50));
                        return;
                    }
                    if (this.grid.index === 1) {
                        const value = Life.Status.getStuffedData().value;
                        Life.Status.setStuffed(value + (right ? 50 : -50));
                    }
                }
            }
            class StatusDetailWindow extends Sprite {
                constructor() {
                    super();
                    this.setFrame(0, 0, 480, 96);
                    this.create();
                }
                create() {
                    this.createTitle();
                    this.createContent();
                }
                createTitle() {
                    this._title = new Sprite_TextEx(480, 32);
                    this.addChild(this._title);
                }
                createContent() {
                    this._content = new Sprite_TextEx(480, 96);
                    this._content.y = 32;
                    this.addChild(this._content);
                }
                set(type) {
                    this._title.setText(`${statusTypeNames[type]}:`);
                    if (type === 0) {
                        this._content.setText(`${Life.Status.getFatigue()}`);
                        return;
                    }
                    if (type === 1) {
                        this._content.setText(`${Life.Status.getStuffedData().value}`);
                        return;
                    }
                }
            }
            class StatusWindow extends Sprite {
                constructor() {
                    super();
                    this.create();
                    this.updateDetail();
                }
                create() {
                    this.createDetailWindow();
                    this.createEditWindow();
                }
                createDetailWindow() {
                    this._statusDetailWindow = new StatusDetailWindow();
                    this._statusDetailWindow.y = 32;
                    this.addChild(this._statusDetailWindow);
                }
                createEditWindow() {
                    this._editWindow = new StatusEditWindow();
                    this._editWindow.grid.setHandler(Iz.GridEventType.CursorMoved, () => {
                        this.updateDetail();
                    });
                    this._editWindow.grid.setUpdateElementHandler(this.updateElements.bind(this));
                    this._editWindow.y = 160;
                    this.addChild(this._editWindow);
                }
                backable() {
                    return true;
                }
                activate() {
                    this._editWindow.activate();
                }
                deactivate() {
                    this._editWindow.deactivate();
                }
                isActive() {
                    return this._editWindow.isActive();
                }
                updateDetail() {
                    this._statusDetailWindow.set(this._editWindow.grid.index);
                }
                updateElements(right) {
                    this._editWindow.onUpdateElements(right);
                    this.updateDetail();
                }
            }
            Debug.StatusWindow = StatusWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// i18n
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class LangInfo {
                title() {
                    return "言語";
                }
                values() {
                    return Iz.System.LangCodeList;
                }
                initialIndex() {
                    const index = this.values().findIndex((value) => value === Iz.System.getLangCode(Iz.System.i18n.lang));
                    return index >= 0 ? index : 0;
                }
            }
            class i18nWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 240, 320), [new LangInfo()]);
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                }
                onUpdateElements() {
                    if (this.grid.index === 0) {
                        const value = this.grid.value();
                        const lang = Iz.System.LangCodeList.findIndex((l) => l === value);
                        if (Iz.System.i18n.lang !== lang) {
                            Iz.System.i18n.setLang(lang);
                            Iz.Life.loadFont(lang);
                        }
                    }
                }
                backable() {
                    return true;
                }
            }
            Debug.i18nWindow = i18nWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 当たり判定
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class LangInfo {
                title() {
                    return "Collision表示";
                }
                values() {
                    return ["OFF", "ON"];
                }
                initialIndex() {
                    return Iz.Life.parallaxLayerDisable ? 1 : 0;
                }
            }
            class CollisionWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 360, 320), [new LangInfo()]);
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                }
                onUpdateElements() {
                    // console.log(this.grid.valueIndex());
                    Iz.Life.setParallaxLayerDisable(this.grid.valueIndex() !== 0);
                }
                backable() {
                    return true;
                }
            }
            Debug.CollisionWindow = CollisionWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// プロフィール
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class UnlockInfo {
                title() {
                    return "プロフィール全解放";
                }
                values() {
                    return [""];
                }
                initialIndex() {
                    return 0;
                }
            }
            class ProfileWindow extends Debug.OptionWindow {
                constructor(log) {
                    super(new Rectangle(0, 0, 360, 320), [new UnlockInfo()]);
                    this.grid.setOkHandler(() => {
                        this.onOk();
                    });
                    this._logWindow = log;
                }
                onOk() {
                    Life.ProfileUtil.unlockAll();
                    this._logWindow.set("全解放しました");
                }
                backable() {
                    return true;
                }
            }
            Debug.ProfileWindow = ProfileWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// プレゼント
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class GiftInfo {
                title() {
                    return "プレゼント無制限";
                }
                values() {
                    return ["OFF", "ON"];
                }
                initialIndex() {
                    return Iz.Life.Status.getNoLimitGifted() ? 1 : 0;
                }
            }
            class GiftWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 360, 320), [new GiftInfo()]);
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                }
                onUpdateElements() {
                    Iz.Life.Status.setNoLimitGifted(this.grid.valueIndex() !== 0);
                }
                backable() {
                    return true;
                }
            }
            Debug.GiftWindow = GiftWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// システム
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            const GameSpeeds = [1, 2, 3, 4];
            const GameSpeedMax = GameSpeeds[GameSpeeds.length - 1];
            class GameSpeedInfo {
                title() {
                    return "GameSpeed";
                }
                values() {
                    return GameSpeeds.map((s) => `x${s}`);
                }
                initialIndex() {
                    const index = this.values().findIndex((value) => Graphics.app.ticker.speed === Number(value[1]));
                    return index >= 0 ? index : 0;
                }
            }
            class SystemWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 480, 320), [new GameSpeedInfo()]);
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                }
                onUpdateElements() {
                    if (this.grid.index === 0) {
                        const value = this.grid.value();
                        // $gameSystem.chronus().setTimeAutoAdd(Number(value));
                        Graphics.app.ticker.speed = Number(value[1]) ?? 1;
                    }
                }
                backable() {
                    return true;
                }
            }
            Debug.SystemWindow = SystemWindow;
            if (Iz.System.isTestMode()) {
                SceneManager.determineRepeatNumber = function (deltaTime) {
                    // [Note] We consider environments where the refresh rate is higher than
                    //   60Hz, but ignore sudden irregular deltaTime.
                    this._smoothDeltaTime *= 0.8;
                    this._smoothDeltaTime += Math.min(deltaTime, GameSpeedMax) * 0.2;
                    if (this._smoothDeltaTime >= 0.9) {
                        this._elapsedTime = 0;
                        return Math.round(this._smoothDeltaTime);
                    }
                    this._elapsedTime += deltaTime;
                    if (this._elapsedTime >= 1) {
                        this._elapsedTime -= 1;
                        return 1;
                    }
                    return 0;
                };
            }
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 釣り再現
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class MapInfo {
                title() {
                    return "マップ";
                }
                values() {
                    return [...$dataFishingMapArea.keys()].map((map) => `${map}`);
                }
                displays() {
                    return [...$dataFishingMapArea.keys()].map((map) => `ID:${map} ${Iz.System.getMapName(map)}`);
                }
                initialIndex() {
                    return 0;
                }
            }
            class WeatherInfo {
                title() {
                    return "天候";
                }
                values() {
                    return ["0", "1"];
                }
                displays() {
                    return ["晴れ", "雨"];
                }
                initialIndex() {
                    return 0;
                }
            }
            class DepthInfo {
                title() {
                    return "深度";
                }
                values() {
                    return ["1", "2", "3", "4", "5"];
                }
                initialIndex() {
                    return 0;
                }
            }
            class HourInfo {
                title() {
                    return "時間(h)";
                }
                values() {
                    return [...Array(24).keys()].map((k) => `${k}`);
                }
                initialIndex() {
                    return 0;
                }
            }
            class MinutesInfo {
                title() {
                    return "時間(m)";
                }
                values() {
                    return [...Array(60).keys()].map((k) => `${k}`);
                }
                initialIndex() {
                    return 0;
                }
            }
            class ExecNumInfo {
                title() {
                    return "実行回数";
                }
                values() {
                    return ["100", "500", "1000", "5000", "10000"];
                }
                initialIndex() {
                    return 0;
                }
            }
            class SortInfo {
                title() {
                    return "ソート順";
                }
                values() {
                    return ["0", "1"];
                }
                displays() {
                    return ["ID", "確率"];
                }
                initialIndex() {
                    return 0;
                }
            }
            class RunInfo {
                title() {
                    return this._title;
                }
                values() {
                    return [""];
                }
                initialIndex() {
                    return 0;
                }
                setTitle(title) {
                    this._title = title;
                }
            }
            class FishingWindow extends Debug.OptionWindow {
                constructor(logWindow) {
                    const runInfo = new RunInfo();
                    runInfo.setTitle("実行する");
                    super(new Rectangle(0, 0, 480, 340), [
                        new MapInfo(),
                        new WeatherInfo(),
                        new DepthInfo(),
                        new HourInfo(),
                        new MinutesInfo(),
                        new ExecNumInfo(),
                        new SortInfo(),
                        runInfo,
                    ]);
                    this._runInfo = runInfo;
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                    this.grid.setOkHandler(() => {
                        if (this.grid.index === 7) {
                            if (!this._running) {
                                this.run();
                            }
                        }
                    });
                    this._running = false;
                    this._logWindow = logWindow;
                }
                onUpdateElements() { }
                async run() {
                    this._running = true;
                    this._runInfo.setTitle("実行中");
                    this.grid.refresh();
                    this.grid.deactivate();
                    const mapId = Number(this.grid.value(0));
                    const weather = Number(this.grid.value(1));
                    const depth = Number(this.grid.value(2));
                    const hour = Number(this.grid.value(3));
                    const minute = Number(this.grid.value(4));
                    const sort = Number(this.grid.value(6));
                    const data = {
                        mapId: mapId,
                        weather: weather,
                        depth: depth,
                        hour: hour,
                        minute: minute,
                    };
                    const execNum = Number(this.grid.value(5));
                    const runner = new Life.SequenceFishRunner();
                    const results = [];
                    let execCount = 0;
                    const OneTimeCount = execNum < 1000 ? 10 : 100;
                    let stopping = false;
                    while (execCount < execNum) {
                        for (let i = 0; i < OneTimeCount; i++) {
                            const bigfish = Iz.Obj.apply(Life.FishingDebug.createDebugBigFishOption(depth), data);
                            const normal = Iz.Obj.apply(Life.FishingDebug.createDebugNormalFishOption(depth, runner.count), data);
                            const result = runner.run({
                                bigfish: bigfish,
                                normal: normal,
                            });
                            results.push(result);
                        }
                        execCount += OneTimeCount;
                        stopping = true;
                        setTimeout(() => {
                            stopping = false;
                            this._runInfo.setTitle(`実行中 ${execCount}/${execNum}`);
                            this.grid.refresh();
                        }, 1);
                        await Iz.PromiseEx.waitUntil(() => !stopping, 1);
                    }
                    const stats = new Life.FishingDebug.FishingStats({ results: results, ...data });
                    stats.print(sort === 1);
                    this._running = false;
                    this._runInfo.setTitle("実行する");
                    this.grid.activate();
                    this.grid.refresh();
                    this._logWindow.set("完了しました");
                }
                backable() {
                    return !this._running;
                }
            }
            Debug.FishingWindow = FishingWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// NPC
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class DetailWindow extends Sprite {
                constructor() {
                    const bitmap = new Bitmap(512, 512);
                    super(bitmap);
                    this.create();
                }
                create() {
                    this.createName();
                    this.createSchedule();
                    this.createProgress();
                }
                createName() {
                    this._name = new Sprite_Text(512, 32);
                    this._name.setText("");
                    this.addChild(this._name);
                }
                createSchedule() {
                    this._schedule = new Sprite_Text(512, 32);
                    this._schedule.setText("");
                    this._schedule.y = 32;
                    this.addChild(this._schedule);
                }
                createProgress() {
                    this._progress = new Sprite_Text(512, 32);
                    this._progress.setText("");
                    this._progress.y = 64;
                    this.addChild(this._progress);
                }
                set(actorId) {
                    this.setName(actorId);
                    this.setSchedule(actorId);
                    this.setProgress(actorId);
                }
                setName(actorId) {
                    const actor = $dataActors[actorId];
                    this._name.setText(`名前: ${actor?.name ?? ""}`);
                }
                setSchedule(actorId) {
                    const npc = $globalMap.nonPlayer(actorId);
                    this._schedule.setText(`スケジュール: ${npc?.scheduler.schedule ?? ""}`);
                }
                setProgress(actorId) {
                    const npc = $globalMap.nonPlayer(actorId);
                    this._progress.setText(`進行度: ${npc?.scheduler.progress ?? ""}`);
                }
            }
            class CharacterIdInfo {
                title() {
                    return "ActorID";
                }
                values() {
                    return $globalMap.nonPlayerIds(true).map((id) => id.toString());
                }
                initialIndex() {
                    return 0;
                }
            }
            class NpcWindow extends Debug.OptionWindow {
                constructor() {
                    super(new Rectangle(0, 0, 240, 320), [new CharacterIdInfo()]);
                    this.create();
                    this.grid.setUpdateElementHandler(this.onUpdateElements.bind(this));
                    this._detail.set(2);
                }
                create() {
                    this.createDetail();
                }
                createDetail() {
                    this._detail = new DetailWindow();
                    this._detail.x = 256;
                    this._detail.y = 64;
                    this.addChild(this._detail);
                }
                onUpdateElements() {
                    if (this.grid.index === 0) {
                        const actorId = Number(this.grid.value());
                        this._detail.set(actorId);
                    }
                }
                backable() {
                    return true;
                }
            }
            Debug.NpcWindow = NpcWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            Debug.logWindowCount = 0;
            class LogWindow extends Sprite {
                constructor() {
                    const bitmap = new Bitmap(512, 96);
                    // bitmap.fillAll("gray");
                    super(bitmap);
                    this.create();
                    this._count = 0;
                }
                create() {
                    this.createText();
                }
                createText() {
                    this._text = new Sprite_TextEx(this.width, this.height);
                    this.addChild(this._text);
                }
                set(text) {
                    this._text.setText(text);
                    this._count = 255;
                }
                update() {
                    super.update();
                    if (this._count > 0) {
                        this._count--;
                    }
                    this.opacity = this._count;
                }
            }
            Debug.LogWindow = LogWindow;
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    class DebugScene extends Scene_Base {
        create() {
            super.create();
            this.createLogWindow();
            this.createTableWindow();
            this.createTimeWindow();
            this.createWorkLevelWindow();
            this.createStatusWindow();
            this.createi18nWindow();
            this.createCollisionWindow();
            this.createProfileWindow();
            this.createGiftWindow();
            this.createSystemWindow();
            this.createFishingWindow();
            this.createNpcWindow();
            this._stack = new Iz.Life.Debug.ActivatorStack([
                { key: Iz.Life.Debug.StackKey.Index, value: this._table },
                { key: Iz.Life.Debug.StackKey.Time, value: this._timeWindow },
                { key: Iz.Life.Debug.StackKey.WorkLevel, value: this._workLevelWindow },
                { key: Iz.Life.Debug.StackKey.Status, value: this._statusWindow },
                { key: Iz.Life.Debug.StackKey.i18n, value: this._i18nWindow },
                { key: Iz.Life.Debug.StackKey.Collision, value: this._collisionWindow },
                { key: Iz.Life.Debug.StackKey.Profile, value: this._profileWindow },
                { key: Iz.Life.Debug.StackKey.Gift, value: this._giftWindow },
                { key: Iz.Life.Debug.StackKey.System, value: this._systemWindow },
                { key: Iz.Life.Debug.StackKey.Fishing, value: this._fishingWindow },
                { key: Iz.Life.Debug.StackKey.Npc, value: this._npcWindow },
            ], Iz.Life.Debug.StackKey.Index);
        }
        createLogWindow() {
            this._logWindow = new Iz.Life.Debug.LogWindow();
            this._logWindow.x = 768;
            this._logWindow.y = 704;
            this.addChild(this._logWindow);
        }
        createTableWindow() {
            this._table = new Iz.Life.Debug.TableWindow(new Rectangle(0, 0, 240, 400));
            this._table.grid.setHandler(Iz.GridEventType.Ok, () => {
                const index = this._table.grid.index;
                if (index === 0) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Time);
                }
                else if (index === 1) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.WorkLevel);
                }
                else if (index === 2) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Status);
                }
                else if (index === 3) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.i18n);
                }
                else if (index === 4) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Collision);
                }
                else if (index === 5) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Profile);
                }
                else if (index === 6) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Gift);
                }
                else if (index === 7) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.System);
                }
                else if (index === 8) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Fishing);
                }
                else if (index === 9) {
                    Iz.Life.Debug.requestStack(Iz.Life.Debug.StackKey.Npc);
                }
            });
            this.addChild(this._table);
        }
        createTimeWindow() {
            const w = new Iz.Life.Debug.TimeWindow();
            w.x = 480;
            this.addChild(w);
            this._timeWindow = w;
        }
        createWorkLevelWindow() {
            const w = new Iz.Life.Debug.WorkLevelWindow();
            w.x = 480;
            this.addChild(w);
            this._workLevelWindow = w;
        }
        createStatusWindow() {
            const w = new Iz.Life.Debug.StatusWindow();
            w.x = 480;
            this.addChild(w);
            this._statusWindow = w;
        }
        createi18nWindow() {
            this._i18nWindow = new Iz.Life.Debug.i18nWindow();
            this._i18nWindow.x = 480;
            this.addChild(this._i18nWindow);
        }
        createCollisionWindow() {
            this._collisionWindow = new Iz.Life.Debug.CollisionWindow();
            this._collisionWindow.x = 480;
            this.addChild(this._collisionWindow);
        }
        createProfileWindow() {
            this._profileWindow = new Iz.Life.Debug.ProfileWindow(this._logWindow);
            this._profileWindow.x = 480;
            this.addChild(this._profileWindow);
        }
        createGiftWindow() {
            this._giftWindow = new Iz.Life.Debug.GiftWindow();
            this._giftWindow.x = 480;
            this.addChild(this._giftWindow);
        }
        createSystemWindow() {
            this._systemWindow = new Iz.Life.Debug.SystemWindow();
            this._systemWindow.x = 480;
            this.addChild(this._systemWindow);
        }
        createFishingWindow() {
            this._fishingWindow = new Iz.Life.Debug.FishingWindow(this._logWindow);
            this._fishingWindow.x = 480;
            this.addChild(this._fishingWindow);
        }
        createNpcWindow() {
            this._npcWindow = new Iz.Life.Debug.NpcWindow();
            this._npcWindow.x = 480;
            this.addChild(this._npcWindow);
        }
        update() {
            super.update();
            if (Iz.Life.Debug.nextStack) {
                this._stack.push(Iz.Life.Debug.nextStack);
                Iz.Life.Debug.clearStack();
            }
            else {
                if (Input.isTriggeredOneshot("cancel")) {
                    if (this._stack.isFirst()) {
                        this.popScene();
                    }
                    else if (this._stack.isPopable()) {
                        this._stack.pop();
                    }
                }
            }
        }
    }
    const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function () {
        _Window_MenuCommand_addOriginalCommands.call(this);
        this.addCommand("デバッグ", "life_debug", true);
    };
    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function () {
        _Scene_Menu_createCommandWindow.call(this);
        this._commandWindow.setHandler("life_debug", () => SceneManager.push(DebugScene));
    };
})();
// 実績確認
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            class StatsElement extends Sprite {
                constructor(w, h) {
                    const bitmap = new Bitmap(w, h);
                    bitmap.fillAll("blue");
                    super(bitmap);
                    this.createTitle(w, h);
                    this.createContent(w, h);
                }
                createTitle(w, h) {
                    this._title = new Sprite_Text(w, h);
                    this.addChild(this._title);
                }
                createContent(w, h) {
                    this._content = new Sprite_Text(w, h);
                    this._content.setAlign("right");
                    this.addChild(this._content);
                }
                setTitle(title) {
                    this._title.setText(title);
                }
                setContent(content) {
                    this._content.setText(content);
                }
            }
            function createElement(title, content, w, h) {
                const e = new StatsElement(w, h);
                e.setTitle(title);
                e.setContent(content);
                return e;
            }
            const TitleHeight = 48;
            const ElementHeight = 32;
            class StatsGroup extends Sprite {
                constructor(option) {
                    const bitmap = new Bitmap(512, TitleHeight + ElementHeight * option.elements.length);
                    super(bitmap);
                    this.create(option);
                }
                create(option) {
                    this.createTitle(option.title);
                    this.createElements(option.elements);
                }
                createTitle(title) {
                    this._title = new Sprite_Text(this.width, TitleHeight);
                    this._title.setText(title);
                    this.addChild(this._title);
                }
                createElements(elements) {
                    this._elements = [];
                    elements.forEach((e, i) => {
                        const elem = createElement(e.title, e.content, this.width, ElementHeight);
                        elem.y += TitleHeight;
                        elem.y += i * ElementHeight;
                        this._elements.push(elem);
                        this.addChild(elem);
                    });
                }
            }
            class StatsPage extends Sprite {
                constructor() {
                    super();
                    this._groups = [];
                }
                add(group) {
                    this._groups.push(group);
                    this.addChild(group);
                }
            }
            class StatsScene extends Scene_Base {
                create() {
                    this._pages = [];
                    this._pageIndex = -1;
                    super.create();
                    this.createStats();
                    this._pageIndex = this._pages.length > 0 ? 0 : -1;
                    this.refreshPage();
                    this.createArrows();
                }
                createStats() {
                    // page1
                    {
                        const page = new StatsPage();
                        page.add(this.createStatsFarm());
                        page.add(this.createStatsFishing());
                        page.add(this.createStatsPickup());
                        page.add(this.createStatsDairy());
                        page.add(this.createStatsMining());
                        page.add(this.createStatsCraft());
                        this._pages.push(page);
                    }
                    // page2
                    {
                        const page = new StatsPage();
                        page.add(this.createStatsCommunication());
                        page.add(this.createStatsManagement());
                        page.add(this.createStatsOther());
                        this._pages.push(page);
                    }
                    this._pages.forEach((p) => {
                        p.x = 96;
                        this.addChild(p);
                    });
                }
                createStatsFarm() {
                    const mostCrop = Life.Stats.farm.getMostCrop();
                    const mostHarvestNum = Life.Stats.farm.getHarvestNum(mostCrop);
                    const mostCropContent = mostCrop
                        ? `${$dataItems[mostCrop].name}:${mostHarvestNum}個`
                        : "";
                    const stats = new StatsGroup({
                        title: "農作",
                        elements: [
                            { title: "耕した回数", content: `${Life.Stats.farm.hoedCount}回` },
                            { title: "水を撒いた回数", content: `${Life.Stats.farm.wateredCount}回` },
                            { title: "種を撒いた回数", content: `${Life.Stats.farm.plantedCount}回` },
                            { title: "収穫した作物数", content: `${Life.Stats.farm.getTotalHarvestCount()}個` },
                            { title: "一番育てた作物", content: `${mostCropContent}` },
                        ],
                    });
                    return stats;
                }
                createStatsFishing() {
                    const mostFish = Life.Stats.fishing.getMostFish();
                    const mostFishNum = Life.Stats.fishing.getFishNum(mostFish);
                    const mostFishContent = mostFish ? `${$dataItems[mostFish].name}:${mostFishNum}匹` : "";
                    const stats = new StatsGroup({
                        title: "釣り",
                        elements: [
                            { title: "釣った魚数", content: `${Life.Stats.fishing.getTotalFishNum()}匹` },
                            { title: "ヌシを釣った数", content: `${Life.Stats.fishing.bigFishNum}匹` },
                            { title: "通常魚種を釣った数", content: `${Life.Stats.fishing.normalFishNum}匹` },
                            { title: "一番釣った魚", content: `${mostFishContent}` },
                            { title: "釣りをしていた時間", content: `${Life.Stats.fishing.totalTime}分` },
                        ],
                    });
                    stats.y = 256;
                    return stats;
                }
                createStatsPickup() {
                    const stats = new StatsGroup({
                        title: "採集",
                        elements: [
                            { title: "入手した木材", content: `${Life.Stats.felling.getItemNum(140)}個` },
                            { title: "入手した石材", content: `${Life.Stats.mining.getNum(141, false)}個` },
                            { title: "採集した回数", content: `${Life.Stats.pickup.totalCount}回` },
                            { title: "伐採した回数", content: `${Life.Stats.felling.totalCount}回` },
                            { title: "オノで与えた総ダメージ", content: `${Life.Stats.felling.totalDamage}` },
                        ],
                    });
                    stats.y = 512;
                    return stats;
                }
                createStatsDairy() {
                    const stats = new StatsGroup({
                        title: "酪農",
                        elements: [
                            { title: "ブラッシング回数", content: `${Life.Stats.dairy.brushedCount}回` },
                            { title: "話しかけた回数", content: `${Life.Stats.dairy.talkedCount}回` },
                            { title: "獲得なつき度", content: `${Life.Stats.dairy.totalHappiness}` },
                            { title: "タマゴの収穫数", content: `${Life.Stats.dairy.getEggAmount()}` },
                            { title: "ミルクの収穫数", content: `${Life.Stats.dairy.getMilkAmount()}` },
                        ],
                    });
                    stats.x = 576;
                    return stats;
                }
                createStatsMining() {
                    const stats = new StatsGroup({
                        title: "採鉱",
                        elements: [
                            {
                                title: "鉱石を拾った総数",
                                content: `${Life.Stats.mining.getTotalMineItemNum()}個`,
                            },
                            { title: "鉱山到達最下層", content: `${Life.Stats.mining.arrivedArea}` },
                            { title: "鉱山で潜った総階数", content: `${Life.Stats.mining.mineAreaCount}` },
                            { title: "鉱山に滞在した時間", content: `${Life.Stats.mining.timeInMine}分` },
                            { title: "ハンマーで与えた総ダメージ", content: `${Life.Stats.mining.totalDamage}` },
                        ],
                    });
                    stats.x = 576;
                    stats.y = 256;
                    return stats;
                }
                createStatsCraft() {
                    const mostCooking = Life.Stats.cooking.getMostItem();
                    let mostCookingContent = "";
                    if (mostCooking) {
                        mostCookingContent += $dataItems[mostCooking]?.name ?? "";
                        mostCookingContent += `:${Life.Stats.cooking.getNum(mostCooking)}回`;
                    }
                    const stats = new StatsGroup({
                        title: "料理、クラフト",
                        elements: [
                            { title: "料理回数", content: `${Life.Stats.cooking.totalCount}回` },
                            { title: "一番作った料理", content: `${mostCookingContent}` },
                            { title: "クラフト回数", content: `${Life.Stats.craft.totalCount}回` },
                        ],
                    });
                    stats.x = 576;
                    stats.y = 512;
                    return stats;
                }
                createStatsCommunication() {
                    const mostTalkedActor = Life.Stats.status.mostTalkedActor();
                    let mostTalkedContent = "";
                    if (mostTalkedActor) {
                        mostTalkedContent += $gameActors.actor(mostTalkedActor)?.name() ?? "";
                        mostTalkedContent += `:${Life.Stats.status.getActor(mostTalkedActor)?.talkedCount ?? 0}回`;
                    }
                    const stats = new StatsGroup({
                        title: "交流",
                        elements: [
                            { title: "一番話しかけたキャラ", content: `${mostTalkedContent}` },
                            { title: "総会話回数", content: `${Life.Stats.status.getTotalTalkedCount()}回` },
                            { title: "プレゼント回数", content: `${Life.Stats.gift.getTotalCount()}回` },
                            {
                                title: "総なかよし度",
                                content: `${Life.Stats.communication.getTotalLikability()}`,
                            },
                            {
                                title: "ぶつかった回数",
                                content: `${Life.Stats.globalMap.getTotalCollidedCount()}回`,
                            },
                            {
                                title: "ハプニング回数",
                                content: `${Life.Stats.globalMap.getTotalHappeningCount()}回`,
                            },
                            {
                                title: "女湯を覗いた回数",
                                content: `${Life.Stats.communication.peekBathCount}回`,
                            },
                            {
                                title: "Hな関係を持った人数",
                                content: `${Life.Stats.communication.getCompletedHeartEventPeople()}人`,
                            },
                        ],
                    });
                    return stats;
                }
                createStatsManagement() {
                    const stats = new StatsGroup({
                        title: "経営",
                        elements: [
                            { title: "総消費金額", content: `${Life.Stats.system.totalConsumeMoney}` },
                            { title: "合計出荷金額", content: `${Life.Stats.shipping.money}` },
                        ],
                    });
                    stats.y = 320;
                    return stats;
                }
                createStatsOther() {
                    const proposeDate = Iz.System.timeToDate(Life.Stats.system.proposeTime);
                    const proposeContent = `${proposeDate.year}年目 ${Iz.System.getMonthName(proposeDate.month)} ${proposeDate.day}日`;
                    const stats = new StatsGroup({
                        title: "その他",
                        elements: [
                            { title: "倒れた回数", content: `${Life.Stats.status.overExhaustedCount}` },
                            { title: "入浴回数", content: `${Life.Stats.status.bathCount}` },
                            { title: "総消費HP", content: `${Life.Stats.status.totalConsumeHp}` },
                            {
                                title: "プロポーズ対象",
                                content: `${$gameActors.actor(Life.Stats.system.proposeActor)?.name() ?? ""}`,
                            },
                            { title: "プロポーズ日付", content: `${proposeContent}` },
                            { title: "プレイ時間", content: `${Life.Stats.system.getPlayTime()}` },
                        ],
                    });
                    stats.x = 576;
                    return stats;
                }
                createArrows() {
                    const left = new Sprite();
                    left.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_TARGET_LEFT);
                    left.x = 16;
                    left.y = 384;
                    this.addChild(left);
                    const right = new Sprite();
                    right.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_TARGET_RIGHT);
                    right.x = 1230;
                    right.y = 384;
                    this.addChild(right);
                }
                update() {
                    super.update();
                    if (Input.isCancelled()) {
                        this.popScene();
                        return;
                    }
                    if (this._pages.length <= 0)
                        return;
                    if (Input.isRepeated(Iz.IO.KEY_NAME_RIGHT) ||
                        Input.isRepeated(Iz.IO.KEY_NAME_SLOT_RIGHT)) {
                        this._pageIndex++;
                        if (this._pageIndex >= this._pages.length) {
                            this._pageIndex = 0;
                        }
                        this.refreshPage();
                        SoundManager.playCursor();
                        return;
                    }
                    if (Input.isRepeated(Iz.IO.KEY_NAME_LEFT) ||
                        Input.isRepeated(Iz.IO.KEY_NAME_SLOT_LEFT)) {
                        this._pageIndex--;
                        if (this._pageIndex < 0) {
                            this._pageIndex = this._pages.length - 1;
                        }
                        this.refreshPage();
                        SoundManager.playCursor();
                        return;
                    }
                }
                refreshPage() {
                    this._pages.forEach((p) => {
                        p.visible = false;
                    });
                    const current = this._pages[this._pageIndex];
                    if (current) {
                        current.visible = true;
                    }
                }
            }
            const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
            Window_MenuCommand.prototype.addOriginalCommands = function () {
                _Window_MenuCommand_addOriginalCommands.call(this);
                this.addCommand("実績確認", "stats_debug", true);
            };
            const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
            Scene_Menu.prototype.createCommandWindow = function () {
                _Scene_Menu_createCommandWindow.call(this);
                this._commandWindow.setHandler("stats_debug", () => SceneManager.push(StatsScene));
            };
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 翻訳テキストチェック
(function (Iz) {
    var Life;
    (function (Life) {
        var Debug;
        (function (Debug) {
            function loadUniqueIds() {
                const XLSX = require("xlsx-js-style");
                const filePath = "../sheats/i18n/uniqueIds.xlsx";
                const wb = XLSX.readFile(filePath);
                const list = XLSX.utils.sheet_to_json(wb.Sheets.UniqueIds);
                const messageList = list.filter((data) => data && data.type === "文章の表示");
                return messageList;
            }
            Debug.loadUniqueIds = loadUniqueIds;
            Scene_Map.prototype.checkTextSize = function (text) {
                const size = this._messageWindow.textSizeEx(text);
                const textState = new TextState();
                const innerWidth = this._messageWindow.innerWidth;
                const newLineX = this._messageWindow.newLineX(textState);
                const limitWidth = innerWidth - newLineX;
                return size.width <= limitWidth;
            };
            Scene_Map.prototype.checkTextSizeAll = async function () {
                const list = loadUniqueIds();
                for (let i = 0; i < Iz.System.LangNum; i++) {
                    const lang = i;
                    Iz.System.i18n.setLang(lang);
                    Iz.Life.loadFont(lang);
                    await Iz.PromiseEx.waitUntil(() => {
                        return FontManager.isReady();
                    });
                    const langCode = Iz.System.LangCodeList[i];
                    const failedList = list
                        // @ts-ignore
                        .filter((data) => data[langCode])
                        .filter((data) => {
                        // @ts-ignore
                        const text = data[langCode];
                        return !this.checkTextSize(text.replaceAll("\\" + "n", "\n"));
                    });
                    console.log(`【${langCode}】`);
                    const text = failedList
                        // @ts-ignore
                        .map((data) => `id:${data.id} text:${data[langCode]}`)
                        .join("\n");
                    console.log(text);
                }
            };
        })(Debug = Life.Debug || (Life.Debug = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// シェーダーテスト
(() => {
    "use strict";
    function createFragmentSrc() {
        const src = "varying vec2 vTextureCoord;" +
            "uniform sampler2D uSampler;" +
            "uniform vec3 uColor;" +
            "vec4 toColor(vec4 texColor) {" +
            "  float a = texColor.a;" +
            "  if (a <= 0.0) {" +
            "    return vec4(0.0,0.0,0.0,0.0);" +
            "  }" +
            "  return vec4(uColor,1.0) * texColor.a;" +
            "}" +
            "void main(void){" +
            "  vec4 texColor = texture2D(uSampler, vTextureCoord).rgba;" +
            "  vec4 color = toColor(texColor);" +
            "  gl_FragColor = color;" +
            "}";
        return src;
    }
    class Filter extends PIXI.Filter {
        constructor() {
            super(undefined, createFragmentSrc());
            this.setColor([1.0, 1.0, 0.0]);
        }
        setColor(color) {
            this.uniforms.uColor = [...color];
        }
    }
    class ColorSprite extends Sprite {
        constructor() {
            super();
            this.setFilter();
        }
        setFilter() {
            if (this.filters)
                return;
            const filter = new Filter();
            this.filters = [];
            this.filters.push(filter);
            this._filter = filter;
        }
    }
    class Shader_Scene extends Scene_Base {
        create() {
            super.create();
            this.createSprite();
        }
        createSprite() {
            this._colorSprite = new ColorSprite();
            this._colorSprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_SHORTCUTICON_OPTION);
            this._colorSprite.anchor.set(0.5, 0.5);
            this._colorSprite.x = 128;
            this._colorSprite.y = 128;
            this._colorSprite.scale.set(1.2, 1.2);
            this._colorSprite.alpha = 0.5;
            this.addChild(this._colorSprite);
            this._normalSprite = new Sprite();
            this._normalSprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_SHORTCUTICON_OPTION);
            this._normalSprite.anchor.set(0.5, 0.5);
            this._normalSprite.x = 128;
            this._normalSprite.y = 128;
            this.addChild(this._normalSprite);
        }
        update() {
            super.update();
            if (Input.isTriggeredOneshot("cancel")) {
                this.popScene();
            }
            else if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                // console.log("b");
                // this._colorSprite.setFilter();
                // this._colorSprite.setColor();
            }
        }
    }
    const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function () {
        _Window_MenuCommand_addOriginalCommands.call(this);
        this.addCommand("シェーダー", "life_debug_shader", true);
    };
    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function () {
        _Scene_Menu_createCommandWindow.call(this);
        this._commandWindow.setHandler("life_debug_shader", () => SceneManager.push(Shader_Scene));
    };
})();
(function (Iz) {
    var Debug;
    (function (Debug) {
        function imageRegex() {
            // if ($.Param.imageType == 'webp') return (/^data:image\/webp;base64,/);
            // if ($.Param.imageType == 'jpeg' || $.Param.imageType == 'jpg') return (/^data:image\/jpeg;base64,/);
            return /^data:image\/png;base64,/;
        }
        function screenshot() {
            const bitmap = SceneManager.snap();
            const urlData = bitmap.canvas.toDataURL();
            const base64Data = urlData.replace(imageRegex(), "");
            const fs = require("fs");
            const tempDir = "../.temp";
            if (!fs.existsSync(tempDir)) {
                fs.mkdirSync(tempDir);
            }
            const filename = "screenshot.png";
            // if(false) {
            //     const time = new Date();
            //     const year = `${time.getFullYear()}`;
            //     const month = `${time.getMonth()+1}`.padStart(2,'0');
            //     const date = `${time.getDate()}`.padStart(2,'0');
            //     const hour = `${time.getHours()}`.padStart(2,'0');
            //     const minutes = `${time.getMinutes()}`.padStart(2,'0');
            //     const seconds = `${time.getSeconds()}`.padStart(2,'0');
            //     filename = `screenshot_${year}${month}${date}${hour}${minutes}${seconds}.png`;
            // }
            fs.writeFile(`${tempDir}/${filename}`, base64Data, "base64", (error) => {
                if (error) {
                    console.error(`screenshot error: ${error}`);
                }
            });
        }
        Debug.screenshot = screenshot;
        if (Utils.isOptionValid("test")) {
            function onKeyUp(e) {
                if (e.key === "p") {
                    screenshot();
                }
            }
            document.addEventListener("keyup", onKeyUp);
        }
    })(Debug = Iz.Debug || (Iz.Debug = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=LifeDebug.js.map