var Iz;
(function (Iz) {
    var System;
    (function (System) {
        System.Lang = {
            JP: 0,
            EN: 1,
            ZH_CN: 2,
            ZH_TW: 3,
            KO: 4,
        };
        System.LangNum = 5;
        System.LangCodeList = ["jp", "en", "zh_CN", "zh_TW", "ko"];
        function getLangCode(lang) {
            return System.LangCodeList[lang] ?? "jp";
        }
        System.getLangCode = getLangCode;
        class i18nProxy {
            // constructor() {
            //     this.setLang(Lang.JP);
            // }
            get lang() {
                return this._lang;
            }
            constructor() {
                this._lang = -1;
                this._list = new Map();
                this._onChangeLangHandlers = [];
            }
            initialize() {
                this._lang = -1;
                this._list.clear();
                // this._onChangeLangHandlers = [];
            }
            setLang(lang, applyGameObjects = true) {
                if (this._lang === lang) {
                    return;
                }
                this._lang = lang;
                this.setup(lang, applyGameObjects);
                this._onChangeLangHandlers.forEach((handler) => {
                    handler();
                });
            }
            onInitializeGameObjects() {
                System.i18nUtil.applyGameObjects();
            }
            setOnChangeLang(handler) {
                this._onChangeLangHandlers.push(handler);
            }
            setup(lang, applyGameObjects) {
                this.setupUniqueIdData(lang);
                this.setupDatabaseData(lang);
                if (applyGameObjects) {
                    System.i18nUtil.applyGameObjects();
                }
            }
            setupUniqueIdData(lang) {
                if (this.isDefaultLang(lang)) {
                    this._list.clear();
                }
                else {
                    const fs = require("fs");
                    const json = fs.readFileSync(`./data/${getLangCode(lang)}/dataUniqueIds.json`, "utf-8");
                    this._list.clear();
                    const ids = JSON.parse(json);
                    ids.forEach((id) => {
                        this._list.set(id.id, id);
                    });
                }
            }
            setupDatabaseData(lang) {
                System.i18nUtil.applyDatabaseTexts();
            }
            getUniqueIdText(uniqueId) {
                const data = this._list.get(uniqueId);
                return data?.text ?? "";
            }
            isDefault() {
                return this.isDefaultLang(this._lang);
            }
            isDefaultLang(lang) {
                return lang === System.Lang.JP;
            }
        }
        System.i18n = new i18nProxy();
        System.i18n.setOnChangeLang(() => {
            applySystemJson();
        });
        function initializei18n() {
            System.i18n.initialize();
            System.i18n.setLang(Iz.Life.env.lang, false);
        }
        System.initializei18n = initializei18n;
        function applySystemJson() {
            // NOTE:
            // System.jsonは個別対応
            const gameTitle = Iz.Text.get("SYSTEM_JSON_GAMETITLE");
            if (gameTitle) {
                $dataSystem.gameTitle = gameTitle;
            }
            for (let i = 0; i < $dataSystem.terms.basic.length; i++) {
                const text = Iz.Text.get(`SYSTEM_JSON_TERMS_BASIC_${i}`);
                if (text) {
                    $dataSystem.terms.basic[i] = text;
                }
            }
            for (let i = 0; i < $dataSystem.terms.commands.length; i++) {
                const text = Iz.Text.get(`SYSTEM_JSON_TERMS_COMMANDS_${i}`);
                if (text) {
                    $dataSystem.terms.commands[i] = text;
                }
            }
            Iz.Obj.keys({ ...$dataSystem.terms.messages }).forEach((key) => {
                const text = Iz.Text.get(`SYSTEM_JSON_TERMS_MESSAGES_${key.toUpperCase()}`);
                if (text) {
                    $dataSystem.terms.messages[key] = text;
                }
            });
        }
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var System;
    (function (System) {
        var i18nUtil;
        (function (i18nUtil) {
            function isJP() {
                return System.i18n.lang === System.Lang.JP;
            }
            i18nUtil.isJP = isJP;
            function isEN() {
                return System.i18n.lang === System.Lang.EN;
            }
            i18nUtil.isEN = isEN;
            function isZH_CN() {
                return System.i18n.lang === System.Lang.ZH_CN;
            }
            i18nUtil.isZH_CN = isZH_CN;
            function isZH_TW() {
                return System.i18n.lang === System.Lang.ZH_TW;
            }
            i18nUtil.isZH_TW = isZH_TW;
            function isKO() {
                return System.i18n.lang === System.Lang.KO;
            }
            i18nUtil.isKO = isKO;
        })(i18nUtil = System.i18nUtil || (System.i18nUtil = {}));
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
// for atlas
(function (Iz) {
    var Life;
    (function (Life) {
        function getFrameKey(key) {
            if (Iz.System.i18n.isDefault()) {
                return key;
            }
            const langCode = Iz.System.getLangCode(Iz.System.i18n.lang);
            return `${key}_${langCode}`;
        }
        Life.getFrameKey = getFrameKey;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var System;
    (function (System) {
        function convertUniqueIdText(text) {
            const regExp = /\\TRN\[(.+?)\]/;
            const result = regExp.exec(text);
            if (!result)
                return text;
            const uniqueId = Number(result[1]);
            const len = result[0].length;
            if (!Iz.System.i18n.isDefault()) {
                const langText = Iz.System.i18n.getUniqueIdText(uniqueId);
                if (langText) {
                    return langText;
                }
            }
            const res = text.slice(len);
            return res;
        }
        System.convertUniqueIdText = convertUniqueIdText;
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
(() => {
    const _Scene_Boot_onDatabaseLoaded = Scene_Boot.prototype.onDatabaseLoaded;
    Scene_Boot.prototype.onDatabaseLoaded = function () {
        Iz.System.initializei18n();
        _Scene_Boot_onDatabaseLoaded.call(this);
    };
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.System.i18n.onInitializeGameObjects();
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.System.i18n.onInitializeGameObjects();
    };
    const _Window_Base_processEscapeCharacter = Window_Base.prototype.processEscapeCharacter;
    Window_Base.prototype.processEscapeCharacter = function (code, textState) {
        switch (code) {
            case "TRN": {
                const uniqueId = Number.parseInt(obtainEscapeWords(textState));
                if (Iz.System.i18n.isDefault()) {
                    textState.text = textState.text.slice(textState.index);
                }
                else {
                    const langText = Iz.System.i18n.getUniqueIdText(uniqueId);
                    if (langText) {
                        textState.text = langText;
                    }
                    else {
                        textState.text = textState.text.slice(textState.index);
                    }
                }
                // \nの文字列を改行コードに差し替え
                // @ts-ignore
                textState.text = textState.text.replaceAll("\\" + "n", "\n");
                textState.text = this.convertEscapeCharacters(textState.text);
                textState.index = 0;
                _Window_Base_processEscapeCharacter.call(this, code, textState);
                break;
            }
            default:
                _Window_Base_processEscapeCharacter.call(this, code, textState);
                break;
        }
    };
    function obtainEscapeWords(textState) {
        const regExp = /\[(.+?)\]/;
        const result = regExp.exec(textState.text.slice(textState.index));
        if (result) {
            textState.index += result[0].length;
            return result[1];
        }
        return "";
    }
})();
//# sourceMappingURL=i18n.js.map