var Iz;
(function (Iz) {
    var System;
    (function (System) {
        var i18nUtil;
        (function (i18nUtil) {
            const textData = new Map();
            function dataPath() {
                const path = require("path");
                const base = path.dirname(process.mainModule.filename);
                return path.join(base, "data");
            }
            function loadDatabaseData() {
                if (Iz.System.i18n.isDefault())
                    return;
                const fs = require("fs");
                const path = require("path");
                const filePath = path.join(dataPath(), Iz.System.getLangCode(Iz.System.i18n.lang), "dataDatabase.json");
                const list = JSON.parse(fs.readFileSync(filePath, "utf-8"));
                textData.clear();
                list.forEach((data) => {
                    textData.set(data.id, data);
                });
            }
            function clearDatabaseData() {
                textData.clear();
            }
            function getText(key) {
                const data = textData.get(key);
                return data?.text ?? "";
            }
            function applyItems() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Items.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataItems.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                    data.description = map.get(data.id)?.description ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataItems.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `ITEMS_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                    $dataItems.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `ITEMS_DESCRIPTION_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.description = text;
                        }
                    });
                }
            }
            function applyGameObjectsItems() { }
            function applyActors() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Actors.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataActors.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataActors.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `ACTORS_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsActors() {
                $dataActors
                    .filter((data) => data)
                    .filter((data) => data.id >= 2)
                    .forEach((data) => {
                    const actor = $gameActors.actor(data.id);
                    if (actor) {
                        actor.setName(data.name);
                    }
                });
            }
            function applySkills() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Skills.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataSkills.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataSkills.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `SKILLS_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsSkills() { }
            function applyDairyShed() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "DairyShed.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataDairyShed.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataDairyShed.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DAIRYSHED_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsDairyShed() { }
            function applyDairyLivestock() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "DairyLivestock.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataDairyLivestock.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataDairyLivestock.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DAIRYLIVESTOCK_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsDairyLivestock() { }
            function applyDairyLivestockGroup() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "DairyLivestockGroup.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataDairyLivestockGroup.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataDairyLivestockGroup.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DAIRYLIVESTOCKGROUP_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsDairyLivestockGroup() { }
            function applyGroup() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Group.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataGroup.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataGroup.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `GROUP_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsGroup() { }
            function applyIndicator() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Indicator.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataIndicator.forEach((data) => {
                    if (!data)
                        return;
                    data.display_name = map.get(data.id)?.display_name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataIndicator.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `INDICATOR_DISPLAY_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.display_name = text;
                        }
                    });
                }
            }
            function applyGameObjectsIndicator() { }
            function applyCharacterLabel() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "CharacterLabel.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataCharacterLabel.forEach((data) => {
                    if (!data)
                        return;
                    data.value = map.get(data.id)?.value ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataCharacterLabel.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `CHARACTERLABEL_VALUE_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.value = text;
                        }
                    });
                }
            }
            function applyGameObjectsCharacterLabel() { }
            function applyPlaceGroup() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "PlaceGroup.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataPlaceGroup.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataPlaceGroup.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `PLACEGROUP_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsPlaceGroup() { }
            function applyQuestContent() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "QuestContent.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(`${temp.id.toString()}_${temp.index.toString()}`, temp);
                });
                $dataQuestContent.forEach((data) => {
                    if (!data)
                        return;
                    data.title = map.get(`${data.id.toString()}_${data.index.toString()}`)?.title ?? "";
                    data.desc = map.get(`${data.id.toString()}_${data.index.toString()}`)?.desc ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataQuestContent.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `QUESTCONTENT_TITLE_${data.id.toString().toUpperCase()}_${data.index.toString().toUpperCase()}`;
                        const text = getText(textKey);
                        if (text) {
                            data.title = text;
                        }
                    });
                    $dataQuestContent.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `QUESTCONTENT_DESC_${data.id.toString().toUpperCase()}_${data.index.toString().toUpperCase()}`;
                        const text = getText(textKey);
                        if (text) {
                            data.desc = text;
                        }
                    });
                }
            }
            function applyGameObjectsQuestContent() { }
            function applyQuestConditionTarget() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "QuestConditionTarget.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataQuestConditionTarget.forEach((data) => {
                    if (!data)
                        return;
                    data.display_name = map.get(data.id)?.display_name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataQuestConditionTarget.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `QUESTCONDITIONTARGET_DISPLAY_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.display_name = text;
                        }
                    });
                }
            }
            function applyGameObjectsQuestConditionTarget() { }
            function applyText() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Text.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataText.forEach((data) => {
                    if (!data)
                        return;
                    data.value = map.get(data.id)?.value ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataText.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `TEXT_VALUE_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.value = text;
                        }
                    });
                }
            }
            function applyGameObjectsText() { }
            function applyGlobalMapInfo() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "GlobalMapInfo.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataGlobalMapInfo.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataGlobalMapInfo.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `GLOBALMAPINFO_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsGlobalMapInfo() { }
            function applyLocation() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Location.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataLocation.forEach((data) => {
                    if (!data)
                        return;
                    data.name = map.get(data.id)?.name ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataLocation.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `LOCATION_NAME_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.name = text;
                        }
                    });
                }
            }
            function applyGameObjectsLocation() {
                Iz.GlobalMap.applyLocationMap();
            }
            function applyTipsText() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "TipsText.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataTipsText.forEach((data) => {
                    if (!data)
                        return;
                    data.text = map.get(data.id)?.text ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataTipsText.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `TIPSTEXT_TEXT_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.text = text;
                        }
                    });
                }
            }
            function applyGameObjectsTipsText() { }
            function applyDialog() {
                const fs = require("fs");
                const path = require("path");
                const list = JSON.parse(fs.readFileSync(path.join(dataPath(), "Dialog.json"), "utf-8"));
                const map = new Map();
                list.forEach((temp) => {
                    if (!temp)
                        return;
                    map.set(temp.id, temp);
                });
                $dataDialog.forEach((data) => {
                    if (!data)
                        return;
                    data.title = map.get(data.id)?.title ?? "";
                    data.text = map.get(data.id)?.text ?? "";
                    data.yes_text = map.get(data.id)?.yes_text ?? "";
                    data.no_text = map.get(data.id)?.no_text ?? "";
                });
                if (!Iz.System.i18n.isDefault()) {
                    $dataDialog.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DIALOG_TITLE_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.title = text;
                        }
                    });
                    $dataDialog.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DIALOG_TEXT_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.text = text;
                        }
                    });
                    $dataDialog.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DIALOG_YES_TEXT_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.yes_text = text;
                        }
                    });
                    $dataDialog.forEach((data) => {
                        if (!data)
                            return;
                        const textKey = `DIALOG_NO_TEXT_${data.id}`;
                        const text = getText(textKey);
                        if (text) {
                            data.no_text = text;
                        }
                    });
                }
            }
            function applyGameObjectsDialog() { }
            function applyDatabaseTexts() {
                loadDatabaseData();
                applyItems();
                applyActors();
                applySkills();
                applyDairyShed();
                applyDairyLivestock();
                applyDairyLivestockGroup();
                applyGroup();
                applyIndicator();
                applyCharacterLabel();
                applyPlaceGroup();
                applyQuestContent();
                applyQuestConditionTarget();
                applyText();
                applyGlobalMapInfo();
                applyLocation();
                applyTipsText();
                applyDialog();
                clearDatabaseData();
            }
            i18nUtil.applyDatabaseTexts = applyDatabaseTexts;
            function applyGameObjects() {
                applyGameObjectsItems();
                applyGameObjectsActors();
                applyGameObjectsSkills();
                applyGameObjectsDairyShed();
                applyGameObjectsDairyLivestock();
                applyGameObjectsDairyLivestockGroup();
                applyGameObjectsGroup();
                applyGameObjectsIndicator();
                applyGameObjectsCharacterLabel();
                applyGameObjectsPlaceGroup();
                applyGameObjectsQuestContent();
                applyGameObjectsQuestConditionTarget();
                applyGameObjectsText();
                applyGameObjectsGlobalMapInfo();
                applyGameObjectsLocation();
                applyGameObjectsTipsText();
                applyGameObjectsDialog();
            }
            i18nUtil.applyGameObjects = applyGameObjects;
        })(i18nUtil = System.i18nUtil || (System.i18nUtil = {}));
    })(System = Iz.System || (Iz.System = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=i18nScriptDatabase.js.map