/*:
 * @target MZ
 * @plugindesc アイテム効果に関する処理
 *
 * @help
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class GameActionEffect {
            constructor(effect) {
                this._effect = effect;
            }
            text() {
                if (this._effect.code === Game_Action.EFFECT_RECOVER_MP) {
                    return Iz.String.format(Iz.Text.get("ITEM_EFFECT_HP_RECOVER"), this._effect.value2);
                }
                return "";
            }
        }
        function itemTargetActors(item, subject) {
            const actor = subject;
            const action = new Game_Action(actor);
            action.setItemObject(item);
            if (!action.isForFriend()) {
                return [];
            }
            if (action.isForAll()) {
                return $gameParty.members();
            }
            return [actor];
        }
        class Runner {
            run(itemId) {
                // 最大体力上昇の可能性があるのでrunEffect()を優先
                this.runEffect(itemId);
                this.runAction(itemId);
            }
            runAction(itemId) {
                const actor = this.subject();
                const item = this.item(itemId);
                if (!actor)
                    return;
                if (!item)
                    return;
                $gameParty.setLastItem(item);
                actor.useItem(item);
                const action = new Game_Action(actor);
                action.setItemObject(item);
                itemTargetActors(item, this.subject()).forEach(function (target) {
                    for (let i = 0; i < action.numRepeats(); i++) {
                        action.apply(target);
                    }
                });
                if (item.animationId > 0) {
                    $gamePlayer.requestAnimation(item.animationId);
                }
                else {
                    // NOTE:
                    // 回復用のエフェクト以外も使用する場合は判定が必要
                    const RecoverAnimationId = 9;
                    $gamePlayer.requestAnimation(RecoverAnimationId);
                }
                action.applyGlobal();
            }
            runEffect(itemId) {
                // 満腹度
                const effect = Life.Status.getItemEffect(itemId);
                if (!effect)
                    return;
                if (effect.stuffed > 0) {
                    Life.Status.addStuffed(effect.stuffed);
                }
                // 追加特性
                effect.traits.forEach((t) => {
                    Life.Status.traits.addDuration(t.traitId, t.duration);
                });
            }
            test(itemId) {
                return this.executable(itemId);
            }
            effects(itemId) {
                const item = this.item(itemId);
                if (!item)
                    return [];
                const effects = [];
                for (let i = 0; i < item.effects.length; i++) {
                    const e = item.effects[i];
                    effects.push(new GameActionEffect(e));
                }
                return effects;
            }
            executable(itemId) {
                if (!this.executableStuffed(itemId))
                    return false;
                // if(!this.executableMZItemTest(itemId))
                //     return false;
                return true;
            }
            executableMZItemTest(itemId) {
                const actor = this.subject();
                const item = this.item(itemId);
                if (!actor)
                    return false;
                if (!item)
                    return false;
                const action = new Game_Action(actor);
                action.setItemObject(item);
                return itemTargetActors(item, this.subject()).some(function (target) {
                    return action.testApply(target);
                });
            }
            executableStuffed(itemId) {
                const stuffed = Life.Status.getItemStuffed(itemId);
                if (stuffed > 0) {
                    return !Life.Status.isStuffed();
                }
                return true;
            }
            item(itemId) {
                return $dataItems[itemId];
            }
            subject() {
                return $gameParty.leader();
            }
        }
        class ItemEffectProxy {
            constructor() {
                this._runner = new Runner();
            }
            run(itemId) {
                this._runner.run(itemId);
            }
            test(itemId) {
                return this._runner.test(itemId);
            }
            effects(itemId) {
                return this._runner.effects(itemId);
            }
        }
        Life.ItemEffectProxy = ItemEffectProxy;
        Life.ItemEffect = new ItemEffectProxy();
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_Map_updateMain = Scene_Map.prototype.updateMain;
    Scene_Map.prototype.updateMain = function () {
        _Scene_Map_updateMain.call(this);
        const data = Iz.Life.Status.getStuffedData();
        if (data.value > 0) {
            const lasttime = data.lastTime;
            const currentTime = Iz.System.getTotalTime();
            // 一定時間ごとに満腹度を下げる
            const duration = $parameter.status.stuffed.decrease_duration;
            if (currentTime >= lasttime + duration) {
                Iz.Life.Status.addStuffed($parameter.status.stuffed.decrease_value);
            }
        }
    };
})();
//# sourceMappingURL=ItemEffect.js.map