/*:
 * @target MZ
 * @plugindesc アイテムスロット
 *
 * @help
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.ItemType = {
            Normal: 1,
            KeyItem: 2,
        };
        function validItemType(itemId) {
            const item = $dataItems[itemId];
            if (!item)
                return false;
            return item.itypeId === Life.ItemType.Normal || item.itypeId === Life.ItemType.KeyItem;
        }
        Life.validItemType = validItemType;
        function isNormalItem(itemId) {
            const item = $dataItems[itemId];
            if (!item)
                return false;
            return item.itypeId === Life.ItemType.Normal;
        }
        Life.isNormalItem = isNormalItem;
        function isKeyItem(itemId) {
            const item = $dataItems[itemId];
            if (!item)
                return false;
            return item.itypeId === Life.ItemType.KeyItem;
        }
        Life.isKeyItem = isKeyItem;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// インベントリ関連
(function (Iz) {
    var Life;
    (function (Life) {
        Life.ItemSlotCol = 10;
        Life.ItemSlotRowMin = 1;
        Life.ItemSlotRowDefault = 2;
        Life.ItemSlotRowMax = 4;
        const ItemSlotTempRow = 1;
        Life.ItemSlotKey_Default = "Default";
        Life.ItemSlotKey_Temp = "Temp";
        Life.ItemSlotGridWidth = 818;
        Life.ItemSlotGridHeight = 76;
        class ItemSlotInventory {
            constructor(items, attr, limit) {
                this._data = { list: new Array(items) };
                this._attr = attr;
                this._limit = limit;
            }
            get list() {
                return this._data.list;
            }
            get maxItems() {
                return this._data.list.length;
            }
            get attr() {
                return this._attr;
            }
            get limit() {
                return this._limit;
            }
            isValid(index) {
                if (index < 0)
                    return false;
                if (index >= this.maxItems)
                    return false;
                return true;
            }
            isValidItem(id) {
                if (!$dataItems[id])
                    return false;
                return true;
            }
            get(index) {
                return this.list[index];
            }
            itemId(index) {
                const data = this.get(index);
                return data ? data.id : 0;
            }
            set(index, id) {
                if (!this.isValid(index))
                    return false;
                if (!this.isValidItem(id))
                    return false;
                // 重複登録不可
                this.removeById(id);
                this.list[index] = { id: id };
                return true;
            }
            index(id) {
                return this.list.findIndex((data) => !!data && data.id === id);
            }
            has(id) {
                return this.index(id) >= 0;
            }
            // 空き領域に追加
            add(id) {
                if (!this.isValidItem(id))
                    return false;
                if (this.has(id))
                    return false;
                const emptyIndex = this.searchEmpty();
                if (emptyIndex < 0)
                    return false;
                this.list[emptyIndex] = { id: id };
                return true;
            }
            searchEmpty() {
                return this.list.findIndex((data) => !data);
            }
            remove(index) {
                if (index >= 0 && index < this.list.length && this.list[index]) {
                    delete this.list[index];
                }
            }
            removeById(id) {
                const index = this.index(id);
                if (index >= 0) {
                    delete this.list[index];
                }
            }
            setupData(maxItems, inventory) {
                const newMaxItems = Math.min(maxItems, this._limit);
                const newData = { list: new Array(newMaxItems) };
                newData.list.fill(undefined);
                const len = Math.min(inventory.list.length, newMaxItems);
                for (let i = 0; i < len; i++) {
                    const data = inventory.list[i];
                    if (data) {
                        newData.list[i] = Object.assign({}, data);
                    }
                }
                this._data = newData;
            }
            setMaxItems(maxItems) {
                this.setupData(maxItems, this._data);
            }
            apply(inventory) {
                this.setupData(inventory.list.length, inventory);
            }
            clear() {
                this._data.list = new Array(this.maxItems);
            }
        }
        Life.ItemSlotInventory = ItemSlotInventory;
        class ItemSlotInventoryList {
            constructor() {
                this.clear();
            }
            get currentKey() {
                return this._currentKey;
            }
            get current() {
                return this.getInventory(this._currentKey);
            }
            get inventories() {
                const list = [];
                for (const entry of Object.entries(this._inventories)) {
                    list.push({ key: entry[0], inventory: entry[1] });
                }
                return list;
            }
            apply(key, inventory) {
                const data = this.getInventory(key);
                if (data) {
                    data.apply(inventory);
                }
            }
            getInventory(key) {
                return this._inventories[key];
            }
            change(key) {
                const inventory = this.getInventory(key);
                if (inventory) {
                    this._currentKey = key;
                }
            }
            clear() {
                this._inventories = {};
                this._inventories[Life.ItemSlotKey_Default] = new ItemSlotInventory(Life.ItemSlotCol * Life.ItemSlotRowDefault, { sync: true }, Life.ItemSlotCol * Life.ItemSlotRowMax);
                this._inventories[Life.ItemSlotKey_Temp] = new ItemSlotInventory(Life.ItemSlotCol * ItemSlotTempRow, { sync: true }, Life.ItemSlotCol * ItemSlotTempRow);
                this._currentKey = Life.ItemSlotKey_Default;
            }
        }
        Life.ItemSlotInventoryList = ItemSlotInventoryList;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// コールバック関連
(function (Iz) {
    var Life;
    (function (Life) {
        const RecoverAnimationId = 9;
        class ItemSlotHander {
            constructor() {
                this._useFinishedListenerList = new Map();
                this.clear();
            }
            // 現在未使用
            addUseChecker(checker) {
                this._useCheckerList.push(checker);
            }
            addUseFinishedListener(key, listener) {
                this._useFinishedListenerList.set(key, listener);
            }
            removeUseFinishedListener(key) {
                this._useFinishedListenerList.delete(key);
            }
            addSelectListener(listener) {
                this._selectList.push(listener);
            }
            addChangeSlotListener(listener) {
                this._changeSlotList.push(listener);
            }
            useCheck(itemId) {
                // useCheck(itemId: number, isSub: boolean) {
                // let res = this._useCheckerList.some((handler) => handler(itemId, isSub));
                // if (res) {
                //     const data = $dataItems[itemId];
                //     if (data?.consumable && !isSeed(itemId)) {
                //         $gameParty.loseItem(data, 1, false);
                //     }
                // } else if (isSub) {
                //     res = useItemEffect(itemId);
                // }
                const res = useItemEffect(itemId);
                this._useFinishedListenerList.forEach((handler) => handler(itemId, res));
                return res;
            }
            onSelect() {
                this._selectList.forEach((callback) => callback());
            }
            onChangeSlot(lineIndex) {
                this._changeSlotList.forEach((callback) => callback(lineIndex));
            }
            clear() {
                this._useCheckerList = [];
                this._useFinishedListenerList.clear();
                this._selectList = [];
                this._changeSlotList = [];
            }
        }
        Life.ItemSlotHander = ItemSlotHander;
        function useItemEffect(itemId) {
            // console.log(`[use item] ID: ${item.id} Name: ${$dataItems[item.id].name}`);
            const effect = Life.ItemEffect;
            if (!effect.test(itemId))
                return false;
            effect.run(itemId);
            return true;
        }
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// パラメータ関連
(function (Iz) {
    var Life;
    (function (Life) {
        Life.ItemSlotMode = {
            Visible_InEvent: 1 << 0,
            Select_InEvent: 1 << 1,
        };
        class ItemSlotParam {
            constructor() {
                this.clear();
            }
            get addNewItem() {
                return this._addNewItem;
            }
            set addNewItem(value) {
                this._addNewItem = value;
            }
            setEventMode(mode) {
                this._eventModeField = this._eventModeField | mode;
            }
            removeEventMode(mode) {
                this._eventModeField = this._eventModeField & ~mode;
            }
            isEventMode(mode) {
                return this._eventModeField & mode;
            }
            clear() {
                this._eventModeField = 0;
                this._addNewItem = true;
            }
        }
        Life.ItemSlotParam = ItemSlotParam;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// アイテム操作関連
(function (Iz) {
    var Life;
    (function (Life) {
        // NOTE:
        // 複数操作をしても不正な状態にならないように、
        // トランザクションのような仕組みを入れたい
        class ItemSlotOperator {
            setItem(slotIndex, itemId) {
                if (!$gameParty.hasItem($dataItems[itemId])) {
                    return false;
                }
                const success = Life.ItemSlot.inventory.set(slotIndex, itemId);
                if (success) {
                    if (Iz.Life.ItemSlot.inventory.attr.sync) {
                        Iz.Life.ItemSlot.refresh();
                        return true;
                    }
                }
                return false;
            }
            addItem(itemId) {
                if (!$gameParty.hasItem($dataItems[itemId])) {
                    return false;
                }
                const success = Life.ItemSlot.inventory.add(itemId);
                if (success) {
                    if (Iz.Life.ItemSlot.inventory.attr.sync) {
                        Iz.Life.ItemSlot.refresh();
                        return true;
                    }
                }
                return false;
            }
            select(index) {
                Life.ItemSlot.select(index);
            }
            selectLine(lineIndex) {
                Life.ItemSlot.selectLine(lineIndex);
            }
            setEnable(value) {
                Life.ItemSlot.active = value;
                Life.ItemSlot.visible = value;
            }
            setActive(value, keepSelected) {
                Life.ItemSlot.active = value;
                Life.ItemSlot.setKeepSelectedOnDeactive(keepSelected ?? false);
            }
            setVisibleInEvent(value) {
                if (value) {
                    Iz.Life.ItemSlot.param.setEventMode(Iz.Life.ItemSlotMode.Visible_InEvent);
                }
                else {
                    Iz.Life.ItemSlot.param.removeEventMode(Iz.Life.ItemSlotMode.Visible_InEvent);
                }
            }
            setUnlockInternal(inventoryKey, slotNum) {
                if (slotNum <= 0)
                    return false;
                const inventory = Life.ItemSlot.inventories.find((inv) => inv.key === inventoryKey);
                if (!inventory)
                    return false;
                const maxItems = Life.ItemSlotCol * slotNum;
                if (maxItems > inventory.inventory.limit)
                    return false;
                inventory.inventory.setMaxItems(maxItems);
                if (Life.ItemSlot.inventoryKey === inventoryKey) {
                    if (Life.ItemSlot.lineIndex + 1 > slotNum) {
                        Life.ItemSlot.selectLine(slotNum - 1);
                    }
                }
                return true;
            }
            setUnlock(slotNum) {
                this.setUnlockInternal(Life.ItemSlotKey_Default, slotNum);
            }
        }
        Life.ItemSlotOperator = ItemSlotOperator;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 全体統括
(function (Iz) {
    var Life;
    (function (Life) {
        class ItemSlotProxy {
            constructor() {
                this._slotList = new Life.ItemSlotInventoryList();
                this._handler = new Life.ItemSlotHander();
                this._param = new Life.ItemSlotParam();
                this._operator = new Life.ItemSlotOperator();
                this._active = false;
                this._visible = false;
            }
            get active() {
                return this._active;
            }
            set active(value) {
                this._active = value;
            }
            get visible() {
                return this._visible;
            }
            set visible(value) {
                this._visible = value;
            }
            get index() {
                return this._gridAccessor ? this._gridAccessor.index : Life.ItemSlotTemp.Index;
            }
            get lineIndex() {
                return this._gridAccessor ? this._gridAccessor.lineIndex : Life.ItemSlotTemp.LineIndex;
            }
            get prevIndex() {
                return this._gridAccessor ? this._gridAccessor.prevIndex : this.index;
            }
            get itemId() {
                return this.inventory.itemId(this.inventoryIndex);
            }
            get inventory() {
                return this._slotList.current;
            }
            get inventoryKey() {
                return this._slotList.currentKey;
            }
            get inventories() {
                return this._slotList.inventories;
            }
            get handler() {
                return this._handler;
            }
            get param() {
                return this._param;
            }
            get operator() {
                return this._operator;
            }
            get inventoryIndex() {
                return this.getInventoryIndex(this.index, this.lineIndex);
            }
            getInventoryIndex(index, lineIndex) {
                return lineIndex * Life.ItemSlotCol + index;
            }
            setAccessor(accessor) {
                this._gridAccessor = accessor;
            }
            changeInventory(key) {
                this._slotList.change(key);
                this.refresh();
            }
            applyInventory(key, inventory) {
                this._slotList.apply(key, inventory);
            }
            useItemSlot(itemId) {
                if (this._handler.useCheck(itemId)) {
                    this.refresh();
                }
            }
            refresh() {
                this._gridAccessor?.refresh();
            }
            select(index) {
                this._gridAccessor?.select(index);
            }
            selectLine(lineIndex) {
                this._gridAccessor?.selectLine(lineIndex);
            }
            setKeepSelectedOnDeactive(flg) {
                this._gridAccessor?.setKeepSelectedOnDeactive(flg);
            }
            clear() {
                this._gridAccessor = undefined;
                this._slotList.clear();
                this._handler.clear();
                this._param.clear();
            }
        }
        Life.ItemSlot = new ItemSlotProxy();
        function initializeItemSlot() {
            Life.ItemSlot.clear();
            // changeItemSlot(ItemSlotKey_Default);
            Iz.Life.ItemSlotTemp.Index = 0;
            Iz.Life.ItemSlotTemp.LineIndex = 0;
        }
        Life.initializeItemSlot = initializeItemSlot;
        // debug
        function registerAllItems() {
            $gameParty.items().forEach((item) => {
                Life.ItemSlot.inventory.add(item.id);
            });
            Life.ItemSlot.refresh();
        }
        Life.registerAllItems = registerAllItems;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var ItemSlotTemp;
        (function (ItemSlotTemp) {
            // biome-ignore lint:
            ItemSlotTemp.Index = 0;
            // biome-ignore lint:
            ItemSlotTemp.LineIndex = 0;
        })(ItemSlotTemp = Life.ItemSlotTemp || (Life.ItemSlotTemp = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// ユーティリティ関数など
(function (Iz) {
    var Life;
    (function (Life) {
        function registrableItems() {
            let items = $gameParty.allItems().filter((item) => DataManager.isItem(item));
            // 隠しアイテムは除外
            items = items.filter((item) => Life.validItemType(item.id));
            // 登録済みアイテムは除外
            items = items.filter((item) => !Life.ItemSlot.inventory.has(item.id));
            return items;
        }
        Life.registrableItems = registrableItems;
        // 所持数限界超え
        function isExceedItems() {
            const registeredItems = Life.ItemSlot.inventory.list.filter((data) => data);
            return registeredItems.length + registrableItems().length > Life.ItemSlot.inventory.maxItems;
        }
        Life.isExceedItems = isExceedItems;
        // 所持数満杯以上
        function isFullItems() {
            const registeredItems = Life.ItemSlot.inventory.list.filter((data) => data);
            return registeredItems.length + registrableItems().length >= Life.ItemSlot.inventory.maxItems;
        }
        Life.isFullItems = isFullItems;
        function getItemSlotRows(items) {
            return Math.ceil(items / Life.ItemSlotCol);
        }
        Life.getItemSlotRows = getItemSlotRows;
        function isMoveSpeedDown() {
            if (Life.ItemSlot.inventoryKey === Life.ItemSlotKey_Temp) {
                return false;
            }
            if (Iz.Life.isExceedItems() && !($gameMap.isEventRunning() || $gameMessage.isBusy())) {
                return true;
            }
            return false;
        }
        Life.isMoveSpeedDown = isMoveSpeedDown;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        class SelectableGrid extends Iz.LoopGrid {
            constructor(options, selectableOption) {
                if (selectableOption?.arrow) {
                    let padding = options.padding;
                    if (!padding)
                        padding = { left: 0, right: 0, top: 0, bottom: 0 };
                    padding.top = 24;
                    padding.bottom = 24;
                    options.padding = padding;
                }
                super(options);
                this._keepSelectedOnDeactive = false;
                this._selected = false;
                this.verticalWrap = Iz.GridVerticalWrapMode.Loop;
                if (selectableOption?.arrow) {
                    this.createArrow();
                    this.onUpdateStep(0);
                }
                if (selectableOption?.targetArrow) {
                    this.createTargetArrow();
                }
            }
            get keepSelectedOnDeactive() {
                return this._keepSelectedOnDeactive;
            }
            set keepSelectedOnDeactive(value) {
                this._keepSelectedOnDeactive = value;
            }
            createArrow() {
                this._arrowUp = new Sprite();
                this._arrowUp.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_ARROW_UP_HOVER);
                this._arrowUp.anchor.set(0.5, 0);
                this._arrowUp.position.set(this.width / 2, 8);
                this.addChild(this._arrowUp);
                this._arrowDown = new Sprite();
                this._arrowDown.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_ARROW_DOWN_HOVER);
                this._arrowDown.anchor.set(0.5, 0);
                this._arrowDown.position.set(this.width / 2, this.height - 32);
                this.addChild(this._arrowDown);
            }
            createTargetArrow() {
                this._arrowTarget = new Sprite();
                this._arrowTarget.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_ARROW_RIGHT_HOVER);
                this._arrowTarget.anchor.set(0.5, 0.5);
                this.addChild(this._arrowTarget);
            }
            select(index) {
                super.select(index);
                this.cell().select(true);
                this._onSelectCallback?.();
                this._selected = true;
            }
            deselect() {
                this.deselectInternal(false);
            }
            deselectInternal(keepCheck) {
                super.deselect();
                if (keepCheck && this._keepSelectedOnDeactive && this.index >= 0) {
                }
                else {
                    this.cell().select(false);
                }
            }
            deactivate() {
                super.deactivate();
                this.deselectInternal(true);
            }
            onUpdateStep(step) {
                if (this._arrowUp) {
                    if (this.maxItems <= this.maxColumn * this.maxRow) {
                        this._arrowUp.visible = false;
                        this._arrowDown.visible = false;
                    }
                    else {
                        this._arrowUp.visible = true;
                        this._arrowDown.visible = true;
                        if (this.step <= 0) {
                            this._arrowUp.visible = false;
                        }
                        if (this.step >= this.limitStep) {
                            this._arrowDown.visible = false;
                        }
                    }
                }
            }
            updateMain() {
                super.updateMain();
                if (this._arrowTarget) {
                    if (this._selected) {
                        // select()のタイミングでは_targetStepが更新されていないので、
                        // updateMain()で行う
                        this._arrowTarget.y = this.nextBlockY(this.index) + this.blockHeight / 2;
                    }
                }
            }
            registerOnSelectCallback(callback) {
                this._onSelectCallback = callback;
            }
        }
        Life.SelectableGrid = SelectableGrid;
        class Sprite_Item extends Sprite {
            constructor() {
                super(ImageManager.loadSystem("IconSet"));
                this.set(0);
            }
            set(itemId) {
                let iconIndex = 0;
                const item = $dataItems[itemId];
                if (item) {
                    iconIndex = item.iconIndex;
                }
                const w = ImageManager.iconWidth;
                const h = ImageManager.iconHeight;
                this.setFrame((iconIndex % 16) * w, Math.floor(iconIndex / 16) * h, w, h);
            }
        }
        Life.Sprite_Item = Sprite_Item;
        Life.ItemIconWidth = 64;
        Life.ItemIconHeight = 64;
        class Sprite_ItemIcon extends Sprite {
            constructor() {
                const bitmap = new Bitmap(Life.ItemIconWidth, Life.ItemIconHeight);
                // bitmap.fillAll("orange");
                super(bitmap);
                this.createBg();
                this.createItem();
                this.createFocus();
                this.createText();
                this._fix = false;
            }
            get text() {
                return this._textSprite;
            }
            get fix() {
                return this._fix;
            }
            set fix(value) {
                this._fix = value;
                if (value) {
                    this._focusSprite.setColorTone([-68, -68, 0, 68]);
                }
                else {
                    this._focusSprite.setColorTone([0, 0, 0, 0]);
                }
            }
            createBg() {
                this._bgSprite = new Sprite();
                this._bgSprite.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_ITEMSLOT_FOCUS_BACK);
                this._bgSprite.hide();
                this._bgSprite.anchor.set(0.5, 0.5);
                this._bgSprite.relativeAnchor.enable = true;
                this._bgSprite.relativeAnchor.ratio = { x: 0.5, y: 0.5 };
                this.addChild(this._bgSprite);
            }
            createItem() {
                const sprite = new Sprite_Item();
                sprite.anchor.set(0.5, 0.5);
                sprite.relativeAnchor.enable = true;
                sprite.relativeAnchor.ratio = { x: 0.5, y: 0.5 };
                this.addChild(sprite);
                this._itemSprite = sprite;
            }
            createText() {
                const sprite = new Sprite_Text(64, 24);
                sprite.setFontSetting(Life.FONT_KEY_ITEM_SLOT_NUMBER);
                sprite.setAlign("right");
                sprite.anchor.set(1, 1);
                sprite.relativeAnchor.enable = true;
                sprite.relativeAnchor.ratio = { x: 1, y: 1 };
                sprite.relativeAnchor.offset.x = -4;
                sprite.relativeAnchor.offset.y = -4;
                this.addChild(sprite);
                this._textSprite = sprite;
            }
            createFocus() {
                this._focusSprite = new Sprite();
                this._focusSprite.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_ITEMSLOT_FOCUS);
                this._focusSprite.anchor.set(0.5, 0.5);
                this._focusSprite.relativeAnchor.enable = true;
                this._focusSprite.relativeAnchor.ratio = { x: 0.5, y: 0.5 };
                this._focusSprite.hide();
                this.addChild(this._focusSprite);
            }
            set(itemId) {
                this._itemSprite.set(itemId);
                const numItems = $gameParty.numItems($dataItems[itemId]);
                if (numItems > 0) {
                    this._textSprite.setText(`${numItems}`);
                }
                else {
                    this._textSprite.setText("");
                }
            }
            select(flg) {
                if (this._fix)
                    return;
                if (flg) {
                    this._bgSprite.show();
                    this._focusSprite.show();
                }
                else {
                    this._bgSprite.hide();
                    this._focusSprite.hide();
                }
            }
        }
        Life.Sprite_ItemIcon = Sprite_ItemIcon;
        class ItemSlotHeader extends Sprite {
            constructor() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT).getFrame(Life.FRAME_KEY_MENU_ITEMSLOT_ITEMNAME_BG);
                super(new Bitmap(frame.width, frame.height));
                this.create();
            }
            create() {
                this.createBg();
                this.createName();
            }
            createBg() {
                this._bg = new Sprite();
                this._bg.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_ITEMNAME_BG);
                this.addChild(this._bg);
            }
            createName() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT).getFrame(Life.FRAME_KEY_MENU_ITEMSLOT_ITEMNAME_BG);
                this._name = new Sprite_Text(frame.width, frame.height);
                this._name.setAlign("center");
                this._name.setFontSetting(Life.FONT_KEY_ITEM_SLOT_ITEM_NAME);
                this.addChild(this._name);
            }
            setText(text) {
                this._name.setText(text);
            }
        }
        Life.ItemSlotHeader = ItemSlotHeader;
        function createItemIconGrid(itemOption) {
            const option = {
                emptyCellCreator: () => new Iz.Life.Sprite_ItemIcon(),
                cellUpdater: itemOption.cellUpdator,
                maxItems: itemOption.col * itemOption.row,
                frameWidth: Life.ItemIconWidth,
                frameHeight: Life.ItemIconHeight,
                col: itemOption.col,
                row: itemOption.row,
                outofRangeCellNum: itemOption.outofRangeCellNum,
                spacing: itemOption.spacing,
            };
            return new SelectableGrid(option);
        }
        Life.createItemIconGrid = createItemIconGrid;
        class ItemSlotWindow extends Window_Base {
            constructor() {
                const rect = new Rectangle(0, 0, Life.ItemSlotGridWidth, Life.ItemSlotGridHeight + 36);
                super(rect);
                this.col = Life.ItemSlotCol;
                this._container.alpha = 0; // Window_Baseの枠は使わない
                this._lineIndex = 0;
                // this._contentsSprite.bitmap?.fillAll("red");
                this.createLineIndex();
                this.createItemName();
                this.createGridBg();
                this.createGrid();
                this.createCursor();
                const mapper = new Iz.GridKeyMapper();
                mapper.set({
                    ok: Iz.IO.KEY_NAME_OK,
                    cancel: Iz.IO.KEY_NAME_SUB_ACTION,
                    left: Iz.IO.KEY_NAME_SLOT_LEFT,
                    right: Iz.IO.KEY_NAME_SLOT_RIGHT,
                    up: Iz.IO.KEY_NAME_SLOT_UP,
                    down: Iz.IO.KEY_NAME_SLOT_DOWN,
                });
                this._grid.setGridKeyMapper(mapper);
                this._grid.locate(Iz.Life.ItemSlotTemp.Index, 0);
                this._grid.registerOnSelectCallback(() => {
                    Life.ItemSlot.handler.onSelect();
                });
                this.changeLine(Iz.Life.ItemSlotTemp.LineIndex);
            }
            get grid() {
                return this._grid;
            }
            get lineMax() {
                return Math.ceil(Life.ItemSlot.inventory.maxItems / this.col);
            }
            get index() {
                return this._grid.index;
            }
            get lineIndex() {
                return this._lineIndex;
            }
            get prevIndex() {
                return this._grid.prevIndex;
            }
            createLineIndex() {
                this._lineIndexSprite = new Sprite();
                this._lineIndexSprite.x = 20;
                this.addChild(this._lineIndexSprite);
            }
            createItemName() {
                this._itemHeader = new ItemSlotHeader();
                this._itemHeader.y = 4;
                this.addChild(this._itemHeader);
                this._itemHeaderDisplayCount = 0;
            }
            createGridBg() {
                const sprite = new Sprite();
                sprite.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_SLOT_BG);
                this._gridBg = sprite;
                this._gridBg.x = (this.width - Life.ItemSlotGridWidth) / 2;
                this._gridBg.y = this.height - Life.ItemSlotGridHeight;
                this.addChild(sprite);
            }
            createGrid() {
                const option = {
                    cellUpdator: this.onUpdateCell.bind(this),
                    col: this.col,
                    row: 1,
                    outofRangeCellNum: 0,
                };
                const grid = createItemIconGrid(option);
                grid.wrap = Iz.GridWrapMode.Loop;
                grid.verticalWrap = Iz.GridVerticalWrapMode.None;
                grid.wheelMove = true;
                grid.setHandler(Iz.GridEventType.CursorMoved, this.onCursorMoved.bind(this));
                grid.setHandler(Iz.GridEventType.CursorOutUp, this.onCursorOutUp.bind(this));
                grid.setHandler(Iz.GridEventType.CursorOutDown, this.onCursorOutDown.bind(this));
                grid.setHandler(Iz.GridEventType.Ok, this.onCursorPress.bind(this, false));
                grid.setHandler(Iz.GridEventType.Cancel, this.onCursorPress.bind(this, true));
                grid.setHandler(Iz.GridEventType.CursorLoopLeft, this.onCursorLoopLeft.bind(this));
                grid.setHandler(Iz.GridEventType.CursorLoopRight, this.onCursorLoopRight.bind(this));
                this._grid = grid;
                this._grid.x = (this.width - this._grid.width) / 2;
                this._grid.y = this.height - this._grid.height - 8;
                this.addChild(grid);
            }
            createCursor() {
                this._cursorLeft = new Life.InputSprite();
                this._cursorLeft.set([
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_CUR_Q },
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_PAD_LB },
                ]);
                this._cursorLeft.anchor.set(0.5, 0.5);
                this._cursorLeft.x = 60;
                this._cursorLeft.y = 72;
                this.addChild(this._cursorLeft);
                this._cursorRight = new Life.InputSprite();
                this._cursorRight.set([
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_KEYBOARD_CUR_E },
                    { atlasKey: Life.ATLAS_KEY_COMMON, frameKey: Life.FRAME_KEY_COMMON_PAD_RB },
                ]);
                this._cursorRight.anchor.set(0.5, 0.5);
                this._cursorRight.x = 758;
                this._cursorRight.y = 72;
                this.addChild(this._cursorRight);
            }
            update() {
                super.update();
                this.updateItemName();
                this.updateOpacity();
            }
            updateItemName() {
                if (this._itemHeaderDisplayCount > 0) {
                    this._itemHeaderDisplayCount--;
                }
                const itemId = Life.ItemSlot.itemId;
                if ($dataItems[itemId]) {
                    this._itemHeader.setText($dataItems[itemId].name);
                }
                else {
                    this._itemHeader.setText("");
                }
                this._itemHeader.visible = !!$dataItems[itemId] && this._itemHeaderDisplayCount > 0;
                const headerX = Math.min(Math.max(this.getHeaderX(this.index), this.getHeaderX(1)), this.getHeaderX(this.col - 1));
                this._itemHeader.x = headerX;
            }
            getHeaderX(index) {
                return 32 + index * Life.ItemIconWidth;
            }
            updateOpacity() {
                this.alpha = this.openness / 255;
                this._gridBg.alpha = this._lineIndexSprite.alpha = this.alpha * 0.85;
            }
            select(index) {
                this._grid.select(index);
            }
            selectLine(lineIndex) {
                this.changeLine(lineIndex);
            }
            refresh() {
                this._grid.refresh();
            }
            setKeepSelectedOnDeactive(flg) {
                this._grid.keepSelectedOnDeactive = flg;
            }
            isActive() {
                return this.active;
            }
            activate() {
                super.activate();
                this._grid.activate();
            }
            deactivate() {
                super.deactivate();
                this._grid.deactivate();
            }
            changeLine(lineIndex) {
                const prevLineIndex = this._lineIndex;
                if (lineIndex < 0) {
                    this._lineIndex = this.lineMax - 1;
                }
                else if (lineIndex >= this.lineMax) {
                    this._lineIndex = 0;
                }
                else {
                    this._lineIndex = lineIndex;
                }
                this._lineIndexSprite.setAtlas(Life.ATLAS_KEY_HUD, `slot_${this.lineIndex + 1}`);
                this.refresh();
                if (prevLineIndex !== this._lineIndex) {
                    Life.ItemSlot.handler.onChangeSlot(this._lineIndex);
                }
            }
            onCursorMoved() {
                this.updateItemHeaderDisplayCount();
            }
            onCursorOutUp() {
                const prev = this._lineIndex;
                this.changeLine(this._lineIndex - 1);
                if (prev !== this._lineIndex) {
                    this.playCursorSound();
                }
                this.updateItemHeaderDisplayCount();
            }
            onCursorOutDown() {
                const prev = this._lineIndex;
                this.changeLine(this._lineIndex + 1);
                if (prev !== this._lineIndex) {
                    this.playCursorSound();
                }
                this.updateItemHeaderDisplayCount();
            }
            onCursorPress(isSub) {
                // Cancelボタンをサブアクション扱いとする
                // const item = $dataItems[ItemSlot.itemId];
                // if (!item) return;
                // Iz.Life.ItemSlot.useItemSlot(item.id, isSub);
            }
            onCursorLoopLeft() {
                this.onCursorOutUp();
                this.updateItemHeaderDisplayCount();
            }
            onCursorLoopRight() {
                this.onCursorOutDown();
                this.updateItemHeaderDisplayCount();
            }
            onUpdateCell(cell, index) {
                const inventoryIndex = Life.ItemSlot.getInventoryIndex(index, this._lineIndex);
                const data = Life.ItemSlot.inventory.get(inventoryIndex);
                const itemId = data ? data.id : 0;
                cell.set(itemId);
            }
            updateInputSlotNumber() {
                for (let i = 1; i <= 10; i++) {
                    const key = `slot_num_${i}`;
                    if (Input.isTriggered(key)) {
                        const itemId = Life.ItemSlot.inventory.itemId(i - 1);
                        if (itemId > 0) {
                            this.select(i - 1);
                        }
                    }
                }
            }
            updateItemHeaderDisplayCount() {
                this._itemHeaderDisplayCount = 240;
            }
        }
        Life.ItemSlotWindow = ItemSlotWindow;
        class ItemSlotLineButton extends Sprite_Clickable {
            constructor() {
                const bitmap = new Bitmap(64, 36);
                // bitmap.fillAll("red");
                super();
                this.bitmap = bitmap;
            }
            onClick() {
                this._handler?.();
            }
            setHandler(handler) {
                this._handler = handler;
            }
        }
        Life.ItemSlotLineButton = ItemSlotLineButton;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// アイテムスロット（マップ）
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeItemSlot();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        const slots = {};
        Iz.Life.ItemSlot.inventories.forEach((data) => {
            slots[data.key] = { list: data.inventory.list };
        });
        contents.itemSlot = {
            active: Iz.Life.ItemSlot.active,
            visible: Iz.Life.ItemSlot.visible,
            inventories: slots,
            currentKey: Iz.Life.ItemSlot.inventoryKey,
            index: Iz.Life.ItemSlot.index,
            lineIndex: Iz.Life.ItemSlot.lineIndex,
        };
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        for (const entry of Object.entries(contents.itemSlot.inventories)) {
            const key = entry[0];
            Iz.Life.ItemSlot.applyInventory(key, entry[1]);
        }
        Iz.Life.ItemSlot.changeInventory(contents.itemSlot.currentKey);
        Iz.Life.ItemSlot.active = contents.itemSlot.active;
        Iz.Life.ItemSlot.visible = contents.itemSlot.visible;
        Iz.Life.ItemSlotTemp.Index = contents.itemSlot.index ?? 0;
        Iz.Life.ItemSlotTemp.LineIndex = contents.itemSlot.lineIndex ?? 0;
    };
    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function () {
        const win = new Iz.Life.ItemSlotWindow();
        const offsetY = -16;
        win.x = (Graphics.width - win.width) / 2;
        win.y = Graphics.height - win.height + offsetY;
        this._itemSlotWindow = win;
        if (Iz.Life.ItemSlot.active) {
            win.activate();
        }
        else {
            win.deactivate();
        }
        win.visible = Iz.Life.ItemSlot.visible;
        Iz.Life.ItemSlot.setAccessor(win);
        const button = new Iz.Life.ItemSlotLineButton();
        button.setHandler(() => {
            if (this._itemSlotWindow.isActive()) {
                const line = this._itemSlotWindow.lineIndex + 1;
                this._itemSlotWindow.changeLine(line);
            }
        });
        button.x = 24;
        button.y = 4;
        win.addChild(button);
        this.addWindow(win);
        _Scene_Map_createAllWindows.call(this);
    };
    const _Scene_Map_onTransferEnd = Scene_Map.prototype.onTransferEnd;
    Scene_Map.prototype.onTransferEnd = function () {
        _Scene_Map_onTransferEnd.call(this);
        this._itemSlotWindow.changeLine(Iz.Life.ItemSlotTemp.LineIndex);
    };
    // チラつき防止
    const _Scene_Map_start = Scene_Map.prototype.start;
    Scene_Map.prototype.start = function () {
        _Scene_Map_start.call(this);
        this._itemSlotWindow.update();
        this._itemSlotWindow.grid.updateMain();
    };
    const _Scene_Map_update = Scene_Map.prototype.update;
    Scene_Map.prototype.update = function () {
        _Scene_Map_update.call(this);
        const eventModeSelect = Iz.Life.ItemSlot.param.isEventMode(Iz.Life.ItemSlotMode.Select_InEvent);
        let enableSlotSelect = true;
        if (!this.isPlayerActive()) {
            enableSlotSelect = false;
        }
        else if ($gameMap.isEventRunning()) {
            if (!eventModeSelect) {
                enableSlotSelect = false;
            }
        }
        else if ($gamePlayer.getActionController().actionKey) {
            enableSlotSelect = false;
        }
        if (enableSlotSelect) {
            this._itemSlotWindow.grid.updateMain();
            this._itemSlotWindow.updateInputSlotNumber();
        }
        if (Iz.Life.ItemSlot.visible && !this._itemSlotWindow.visible) {
            this._itemSlotWindow.visible = true;
        }
        else if (!Iz.Life.ItemSlot.visible && this._itemSlotWindow.visible) {
            this._itemSlotWindow.visible = false;
        }
        if (Iz.Life.ItemSlot.active && !this._itemSlotWindow.isActive()) {
            this._itemSlotWindow.activate();
        }
        else if (!Iz.Life.ItemSlot.active && this._itemSlotWindow.isActive()) {
            this._itemSlotWindow.deactivate();
        }
        const eventVisible = Iz.Life.ItemSlot.param.isEventMode(Iz.Life.ItemSlotMode.Visible_InEvent);
        const eventProcessing = $gameMap._interpreter.isProcessing();
        const visible = eventProcessing ? eventVisible !== 0 : true;
        if (visible && this._itemSlotWindow.isClosed() && !$gameMessage.isBusy()) {
            this._itemSlotWindow.open();
        }
        else if ($gameMessage.isBusy() ||
            (!visible && !this._itemSlotWindow.isClosed() && !this._itemSlotWindow.isClosing())) {
            this._itemSlotWindow.close();
        }
    };
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        Iz.Life.ItemSlotTemp.Index = this._itemSlotWindow.index;
        Iz.Life.ItemSlotTemp.LineIndex = this._itemSlotWindow.lineIndex;
        Iz.Life.ItemSlot.setAccessor(undefined);
        _Scene_Map_terminate.call(this);
    };
    const _Game_Party_gainItem = Game_Party.prototype.gainItem;
    Game_Party.prototype.gainItem = function (item, amount, includeEquip) {
        const hasPrev = this.hasItem(item);
        _Game_Party_gainItem.call(this, item, amount, includeEquip);
        if (!DataManager.isItem(item))
            return;
        // アイテムが無くなっていたらスロットから削除
        if (!this.hasItem(item)) {
            const itemId = item.id;
            Iz.Life.ItemSlot.inventories.forEach((data) => {
                if (data.inventory.attr.sync) {
                    data.inventory.removeById(itemId);
                }
            });
        }
        else {
            // 新規アイテムは追加
            if (!hasPrev && Iz.Life.validItemType(item.id)) {
                Iz.Life.ItemSlot.inventory.add(item.id);
            }
        }
        if (Iz.Life.ItemSlot.inventory.attr.sync) {
            Iz.Life.ItemSlot.refresh();
        }
    };
})();
// 使用アクション
(function (Iz) {
    var Life;
    (function (Life) {
        class ItemUseGauge extends Sprite {
            constructor(target) {
                super();
                this.createBarBg();
                this.createBar();
                this.createBarFrame();
                const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_HUD);
                const frame = atlas.getFrame(Iz.Life.FRAME_KEY_HUD_GAUGE_OBJ_FRAME);
                this.setFrame(0, 0, frame.width, frame.height);
                this.z = 11;
                this._target = target;
                this._offsetX = -Math.floor(this.width / 2);
                this._offsetY = -80;
            }
            createBarBg() {
                const sprite = new Sprite();
                sprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_GAUGE_OBJ_HP);
                this.addChild(sprite);
            }
            createBar() {
                const sprite = new Sprite();
                sprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_BAR_OBJ_HP);
                sprite.x = 2;
                sprite.y = 4;
                this.addChild(sprite);
                this._bar = sprite;
            }
            createBarFrame() {
                const sprite = new Sprite();
                sprite.setAtlas(Iz.Life.ATLAS_KEY_HUD, Iz.Life.FRAME_KEY_HUD_GAUGE_OBJ_FRAME);
                this.addChild(sprite);
            }
            setValue(value_) {
                const frame = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_HUD).getFrame(Iz.Life.FRAME_KEY_HUD_BAR_OBJ_HP);
                const value = value_.clamp(0, 1);
                this._bar.setFrame(frame.x, frame.y, frame.width * value, frame.height);
            }
            update() {
                super.update();
                this.setValue($gameTemp.itemUseRate);
                this.visible = $gameTemp.itemUseRate > 0;
                this._bar.alpha = $gameTemp.itemUseRate;
                this.updatePosition();
            }
            updatePosition() {
                if (!this._target)
                    return;
                this.x = this._offsetX + this._target.x;
                this.y = this._offsetY + this._target.y;
            }
        }
        Life.ItemUseGauge = ItemUseGauge;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=ItemSlot.js.map