/*:
 * @target MZ
 * @plugindesc アイテム保持管理
 *
 * @help
 *
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.ItemOwnership = {
            Party: 1,
            Warehouse: 2,
        };
        const WarehouseName = "WAREHOUSE_WAREHOUSE";
        class PartyController {
            items() {
                return $gameParty.items().map((item) => item.id);
            }
            numItems(itemId) {
                return $gameParty.numItems($dataItems[itemId]);
            }
            gainItems(itemId, num) {
                $gameParty.gainItem($dataItems[itemId], num);
            }
            loseItems(itemId, num) {
                $gameParty.loseItem($dataItems[itemId], num, false);
            }
            numGroupItems(groupId) {
                return Life.getItemNumByGroup(groupId);
            }
            isFull(itemId) {
                const max = $gameParty.maxItems($dataItems[itemId]);
                return this.numItems(itemId) >= max;
            }
        }
        class WarehouseController {
            items() {
                return WarehouseUtil.getItemAll(WarehouseName).map((item) => item.id);
            }
            numItems(itemId) {
                const item = WarehouseUtil.getItem(WarehouseName, itemId);
                return item.num;
            }
            gainItems(itemId, num) {
                // deposit
                WarehouseUtil.depositItem(WarehouseName, itemId, num);
            }
            loseItems(itemId, num) {
                // withdraw
                WarehouseUtil.withdrawItem(WarehouseName, itemId, num);
            }
            numGroupItems(groupId) {
                let num = 0;
                WarehouseUtil.getItemAll(WarehouseName)
                    .filter((item) => Life.getItemGroups(item.id).find((group) => group === groupId))
                    .forEach((item) => {
                    num += item.num;
                });
                return num;
            }
            isFull(itemId) {
                const info = WarehouseUtil.getWarehouseInfo(WarehouseName);
                if (info.infinity)
                    return false;
                return info.currentCapacity >= info.maxCapactity;
            }
        }
        class Main {
            constructor() {
                this._controllers = new Map();
                this.initialize();
            }
            initialize() {
                this._controllers.set(Life.ItemOwnership.Party, new PartyController());
                this._controllers.set(Life.ItemOwnership.Warehouse, new WarehouseController());
            }
            items(owners) {
                const list = new Set();
                for (let i = 0; i < owners.length; i++) {
                    const controller = this._controllers.get(owners[i]);
                    if (!controller)
                        continue;
                    controller.items().forEach((item) => list.add(item));
                }
                return Array.from(list).sort();
            }
            numItems(itemId, owners) {
                let num = 0;
                owners.forEach((owner) => {
                    const controller = this._controllers.get(owner);
                    if (controller) {
                        num += controller.numItems(itemId);
                    }
                });
                return num;
            }
            gainItems(itemId, num, owners) {
                if (num < 0) {
                    this.loseItems(itemId, num, owners);
                    return;
                }
                let rest = num;
                for (let i = 0; i < owners.length; i++) {
                    const controller = this._controllers.get(owners[i]);
                    if (!controller) {
                        continue;
                    }
                    while (true) {
                        if (controller.isFull(itemId))
                            break;
                        if (rest <= 0)
                            break;
                        controller.gainItems(itemId, 1);
                        rest--;
                    }
                }
            }
            loseItems(itemId, num, owners) {
                let rest = num;
                for (let i = 0; i < owners.length; i++) {
                    const controller = this._controllers.get(owners[i]);
                    if (!controller) {
                        continue;
                    }
                    while (true) {
                        if (controller.numItems(itemId) <= 0)
                            break;
                        if (rest <= 0)
                            break;
                        controller.loseItems(itemId, 1);
                        rest--;
                    }
                }
            }
            numGroupItems(groupId, owners) {
                let num = 0;
                owners.forEach((owner) => {
                    const controller = this._controllers.get(owner);
                    if (controller) {
                        num += controller.numGroupItems(groupId);
                    }
                });
                return num;
            }
        }
        Life.ItemHolder = new Main();
        function initializeItemHolder() {
            Life.ItemHolder.initialize();
        }
        Life.initializeItemHolder = initializeItemHolder;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeItemHolder();
    };
})();
//# sourceMappingURL=Items.js.map