/*:
 * @target MZ
 * @plugindesc メニュー
 *
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        // export type MenuContent = WindowBase & IBackable;
        class MenuContentBase extends Iz.WindowBase {
        }
        Life.MenuContentBase = MenuContentBase;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// アイテムスロット登録画面
(function (Iz) {
    var Life;
    (function (Life) {
        const GridOffsetY = 106;
        const SpacingBottom = 42;
        const LineIndexSpriteWidth = 72;
        const LineIndexSpriteHeight = 36;
        function getGridStartX() {
            return 8;
        }
        function getGridStartY() {
            return -12;
        }
        class TraitElement extends Sprite {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.createText();
            }
            createText() {
                this._text = new Sprite_TextEx(512, 32);
                this._text.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_POPUP_ELEMENT);
                this.addChild(this._text);
            }
            set(traitId) {
                const data = $dataTrait.get(traitId);
                if (!data) {
                    this._text.setText("");
                    return;
                }
                const desc = Life.Status.getTraitDesc(traitId);
                this._text.setText(desc);
            }
        }
        const TraitElementRow = 5;
        const TraitElementCol = 2;
        class DetailPopup extends Iz.WindowBase {
            constructor() {
                super(new Rectangle(0, 0, 1, 1), new Iz.EasingOpenness(Iz.Easing.easeOutBack, Iz.Easing.easeInBack));
                this.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_WINDOW_ITEMDETAIL);
                const f = this._frame;
                this.setFrame(0, 0, f.width, f.height);
                this.create();
                this.anchor.set(0.5, 0.5);
            }
            create() {
                this.createItemName();
                this.createGroupTitle();
                this.createGroups();
                this.createTraitTitle();
                this.createElementRoot();
                this.createElements();
                this.createCloseButton();
                this.createCloseText();
            }
            createItemName() {
                this._itemName = new Sprite_Text(512, 32);
                this._itemName.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_POPUP_TITLE);
                this._itemName.anchor.set(0.5, 0.5);
                this._itemName.y = Math.floor(-this.height / 2 + 66);
                this._itemName.setAlign("center");
                this.addChild(this._itemName);
            }
            createGroupTitle() {
                this._groupTitle = new Sprite_Text(192, 32);
                this._groupTitle.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_POPUP_TITLE);
                this._groupTitle.anchor.set(0.5, 0.5);
                this._groupTitle.x = -280;
                this._groupTitle.y = -168;
                this._groupTitle.setText(Iz.Text.get("MENU_ITEMSLOT_POPUP_ITEMGROUP_TITLE"));
                this.addChild(this._groupTitle);
            }
            createGroups() {
                this._groups = [];
                for (let i = 0; i < Life.ItemGroupMax; i++) {
                    const e = new Sprite_Text(512, 32);
                    e.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_POPUP_ELEMENT);
                    e.anchor.set(0.5, 0.5);
                    e.x = -112;
                    e.y = -120 + i * 40;
                    this._groups.push(e);
                    this.addChild(e);
                }
            }
            createTraitTitle() {
                this._traitTitle = new Sprite_Text(192, 32);
                this._traitTitle.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_POPUP_TITLE);
                this._traitTitle.anchor.set(0.5, 0.5);
                this._traitTitle.x = -280;
                this._traitTitle.y = 12;
                this._traitTitle.setText(Iz.Text.get("MENU_ITEMSLOT_POPUP_TRAIT_TITLE"));
                this.addChild(this._traitTitle);
            }
            createElementRoot() {
                this._elementRoot = new Sprite();
                this._elementRoot.x = -Math.floor(this.width / 2) + 98;
                this._elementRoot.y = 38;
                this.addChild(this._elementRoot);
            }
            createElements() {
                this._elements = [];
                for (let x = 0; x < TraitElementCol; x++) {
                    for (let y = 0; y < TraitElementRow; y++) {
                        const e = new TraitElement();
                        e.x = x * 384;
                        e.y = y * 39;
                        this._elements.push(e);
                        this._elementRoot.addChild(e);
                    }
                }
            }
            createCloseButton() {
                const sprite = new Life.AtlasImageSprite();
                sprite.set("cancel");
                sprite.x = 282;
                sprite.y = 242;
                this.addChild(sprite);
            }
            createCloseText() {
                const text = new Sprite_TextEx(160, 32);
                text.setFontSetting(Life.FONT_KEY_MENU_QUEST_POPUP_CLOSE);
                text.setText(Iz.Text.get("MENU_QUEST_POPUP_CLOSE"));
                text.relativeAnchor.enable = true;
                text.relativeAnchor.ratio.x = 1;
                text.relativeAnchor.ratio.y = 1;
                text.relativeAnchor.offset.x = -122;
                text.relativeAnchor.offset.y = -44;
                text.setTextAlign(0.5, 0.5);
                this.addChild(text);
            }
            refresh(itemId) {
                this._itemName.setText($dataItems[itemId]?.name ?? "");
                const groups = Life.getItemGroups(itemId);
                for (let i = 0; i < this._groups.length; i++) {
                    const group = groups[i];
                    const groupName = group ? Life.getItemGroupName(group) : "";
                    this._groups[i].setText(groupName);
                }
                const effect = Life.Status.getItemEffect(itemId);
                const traits = effect ? effect.traits.map((t) => t.traitId) : [];
                for (let i = 0; i < this._elements.length; i++) {
                    const t = traits[i];
                    if (!t) {
                        this._elements[i].set(0);
                    }
                    else {
                        this._elements[i].set(t);
                    }
                }
            }
        }
        class GridWindow extends Iz.WindowBase {
            constructor(index) {
                super(new Rectangle(0, 0, Iz.Life.ItemSlotGridWidth, Iz.Life.ItemSlotGridHeight + LineIndexSpriteHeight));
                this.createBgSprite();
                this._lineIndex = index;
                // this.bitmap?.fillAll("red");
            }
            createBgSprite() {
                this._bgSprite = new Sprite();
                this._bgSprite.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_SLOT_BG);
                this._bgSprite.y = LineIndexSpriteHeight;
                this.addChild(this._bgSprite);
            }
        }
        class DetailWindow extends Iz.WindowBase {
            constructor(rect) {
                super(rect);
                this.createBg(rect);
                this.createItemTitle();
                this.createItemDesc(rect);
                this.createPrice();
            }
            createBg(rect) {
                this._bg = new Sprite();
                this._bg.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_WINDOW_ITEMDESC);
                this.addChild(this._bg);
            }
            createItemTitle() {
                this._itemTitle = new Sprite_TextEx(352, 64);
                this._itemTitle.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_ITEM_DETAIL_TITLE);
                this._itemTitle.setText("");
                this._itemTitle.x = 32;
                this._itemTitle.y = 32;
                this.addChild(this._itemTitle);
            }
            createItemDesc(rect) {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT).getFrame(Life.FRAME_KEY_MENU_ITEMSLOT_WINDOW_ITEMDESC);
                const paddginX = 32;
                this._itemDesc = new Sprite_TextEx(frame.width - paddginX * 2, 128);
                this._itemDesc.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_ITEM_DETAIL_DESC);
                this._itemDesc.x = paddginX;
                this._itemDesc.y = 68;
                this.addChild(this._itemDesc);
            }
            createPrice() {
                this._price = new Sprite_TextEx(400, 32);
                this._price.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_ITEM_DETAIL_PRICE);
                this._price.x = 448;
                this._price.y = 30;
                this.addChild(this._price);
            }
            setItem(itemId) {
                const item = $dataItems[itemId];
                if (item) {
                    this._itemTitle.setText(item.name);
                    const desc = this.getItemDesc(itemId);
                    this._itemDesc.setText(desc);
                    this._price.setText(Iz.String.format(Iz.Text.get("MENU_ITEMSLOT_DETAIL_PRICE"), item.price));
                }
                else {
                    this._itemTitle.setText("");
                    this._itemDesc.setText("");
                    this._price.setText("");
                }
            }
            getItemDesc(itemId) {
                return Life.getItemDescription(itemId, false);
            }
        }
        const ElementHeight = 48;
        class ItemListElement extends Sprite {
            constructor(w, h) {
                super(new Bitmap(w, h));
                this.createBg();
                this.createIcon();
                this.createText(w - this._icon.width, h);
                this.createNumText(h);
                this._fix = false;
            }
            get fix() {
                return this._fix;
            }
            set fix(value) {
                this._fix = value;
                if (value) {
                    this._bgSprite.setColorTone([-68, -68, 0, 68]);
                }
                else {
                    this._bgSprite.setColorTone([0, 0, 0, 0]);
                }
            }
            createBg() {
                this._bgSprite = new Sprite();
                this._bgSprite.setAtlas(Life.ATLAS_KEY_MENU_ITEMSLOT, Life.FRAME_KEY_MENU_ITEMSLOT_ITEMLIST_FOCUS);
                this._bgSprite.hide();
                this._bgSprite.anchor.set(0.5, 0.5);
                this._bgSprite.relativeAnchor.enable = true;
                this._bgSprite.relativeAnchor.ratio = { x: 0.5, y: 0.5 };
                this.addChild(this._bgSprite);
            }
            createIcon() {
                this._icon = new Iz.Life.Sprite_Item();
                this._icon.anchor.set(0, 0.5);
                this._icon.x = 16;
                this._icon.y = 24;
                this.addChild(this._icon);
            }
            createText(w, h) {
                this._text = new Sprite_Text(w, h);
                this._text.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_ITEM_LIST);
                this._text.x = 60;
                this.addChild(this._text);
            }
            createNumText(height) {
                this._numText = new Sprite_Text(96, height);
                this._numText.setFontSetting(Life.FONT_KEY_MENU_ITEM_SLOT_ITEM_LIST);
                this._numText.setAlign("right");
                this._numText.x = 250;
                this.addChild(this._numText);
            }
            setItem(itemId) {
                this._icon.set(itemId);
                const item = $dataItems[itemId];
                if (item) {
                    this._text.setText(item.name, true);
                    this._numText.setText(`${$gameParty.numItems(item)}`, true);
                }
                else {
                    this._text.setText("", true);
                    this._numText.setText("", true);
                }
            }
            select(flg) {
                if (this._fix)
                    return;
                if (flg) {
                    this._bgSprite.show();
                }
                else {
                    this._bgSprite.hide();
                }
            }
        }
        const ItemKind = {
            All: 0,
        };
        const ItemKindMax = 4;
        class ItemListWindow extends Iz.WindowBase {
            constructor(rect) {
                super(rect);
                this.createBg(rect.width, rect.height);
                this.createGrid(rect.width, rect.height);
                this._itemKind = ItemKind.All;
                this.refresh(true);
                this.update(); // チラつき防止
            }
            get itemId() {
                return this.getItemId(this._grid.index);
            }
            get grid() {
                return this._grid;
            }
            createBg(width, height) {
                this._bg = Iz.Life.createMenuItemSlotBg();
                this._bg.setSize(width, height);
                this.addChild(this._bg);
            }
            createGrid(width, height) {
                const elementWidth = width;
                const elementHeight = ElementHeight;
                const option = {
                    emptyCellCreator: () => new ItemListElement(elementWidth, elementHeight),
                    cellUpdater: this.onUpdateCell.bind(this),
                    frameWidth: elementWidth,
                    frameHeight: elementHeight,
                    maxItems: 20,
                    col: 1,
                    row: 12,
                };
                const selectableOption = {
                    arrow: true,
                };
                this._grid = new Iz.Life.SelectableGrid(option, selectableOption);
                this._grid.position.set(0, -10);
                this._grid.refresh();
                this.addChild(this._grid);
            }
            onUpdateCell(cell, index) {
                cell.setItem(this.getItemId(index));
            }
            getItemId(index) {
                const itmes = this.items();
                return itmes[index] ? itmes[index].id : 0;
            }
            // protected onUpdate() {
            //     this._grid.updateMain();
            // }
            refresh(deselect) {
                // this._grid.deselect();
                // this._grid.maxItems = this.items().length;
                this._grid.adjustPosition(this.items().length);
                if (deselect) {
                    this._grid.deselect();
                }
            }
            items() {
                const items = Life.registrableItems();
                switch (this._itemKind) {
                    case ItemKind.All:
                        return items;
                    default:
                        return [];
                }
            }
            activate() {
                super.activate();
                this._grid.activate();
            }
            deactivate() {
                super.deactivate();
                this._grid.deactivate();
            }
        }
        Life.SubMenutype = {
            Detail: 0, // 詳細
            Dispose: 1, // 捨てる
            Cancel: 2,
            Sell: 5, // 売却
            EditName: 6, // 名前変更
        };
        // const SubMenuTypeMax = 3;
        const SwitchKey_Grids = "grids";
        const SwitchKey_ItemList = "item_list";
        const SwitchKey_ItemSubMenu = "item_submenu";
        const SwitchKey_ItemListSubMenu = "itemlist_submenu";
        const SwitchKey_DetailPopup = "detailpopup";
        const SequenceKey_Slot = "sequence_slot";
        const SequenceKey_SlotChange = "sequence_slotchange";
        const SequenceKey_ItemList = "sequence_itemlist";
        const SequenceKey_ItemListChange = "sequence_itemlistchange";
        const SequenceKey_SubMenu = "sequence_submenu";
        const SequenceKey_ItemListSubMenu = "sequence_itemlist_submenu";
        const SequenceKey_DetailPopup = "sequence_detailpopup";
        class SubMenuWindow extends Sprite {
            constructor() {
                super();
                this.setList();
            }
            get grid() {
                return this._window.grid;
            }
            get subMenuType() {
                return this._list[this.grid.index];
            }
            createGrid(list) {
                const frameWidth = 160;
                const frameHeight = 40;
                const option = {
                    emptyCellCreator: () => {
                        return new Iz.Life.CommonGridElement(frameWidth, frameHeight);
                    },
                    cellUpdater: (cell, index) => {
                        const type = list[index];
                        if (type === Life.SubMenutype.Detail) {
                            cell.set(Iz.Text.get("MENU_ITEMSLOT_SUBMENU_DETAIL"));
                        }
                        else if (type === Life.SubMenutype.Dispose) {
                            cell.set(Iz.Text.get("MENU_ITEMSLOT_SUBMENU_DISPOSE"));
                        }
                        else if (type === Life.SubMenutype.Cancel) {
                            cell.set(Iz.Text.get("MENU_ITEMSLOT_SUBMENU_CANCEL"));
                        }
                        else if (type === Life.SubMenutype.Sell) {
                            cell.set(Iz.Text.get("MENU_SHED_SUBMENU_SELL"));
                        }
                        else if (type === Life.SubMenutype.EditName) {
                            cell.set(Iz.Text.get("MENU_SHED_SUBMENU_NAME_EDIT"));
                        }
                        else {
                            cell.set("");
                        }
                    },
                    maxItems: list.length,
                    frameWidth: frameWidth,
                    frameHeight: frameHeight,
                    col: 1,
                    row: list.length,
                };
                this._window = Iz.Life.createCommonGridWindow(option);
                this.grid.setHandler(Iz.GridEventType.Ok, () => {
                    if (list[this.grid.index] === Life.SubMenutype.Cancel) {
                        SoundManager.playCancel();
                    }
                    else {
                        SoundManager.playOk();
                    }
                });
                this.grid.setHandler(Iz.GridEventType.Cancel, () => {
                    SoundManager.playCancel();
                });
                this.grid.updateMain();
                this.addChild(this._window);
            }
            setList(...list) {
                if (this._window) {
                    this.removeChild(this._window);
                }
                this.createGrid([...list]);
                this._list = [...list];
            }
            activate() {
                this._window.activate();
            }
            deactivate() {
                this._window.deactivate();
            }
            isActive() {
                return this._window.isActive();
            }
        }
        Life.SubMenuWindow = SubMenuWindow;
        class SlotSequence {
            constructor(grid, switcher, itemList) {
                this._grid = grid;
                this._switcher = switcher;
                this._itemList = itemList;
            }
            onStart(arg) {
                this.updateWrap();
                this._switcher.on(SwitchKey_Grids);
                this._grid.setHandler(Iz.GridEventType.CursorOutLeft, this.onOutGrid.bind(this));
                this._grid.setHandler(Iz.GridEventType.CursorOutRight, this.onOutGrid.bind(this));
                this._state = 0;
            }
            onUpdate() {
                if (Input.isTriggered(Iz.IO.KEY_NAME_SHIFT)) {
                    Iz.Life.ItemSlot.inventory.remove(this._grid.index);
                    this._grid.refresh();
                    this._itemList.refresh(true);
                    this.updateWrap();
                }
                else if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                    this._state = 2;
                }
                else if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_SUBMENU)) {
                    if (Life.ItemSlot.inventory.get(this._grid.index)) {
                        this._state = 3;
                    }
                }
                return this._state !== 0;
            }
            onFinish() {
                this._grid.clearHandler();
            }
            onOutGrid() {
                this._state = 1;
            }
            getResult() {
                let nextSequence = "";
                switch (this._state) {
                    case 1:
                        nextSequence = SequenceKey_ItemList;
                        break;
                    case 2:
                        nextSequence = SequenceKey_SlotChange;
                        break;
                    case 3:
                        nextSequence = SequenceKey_SubMenu;
                        break;
                    default:
                        nextSequence = SequenceKey_Slot;
                }
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: nextSequence,
                    output: {},
                };
            }
            updateWrap() {
                if (this._itemList.items().length <= 0) {
                    this._grid.wrap = Iz.GridWrapMode.Loop;
                }
                else {
                    this._grid.wrap = Iz.GridWrapMode.None;
                }
            }
        }
        class SlotChangeSequence {
            constructor(grid, switcher, itemList) {
                this._grid = grid;
                this._switcher = switcher;
                this._itemList = itemList;
            }
            get isActiveItemList() {
                return this._itemList.isActive();
            }
            onStart(arg) {
                if (this._itemList.items().length <= 0) {
                    this._grid.wrap = Iz.GridWrapMode.Loop;
                }
                else {
                    this._grid.wrap = Iz.GridWrapMode.None;
                }
                this._switcher.on(SwitchKey_Grids);
                this._grid.setHandler(Iz.GridEventType.CursorOutLeft, this.onOutGrid.bind(this));
                this._grid.setHandler(Iz.GridEventType.CursorOutRight, this.onOutGrid.bind(this));
                this._itemList.grid.setHandler(Iz.GridEventType.CursorOutLeft, this.onOutGridItemListLeft.bind(this));
                this._itemList.grid.setHandler(Iz.GridEventType.CursorOutRight, this.onOutGridItemListRight.bind(this));
                this._grid.cellStates[this._grid.index].selectable = false;
                this._grid.cell().fix = true;
            }
            onUpdate() {
                if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                    if (this.isActiveItemList) {
                        const srcIndex = this._grid.cellStates.findIndex((cell) => !cell.selectable);
                        if (srcIndex >= 0) {
                            Iz.Life.ItemSlot.operator.setItem(srcIndex, this._itemList.itemId);
                        }
                    }
                    else {
                        const srcIndex = this._grid.cellStates.findIndex((cell) => !cell.selectable);
                        if (srcIndex !== this._grid.index) {
                            const srcItemId = Life.ItemSlot.inventory.itemId(srcIndex);
                            const dstItemId = Life.ItemSlot.inventory.itemId(this._grid.index);
                            Life.ItemSlot.inventory.set(srcIndex, dstItemId);
                            Life.ItemSlot.inventory.set(this._grid.index, srcItemId);
                        }
                    }
                    return true;
                }
                if (Input.isTriggered(Iz.IO.KEY_NAME_CANCEL)) {
                    return true;
                }
                return false;
            }
            onFinish() {
                this._grid.clearHandler();
                this._itemList.grid.clearHandler();
                const srcIndex = this._grid.cellStates.findIndex((cell) => !cell.selectable);
                this._grid.cell(srcIndex).fix = false;
                this._grid.cellStates.forEach((cell) => {
                    cell.selectable = true;
                });
                this._grid.refresh();
                if (this.isActiveItemList) {
                    this._grid.select(srcIndex);
                    this._itemList.refresh(true);
                }
                else {
                    this._grid.cell(srcIndex).select(false);
                }
            }
            onOutGrid() {
                this._switcher.on(SwitchKey_ItemList);
            }
            onOutGridItemListLeft() {
                this._switcher.on(SwitchKey_Grids);
                const index = this._grid.row() * this._grid.maxColumn - 1;
                this._grid.select(index);
            }
            onOutGridItemListRight() {
                this._switcher.on(SwitchKey_Grids);
                const index = (this._grid.row() - 1) * this._grid.maxColumn;
                this._grid.select(index);
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: SequenceKey_Slot,
                    output: {},
                };
            }
        }
        class ItemListSequence {
            constructor(grid, switcher, itemList) {
                this._grid = grid;
                this._switcher = switcher;
                this._itemList = itemList;
            }
            onStart(arg) {
                this._switcher.on(SwitchKey_ItemList);
                this._itemList.grid.wrap = Iz.GridWrapMode.None;
                this._itemList.grid.setHandler(Iz.GridEventType.CursorOutLeft, this.onOutGridItemListLeft.bind(this));
                this._itemList.grid.setHandler(Iz.GridEventType.CursorOutRight, this.onOutGridItemListRight.bind(this));
                this._state = 0;
            }
            onUpdate() {
                if (Life.registrableItems().length <= 0) {
                    this._state = 1;
                }
                else {
                    if (Input.isTriggered(Iz.IO.KEY_NAME_SHIFT)) {
                        if (this._itemList.itemId > 0) {
                            Iz.Life.ItemSlot.operator.addItem(this._itemList.itemId);
                            this._grid.refresh();
                            this._itemList.refresh(false);
                        }
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                        this._state = 2;
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_SUBMENU)) {
                        if (this._itemList.itemId > 0) {
                            this._state = 3;
                        }
                    }
                }
                return this._state !== 0;
            }
            onFinish() {
                this._itemList.grid.clearHandler();
            }
            getResult() {
                let nextSequence = "";
                switch (this._state) {
                    case 1:
                        nextSequence = SequenceKey_Slot;
                        break;
                    case 2:
                        nextSequence = SequenceKey_ItemListChange;
                        break;
                    case 3:
                        nextSequence = SequenceKey_ItemListSubMenu;
                        break;
                }
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: nextSequence,
                    output: {},
                };
            }
            onOutGridItemListLeft() {
                const index = this._grid.row() * this._grid.maxColumn - 1;
                this._grid.select(index);
                this._state = 1;
            }
            onOutGridItemListRight() {
                const index = (this._grid.row() - 1) * this._grid.maxColumn;
                this._grid.select(index);
                this._state = 1;
            }
        }
        class ItemListChangeSequence {
            constructor(grid, switcher, itemList) {
                this._grid = grid;
                this._switcher = switcher;
                this._itemList = itemList;
            }
            get isActiveGrid() {
                return this._grid.isActive();
            }
            onStart(arg) {
                this._grid.wrap = Iz.GridWrapMode.None;
                this._switcher.on(SwitchKey_ItemList);
                this._grid.setHandler(Iz.GridEventType.CursorOutLeft, this.onOutGrid.bind(this));
                this._grid.setHandler(Iz.GridEventType.CursorOutRight, this.onOutGrid.bind(this));
                this._itemList.grid.setHandler(Iz.GridEventType.CursorOutLeft, this.onOutGridItemListLeft.bind(this));
                this._itemList.grid.setHandler(Iz.GridEventType.CursorOutRight, this.onOutGridItemListRight.bind(this));
                this._itemList.grid.cellStates[this._itemList.grid.index].selectable = false;
                this._itemList.grid.cell().fix = true;
            }
            onUpdate() {
                if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                    if (this.isActiveGrid) {
                        Iz.Life.ItemSlot.operator.setItem(this._grid.index, this._itemList.itemId);
                    }
                    return true;
                }
                if (Input.isTriggered(Iz.IO.KEY_NAME_CANCEL)) {
                    return true;
                }
                return false;
            }
            onFinish() {
                this._grid.clearHandler();
                this._itemList.grid.clearHandler();
                const srcIndex = this._itemList.grid.cellStates.findIndex((cell) => !cell.selectable);
                this._itemList.grid.cell(srcIndex).fix = false;
                this._itemList.grid.cell(srcIndex).select(false);
                this._itemList.grid.cellStates.forEach((cell) => {
                    cell.selectable = true;
                });
                this._itemList.grid.refresh();
                if (this.isActiveGrid) {
                    this._grid.refresh();
                    this._itemList.grid.select(srcIndex);
                    this._itemList.refresh(false);
                }
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this._itemList.items().length <= 0 ? SequenceKey_Slot : SequenceKey_ItemList,
                    output: {},
                };
            }
            onOutGrid() {
                this._switcher.on(SwitchKey_ItemList);
            }
            onOutGridItemListLeft() {
                this._switcher.on(SwitchKey_Grids);
                const index = this._grid.row() * this._grid.maxColumn - 1;
                this._grid.select(index);
            }
            onOutGridItemListRight() {
                this._switcher.on(SwitchKey_Grids);
                const index = (this._grid.row() - 1) * this._grid.maxColumn;
                this._grid.select(index);
            }
        }
        class SubMenuSequence {
            constructor(grid, switcher, itemList, submenu) {
                this._grid = grid;
                this._switcher = switcher;
                this._itemList = itemList;
                this._subMenu = submenu;
                this._state = -1;
                this._onOkHandler = this.onOk.bind(this);
                this._onCancelHandler = this.onCancel.bind(this);
            }
            get item() {
                return Life.ItemSlot.inventory.get(this._grid.index);
            }
            get itemId() {
                return this.item?.id ?? 0;
            }
            onStart(arg) {
                this._grid.cell().fix = true;
                if (this.itemId) {
                    if (!Life.isDisposableItem(this.itemId)) {
                        this._subMenu.setList(Life.SubMenutype.Detail, Life.SubMenutype.Cancel);
                    }
                    else {
                        this._subMenu.setList(Life.SubMenutype.Detail, Life.SubMenutype.Dispose, Life.SubMenutype.Cancel);
                    }
                }
                this._switcher.on(SwitchKey_ItemSubMenu);
                this._subMenu.grid.setHandler(Iz.GridEventType.Ok, this._onOkHandler);
                this._subMenu.grid.setHandler(Iz.GridEventType.Cancel, this._onCancelHandler);
                this._subMenu.visible = true;
                this._subMenu.grid.select(Life.SubMenutype.Detail);
                const colIndex = this._grid.index % Life.ItemSlotCol;
                const rowIndex = Math.floor(this._grid.index / Life.ItemSlotCol);
                this._subMenu.x = this._grid.x + (colIndex + 1) * this._grid.blockWidth;
                this._subMenu.y = this._grid.y + rowIndex * this._grid.blockHeight;
                this._state = -1;
            }
            onUpdate() {
                return this._state !== -1;
            }
            onFinish() {
                this._subMenu.visible = false;
                this._subMenu.grid.removeHandler(Iz.GridEventType.Ok, this._onOkHandler);
                this._subMenu.grid.removeHandler(Iz.GridEventType.Cancel, this._onCancelHandler);
                this._grid.cell().fix = false;
                this._grid.refresh();
            }
            getResult() {
                const arg = {
                    param: {
                        itemId: this.itemId,
                    },
                };
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this._state === Life.SubMenutype.Detail ? SequenceKey_DetailPopup : SequenceKey_Slot,
                    output: this._state === Life.SubMenutype.Detail ? arg : {},
                };
            }
            onOk() {
                this._onOkAsync();
            }
            async _onOkAsync() {
                if (this._subMenu.subMenuType === Life.SubMenutype.Dispose) {
                    const option = Life.createDialogOption("menu_item_dispose");
                    if (!option)
                        return false;
                    option.text = Iz.String.format(option.text, $dataItems[this.itemId]?.name ?? "");
                    this._subMenu.deactivate();
                    const res = await Life.Dialog.openAsync(option);
                    if (res) {
                        const item = this.item;
                        if (item && Life.isNormalItem(item.id)) {
                            const data = $dataItems[item.id];
                            $gameParty.loseItem(data, $gameParty.numItems(data), false);
                            Life.ItemSlot.inventory.removeById(item.id);
                        }
                    }
                }
                this._state = this._subMenu.subMenuType;
            }
            onCancel() {
                this._state = Life.SubMenutype.Cancel;
            }
        }
        const PrevItemListSubMenu = "prevItemListSubMenu";
        class ItemListSubMenuSequence {
            constructor(grid, switcher, itemList, submenu) {
                this._grid = grid;
                this._switcher = switcher;
                this._itemList = itemList;
                this._subMenu = submenu;
                this._state = -1;
                this._onOkHandler = this.onOk.bind(this);
                this._onCancelHandler = this.onCancel.bind(this);
            }
            get itemId() {
                return this._itemList.itemId;
            }
            onStart(arg) {
                this._itemList.grid.cell().fix = true;
                if (this.itemId) {
                    if (!Life.isDisposableItem(this.itemId)) {
                        this._subMenu.setList(Life.SubMenutype.Detail, Life.SubMenutype.Cancel);
                    }
                    else {
                        this._subMenu.setList(Life.SubMenutype.Detail, Life.SubMenutype.Dispose, Life.SubMenutype.Cancel);
                    }
                }
                this._switcher.on(SwitchKey_ItemSubMenu);
                this._subMenu.grid.setHandler(Iz.GridEventType.Ok, this._onOkHandler);
                this._subMenu.grid.setHandler(Iz.GridEventType.Cancel, this._onCancelHandler);
                this._subMenu.visible = true;
                this._subMenu.grid.select(Life.SubMenutype.Detail);
                let stepOffset = this._itemList.grid.getStepOffset(this._itemList.grid.index);
                if (stepOffset < 7) {
                    stepOffset += 1.5;
                }
                else {
                    stepOffset -= 2;
                }
                this._subMenu.x = this._itemList.x;
                this._subMenu.y = this._itemList.y + stepOffset * this._itemList.grid.blockHeight;
                this._state = -1;
            }
            onUpdate() {
                return this._state !== -1;
            }
            onFinish() {
                this._subMenu.visible = false;
                this._subMenu.grid.removeHandler(Iz.GridEventType.Ok, this._onOkHandler);
                this._subMenu.grid.removeHandler(Iz.GridEventType.Cancel, this._onCancelHandler);
                this._itemList.grid.cell().fix = false;
                this._itemList.refresh(false);
            }
            getResult() {
                const arg = {
                    param: {
                        itemId: this.itemId,
                        prev: PrevItemListSubMenu,
                    },
                };
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this._state === Life.SubMenutype.Detail
                        ? SequenceKey_DetailPopup
                        : SequenceKey_ItemList,
                    output: this._state === Life.SubMenutype.Detail ? arg : {},
                };
            }
            onOk() {
                this._onOkAsync();
            }
            async _onOkAsync() {
                if (this._subMenu.subMenuType === Life.SubMenutype.Dispose) {
                    const option = Life.createDialogOption("menu_item_dispose");
                    if (!option)
                        return false;
                    option.text = Iz.String.format(option.text, $dataItems[this.itemId]?.name ?? "");
                    this._subMenu.deactivate();
                    const res = await Life.Dialog.openAsync(option);
                    if (res) {
                        const itemId = this._itemList.itemId;
                        if (itemId && Life.isNormalItem(itemId)) {
                            const data = $dataItems[itemId];
                            $gameParty.loseItem(data, $gameParty.numItems(data), false);
                        }
                    }
                }
                this._state = this._subMenu.subMenuType;
            }
            onCancel() {
                this._state = Life.SubMenutype.Cancel;
            }
        }
        const PopupEasingTime = 10;
        class ItemDetailPopupSequence {
            constructor(popup, popupBg, switcher) {
                this._popup = popup;
                this._popupBg = popupBg;
                this._switcher = switcher;
                this._prevItemList = false;
            }
            updateAlpha() {
                this._popupBg.alpha = Iz.Easing.easeOutQuint.value(this._frame / PopupEasingTime);
            }
            onStart(arg) {
                this._switcher.on(SwitchKey_DetailPopup);
                this._popup.visible = true;
                this._popup.open(true);
                this._popup.refresh(arg.param.itemId ?? 0);
                this._frame = 0;
                this._popupBg.visible = true;
                this.updateAlpha();
                this._prevItemList = arg.param.prev === PrevItemListSubMenu;
            }
            onUpdate() {
                this._frame++;
                if (this._frame >= PopupEasingTime) {
                    this._frame = PopupEasingTime;
                }
                this.updateAlpha();
                const triggered = Input.isCancelled();
                if (triggered) {
                    SoundManager.playCancel();
                }
                return triggered;
            }
            onFinish() {
                this._popup.close();
                this._popup.visible = false;
                this._popupBg.visible = false;
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: this._prevItemList ? SequenceKey_ItemList : SequenceKey_Slot,
                    output: {},
                };
            }
        }
        class ContentItemSlot extends Life.MenuContentBase {
            constructor(w, h) {
                super(new Rectangle(0, 0, w, h));
                // this.bitmap?.fillAll("yellow");
                this._root = this;
                this.create();
            }
            create() {
                this.createGridWindows();
                this.createGrid();
                this.createItemHeader();
                this.createDetail();
                this.createItemList();
                this.createSubMenu();
                this.createPopupBg();
                this.createDetailPopup();
                this.setupSwitcher();
                this.setupSequence();
                this._selectedItem = 0;
            }
            createGridWindows() {
                this._gridWindows = [];
                const slotNum = Life.getItemSlotRows(Life.ItemSlot.inventory.limit);
                const unlockedNum = Life.getItemSlotRows(Life.ItemSlot.inventory.maxItems);
                for (let i = 0; i < slotNum; i++) {
                    this._gridWindows[i] = new GridWindow(i);
                    this._gridWindows[i].position.set(getGridStartX(), getGridStartY() + GridOffsetY * i);
                    this._root.addChild(this._gridWindows[i]);
                    if (i >= unlockedNum) {
                        this._gridWindows[i].setColorTone([-68, -68, -68, 0]);
                    }
                }
            }
            createGrid() {
                const slotNum = Life.getItemSlotRows(Life.ItemSlot.inventory.maxItems);
                const option = {
                    cellUpdator: this.onUpdateIcon.bind(this),
                    col: Iz.Life.ItemSlotCol,
                    row: slotNum,
                    outofRangeCellNum: 0,
                    spacing: { left: 0, right: 0, top: 0, bottom: SpacingBottom },
                };
                this._grid = Iz.Life.createItemIconGrid(option);
                this._grid.bitmap?.fillAll("blue");
                this._grid.position.set(this._gridWindows[0].x + (this._gridWindows[0].width - this._grid.width) / 2, this._gridWindows[0].y +
                    LineIndexSpriteHeight +
                    (Iz.Life.ItemSlotGridHeight - this._grid.frameSize.height) / 2);
                this._grid.wrap = Iz.GridWrapMode.Loop;
                const inventoryIndex = Life.ItemSlot.inventoryIndex;
                if (inventoryIndex >= 0 && inventoryIndex < Life.ItemSlot.inventory.maxItems) {
                    this._grid.select(inventoryIndex);
                }
                this._grid.refresh();
                this._root.addChild(this._grid);
            }
            createItemHeader() {
                this._itemHeader = new Life.ItemSlotHeader();
                this._root.addChild(this._itemHeader);
            }
            createDetail() {
                this._detail = new DetailWindow(new Rectangle(0, 0, Iz.Life.ItemSlotGridWidth, 192));
                // this._detail.bitmap?.fillAll("green");
                const offset = 8;
                const gridWindowsHeight = 434;
                this._detail.position.set(getGridStartX(), getGridStartY() + gridWindowsHeight + offset);
                this._root.addChild(this._detail);
            }
            createItemList() {
                this._itemList = new ItemListWindow(new Rectangle(0, 0, 368, 600));
                const offset = 24;
                this._itemList.position.set(this._gridWindows[0].x + this._gridWindows[0].width + 8, offset);
                this._root.addChild(this._itemList);
            }
            createSubMenu() {
                const w = new SubMenuWindow();
                this._subMenu = w;
                this._subMenu.visible = false;
                this._root.addChild(w);
            }
            createPopupBg() {
                const bitmap = new Bitmap(Graphics.width + 2, Graphics.height + 2);
                bitmap.fillAll("rgba(0, 0, 0, 0.6)");
                this._popupBg = new Sprite(bitmap);
                this._popupBg.x = -38;
                this._popupBg.y = -96;
                this._popupBg.visible = false;
                this.addChild(this._popupBg);
            }
            createDetailPopup() {
                this._detailPopup = new DetailPopup();
                this._detailPopup.x = this.width / 2;
                this._detailPopup.y = this.height / 2;
                this._detailPopup.visible = false;
                this._root.addChild(this._detailPopup);
            }
            setupSwitcher() {
                this._switcher = new Iz.ActivateSwitcher();
                this._switcher.add(SwitchKey_Grids, this._grid);
                this._switcher.add(SwitchKey_ItemList, this._itemList);
                this._switcher.add(SwitchKey_ItemSubMenu, this._subMenu);
                this._switcher.add(SwitchKey_DetailPopup, this._detailPopup);
            }
            setupSequence() {
                this._rootSequence = new Iz.RootSequence();
                {
                    const sequence = new SlotSequence(this._grid, this._switcher, this._itemList);
                    this._rootSequence.set(SequenceKey_Slot, sequence, [
                        { dstSequence: SequenceKey_ItemList },
                        { dstSequence: SequenceKey_SlotChange },
                        { dstSequence: SequenceKey_SubMenu },
                    ]);
                }
                {
                    const sequence = new SlotChangeSequence(this._grid, this._switcher, this._itemList);
                    this._rootSequence.set(SequenceKey_SlotChange, sequence, [
                        { dstSequence: SequenceKey_Slot },
                    ]);
                }
                {
                    const sequence = new ItemListSequence(this._grid, this._switcher, this._itemList);
                    this._rootSequence.set(SequenceKey_ItemList, sequence, [
                        { dstSequence: SequenceKey_Slot },
                        { dstSequence: SequenceKey_ItemListChange },
                        { dstSequence: SequenceKey_ItemListSubMenu },
                    ]);
                }
                {
                    const sequence = new ItemListChangeSequence(this._grid, this._switcher, this._itemList);
                    this._rootSequence.set(SequenceKey_ItemListChange, sequence, [
                        { dstSequence: SequenceKey_Slot },
                        { dstSequence: SequenceKey_ItemList },
                    ]);
                }
                {
                    const sequence = new SubMenuSequence(this._grid, this._switcher, this._itemList, this._subMenu);
                    this._rootSequence.set(SequenceKey_SubMenu, sequence, [
                        { dstSequence: SequenceKey_Slot },
                        { dstSequence: SequenceKey_DetailPopup },
                    ]);
                }
                {
                    const sequence = new ItemListSubMenuSequence(this._grid, this._switcher, this._itemList, this._subMenu);
                    this._rootSequence.set(SequenceKey_ItemListSubMenu, sequence, [
                        { dstSequence: SequenceKey_Slot },
                        { dstSequence: SequenceKey_ItemList },
                        { dstSequence: SequenceKey_DetailPopup },
                    ]);
                }
                {
                    const sequence = new ItemDetailPopupSequence(this._detailPopup, this._popupBg, this._switcher);
                    this._rootSequence.set(SequenceKey_DetailPopup, sequence, [
                        { dstSequence: SequenceKey_Slot },
                        { dstSequence: SequenceKey_ItemList },
                    ]);
                }
                this._rootSequence.start({});
            }
            onStart() { }
            onUpdate() {
                this._switcher.update();
                this._rootSequence.update();
                let nextSelectedItem = 0;
                if (this._switcher.isOn(SwitchKey_Grids)) {
                    const data = Iz.Life.ItemSlot.inventory.get(this._grid.index);
                    nextSelectedItem = data ? data.id : 0;
                }
                else if (this._switcher.isOn(SwitchKey_ItemList)) {
                    nextSelectedItem = this._itemList.itemId;
                }
                if (this._selectedItem !== nextSelectedItem) {
                    this._detail.setItem(nextSelectedItem);
                    this._selectedItem = nextSelectedItem;
                }
                this._grid.updateMain();
                this._itemList.grid.updateMain();
                this.updateItemHeader();
            }
            updateItemHeader() {
                //
                const data = Iz.Life.ItemSlot.inventory.get(this._grid.index);
                if (data) {
                    this._itemHeader.setText($dataItems[data.id].name);
                }
                else {
                    this._itemHeader.setText("");
                }
                this._itemHeader.visible = !!data && this._grid.isActive();
                const headerX = Math.min(Math.max(this.getHeaderX(this._grid.index), this.getHeaderX(0)), this.getHeaderX(Life.ItemSlotCol - 1));
                this._itemHeader.x = headerX;
                this._itemHeader.y = this.getHeaderY(this._grid.index);
            }
            getHeaderX(index) {
                return 44 + (index % Life.ItemSlotCol) * Life.ItemIconWidth;
            }
            getHeaderY(index) {
                return -4 + Math.floor(index / Life.ItemSlotCol) * GridOffsetY;
            }
            onUpdateIcon(cell, index) {
                const data = Iz.Life.ItemSlot.inventory.get(index);
                if (data) {
                    cell.set(data.id);
                }
                else {
                    cell.set(0);
                }
                // cell.bitmap?.fillAll("yellow");  // 領域確認用
            }
            backable() {
                return (!this._rootSequence.isBusy() &&
                    (this._rootSequence.key === SequenceKey_Slot ||
                        this._rootSequence.key === SequenceKey_ItemList));
            }
            headerAtlas() {
                return {
                    atlasKey: Life.ATLAS_KEY_MENU_ITEMSLOT,
                    frameKey: Life.FRAME_KEY_MENU_ITEMSLOT_TITLE,
                };
            }
            footerText() {
                switch (this._rootSequence.key) {
                    case SequenceKey_Slot:
                        if (Life.ItemSlot.inventory.itemId(this._grid.index) > 0) {
                            return Iz.Text.get("MENU_ITEMSLOT_FOOTER_3");
                        }
                        return Iz.Text.get("MENU_ITEMSLOT_FOOTER_1");
                    case SequenceKey_ItemList:
                        return Iz.Text.get("MENU_ITEMSLOT_FOOTER_2");
                    default:
                        return Iz.Text.get("MENU_ITEMSLOT_FOOTER_1");
                }
            }
        }
        Life.ContentItemSlot = ContentItemSlot;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 住民一覧
(function (Iz) {
    var Life;
    (function (Life) {
        const UnknownText = "???";
        const HeartMax = 10;
        class ProfileHeader extends Sprite {
            constructor() {
                super();
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_RESIDENTS).getFrame(Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_NAME);
                this.width = frame.width;
                this.height = frame.height;
                this.create();
                this.setNameEnable(false);
            }
            create() {
                this.createBg();
                this.createName();
                this.createFlower();
            }
            createBg() {
                this._bg = new Sprite();
                this._bg.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_NAME);
                this.addChild(this._bg);
                this._bg.y = 10;
            }
            createName() {
                this._nameSprite = new Sprite();
                this._bg.addChild(this._nameSprite);
            }
            createFlower() {
                this._flower = new Sprite();
                this._flower.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_FLOWER);
                this._flower.x = -8;
                this._flower.y = -4;
                this.addChild(this._flower);
            }
            setNameEnable(flg) {
                this._nameSprite.visible = flg;
            }
            setName(actorId) {
                if (Life.Profile.getActorFlag(actorId)) {
                    this._nameSprite.visible = true;
                    const frameKey = `name_${actorId.toString().padStart(2, "0")}`;
                    this._nameSprite.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.getFrameKey(frameKey));
                    const bgFrame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_RESIDENTS).getFrame(Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_NAME);
                    this._nameSprite.x = Math.floor((bgFrame.width - this._nameSprite.width) / 2);
                    this._nameSprite.y = Math.floor((bgFrame.height - this._nameSprite.height) / 2);
                }
                else {
                    this._nameSprite.visible = false;
                }
            }
        }
        class ResidentBasicElement extends Sprite {
            constructor(lineNum = 1) {
                super();
                this.create(lineNum);
            }
            create(lineNum) {
                this.createBg();
                this.createText(lineNum);
            }
            createBg() {
                this._bg = new Sprite();
                this._bg.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.FRAME_KEY_MENU_RESIDENTS_INFO_TITLE_BG);
                this.addChild(this._bg);
                this._title = new Sprite_Text(160);
                this._title.setAlign("center");
                this._title.setFontSetting(Life.FONT_KEY_MENU_RESIDENT_ELEMENT_TITLE);
                this.addChild(this._title);
            }
            createText(lineNum) {
                this._text = new Sprite_TextEx(236, 48 + 54 * (lineNum - 1));
                this._text.x = this._bg.width + 10;
                this._text.y = -2;
                this._text.setFontSetting(Life.FONT_KEY_MENU_RESIDENT_ELEMENT);
                this.addChild(this._text);
            }
            setTitle(title) {
                this._title.setText(title, true);
            }
            setText(text) {
                this._text.setText(text);
            }
            getTextWidth() {
                return this._text.width;
            }
        }
        class ResidentProfileBasic extends Sprite {
            constructor() {
                super();
                this.width = 400;
                this.height = 300;
                this.create();
            }
            create() {
                this.createBirth();
                this.createHeightAndWeight();
                this.createThreeSize();
                this.createInterest();
            }
            createBirth() {
                this._basicBirth = new ResidentBasicElement();
                this._basicBirth.setTitle(Iz.Text.get("MENU_PROFILE_BIRTH"));
                this.addChild(this._basicBirth);
            }
            createHeightAndWeight() {
                this._basicHeightAndWeight = new ResidentBasicElement();
                this._basicHeightAndWeight.setTitle(Iz.Text.get("MENU_PROFILE_HEIGHT_AND_WEIGHT"));
                this._basicHeightAndWeight.y = 54;
                this.addChild(this._basicHeightAndWeight);
            }
            createThreeSize() {
                this._basicThreeSize = new ResidentBasicElement();
                // NOTE:
                // 身長,体重,スリーサイズをまとめて表現する翻訳がある場合、
                // スリーサイズは省略
                const title = Iz.Text.get("MENU_PROFILE_THREE_SIZE");
                if (title) {
                    this._basicThreeSize.setTitle(title);
                }
                else {
                    this._basicThreeSize.setTitle("");
                }
                this._basicThreeSize.visible = !!title;
                this._basicThreeSize.y = 107;
                this.addChild(this._basicThreeSize);
            }
            createInterest() {
                this._basicInterest = new ResidentBasicElement(3);
                this._basicInterest.setTitle(Iz.Text.get("MENU_PROFILE_INTEREST"));
                this._basicInterest.y = 160;
                this.addChild(this._basicInterest);
            }
            set(actorId) {
                if (!$dataProfile[actorId] || !Life.Profile.getActorFlag(actorId)) {
                    this.clear();
                }
                else {
                    this.setBirth(actorId);
                    this.setHeightAndWeight(actorId);
                    this.setThreeSize(actorId);
                    this.setInterest(actorId);
                }
            }
            clear() {
                this._basicBirth.setText(UnknownText);
                this._basicHeightAndWeight.setText(UnknownText);
                this._basicThreeSize.setText(UnknownText);
                this._basicInterest.setText(UnknownText);
            }
            setBirth(actorId) {
                if (Life.Profile.getBirthFlag(actorId)) {
                    // const monthName = Iz.System.getMonthName($dataProfile[actorId].birth_month);
                    const day = $dataProfile[actorId].birth_day;
                    this._basicBirth.setText(
                    // Iz.String.format(Iz.Text.get("MENU_PROFILE_BIRTH_FORMAT"), monthName, day),
                    Iz.System.getDaysText($dataProfile[actorId].birth_month, day));
                }
                else {
                    this._basicBirth.setText(UnknownText);
                }
            }
            setHeightAndWeight(actorId) {
                if (Life.Profile.getHeightFlag(actorId)) {
                    const str = Iz.String.format(Iz.Text.get("PROFILE_HEIGHT_AND_WEIGHT_FORMAT"), $dataProfile[actorId].height, $dataProfile[actorId].weight);
                    this._basicHeightAndWeight.setText(str);
                }
                else {
                    this._basicHeightAndWeight.setText(UnknownText);
                }
            }
            setThreeSize(actorId) {
                if (Life.Profile.getThreeSizeFlag(actorId)) {
                    const data = $dataProfile[actorId];
                    const threeSizeStr = Iz.String.format(Iz.Text.get("PROFILE_THREESIZE_FORMAT"), data.bust, data.waist, data.hip);
                    this._basicThreeSize.setText(threeSizeStr);
                }
                else {
                    this._basicThreeSize.setText(UnknownText);
                }
            }
            setInterest(actorId) {
                if (Life.Profile.getInterestFlag(actorId)) {
                    const str = $dataProfileInterest
                        .filter((data) => !!data && data.id === actorId)
                        .map((data) => `${Iz.Text.get(data.text_key)} `)
                        .join("\n");
                    this._basicInterest.setText(str);
                }
                else {
                    this._basicInterest.setText(UnknownText);
                }
            }
        }
        class ResidentFavoriteElement extends Sprite {
            constructor() {
                super();
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_RESIDENTS).getFrame(Life.FRAME_KEY_MENU_RESIDENTS_LABEL);
                this.width = frame.width;
                this.height = frame.height;
                this.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.FRAME_KEY_MENU_RESIDENTS_LABEL);
                this.create();
            }
            create() {
                this.createTitle();
                this.createText();
            }
            createTitle() {
                this._title = new Sprite_TextEx(128, 32);
                this._title.setFontSetting(Life.FONT_KEY_MENU_RESIDENT_ELEMENT_TITLE);
                this._title.x = 8;
                this.addChild(this._title);
            }
            createText() {
                this._text = new Sprite_TextEx(528, 32);
                this._text.setFontSetting(Life.FONT_KEY_MENU_RESIDENT_ELEMENT);
                this._text.x = this._title.x + this._title.width + 16;
                this.addChild(this._text);
            }
            setTitle(title) {
                this._title.setText(title);
            }
            setText(text) {
                this._text.setText(text);
            }
        }
        class ResidentProfileFavorite extends Sprite {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.createLike();
                this.createFavorite();
                this.createDislike();
            }
            createLike() {
                this._likeElement = new ResidentFavoriteElement();
                this._likeElement.setTitle(Iz.Text.get("MENU_PROFILE_LIKE"));
                this.addChild(this._likeElement);
            }
            createFavorite() {
                this._favoriteElement = new ResidentFavoriteElement();
                this._favoriteElement.setTitle(Iz.Text.get("MENU_PROFILE_FAVORITE"));
                this._favoriteElement.y = 46;
                this.addChild(this._favoriteElement);
            }
            createDislike() {
                this._dislikeElement = new ResidentFavoriteElement();
                this._dislikeElement.setTitle(Iz.Text.get("MENU_PROFILE_DISLIKE"));
                this._dislikeElement.y = 92;
                this.addChild(this._dislikeElement);
            }
            set(actorId) {
                if (!$dataProfile[actorId] || !Life.Profile.getActorFlag(actorId)) {
                    this.clear();
                }
                else {
                    this.setLike(actorId);
                    this.setFavorite(actorId);
                    this.setDislike(actorId);
                }
            }
            clear() {
                this._likeElement.setText(UnknownText);
                this._favoriteElement.setText(UnknownText);
                this._dislikeElement.setText(UnknownText);
            }
            getItemReactionStrings(actorId, reactionType) {
                return $dataProfileReaction
                    .filter((data) => !!data && data.id === actorId)
                    .filter((data) => data.reaction === reactionType)
                    .filter((data) => data.display)
                    .sort((a, b) => a.display_order - b.display_order)
                    .map((data) => {
                    if (data.type === Life.Data.ProfileItemType.Item) {
                        if (Life.Profile.getItemFlag(actorId, data.type_id)) {
                            return Iz.String.format("{0}", $dataItems[data.type_id].name);
                        }
                    }
                    else if (data.type === Life.Data.ProfileItemType.ItemGroup) {
                        if (Life.Profile.getGroupFlag(actorId, data.type_id)) {
                            return Iz.String.format("{0}", Iz.Life.getItemGroupName(data.type_id));
                        }
                    }
                    return UnknownText;
                })
                    .join(Iz.Text.get("SYSTEM_JOIN_CHARACTER"));
            }
            setLike(actorId) {
                const str = this.getItemReactionStrings(actorId, Life.Data.ProfileReactionType.Like);
                this._likeElement.setText(str);
            }
            setFavorite(actorId) {
                const favorite = this.getItemReactionStrings(actorId, Life.Data.ProfileReactionType.Favorite);
                const favorite2 = this.getItemReactionStrings(actorId, Life.Data.ProfileReactionType.Favorite2);
                const favorite3 = this.getItemReactionStrings(actorId, Life.Data.ProfileReactionType.Favorite3);
                this._favoriteElement.setText([favorite, favorite2, favorite3].join(Iz.Text.get("SYSTEM_JOIN_CHARACTER")));
            }
            setDislike(actorId) {
                const dislike = this.getItemReactionStrings(actorId, Life.Data.ProfileReactionType.DisLike);
                const dislike2 = this.getItemReactionStrings(actorId, Life.Data.ProfileReactionType.DisLike2);
                this._dislikeElement.setText([dislike, dislike2].join(Iz.Text.get("SYSTEM_JOIN_CHARACTER")));
            }
        }
        class ResidentProfile extends Sprite {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.createHeader();
                this.createBg();
                this.createSD();
                this.createBasic();
                this.createFavorite();
            }
            createHeader() {
                this._header = new ProfileHeader();
                this.addChild(this._header);
            }
            createBg() {
                this._bg = new Sprite();
                this._bg.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_PROFILE);
                const offsetY = 16;
                this._bg.move(0, this._header.y + this._header.height + offsetY);
                this.addChild(this._bg);
            }
            createSD() {
                this._photoBg = new Sprite();
                this._photoBg.setAtlas(Life.ATLAS_KEY_MENU_RESIDENTS, Life.FRAME_KEY_MENU_RESIDENTS_PHOTO_BG);
                this._photoBg.move(432, 102);
                this.addChild(this._photoBg);
                this._sdSpriteRoot = new Sprite(new Bitmap(4, 4));
                this._sdSpriteRoot.anchor.set(0.5, 0.5);
                this._sdSpriteRoot.relativeAnchor.enable = true;
                this._sdSpriteRoot.relativeAnchor.ratio.x = 0.5;
                this._sdSpriteRoot.relativeAnchor.ratio.y = 0.5;
                this._photoBg.addChild(this._sdSpriteRoot);
                this._sdSprite = new Sprite();
                this._sdSprite.anchor.set(0.5, 0.5);
                this._sdSprite.relativeAnchor.enable = true;
                this._sdSprite.relativeAnchor.ratio = { x: 0.5, y: 0.5 };
                this._sdSpriteRoot.addChild(this._sdSprite);
                this._sdOffsetBase = { x: 0, y: 0 };
            }
            createBasic() {
                this._basic = new ResidentProfileBasic();
                this._basic.x = 28;
                this._basic.y = this._bg.y + 38;
                this.addChild(this._basic);
            }
            createFavorite() {
                this._favorite = new ResidentProfileFavorite();
                this._favorite.x = 24;
                this._favorite.y = this._basic.y + this._basic.height + 24;
                this.addChild(this._favorite);
            }
            setProfile(actorId) {
                const actor = $gameActors.actor(actorId);
                if (actor && Life.Profile.getActorFlag(actorId)) {
                    this._header.setNameEnable(true);
                    this._header.setName(actor.actorId());
                    const data = $dataProfile[actorId];
                    const offsetX = this._sdOffsetBase.x + (data ? data.sd_offset_x : 0);
                    const offsetY = this._sdOffsetBase.y + (data ? data.sd_offset_y : 0);
                    this._sdSpriteRoot.relativeAnchor.offset.x = offsetX;
                    this._sdSpriteRoot.relativeAnchor.offset.y = offsetY;
                    this._sdSprite.visible = false;
                    this._sdSprite.bitmap = ImageManager.loadPicture(`sd/sd_${actorId.toString().padStart(2, "0")}`);
                    this._sdSprite.bitmap.addLoadListener(() => {
                        this._sdSprite.visible = true;
                    });
                    this._basic.set(actorId);
                    this._favorite.set(actorId);
                }
                else {
                    this._header.setNameEnable(false);
                    this._sdSpriteRoot.relativeAnchor.offset.x = 0;
                    this._sdSpriteRoot.relativeAnchor.offset.y = 0;
                    this._sdSprite.visible = false;
                    this._basic.set(actorId);
                    this._favorite.set(actorId);
                }
            }
        }
        class Scroll extends Life.ScrollBase {
            constructor(option) {
                super(option);
                this._actorIds = Life.getProfileActors();
            }
            get actorIds() {
                return this._actorIds;
            }
            get actorId() {
                return this.actorIds[this.index()] ?? 0;
            }
            maxItems() {
                return this.actorIds.length;
            }
            drawItem(index) {
                const rect = this.itemRectWithPadding(index);
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_RESIDENTS);
                const bitmap = atlas.getBitmap();
                const actorId = this.actorIds[index] ?? 0;
                const actor = $gameActors.actor(actorId);
                const valid = actor && Life.Profile.getActorFlag(actorId);
                // bg
                {
                    const f = atlas.getFrame(Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_LIST);
                    this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.x, rect.y);
                }
                // icon
                {
                    const frameName = valid
                        ? `face_${actorId.toString().padStart(2, "0")}`
                        : Life.FRAME_KEY_MENU_RESIDENTS_FACE_LOCK;
                    const f = atlas.getFrame(frameName);
                    const y = rect.y + Math.floor((rect.height - f.height) / 2);
                    this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.x + 16, y);
                }
                // name
                const actorName = valid ? (actor?.name() ?? "") : UnknownText;
                this.drawTextEx(actorName, rect.x + 86, rect.y + 20, 256);
                // emptyheart
                for (let i = 0; i < HeartMax; i++) {
                    const f = atlas.getFrame(Life.FRAME_KEY_MENU_RESIDENTS_HEART_BLANK);
                    this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.x + 86 + i * 25, rect.y + 58);
                }
                // heart
                const level = Life.Status.getLikabilityLevel(actorId);
                if (level >= Life.Status.getLikabilityLevelMax()) {
                    for (let i = 0; i < HeartMax; i++) {
                        const f = atlas.getFrame(Life.FRAME_KEY_MENU_RESIDENTS_HAERT_FULL);
                        this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.x + 86 + i * 25, rect.y + 58);
                    }
                }
                else {
                    const RateMaxLevel = Life.Status.getLikabilityLevelMax();
                    const currentExp = Life.Status.getLikability(actorId);
                    const expRate = currentExp / Life.Status.getLikabilityLevelExp(RateMaxLevel);
                    // 塗りつぶす個数
                    let fillNum = expRate * HeartMax;
                    for (let i = 0; i < HeartMax; i++) {
                        let rate = 0;
                        if (fillNum >= 1) {
                            rate = 1;
                            fillNum--;
                        }
                        else if (fillNum > 0) {
                            rate = fillNum;
                            fillNum = 0;
                        }
                        else {
                            rate = 0;
                        }
                        const f = atlas.getFrame(Life.FRAME_KEY_MENU_RESIDENTS_HAERT_FULL);
                        const w = f.width * rate;
                        this.contents.blt(bitmap, f.x, f.y, w, f.height, rect.x + 86 + i * 25, rect.y + 58);
                    }
                }
                // present
                {
                    let frameName = Life.FRAME_KEY_MENU_RESIDENTS_PRESENT_BLANK;
                    if (valid && Iz.Life.Status.getGifted(actorId)) {
                        frameName = Life.FRAME_KEY_MENU_RESIDENTS_PRESENT_FULL;
                    }
                    const f = atlas.getFrame(frameName);
                    this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.x + 338, rect.y + 38);
                }
                // arrow
                if (index === this.index()) {
                    const arrow = atlas.getFrame(Life.FRAME_KEY_MENU_RESIDENTS_ARROW_RIGHT_HOVER);
                    this.contents.blt(bitmap, arrow.x, arrow.y, arrow.width, arrow.height, rect.x - 24, rect.y + (rect.height - arrow.height) / 2);
                }
            }
            resetTextColor() {
                this.setFontSetting(Life.FONT_KEY_MENU_RESIDENT_CHARACTER);
            }
        }
        class ContentResident extends Life.MenuContentBase {
            constructor(w, h) {
                super(new Rectangle(0, 0, w, h));
                this.create();
                this._scroll.setSelectHandler(this.onSelect.bind(this));
                this._scroll.select(0);
            }
            create() {
                this.createScroll();
                this.createProfile();
            }
            createScroll() {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_RESIDENTS);
                const frame = atlas.getFrame(Life.FRAME_KEY_MENU_RESIDENTS_WINDOW_LIST);
                this._scroll = new Scroll({
                    height: 600,
                    itemContentWidth: frame.width,
                    itemContentHeight: frame.height,
                    itemPad: { x: 0, y: 0 },
                    colSpacing: 64,
                });
                this._scroll.activate();
                this._scroll.x = 0;
                this._scroll.y = 32;
                this.addChild(this._scroll);
            }
            createProfile() {
                this._profile = new ResidentProfile();
                const offsetX = 468;
                const offsetY = 32;
                this._profile.move(offsetX, offsetY);
                this.addChild(this._profile);
            }
            onStart() { }
            onUpdate() { }
            onSelect(index) {
                const actorId = this._scroll.actorId;
                this._profile.setProfile(actorId);
            }
            backable() {
                return true;
            }
            headerAtlas() {
                return {
                    atlasKey: Life.ATLAS_KEY_MENU_RESIDENTS,
                    frameKey: Life.FRAME_KEY_MENU_RESIDENTS_TITLE,
                };
            }
            footerText() {
                return Iz.Text.get("MENU_PROFILE_FOOTER");
            }
        }
        Life.ContentResident = ContentResident;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// ミニマップ
(function (Iz) {
    var Life;
    (function (Life) {
        class MiniMapPointRoot extends Sprite {
            constructor(pointId) {
                super();
                this.setPoint(pointId);
                this.create();
                this.setClosed(pointId);
                this.setAngleTween();
                this._page = 0;
            }
            get pointId() {
                return this._pointId;
            }
            get displayNumX() {
                return $dataMenuMiniMapPoint[this.pointId].display_character_x;
            }
            get displayNumY() {
                return $dataMenuMiniMapPoint[this.pointId].display_character_y;
            }
            get displayMax() {
                return this.displayNumX * this.displayNumY;
            }
            get collision() {
                return this._collision;
            }
            create() {
                this._icons = [];
                for (let y = 0; y < this.displayNumY; y++) {
                    for (let x = 0; x < this.displayNumX; x++) {
                        const icon = new Life.FaceIcon();
                        this._icons.push(icon);
                        this.addChild(icon);
                    }
                }
                this._closedSprite = new Sprite();
                this._closedSprite.setAtlas(Life.ATLAS_KEY_MENU_MINIMAP, Life.FRAME_KEY_MENU_MINIMAP_CLOSE);
                this._closedSprite.visible = false;
                this._closedSprite.anchor.set(0.5, 0);
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_MINIMAP).getFrame(Life.FRAME_KEY_MENU_MINIMAP_CLOSE);
                const offsetY = 16;
                this._closedSprite.y = -Math.floor(frame.height / 2) + offsetY;
                this.addChild(this._closedSprite);
                this.createCollision();
            }
            createCollision() {
                const CollisionSize = 96;
                const bitmap = new Bitmap(CollisionSize, CollisionSize);
                // bitmap.fillAll("green");
                this._collision = new Sprite(bitmap);
                this._collision.anchor.set(0.5, 0.5);
                this.addChild(this._collision);
            }
            setPoint(pointId) {
                this._pointId = pointId;
                const data = $dataMenuMiniMapPoint[pointId];
                if (data) {
                    this.x = data.x;
                    this.y = data.y;
                }
                else {
                    this.x = 0;
                    this.y = 0;
                }
            }
            setClosed(pointId) {
                this._pointId = pointId;
                const data = $dataMenuMiniMapPoint[pointId];
                if (data) {
                    // const schedule = Facility.getShopSchedule(data.facility_id);
                    // if (schedule) {
                    //     this._closedSprite.visible = !isOpenTime(schedule);
                    //     return;
                    // }
                    const schedule = Life.Facility.getShopSchedule(data.facility_id);
                    if (schedule) {
                        this._closedSprite.visible = !Life.Facility.isOpenShop(data.facility_id);
                        return;
                    }
                }
                this._closedSprite.visible = false;
            }
            update() {
                super.update();
                if (this._tween) {
                    this._tween.update();
                    this.alpha = this._tween.value();
                }
                if (this._angleTween?.isPlaying()) {
                    this._angleTween.update();
                    this._closedSprite.angle = this._angleTween.value() * (this._baseAngle * 2);
                }
                else {
                    this._closedSprite.angle = 0;
                }
            }
            setAllActors(actors) {
                this._actors = [...actors];
                if (this._actors.length > this.displayMax) {
                    this.setTween();
                }
                this.setPage(0);
            }
            setTween() {
                this._tween = Iz.Tween.create({
                    clips: [
                        { param: { duration: 60, easing: Iz.Easing.easeOne } },
                        {
                            param: { duration: 60, easing: Iz.Easing.easeInQuint, invert: true },
                            event: {
                                onFinish: () => {
                                    this.setPage(this._page + 1);
                                },
                            },
                        },
                        { param: { duration: 60, easing: Iz.Easing.easeOutQuint } },
                    ],
                    loop: true,
                });
                this._tween.start();
            }
            setAngleTween() {
                this._angleTween = Iz.Tween.create({
                    clips: [
                        { param: { duration: 10, easing: Iz.Easing.easeInOutSine } },
                        {
                            param: { duration: 10, easing: Iz.Easing.easeInOutSine, invert: true },
                            event: {
                                onFinish: () => {
                                    this._baseAngle *= 0.5;
                                    if (this._baseAngle < 1) {
                                        this._angleTween.stop();
                                    }
                                },
                            },
                        },
                    ],
                    loop: true,
                });
                this._angleTween.start();
                this._baseAngle = 10;
            }
            setPage(page) {
                this._page = page;
                const maxPage = Math.ceil(this._actors.length / this.displayMax) - 1;
                if (page > maxPage) {
                    this._page = 0;
                }
                let nextBeginIndex = this._page * this.displayMax;
                if (nextBeginIndex >= this._actors.length) {
                    nextBeginIndex = this._actors.length;
                }
                const nextEndIndex = Math.min(Math.max(nextBeginIndex + this.displayMax, nextBeginIndex), this._actors.length);
                const displayActors = this._actors.slice(nextBeginIndex, nextEndIndex);
                this.setUpIcons(displayActors);
            }
            setUpIcons(actors) {
                const basePos = this.calcDisplayBasePosition(actors.length);
                for (let i = 0; i < this.displayMax; i++) {
                    const actor = actors[i];
                    if (actor) {
                        this._icons[i].visible = true;
                        this._icons[i].x = basePos.x + (i % this.displayNumX) * 48;
                        this._icons[i].y = basePos.y + Math.floor(i / this.displayNumX) * 48;
                        this._icons[i].set(actor);
                    }
                    else {
                        this._icons[i].visible = false;
                    }
                }
            }
            calcDisplayBasePosition(len) {
                const baseX = Math.min(Math.max(len, 0), this.displayNumX);
                const baseY = Math.min(Math.max(Math.ceil(len / this.displayNumX), 0), this.displayNumY);
                const offsetY = -16;
                return { x: Math.floor((-baseX / 2) * 48), y: Math.floor((-baseY / 2) * 48) + offsetY };
            }
        }
        class FacilityDetail extends Sprite {
            constructor() {
                super();
                this.setAtlas(Life.ATLAS_KEY_MENU_MINIMAP, Life.FRAME_KEY_MENU_MINIMAP_FLAME);
                this.create();
            }
            create() {
                this.createMapName();
                this.createOpenTime();
                this.createClosedDays();
                this.createTemporaryClosed();
            }
            createMapName() {
                this._mapName = new Sprite_Text(this.width, 32);
                this._mapName.setAlign("center");
                this._mapName.setFontSetting(Life.FONT_KEY_MENU_MINIMAP_FACILITY_NAME);
                this.addChild(this._mapName);
            }
            createOpenTime() {
                this._openTime = new Sprite_TextEx(512, 32);
                this._openTime.setFontSetting(Life.FONT_KEY_MENU_MINIMAP_FACILITY_DETAIL);
                this._openTime.x = 32;
                this._openTime.y = 46;
                this.addChild(this._openTime);
            }
            createClosedDays() {
                this._closedDays = new Sprite_TextEx(512, 32);
                this._closedDays.setFontSetting(Life.FONT_KEY_MENU_MINIMAP_FACILITY_DETAIL);
                this._closedDays.x = 512;
                this._closedDays.y = 46;
                this.addChild(this._closedDays);
            }
            createTemporaryClosed() {
                this._temporaryClosed = new Sprite_Text(512, 32);
                this._temporaryClosed.setFontSetting(Life.FONT_KEY_MENU_MINIMAP_FACILITY_DETAIL);
                this._temporaryClosed.setAlign("center");
                this._temporaryClosed.x = Math.floor((this.width - this._temporaryClosed.width) / 2);
                this._temporaryClosed.y = 46;
                this.addChild(this._temporaryClosed);
            }
            set(option) {
                this._mapName.setText(option.name);
                if (option.temporary) {
                    this._openTime.setText("");
                    this._closedDays.setText("");
                    this._temporaryClosed.setText(Iz.Text.get("MENU_MINIMAP_TEMPORARY_CLOSED"));
                    return;
                }
                if (option.time) {
                    const begin = Iz.System.toChronusFormat(option.time.begin_hour, option.time.begin_minute);
                    const end = Iz.System.toChronusFormat(option.time.end_hour, option.time.end_minute);
                    const format = Iz.Text.get("MENU_MINIMAP_OPEN_TIME");
                    this._openTime.setText(Iz.String.format(format, begin, end));
                }
                else {
                    this._openTime.setText("");
                }
                if (option.closedDays.length > 0) {
                    const text = option.closedDays
                        .map((day) => Iz.System.getDayOfWeekName(day - 1))
                        .join(",");
                    const format = Iz.Text.get("MENU_MINIMAP_CLOSED_DAYS");
                    this._closedDays.setText(Iz.String.format(format, text));
                }
                else {
                    this._closedDays.setText("");
                }
                this._temporaryClosed.setText("");
            }
        }
        const BackgroundWidth = 1032;
        const BackgroundHeight = 580;
        class ContentMiniMap extends Life.MenuContentBase {
            constructor(w, h) {
                super(new Rectangle(0, 0, w, h));
                // 表示対象を限定しとく
                const npcs = $dataNonPlayers.filter((data) => data).map((data) => data.id);
                this._drawableActorIds = [1, ...npcs];
                this._drawableActorIds.sort((a, b) => a - b);
                this.create(w, h);
            }
            create(w, h) {
                this.createBackground(w, h);
                this._pointOrigin = new Sprite();
                this._background.addChild(this._pointOrigin);
                this.createCursor();
                this.createFacilityDetail();
                this.createChronus();
                this.initializePointMap();
            }
            createBackground(w, h) {
                // 仮のビットマップを作成しておいて、画像を読み終えたら差し替える
                const bp = new Bitmap(BackgroundWidth, BackgroundHeight);
                this._background = new Sprite(bp);
                this._background.x = Math.floor((w - BackgroundWidth) / 2);
                this._background.y = Math.floor((h - BackgroundHeight) / 2);
                this.addChild(this._background);
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_MINIMAP);
                const bitmap = atlas.getBitmap();
                bitmap.addLoadListener(() => {
                    this._background.setAtlas(Life.ATLAS_KEY_MENU_MINIMAP, Life.FRAME_KEY_MENU_MINIMAP_MINIMAP);
                });
            }
            createCursor() {
                this._cursor = new Sprite();
                this._cursor.setAtlas(Life.ATLAS_KEY_MENU_MINIMAP, Life.FRAME_KEY_MENU_MINIMAP_CURSOR);
                this._background.addChild(this._cursor);
                this._cursorTween = Iz.Tween.create({
                    clips: [
                        { param: { duration: 30, easing: Iz.Easing.easeInOutSine } },
                        { param: { duration: 30, easing: Iz.Easing.easeInOutSine, invert: true } },
                    ],
                    loop: true,
                });
            }
            createFacilityDetail() {
                this._facilityDetail = new FacilityDetail();
                this._facilityDetail.x = (this.width - this._facilityDetail.width) / 2;
                this._facilityDetail.y = this.height - 112;
                this.addChild(this._facilityDetail);
            }
            createChronus() {
                const rect = new Rectangle(0, 0, 0, 0);
                this._chronus = new Window_Chronus(rect);
                this._chronus.x = this._background.x + this._background.width - 196;
                this._chronus.y = 40;
                this.addChild(this._chronus);
            }
            initializePointMap() {
                this._mapToPoint = new Map();
                this._locaionToPoint = new Map();
                $dataMenuMiniMapPoint
                    .filter((point) => point)
                    .forEach((point) => {
                    $dataMenuMiniMapPointContent
                        .filter((c) => c && c.id === point.id)
                        .forEach((c) => {
                        // map
                        if (c.type === 1) {
                            this._mapToPoint.set(c.type_id, point.id);
                        }
                        // location
                        else if (c.type === 2) {
                            this._locaionToPoint.set(c.type_id, point.id);
                        }
                    });
                });
            }
            refresh() {
                this._pointRoots = new Map();
                this._pointRoots.clear();
                this._pointOrigin.removeChildren();
                $dataMenuMiniMapPoint
                    .filter((data) => data)
                    .forEach((data) => {
                    const root = new MiniMapPointRoot(data.id);
                    this._pointRoots.set(data.id, root);
                    this._pointOrigin.addChild(root);
                });
                const pointMap = new Map();
                this._drawableActorIds.forEach((actor) => {
                    const point = this.getActorPoint(actor);
                    if (point) {
                        const actors = pointMap.get(point);
                        if (actors) {
                            actors.push(actor);
                        }
                        else {
                            const ar = [];
                            ar.push(actor);
                            pointMap.set(point, ar);
                        }
                    }
                });
                pointMap.forEach((actors, point) => {
                    actors.sort((a, b) => a - b);
                });
                pointMap.forEach((actors, point) => {
                    const root = this._pointRoots.get(point);
                    if (root) {
                        // 確認用
                        // root.setAllActors([1,2,3,4,5,6,7,8,9,10,11,12,13,14,15]);
                        root.setAllActors(actors);
                    }
                });
                this.setCursor(0);
            }
            getActorPoint(actorId) {
                if (actorId === 1) {
                    return this.getPoint($gameMap.mapId(), $gamePlayer.x, $gamePlayer.y);
                }
                if (actorId >= 2) {
                    const npc = $globalMap.nonPlayer(actorId);
                    if (!npc.validity)
                        return undefined;
                    return this.getPoint(npc.mapId(), npc.x, npc.y);
                }
                return undefined;
            }
            getPoint(mapId, x, y) {
                const location = $globalMap.getLocation(mapId, x, y);
                if (location) {
                    const point = this._locaionToPoint.get(location.id);
                    if (point) {
                        return point;
                    }
                }
                const map = this._mapToPoint.get(mapId);
                if (map) {
                    return map;
                }
                return undefined;
            }
            pointToCursor(pointId) {
                const dataCursor = $dataMenuMiniMapCursor.find((data) => data && data.minimap_point_id === pointId);
                return dataCursor?.id ?? 0;
            }
            setCursor(cursorId) {
                if (this._cursorId === cursorId) {
                    return;
                }
                this.setCursorInternal(cursorId);
                this.setDetail(this._cursorId);
            }
            setCursorInternal(cursorId) {
                const data = $dataMenuMiniMapCursor[cursorId];
                if (!data) {
                    this._cursorId = 0;
                    this._cursor.visible = false;
                    return false;
                }
                const point = $dataMenuMiniMapPoint[data.minimap_point_id];
                if (!point) {
                    this._cursorId = 0;
                    this._cursor.visible = false;
                    return false;
                }
                this._cursorId = cursorId;
                this._cursor.visible = true;
                this._cursor.x = point.x - this._cursor.width / 2;
                this._cursorTween.start();
                return true;
            }
            setDetail(cursorId) {
                const data = $dataMenuMiniMapCursor[cursorId];
                if (data) {
                    const facilityId = $dataMenuMiniMapPoint[data.minimap_point_id].facility_id;
                    const facility = $dataFacility.get(facilityId);
                    if (facility) {
                        const mapName = Iz.System.getMapName(facility.name_map);
                        if (mapName) {
                            const option = {
                                name: mapName,
                                time: undefined,
                                closedDays: [],
                                temporary: Life.Facility.isTemporarilyClosed(facilityId),
                            };
                            const shopSchedule = Life.Facility.getShopSchedule(facilityId);
                            if (shopSchedule) {
                                option.time = {
                                    begin_hour: shopSchedule.begin_hour,
                                    begin_minute: shopSchedule.begin_minute,
                                    end_hour: shopSchedule.end_hour,
                                    end_minute: shopSchedule.end_minute,
                                };
                                option.closedDays = $dataShopClosedDay
                                    .filter((data) => data && data.id === facilityId)
                                    .filter((data) => data.closed_type === Life.Data.ShopClosedType.DayOfWeek)
                                    .map((data) => data.closed_type_id);
                            }
                            else {
                                const facilitySchedule = Life.Facility.getSchedule(facilityId);
                                if (facilitySchedule) {
                                    option.time = {
                                        begin_hour: facilitySchedule.begin_hour,
                                        begin_minute: facilitySchedule.begin_minute,
                                        end_hour: facilitySchedule.end_hour,
                                        end_minute: facilitySchedule.end_minute,
                                    };
                                }
                            }
                            this._facilityDetail.visible = true;
                            this._facilityDetail.set(option);
                            return;
                        }
                    }
                }
                this._facilityDetail.visible = false;
            }
            onStart() {
                this.refresh();
            }
            onUpdate() {
                this.updateInput();
                this.updateCursor();
            }
            updateInput() {
                if (this._cursorId === 0) {
                    const FirstCursorId = 2;
                    const SecondCursorId = 1;
                    let cursor = 0;
                    if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                        cursor = FirstCursorId;
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_UP)) {
                        cursor = FirstCursorId;
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_DOWN)) {
                        cursor = SecondCursorId;
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_LEFT)) {
                        cursor = FirstCursorId;
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_RIGHT)) {
                        cursor = SecondCursorId;
                    }
                    else if (TouchInput.isClicked()) {
                        cursor = FirstCursorId;
                    }
                    if (cursor) {
                        this.setCursor(cursor);
                    }
                }
                else {
                    const data = $dataMenuMiniMapCursor[this._cursorId];
                    if (!data) {
                        this.setCursor(0);
                        return;
                    }
                    let cursorId = this._cursorId;
                    if (Input.isRepeated(Iz.IO.KEY_NAME_UP)) {
                        cursorId = data.cursor_id_up;
                    }
                    else if (Input.isRepeated(Iz.IO.KEY_NAME_DOWN)) {
                        cursorId = data.cursor_id_down;
                    }
                    else if (Input.isRepeated(Iz.IO.KEY_NAME_LEFT)) {
                        cursorId = data.cursor_id_left;
                    }
                    else if (Input.isRepeated(Iz.IO.KEY_NAME_RIGHT)) {
                        cursorId = data.cursor_id_right;
                    }
                    else if (Input.isCancelled(true)) {
                        cursorId = 0;
                    }
                    this.setCursor(cursorId);
                }
                if (TouchInput.isHovered()) {
                    const roots = $dataMenuMiniMapCursor
                        .filter((data) => data)
                        .map((data) => this._pointRoots.get(data.minimap_point_id));
                    const root = roots.find((data) => data?.collision.isTouched());
                    if (root) {
                        const cursorId = this.pointToCursor(root.pointId);
                        this.setCursor(cursorId);
                    }
                }
            }
            updateCursor() {
                const data = $dataMenuMiniMapCursor[this._cursorId];
                if (!data) {
                    return;
                }
                const point = $dataMenuMiniMapPoint[data.minimap_point_id];
                if (!point) {
                    return;
                }
                this._cursorTween.update();
                const offsetY = -48 + 16 * this._cursorTween.value();
                this._cursor.y = point.y - this._cursor.height + offsetY;
            }
            backable() {
                return true;
            }
            headerAtlas() {
                return {
                    atlasKey: Life.ATLAS_KEY_MENU_MINIMAP,
                    frameKey: Life.FRAME_KEY_MENU_MINIMAP_TITLE,
                };
            }
            footerText() {
                return Iz.Text.get("MENU_MINIMAP_FOOTER");
            }
        }
        Life.ContentMiniMap = ContentMiniMap;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// イベントリスト（クエスト）
(function (Iz) {
    var Life;
    (function (Life) {
        //
        class QuestListHeaderButton extends Sprite_Clickable {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.createText();
                this.setFrame(0, 0, 128, 32);
            }
            createText() {
                this._text = new Sprite_Text(110, 32);
                this._text.setAlign("center");
                this._text.y = 4;
                this._text.setFontSetting(Life.FONT_KEY_MENU_QUEST_STATE_TITLE);
                this.addChild(this._text);
            }
            setHandler(handler) {
                this._onClickHandler = handler;
            }
            set(state) {
                switch (state) {
                    case Life.QuestState.InProgress:
                        this._text.setText(Iz.Text.get("MENU_QUEST_STATE_TITLE_INPROGRESS"));
                        // this._text.bitmap?.fillAll("blue");
                        break;
                    case Life.QuestState.Unlocked:
                        this._text.setText(Iz.Text.get("MENU_QUEST_STATE_TITLE_UNLOCKED"));
                        break;
                    case Life.QuestState.Complete:
                        this._text.setText(Iz.Text.get("MENU_QUEST_STATE_TITLE_COMPLETE"));
                        break;
                }
                this._state = state;
            }
            onClick() {
                SoundManager.playCursor();
                this._onClickHandler?.(this._state);
            }
            destroy() {
                super.destroy();
                this._onClickHandler = undefined;
            }
        }
        function getStateOrder() {
            const order = new Map();
            order.set(0, Life.QuestState.InProgress);
            order.set(1, Life.QuestState.Unlocked);
            order.set(2, Life.QuestState.Complete);
            return order;
        }
        class QuestListHeader extends Sprite {
            constructor() {
                super();
                this.create();
                this._active = true;
            }
            create() {
                this.createArrows();
                this.createButtons();
            }
            createArrows() {
                this._leftArrow = new Sprite();
                this._leftArrow.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_ARROW_LEFT);
                this._leftArrow.x = -6;
                this._leftArrow.y = 6;
                this.addChild(this._leftArrow);
                this._rightArrow = new Sprite();
                this._rightArrow.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_ARROW_RIGHT);
                this._rightArrow.x = 408;
                this._rightArrow.y = 6;
                this.addChild(this._rightArrow);
            }
            createButtons() {
                this._buttons = [];
                for (let i = 0; i < 3; i++) {
                    const button = new QuestListHeaderButton();
                    button.x = 32 + i * 128;
                    this.addChild(button);
                    this._buttons.push(button);
                }
                const order = getStateOrder();
                for (let i = 0; i < this._buttons.length; i++) {
                    const state = order.get(i);
                    if (state !== undefined) {
                        this._buttons[i].set(state);
                        this._buttons[i].setHandler((index) => {
                            this.onClick(index);
                        });
                    }
                }
            }
            setHandler(handler) {
                this._onClickHandler = handler;
            }
            onClick(index) {
                if (!this.isActive())
                    return;
                this._onClickHandler?.(index);
            }
            activate() {
                this._active = true;
            }
            deactivate() {
                this._active = false;
            }
            isActive() {
                return this._active;
            }
        }
        class Scroll extends Life.ScrollBase {
            constructor(handler) {
                const option = {
                    height: 552,
                    itemContentWidth: 432,
                    itemContentHeight: 56,
                    itemPad: { x: 0, y: 0 },
                    colSpacing: 0,
                    rowSpacing: 0,
                    pad: { x: 0, y: 20 },
                };
                super(option);
                this._getQuestListHandler = handler;
            }
            get questList() {
                return this._getQuestListHandler?.() ?? [];
            }
            maxItems() {
                return this.questList.length;
            }
            drawItem(index) {
                const rect = this.itemRect(index);
                const questId = this.questList[index];
                const quest = $dataQuest.get(questId);
                const questContent = Life.Quest.getQuestContent(questId);
                if (questContent && quest) {
                    // bg
                    if (this.index() === index) {
                        const bgAtlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_EVENTLIST);
                        const bgFrame = bgAtlas.getFrame(Life.FRAME_KEY_MENU_EVENTLIST_EVENTLIST_SELECTER);
                        this.contents.blt(bgAtlas.getBitmap(), bgFrame.x, bgFrame.y, bgFrame.width, bgFrame.height, rect.x, rect.y);
                    }
                    // text
                    const text = Iz.String.format("{0}{1}", quest.test ? "[Test] " : "", questContent.title);
                    // NOTE: widthが意味のない？引数になっている模様
                    this.drawTextEx(text, rect.x + 24, rect.y + 12, 1);
                    // heart
                    if (quest.heart) {
                        const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_EVENTLIST);
                        const frame = atlas.getFrame(Life.FRAME_KEY_MENU_EVENTLIST_SCENE_ON);
                        const x = rect.x + 372;
                        const y = rect.y + 14;
                        this.contents.blt(atlas.getBitmap(), frame.x, frame.y, frame.width, frame.height, x, y);
                    }
                }
            }
            resetTextColor() {
                this.setFontSetting(Life.FONT_KEY_MENU_QUEST_STATE);
            }
        }
        class QuestList extends Sprite {
            constructor() {
                super();
                this.create();
            }
            get state() {
                return this._state;
            }
            get questId() {
                if (this._scroll.index() >= 0) {
                    return this._questList[this._scroll.index()] ?? 0;
                }
                return 0;
            }
            create() {
                this.createBg();
                this.createScroll();
            }
            createBg() {
                this._bg = new Sprite();
                this.addChild(this._bg);
            }
            createScroll() {
                this._scroll = new Scroll(() => {
                    return this._questList;
                });
                this._scroll.x = 6;
                this._scroll.y = 46;
                this._scroll.activate();
                this._scroll.refresh();
                this.addChild(this._scroll);
            }
            setState(state) {
                if (this._state === state)
                    return false;
                switch (state) {
                    case Life.QuestState.InProgress:
                        this._bg.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_TAB_L);
                        break;
                    case Life.QuestState.Unlocked:
                        this._bg.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_TAB_C);
                        break;
                    case Life.QuestState.Complete:
                        this._bg.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_TAB_R);
                        break;
                }
                this._questList = Life.Quest.getQuestDataList()
                    .filter((data) => data.state !== Life.QuestState.Init)
                    .filter((data) => data.state === state)
                    .filter((data) => {
                    // 完了以外はアクティブなクエストのみ表示
                    if (data.state === Life.QuestState.Complete) {
                        return true;
                    }
                    return Life.Quest.checkActiveCondition(data.id);
                })
                    .map((data) => data.id);
                this._scroll.forceSelect(0);
                this._state = state;
                return true;
            }
            setSelectHandler(handler) {
                this._scroll.setSelectHandler(handler);
            }
            setOkHandler(handler) {
                this._scroll.setHandler(Iz.IO.KEY_NAME_OK, handler);
            }
            activate() {
                this._scroll.activate();
            }
            deactivate() {
                this._scroll.deactivate();
            }
            isActive() {
                return this._scroll.active;
            }
        }
        class QuestDetailContent extends Sprite {
            constructor() {
                super();
                this.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_DETAILS_BG);
                this.create();
            }
            create() {
                this.createTitles();
                this.createFaceIcon();
                this.createCharacterText();
                this.createPlaceText();
                this.createRewardText();
                this.createDescText();
            }
            createTitles() {
                this._characterTitle = new Sprite_Text(160, 32);
                this._characterTitle.setFontSetting(Life.FONT_KEY_MENU_QUEST_ELEMENT_TITLE);
                this._characterTitle.setAlign("center");
                this._characterTitle.setText(Iz.Text.get("MENU_QUEST_TITLE_CHARACTER"));
                this._characterTitle.x = 30;
                this._characterTitle.y = 40;
                this.addChild(this._characterTitle);
                this._placeTitle = new Sprite_Text(160, 32);
                this._placeTitle.setFontSetting(Life.FONT_KEY_MENU_QUEST_ELEMENT_TITLE);
                this._placeTitle.setAlign("center");
                this._placeTitle.setText(Iz.Text.get("MENU_QUEST_TITLE_PLACE"));
                this._placeTitle.x = 30;
                this._placeTitle.y = 92;
                this.addChild(this._placeTitle);
                this._rewardTitle = new Sprite_Text(160, 32);
                this._rewardTitle.setFontSetting(Life.FONT_KEY_MENU_QUEST_ELEMENT_TITLE);
                this._rewardTitle.setAlign("center");
                this._rewardTitle.setText(Iz.Text.get("MENU_QUEST_TITLE_REWARD"));
                this._rewardTitle.x = 30;
                this._rewardTitle.y = 144;
                this.addChild(this._rewardTitle);
            }
            createFaceIcon() {
                this._faceIcon = new Life.FaceIcon();
                this._faceIcon.x = 196;
                this._faceIcon.y = 30;
                this.addChild(this._faceIcon);
            }
            createCharacterText() {
                this._characterText = new Sprite_TextEx(256, 48);
                this._characterText.setFontSetting(Life.FONT_KEY_MENU_QUEST_ELEMENT);
                this._characterText.setText("");
                this._characterText.x = 248;
                this._characterText.y = 34;
                this.addChild(this._characterText);
            }
            createPlaceText() {
                this._placeText = new Sprite_TextEx(512, 48);
                this._placeText.setFontSetting(Life.FONT_KEY_MENU_QUEST_ELEMENT);
                this._placeText.setText("");
                this._placeText.x = 196;
                this._placeText.y = 90;
                this.addChild(this._placeText);
            }
            createRewardText() {
                this._rewardText = new Sprite_TextEx(512, 48);
                this._rewardText.setFontSetting(Life.FONT_KEY_MENU_QUEST_ELEMENT);
                this._rewardText.setText("");
                this._rewardText.x = 196;
                this._rewardText.y = 142;
                this.addChild(this._rewardText);
            }
            createDescText() {
                this._descText = new Sprite_TextEx(660, 264);
                this._descText.setFontSetting(Life.FONT_KEY_MENU_QUEST_DESC);
                this._descText.setText("");
                this._descText.x = 40;
                this._descText.y = 216;
                this.addChild(this._descText);
            }
            set(questId) {
                const quest = $dataQuest.get(questId);
                const questContent = Life.Quest.getQuestContent(questId);
                if (questContent && quest) {
                    this._faceIcon.visible = true;
                    this._faceIcon.set(quest.character);
                    const actor = $gameActors.actor(quest.character);
                    this._characterText.setText(actor ? actor.name() : "");
                    const placeId = Life.Quest.getState(questId) === Life.QuestState.Unlocked
                        ? quest.condition_start_place
                        : questContent.place;
                    const place = $dataQuestPlace.get(placeId);
                    this._placeText.setText(place ? Life.Quest.getConditionName(place.type, place.type_id) : "");
                    const rewards = Life.Quest.getRewards(questId);
                    let rewardText = "";
                    if (rewards.length === 1) {
                        rewardText = Life.Quest.getRewardName(rewards[0]);
                    }
                    else if (rewards.length >= 2) {
                        rewardText = Iz.String.format(Iz.Text.get("MENU_QUEST_REWARDS_FORMAT"), Life.Quest.getRewardName(rewards[0]));
                    }
                    this._rewardText.setText(rewardText);
                    this._descText.setText(Life.Quest.convertEscapeCharacterQuest(placeId, questContent.desc));
                }
                else {
                    this._faceIcon.visible = false;
                    this._characterText.setText("");
                    this._placeText.setText("");
                    this._rewardText.setText("");
                    this._descText.setText("");
                }
            }
        }
        class QuestDetail extends Sprite {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.createTitle();
                this.createTitleText();
                this.createDetailContent();
            }
            createTitle() {
                this._titleBg = new Sprite();
                this._titleBg.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_TITLE_EVENT);
                this._titleBg.anchor.set(0.5, 0);
                this._titleBg.relativeAnchor.enable = true;
                this._titleBg.relativeAnchor.ratio.x = 0.5;
                this._titleBg.relativeAnchor.offset.x = 50;
                this._titleBg.relativeAnchor.offset.y = 20;
                this.addChild(this._titleBg);
            }
            createTitleText() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_EVENTLIST).getFrame(Life.FRAME_KEY_MENU_EVENTLIST_TITLE_EVENT);
                this._titleText = new Sprite_TextEx(frame.width, frame.height);
                this._titleText.setFontSetting(Life.FONT_KEY_MENU_QUEST_TITLE);
                this._titleText.setText("");
                this._titleText.setTextAlign(0.5, 0.5);
                this._titleText.relativeAnchor.enable = true;
                this._titleText.relativeAnchor.ratio = { x: 0.5, y: 0.5 };
                this._titleText.relativeAnchor.offset.y = -4;
                this._titleBg.addChild(this._titleText);
            }
            createDetailContent() {
                this._detailContent = new QuestDetailContent();
                this._detailContent.x = -320;
                this._detailContent.y = 102;
                this.addChild(this._detailContent);
            }
            set(questId) {
                const quest = Life.Quest.getQuestContent(questId);
                this._titleText.setText(quest ? quest.title : "");
                this._titleText.setTextAlign(0.5, 0.5);
                this._detailContent.set(questId);
            }
        }
        class QuestConditionContent extends Sprite {
            constructor() {
                // const bitmap = new Bitmap(384,32);
                // bitmap.fillAll("blue");
                // super(bitmap);
                super();
                this.create();
            }
            create() {
                this.createIcons();
                this.createText();
            }
            createIcons() {
                this._emptyMark = new Sprite();
                this._emptyMark.y = 6;
                this._emptyMark.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_POPUP_INFO_UNACHIEVE);
                this.addChild(this._emptyMark);
                this._meetMark = new Sprite();
                this._meetMark.y = 6;
                this._meetMark.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_POPUP_INFO_CLEAR);
                this.addChild(this._meetMark);
            }
            createText() {
                this._text = new Sprite_TextEx(784, 32);
                this._text.setFontSetting(Life.FONT_KEY_MENU_QUEST_POPUP_ELEMENT);
                this._text.setFontSize(20);
                this._text.x = 28;
                this._text.y = -4;
                this.addChild(this._text);
            }
            set(text, meet) {
                this._emptyMark.visible = !meet;
                this._meetMark.visible = meet;
                this._text.setText(text);
            }
        }
        const RewardMax = 4;
        const ConditionMax = 6;
        class QuestDetailPopup extends Iz.WindowBase {
            constructor() {
                super(new Rectangle(0, 0, 1, 1), new Iz.EasingOpenness(Iz.Easing.easeOutBack, Iz.Easing.easeInBack));
                this.setAtlas(Life.ATLAS_KEY_MENU_EVENTLIST, Life.FRAME_KEY_MENU_EVENTLIST_POPUP_INFO_BASE);
                const f = this._frame;
                this.setFrame(0, 0, f.width, f.height);
                this.create();
            }
            create() {
                this.createTitles();
                this.createRewardText();
                this.createConditions();
                this.createCloseButton();
                this.createCloseText();
            }
            createTitles() {
                const rewardTitle = new Sprite_Text(160, 32);
                rewardTitle.setAlign("center");
                rewardTitle.setFontSetting(Life.FONT_KEY_MENU_QUEST_POPUP_ELEMENT_TITLE);
                rewardTitle.x = -432;
                rewardTitle.y = -250;
                rewardTitle.setText(Iz.Text.get("MENU_QUEST_TITLE_REWARD"));
                this.addChild(rewardTitle);
                const conditionTitle = new Sprite_Text(160, 32);
                conditionTitle.setAlign("center");
                conditionTitle.setFontSetting(Life.FONT_KEY_MENU_QUEST_POPUP_ELEMENT_TITLE);
                conditionTitle.x = -430;
                conditionTitle.y = -36;
                this._conditionTitleText = conditionTitle;
                this.addChild(conditionTitle);
            }
            createRewardText() {
                this._rewardTexts = [];
                for (let i = 0; i < RewardMax; i++) {
                    const text = new Sprite_TextEx(800, 160);
                    text.setFontSetting(Life.FONT_KEY_MENU_QUEST_POPUP_ELEMENT);
                    text.x = -406;
                    text.y = -203 + i * 38;
                    this._rewardTexts.push(text);
                    this.addChild(text);
                }
            }
            createConditions() {
                this._conditions = [];
                for (let i = 0; i < ConditionMax; i++) {
                    const condition = new QuestConditionContent();
                    condition.visible = false;
                    condition.x = -410;
                    condition.y = 16 + i * 38;
                    this._conditions.push(condition);
                    this.addChild(condition);
                }
            }
            createCloseButton() {
                const sprite = new Life.AtlasImageSprite();
                sprite.set("cancel");
                sprite.x = 282;
                sprite.y = 242;
                this.addChild(sprite);
            }
            createCloseText() {
                const text = new Sprite_TextEx(160, 32);
                text.setFontSetting(Life.FONT_KEY_MENU_QUEST_POPUP_CLOSE);
                text.setText(Iz.Text.get("MENU_QUEST_POPUP_CLOSE"));
                text.relativeAnchor.enable = true;
                text.relativeAnchor.ratio.x = 1;
                text.relativeAnchor.ratio.y = 1;
                text.relativeAnchor.offset.x = -122;
                text.relativeAnchor.offset.y = -44;
                text.setTextAlign(0.5, 0.5);
                this.addChild(text);
            }
            set(questId) {
                const quest = $dataQuest.get(questId);
                const questContent = Life.Quest.getQuestContent(questId);
                if (questContent && quest) {
                    const rewards = Life.Quest.getRewards(questId);
                    for (let i = 0; i < this._rewardTexts.length; i++) {
                        if (!rewards[i]) {
                            this._rewardTexts[i].setText("");
                        }
                        else {
                            this._rewardTexts[i].setText(Life.Quest.getRewardName(rewards[i]));
                        }
                    }
                    if (Life.Quest.getState(questId) === Life.QuestState.Unlocked) {
                        this._conditionTitleText.setText(Iz.Text.get("MENU_QUEST_TITLE_CONDITION_UNLOCKED"));
                    }
                    else {
                        this._conditionTitleText.setText(Iz.Text.get("MENU_QUEST_TITLE_CONDITION_INPROGRESS"));
                    }
                    const conditionId = Life.Quest.getState(questId) === Life.QuestState.Unlocked
                        ? quest.condition_start
                        : questContent.condition_complete;
                    const list = Life.Quest.getConditionStatus(conditionId);
                    const infos = [];
                    if (list.or.length > 0) {
                        const text = list.or
                            .map((status) => Life.Quest.getConditionName(status.data.type, status.data.type_id))
                            .join(Iz.Text.get("QUEST_CONDITION_JOIN_OR"));
                        infos.push({ text: text, meet: list.or.some((status) => status.meet) });
                    }
                    list.and.forEach((status) => {
                        const text = Life.Quest.getConditionName(status.data.type, status.data.type_id);
                        infos.push({ text: text, meet: status.meet });
                    });
                    for (let i = 0; i < this._conditions.length; i++) {
                        const content = this._conditions[i];
                        if (i < infos.length) {
                            content.visible = true;
                            content.set(infos[i].text, infos[i].meet);
                        }
                        else {
                            content.visible = false;
                        }
                    }
                }
                else {
                    this._rewardTexts.forEach((r) => {
                        r.setText("");
                    });
                    this._conditions.forEach((c) => {
                        c.visible = false;
                    });
                }
            }
            setEnable(flg) {
                if (flg) {
                    this.open(true);
                    this.visible = true;
                }
                else {
                    this.close();
                    this.visible = false;
                }
            }
        }
        const SequenceKey_QuestList = "sequence_questlist";
        const SequenceKey_Popup = "sequence_popup";
        class QuestListSequence {
            constructor(content) {
                this._content = content;
                this._content.list.setOkHandler(() => {
                    this._clickedOk = true;
                });
            }
            onStart(arg) {
                this._content.list.activate();
                this._content.listHeader.activate();
                this._content.popupBg.visible = false;
                this._content.popup.setEnable(false);
            }
            changeQuestState(nextState) {
                if (this.validState(nextState)) {
                    const changed = this._content.setState(nextState);
                    if (changed) {
                        SoundManager.playCursor();
                    }
                }
            }
            onUpdate() {
                if (this._clickedOk) {
                    return true;
                }
                if (Input.isTriggered(Iz.IO.KEY_NAME_RIGHT)) {
                    const states = [...getStateOrder().values()];
                    const index = states.findIndex((s) => s === this._content.state);
                    const nextState = states[index + 1];
                    this.changeQuestState(nextState);
                }
                else if (Input.isTriggered(Iz.IO.KEY_NAME_LEFT)) {
                    const states = [...getStateOrder().values()];
                    const index = states.findIndex((s) => s === this._content.state);
                    const nextState = states[index - 1];
                    this.changeQuestState(nextState);
                }
                return false;
            }
            onFinish() {
                this._clickedOk = false;
            }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: SequenceKey_Popup,
                    output: {},
                };
            }
            validState(state) {
                return (state === Life.QuestState.InProgress ||
                    state === Life.QuestState.Complete ||
                    state === Life.QuestState.Unlocked);
            }
        }
        const PopupEasingTime = 10;
        class PopupSequence {
            constructor(content) {
                this._content = content;
            }
            updateAlpha() {
                this._content.popupBg.alpha = Iz.Easing.easeOutQuint.value(this._frame / PopupEasingTime);
            }
            onStart(arg) {
                this._content.list.deactivate();
                this._content.listHeader.deactivate();
                this._content.popupBg.visible = true;
                this._content.popup.setEnable(true);
                this._frame = 0;
                this.updateAlpha();
            }
            onUpdate() {
                this._frame++;
                if (this._frame >= PopupEasingTime) {
                    this._frame = PopupEasingTime;
                }
                this.updateAlpha();
                if (Input.isCancelled()) {
                    if (this._content.popup.isOpen()) {
                        SoundManager.playCancel();
                        return true;
                    }
                }
                return false;
            }
            onFinish() { }
            getResult() {
                return {
                    response: Iz.SequenceResponse.Complete,
                    nextSequence: SequenceKey_QuestList,
                    output: {},
                };
            }
        }
        class ContentQuest extends Life.MenuContentBase {
            constructor(w, h) {
                super(new Rectangle(0, 0, w, h));
                this.create();
                this.setState(Life.QuestState.InProgress);
            }
            get state() {
                return this._list.state;
            }
            get listHeader() {
                return this._header;
            }
            get list() {
                return this._list;
            }
            get popupBg() {
                return this._popupBg;
            }
            get popup() {
                return this._detailPopup;
            }
            create() {
                this.createList();
                this.createHeader();
                this.createDetail();
                this.createPopupBg();
                this.createDetailPopup();
                this.setupSequence();
                this.setState(Life.QuestState.InProgress);
            }
            createList() {
                this._list = new QuestList();
                this._list.setSelectHandler((index) => {
                    this.onSelect(index);
                });
                this._list.x = 8;
                this._list.y = 24;
                this.addChild(this._list);
            }
            createHeader() {
                this._header = new QuestListHeader();
                this._header.x = 16;
                this._header.y = 28;
                this._header.setHandler(this.onClickState.bind(this));
                this.addChild(this._header);
            }
            createDetail() {
                this._detail = new QuestDetail();
                this._detail.x = 780;
                this._detail.y = 10;
                this.addChild(this._detail);
            }
            createPopupBg() {
                const bitmap = new Bitmap(Graphics.width + 2, Graphics.height + 2);
                bitmap.fillAll("rgba(0, 0, 0, 0.6)");
                this._popupBg = new Sprite(bitmap);
                this._popupBg.x = -38;
                this._popupBg.y = -96;
                this.addChild(this._popupBg);
            }
            createDetailPopup() {
                this._detailPopup = new QuestDetailPopup();
                this._detailPopup.anchor.set(0.5, 0.5);
                this._detailPopup.x = this.width / 2;
                this._detailPopup.y = this.height / 2;
                this._detailPopup.visible = false;
                this.addChild(this._detailPopup);
            }
            setupSequence() {
                this._rootSequence = new Iz.RootSequence();
                {
                    const sequence = new QuestListSequence(this);
                    this._rootSequence.set(SequenceKey_QuestList, sequence, [
                        { dstSequence: SequenceKey_Popup },
                    ]);
                }
                {
                    const sequence = new PopupSequence(this);
                    this._rootSequence.set(SequenceKey_Popup, sequence, [
                        { dstSequence: SequenceKey_QuestList },
                    ]);
                }
                this._rootSequence.start({});
            }
            setState(state) {
                return this._list.setState(state);
            }
            onStart() { }
            onUpdate() {
                this._rootSequence.update();
            }
            onClickState(state) {
                this.setState(state);
            }
            onSelect(index) {
                this._detail.set(this._list.questId);
                this._detailPopup.set(this._list.questId);
            }
            backable() {
                if (this._rootSequence.isBusy())
                    return false;
                return this._rootSequence.key === SequenceKey_QuestList;
            }
            headerAtlas() {
                return {
                    atlasKey: Life.ATLAS_KEY_MENU_EVENTLIST,
                    frameKey: Life.FRAME_KEY_MENU_EVENTLIST_TITLE,
                };
            }
            footerText() {
                let text = "";
                text = Iz.Text.get("MENU_QUEST_FOOTER");
                return text;
            }
        }
        Life.ContentQuest = ContentQuest;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        class FaceIcon extends Sprite {
            constructor(actorId) {
                super();
                if (actorId) {
                    this.set(actorId);
                }
                else {
                    const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_MINIMAP).getFrame(Life.FRAME_KEY_MENU_MINIMAP_CHARACTER01);
                    this.setFrame(0, 0, frame.width, frame.height);
                }
            }
            set(actorId) {
                const strId = actorId.toString().padStart(2, "0");
                this.setAtlas(Life.ATLAS_KEY_MENU_MINIMAP, `character${strId}`);
            }
        }
        Life.FaceIcon = FaceIcon;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// スキル一覧（作業レベル）
(function (Iz) {
    var Life;
    (function (Life) {
        const WorkTypeMax = 5;
        class Scroll extends Life.ScrollBase {
            maxItems() {
                return WorkTypeMax;
            }
            drawItem(index) {
                const rect = this.itemRectWithPadding(index);
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SKILL);
                const bitmap = atlas.getBitmap();
                const workType = this.getWorkType(index);
                // bg
                const frame = atlas.getFrame(Life.FRAME_KEY_MENU_SKILL_WINDOW_LIST);
                this.contents.blt(bitmap, frame.x, frame.y, frame.width, frame.height, rect.x, rect.y);
                // icon
                const iconFrame = atlas.getFrame(this.getIconFrameKey(workType));
                this.contents.blt(bitmap, iconFrame.x, iconFrame.y, iconFrame.width, iconFrame.height, rect.x + 16, rect.y + Math.floor((rect.height - iconFrame.height) / 2));
                // text
                this.drawText(this.getWorkTypeText(workType), rect.x + 88, rect.y + 16);
                // level
                this.drawText(`Lv ${Life.Status.getWorkLevel(workType)}`, rect.x + 52, rect.y + 16, 192, "right");
                // gauge
                const gaugeFrame = atlas.getFrame(Life.FRAME_KEY_MENU_SKILL_GAUGE_FRAME_EXP);
                this.contents.blt(bitmap, gaugeFrame.x, gaugeFrame.y, gaugeFrame.width, gaugeFrame.height, rect.x + 84, rect.y + 58);
                const gauge = atlas.getFrame(Life.FRAME_KEY_MENU_SKILL_GAUGE_BAR_EXP);
                const gaugeRate = this.getGaugeRate(workType);
                if (gaugeRate > 0) {
                    this.contents.blt(bitmap, gauge.x, gauge.y, gauge.width, gauge.height, rect.x + 88, rect.y + 62, gauge.width * gaugeRate, gauge.height);
                }
                // arrow
                if (index === this.index()) {
                    const arrow = atlas.getFrame(Life.FRAME_KEY_MENU_SKILL_ARROW_RIGHT_HOVER);
                    this.contents.blt(bitmap, arrow.x, arrow.y, arrow.width, arrow.height, rect.x - 24, rect.y + (rect.height - arrow.height) / 2);
                }
            }
            getWorkType(index) {
                return (index + 1);
            }
            getWorkTypeText(workType) {
                return Life.getWorkTypeName(workType);
            }
            getIconFrameKey(workType) {
                const keys = [
                    "",
                    Life.FRAME_KEY_MENU_SKILL_ICON_FARM,
                    Life.FRAME_KEY_MENU_SKILL_ICON_DAIRY,
                    Life.FRAME_KEY_MENU_SKILL_ICON_MINING,
                    Life.FRAME_KEY_MENU_SKILL_ICON_PICK,
                    Life.FRAME_KEY_MENU_SKILL_ICON_FISHING,
                ];
                return keys[workType] ?? "";
            }
            getGaugeRate(type) {
                const maxLevel = Life.Status.getWorkLevelMax(type);
                const level = Life.Status.getWorkLevel(type);
                if (level >= maxLevel) {
                    return 1;
                }
                const nextLevel = Math.min(level + 1, maxLevel);
                const prevExp = $dataWorkLevelExp[level].exp_total;
                const nextExp = $dataWorkLevelExp[nextLevel].exp_total;
                const exp = Life.Status.getWorkLevelExp(type);
                const rate = (exp - prevExp) / (nextExp - prevExp);
                return rate;
            }
            resetTextColor() {
                this.setFontSetting(Life.FONT_KEY_MENU_SKILL_SCROLL_TEXT);
            }
        }
        class Content extends Sprite {
            constructor() {
                super();
                this.setAtlas(Life.ATLAS_KEY_MENU_SKILL, Life.FRAME_KEY_MENU_SKILL_WINDOW_SKILL);
                this.createTitle();
                this.createDescTitle();
                this.createDesc();
                this.createElementTitle();
                this.createElements();
            }
            createTitle() {
                this._title = new Sprite_Text(this.width, 32);
                this._title.setAlign("center");
                this._title.setFontSetting(Life.FONT_KEY_MENU_SKILL_CONTENT_TITLE);
                this._title.y = 32;
                this.addChild(this._title);
            }
            createDescTitle() {
                const text = new Sprite_Text(160, 32);
                text.setAlign("center");
                text.setFontSetting(Life.FONT_KEY_MENU_SKILL_CONTENT_TITLE);
                text.setText(Iz.Text.get("MENU_SKILL_DESC_TITLE"));
                text.x = 32;
                text.y = 100;
                this.addChild(text);
            }
            createDesc() {
                this._desc = new Sprite_TextEx(672, 300);
                this._desc.setFontSetting(Life.FONT_KEY_MENU_SKILL_CONTENT_ELEMENT);
                this._desc.setFontSize(20);
                this._desc.setText("");
                this._desc.move(56, 152);
                this.addChild(this._desc);
            }
            createElementTitle() {
                const text = new Sprite_Text(160, 32);
                text.setAlign("center");
                text.setFontSetting(Life.FONT_KEY_MENU_SKILL_CONTENT_TITLE);
                text.setText(Iz.Text.get("MENU_SKILL_TRAIT_TITLE"));
                text.x = 16;
                text.y = 344;
                this.addChild(text);
            }
            createElements() {
                this._elements = [];
                const ElementMax = 8;
                const baseX = 48;
                const baseY = 394;
                for (let i = 0; i < ElementMax; i++) {
                    const e = new Sprite_TextEx(384, 32);
                    e.setFontSetting(Life.FONT_KEY_MENU_SKILL_CONTENT_ELEMENT);
                    e.x = baseX + 404 * (i % 2);
                    e.y = baseY + 38 * Math.floor(i / 2);
                    e.setText("");
                    // e.setText("作物の収穫量+50% 作物の収穫量+50%");
                    this._elements[i] = e;
                    this.addChild(e);
                }
            }
            setWorkType(workType) {
                this._title.setText(Iz.Text.get(`WORK_TYPE_HIRAGANA_NAME_${workType}`));
                this._desc.setText(this.getDescText(workType));
                const traitTexts = this.getTraitTexts(workType);
                for (let i = 0; i < this._elements.length; i++) {
                    const traitText = traitTexts[i];
                    if (traitText) {
                        this._elements[i].setText(traitText);
                    }
                    else {
                        this._elements[i].setText("");
                    }
                }
            }
            getDescText(workType) {
                return Iz.Text.get(`WORK_TYPE_DETAIL_${workType}`) ?? "";
            }
            getTraitTexts(workType) {
                const textList = [];
                // パラメータ
                const traits = Life.Status.getWorkLevelTrait(workType);
                Life.Status.getTraitParams(traits).forEach((data) => {
                    // NOTE:
                    // 現状体力(MPを使用)のみ設定可
                    if (data.paramId === MZ.Trait.ParamId.MMp) {
                        const paramText = TextManager.mp;
                        if (data.plusValue !== 0) {
                            textList.push(Life.Status.getConstantText(paramText, data.plusValue));
                        }
                        if (data.rateValue !== 0) {
                            textList.push(Life.Status.getPercentText(paramText, data.rateValue));
                        }
                    }
                });
                // なかよし度ボーナス
                const likabilityBonus = Life.Status.getTraitLikabilityAddPercents(traits);
                if (likabilityBonus !== 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_LIKABILITY"), likabilityBonus));
                }
                // 釣りヒット確率
                const normalRate = Life.Status.getTraitFishingHitAddPercents(traits, false);
                if (normalRate > 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_FISHING_HIT_RATE_ADD_NORMAL"), normalRate));
                }
                const bigFishRate = Life.Status.getTraitFishingHitAddPercents(traits, true);
                if (bigFishRate > 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_FISHING_HIT_RATE_ADD_BIGFISH"), bigFishRate));
                }
                // 魚種グループ確率
                // Status.getFishGroups().forEach(fishGroup => {
                //     const fishGroupRate = Status.getTraitFishGroupAddPercents(traits,fishGroup);
                //     // TODO: 魚種グループごとの名前
                //     const title = Text.get("TRAIT_FISH_GROUP_RATE");
                //     textList.push(Status.getPercentText(title,fishGroupRate));
                // });
                // 追加スキル
                Life.Status.getTraitSkills(traits).forEach((skillId) => {
                    const skill = $dataSkills[skillId];
                    if (skill) {
                        textList.push(skill.name);
                    }
                });
                // オノダメージアップ
                const damageAx = Life.Status.getTraitDamageAx(traits);
                if (damageAx !== 0) {
                    textList.push(Life.Status.getConstantText(Iz.Text.get("TRAIT_DAMAGE_AX"), damageAx));
                }
                // ハンマーダメージアップ
                const damageHammer = Life.Status.getTraitDamageHammer(traits);
                if (damageHammer !== 0) {
                    textList.push(Life.Status.getConstantText(Iz.Text.get("TRAIT_DAMAGE_HAMMER"), damageHammer));
                }
                // 疲労耐性
                const fatigue = Life.Status.getTraitFatigue(traits);
                if (fatigue !== 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_FATIGUE_RESIST"), fatigue));
                }
                // 体力消費耐性
                const consumes = Life.Status.getTraitConsumeHp(traits);
                if (consumes.constantValue !== 0) {
                    textList.push(Life.Status.getConstantText(Iz.Text.get("TRAIT_HP_RESIST"), consumes.constantValue));
                }
                if (consumes.rateValue !== 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_HP_RESIST"), consumes.rateValue));
                }
                // 収穫量アップ
                const harvest = Life.Status.getTraitHarvest(traits);
                if (harvest !== 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_HARVEST"), harvest));
                }
                // 鉱石入手量アップ
                const mining = Life.Status.getTraitMining(traits);
                if (mining !== 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_MINING"), mining));
                }
                // 採取入手量アップ
                const pickup = Life.Status.getTraitPickup(traits);
                if (pickup !== 0) {
                    textList.push(Life.Status.getPercentText(Iz.Text.get("TRAIT_PICKUP"), pickup));
                }
                return textList;
            }
        }
        class Profile extends Sprite {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.createContent();
            }
            createContent() {
                this._content = new Content();
                this.addChild(this._content);
            }
            setWorkType(workType) {
                this._content.setWorkType(workType);
            }
        }
        class ContentWorkLevel extends Life.MenuContentBase {
            constructor(w, h) {
                super(new Rectangle(0, 0, w, h));
                this.create();
                this._scroll.setSelectHandler(this.onSelect.bind(this));
                this._scroll.select(0);
            }
            create() {
                this.createScroll();
                this.createProfile();
            }
            createScroll() {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SKILL);
                const frame = atlas.getFrame(Life.FRAME_KEY_MENU_SKILL_WINDOW_LIST);
                this._scroll = new Scroll({
                    height: 600,
                    itemContentWidth: frame.width,
                    itemContentHeight: frame.height,
                    itemPad: { x: 0, y: 0 },
                    colSpacing: 64,
                    rowSpacing: 12,
                });
                this._scroll.activate();
                this._scroll.x = -4;
                this._scroll.y = 28;
                this.addChild(this._scroll);
            }
            createProfile() {
                this._profile = new Profile();
                this._profile.move(312, 40);
                this.addChild(this._profile);
            }
            onStart() { }
            onUpdate() { }
            onSelect(index) {
                this._profile.setWorkType((index + 1));
            }
            backable() {
                return true;
            }
            headerAtlas() {
                return {
                    atlasKey: Life.ATLAS_KEY_MENU_SKILL,
                    frameKey: Life.FRAME_KEY_MENU_SKILL_TITLE,
                };
            }
            footerText() {
                return Iz.Text.get("MENU_SKILL_FOOTER");
            }
        }
        Life.ContentWorkLevel = ContentWorkLevel;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 小屋
(function (Iz) {
    var Life;
    (function (Life) {
        class Header extends Sprite {
            constructor() {
                super();
                const w = 1150;
                const h = 76;
                this.setFrame(0, 0, w, h);
                this.create();
            }
            create() {
                this.createBg();
                this.createHappiness();
                this.createShedLevel();
                this.createLivestocks();
                this.createFeeds();
            }
            createBg() {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SHED);
                const frame = atlas.getFrame(Life.FRAME_KEY_MENU_SHED_HOUSE_INFO_BASE);
                this._bg = new HorizontalSlicedSprite(atlas.getBitmap());
                this._bg.setBitmapRect(new Rectangle(frame.x, frame.y, frame.width, frame.height));
                this._bg.setSlice(48, 48);
                this._bg.setSize(this.width);
                this._bg.x = 26;
                this._bg.y = 8;
                this.addChild(this._bg);
                this._root = new Sprite();
                this._root.x = -8;
                this._bg.addChild(this._root);
            }
            createHappiness() {
                const mark = new Sprite();
                mark.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_HAERT_FULL);
                mark.x = 64;
                mark.y = 27;
                this._root.addChild(mark);
                const happinessBg = new Sprite();
                happinessBg.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_TOTAL_HAPPINESS_BASE);
                happinessBg.x = 231;
                happinessBg.y = 13;
                // happinessBg.setBlendColor([255,255,0,255]);  // 確認用
                this._root.addChild(happinessBg);
                const text = new Sprite_TextEx(192, 40);
                text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_ELEMENT);
                text.setText(Iz.Text.get("MENU_SHED_TOTAL_HAPPINESS"));
                text.x = 96;
                text.y = 18;
                this._root.addChild(text);
                this._happiness = new Sprite_Text(172, 40);
                this._happiness.setAlign("center");
                this._happiness.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_ELEMENT);
                this._happiness.x = 231;
                this._happiness.y = 18;
                this._happiness.setText("12345678");
                this._root.addChild(this._happiness);
            }
            createHeaderTitleText() {
                const text = new Sprite_Text(138, 40);
                text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                text.setAlign("center");
                return text;
            }
            createHeaderElementText() {
                const text = new Sprite_Text(138, 40);
                text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_ELEMENT);
                text.setAlign("center");
                return text;
            }
            createShedLevel() {
                const bg = new Sprite();
                bg.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_INFO_LABEL);
                bg.x = 407;
                bg.y = 20;
                this._root.addChild(bg);
                const text = this.createHeaderTitleText();
                text.setText(Iz.Text.get("MENU_SHED_SHED_LEVEL"));
                text.x = 401;
                text.y = 17;
                this._root.addChild(text);
                this._shedLevel = this.createHeaderElementText();
                this._shedLevel.x = 518;
                this._shedLevel.y = 18;
                this._root.addChild(this._shedLevel);
            }
            createLivestocks() {
                const bg = new Sprite();
                bg.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_INFO_LABEL);
                bg.x = 636;
                bg.y = 20;
                this._root.addChild(bg);
                const text = this.createHeaderTitleText();
                text.setText(Iz.Text.get("MENU_SHED_LIVESTOCK_NUM"));
                text.x = 630;
                text.y = 17;
                this._root.addChild(text);
                this._livestocks = this.createHeaderElementText();
                this._livestocks.x = 752;
                this._livestocks.y = 18;
                this._root.addChild(this._livestocks);
            }
            createFeeds() {
                const bg = new Sprite();
                bg.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_INFO_LABEL);
                bg.x = 880;
                bg.y = 20;
                this._root.addChild(bg);
                const text = this.createHeaderTitleText();
                text.setText(Iz.Text.get("MENU_SHED_FEEDS"));
                text.x = 874;
                text.y = 17;
                this._root.addChild(text);
                this._feeds = this.createHeaderElementText();
                this._feeds.x = 994;
                this._feeds.y = 18;
                this._root.addChild(this._feeds);
            }
            set(shedId) {
                this._happiness.setText(`${Life.DairyUtil.getHappinessShed(shedId)}`);
                const shedLevel = Life.getLivestockShedLevel(shedId);
                this._shedLevel.setText(`Lv${shedLevel}`);
                const shedLevelMax = Life.getLivestockShedMaxLevel(shedId);
                this._livestocks.setText(`${Life.Dairy.getShedLivestocks(shedId).length}/${Life.getLivestockLimit(shedId, shedLevelMax)}`);
                const shed = Life.Dairy.livestockSheds.find((shed) => shed && shed.id === shedId);
                let text = "0/0";
                if (shed) {
                    const len = shed.feeds.filter((feed) => feed.amount > 0).length;
                    text = `${len}/${shed.feeds.length}`;
                }
                this._feeds.setText(text);
            }
        }
        function getIconList(livestock) {
            const res = {
                feed: "",
                brushing: "",
                talk: "",
                product: "",
            };
            res.feed = livestock.producted
                ? Life.FRAME_KEY_MENU_SHED_ICON_FOOD_ON
                : Life.FRAME_KEY_MENU_SHED_ICON_FOOD_OFF;
            res.brushing = livestock.cared
                ? Life.FRAME_KEY_MENU_SHED_ICON_BLUSH_ON
                : Life.FRAME_KEY_MENU_SHED_ICON_BLUSH_OFF;
            res.talk = livestock.talked
                ? Life.FRAME_KEY_MENU_SHED_ICON_TALK_ON
                : Life.FRAME_KEY_MENU_SHED_ICON_TALK_OFF;
            let product = "";
            if (livestock.type === Life.Data.LivestockType.Cow) {
                if (livestock.canProducted()) {
                    product = Life.FRAME_KEY_MENU_SHED_ICON_MILK_ON;
                }
                else {
                    product = Life.FRAME_KEY_MENU_SHED_ICON_MILK_OFF;
                }
            }
            else if (livestock.type === Life.Data.LivestockType.Chicken) {
                if (livestock.canProducted()) {
                    product = Life.FRAME_KEY_MENU_SHED_ICON_EGG_ON;
                }
                else {
                    product = Life.FRAME_KEY_MENU_SHED_ICON_EGG_OFF;
                }
            }
            res.product = product;
            return res;
        }
        class Scroll extends Life.ScrollBase {
            get livestock() {
                return this.livestocks[this.index()];
            }
            get livestocks() {
                return Life.Dairy.getShedLivestocks(this.shedId);
            }
            get livestockLimit() {
                const levelMax = Life.getLivestockShedMaxLevel(this.shedId);
                const limit = Life.getLivestockLimit(this.shedId, levelMax);
                return limit;
            }
            get currentLivestockLimit() {
                const shedLevel = Life.getLivestockShedLevel(this.shedId);
                const limit = Life.getLivestockLimit(this.shedId, shedLevel);
                return limit;
            }
            get shedId() {
                return this._getShedIdHandler?.() ?? 0;
            }
            maxItems() {
                return this.livestockLimit;
            }
            drawItem(index) {
                const rect = this.itemRectWithPadding(index);
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SHED);
                const bitmap = atlas.getBitmap();
                if (index < this.currentLivestockLimit) {
                    const f = atlas.getFrame(Life.FRAME_KEY_MENU_SHED_LIST_BASE);
                    this.contents.blt(bitmap, f.x, f.y, f.width, f.height, rect.x, rect.y);
                    const livestock = this.livestocks[index];
                    if (livestock) {
                        // icon
                        const iconF = atlas.getFrame(`livestock_${livestock.id}`);
                        this.contents.blt(bitmap, iconF.x, iconF.y, iconF.width, iconF.height, rect.x + 20, rect.y + 19);
                        // 名前
                        this.drawTextEx(livestock.name, rect.x + 96, rect.y + 16, rect.width);
                        // なつき度
                        const heartF = atlas.getFrame(Life.FRAME_KEY_MENU_SHED_HAERT_FULL);
                        this.contents.blt(bitmap, heartF.x, heartF.y, heartF.width, heartF.height, rect.x + 92, rect.y + 56);
                        const happinessText = `\\FSET[${Life.FONT_KEY_MENU_SHED_LIVESTOCK_HAPPINESS}]${livestock.happiness}\\FRESET`;
                        this.drawTextEx(happinessText, rect.x + 120, rect.y + 52, rect.width);
                        // お世話状況アイコン
                        const iconList = getIconList(livestock);
                        const feedF = atlas.getFrame(iconList.feed);
                        this.contents.blt(bitmap, feedF.x, feedF.y, feedF.width, feedF.height, rect.x + 178, rect.y + 52);
                        const brushF = atlas.getFrame(iconList.brushing);
                        this.contents.blt(bitmap, brushF.x, brushF.y, brushF.width, brushF.height, rect.x + 220, rect.y + 52);
                        const talkF = atlas.getFrame(iconList.talk);
                        this.contents.blt(bitmap, talkF.x, talkF.y, talkF.width, talkF.height, rect.x + 262, rect.y + 52);
                        const productF = atlas.getFrame(iconList.product);
                        this.contents.blt(bitmap, productF.x, productF.y, productF.width, productF.height, rect.x + 304, rect.y + 52);
                    }
                }
                else {
                    const frame = atlas.getFrame(Life.FRAME_KEY_MENU_SHED_LIST_LOCK);
                    this.contents.blt(atlas.getBitmap(), frame.x, frame.y, frame.width, frame.height, rect.x, rect.y);
                }
                if (index === this.index()) {
                    const frame = atlas.getFrame(Life.FRAME_KEY_MENU_SHED_ARROW_RIGHT_HOVER);
                    this.contents.blt(atlas.getBitmap(), frame.x, frame.y, frame.width, frame.height, rect.x - 4, rect.y + (rect.height - frame.height) / 2);
                }
            }
            resetTextColor() {
                this.setFontSetting(Life.FONT_KEY_MENU_SHED_LIVESTOCK_NAME);
            }
            setGetShedIdHandler(handler) {
                this._getShedIdHandler = handler;
            }
        }
        const HeartMax = 5;
        class Detail extends Sprite {
            constructor() {
                super();
                this.create();
            }
            create() {
                this.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_INFOBASE);
                this.createName();
                this.createPhoto();
                this.createTitles();
                this.createHappiness();
                this.createDate();
                this.createCares();
                this.createState();
                this.createProductRank();
            }
            createName() {
                this._name = new Sprite_Text(384, 32);
                this._name.setAlign("center");
                this._name.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                this._name.x = 32;
                this._name.y = 24;
                this.addChild(this._name);
            }
            createPhoto() {
                const sprite = new Sprite();
                sprite.x = 128;
                sprite.y = 64;
                sprite.setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_PHOTO_BG);
                this.addChild(sprite);
                this._photo = new Sprite();
                this._photo.x = 128;
                this._photo.y = 64;
                this.addChild(this._photo);
            }
            createTitles() {
                {
                    const text = new Sprite_Text(144, 32);
                    text.setAlign("center");
                    text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                    text.setText(Iz.Text.get("MENU_SHED_DETAIL_HAPPINESS"));
                    text.x = 28;
                    text.y = 259;
                    this.addChild(text);
                }
                {
                    const text = new Sprite_Text(144, 32);
                    text.setAlign("center");
                    text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                    text.setText(Iz.Text.get("MENU_SHED_DETAIL_DATE"));
                    text.x = 28;
                    text.y = 313;
                    this.addChild(text);
                }
                {
                    const text = new Sprite_Text(144, 32);
                    text.setAlign("center");
                    text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                    text.setText(Iz.Text.get("MENU_SHED_DETAIL_CARE"));
                    text.x = 28;
                    text.y = 367;
                    this.addChild(text);
                }
                {
                    const text = new Sprite_Text(144, 32);
                    text.setAlign("center");
                    text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                    text.setText(Iz.Text.get("MENU_SHED_DETAIL_STATE"));
                    text.x = 28;
                    text.y = 420;
                    this.addChild(text);
                }
                {
                    const text = new Sprite_Text(144, 32);
                    text.setAlign("center");
                    text.setFontSetting(Life.FONT_KEY_MENU_SHED_HEADER_TITLE);
                    text.setText(Iz.Text.get("MENU_SHED_DETAIL_PRODUCT_RANK"));
                    text.x = 28;
                    text.y = 473;
                    this.addChild(text);
                }
            }
            createHappiness() {
                this._emptyHearts = [];
                this._hearts = [];
                for (let i = 0; i < HeartMax; i++) {
                    this._emptyHearts[i] = new Sprite();
                    this._emptyHearts[i].setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_HEART_BLANK);
                    this._emptyHearts[i].x = 188 + i * 25;
                    this._emptyHearts[i].y = 266;
                    this.addChild(this._emptyHearts[i]);
                    this._hearts[i] = new Sprite();
                    this._hearts[i].setAtlas(Life.ATLAS_KEY_MENU_SHED, Life.FRAME_KEY_MENU_SHED_HAERT_FULL);
                    this._hearts[i].x = 188 + i * 25;
                    this._hearts[i].y = 266;
                    this.addChild(this._hearts[i]);
                }
            }
            createDate() {
                this._date = new Sprite_TextEx(240, 32);
                this._date.setFontSetting(Life.FONT_KEY_MENU_SHED_DETAIL_ELEMENT);
                this._date.x = 188;
                this._date.y = 310;
                this.addChild(this._date);
            }
            createCares() {
                this._feed = new Sprite();
                this._brushing = new Sprite();
                this._talk = new Sprite();
                this._product = new Sprite();
                this.addChild(this._feed);
                this.addChild(this._brushing);
                this.addChild(this._talk);
                this.addChild(this._product);
                this._feed.move(190, 366);
                this._brushing.move(246, 366);
                this._talk.move(302, 366);
                this._product.move(358, 366);
            }
            createState() {
                this._state = new Sprite_TextEx(240, 32);
                this._state.setFontSetting(Life.FONT_KEY_MENU_SHED_DETAIL_ELEMENT);
                this._state.x = 188;
                this._state.y = 416;
                this.addChild(this._state);
            }
            createProductRank() {
                this._productRank = new Sprite_TextEx(240, 32);
                this._productRank.setFontSetting(Life.FONT_KEY_MENU_SHED_DETAIL_ELEMENT);
                this._productRank.x = 188;
                this._productRank.y = 468;
                this.addChild(this._productRank);
            }
            set(livestock) {
                if (livestock) {
                    this._name.setText(livestock.name);
                    this._photo.setAtlas(Life.ATLAS_KEY_MENU_SHED, `photo_${livestock.id}`);
                }
                else {
                    this._name.setText("");
                    this._photo.setAtlas(Life.ATLAS_KEY_MENU_SHED, "");
                }
                this.setHearts(livestock);
                this.setDate(livestock);
                this.setCares(livestock);
                this.setState(livestock);
                this.setProductRank(livestock);
            }
            setHearts(livestock) {
                if (!livestock) {
                    this._emptyHearts.forEach((h) => {
                        h.visible = false;
                    });
                    this._hearts.forEach((h) => {
                        h.visible = false;
                    });
                    return;
                }
                const expRate = Math.min(Math.max(livestock.happiness / $parameter.dairy.happiness_max, 0), 1);
                // 塗りつぶす個数
                let fillNum = expRate * this._hearts.length;
                for (let i = 0; i < this._hearts.length; i++) {
                    let rate = 0;
                    if (fillNum >= 1) {
                        rate = 1;
                        fillNum--;
                    }
                    else if (fillNum > 0) {
                        rate = fillNum;
                        fillNum = 0;
                    }
                    else {
                        rate = 0;
                    }
                    this._emptyHearts[i].visible = true;
                    this._hearts[i].visible = true;
                    const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SHED).getFrame(Life.FRAME_KEY_MENU_SHED_HAERT_FULL);
                    const w = frame.width * rate;
                    this._hearts[i].setFrame(frame.x, frame.y, w, frame.height);
                }
            }
            setDate(livestock) {
                if (livestock) {
                    this._date.setText(Iz.System.getDaysText(livestock.startHaveMonth, livestock.startHaveDay));
                }
                else {
                    this._date.setText("");
                }
            }
            setCares(livestock) {
                this._feed.visible = !!livestock;
                this._brushing.visible = !!livestock;
                this._talk.visible = !!livestock;
                this._product.visible = !!livestock;
                if (livestock) {
                    const list = getIconList(livestock);
                    this._feed.setAtlas(Life.ATLAS_KEY_MENU_SHED, list.feed);
                    this._brushing.setAtlas(Life.ATLAS_KEY_MENU_SHED, list.brushing);
                    this._talk.setAtlas(Life.ATLAS_KEY_MENU_SHED, list.talk);
                    this._product.setAtlas(Life.ATLAS_KEY_MENU_SHED, list.product);
                }
            }
            setState(livestock) {
                if (livestock) {
                    const texts = [];
                    texts.push(livestock.producted
                        ? Iz.Text.get("MENU_SHED_DETAIL_STATE_GOOD_MOOD")
                        : Iz.Text.get("MENU_SHED_DETAIL_STATE_BAD_MOOD"));
                    if (livestock.pregnant) {
                        texts.push(Iz.Text.get("MENU_SHED_DETAIL_STATE_PREGNANT"));
                    }
                    this._state.setText(texts.join(" / "));
                }
                else {
                    this._state.setText("");
                }
            }
            setProductRank(livestock) {
                if (livestock) {
                    let rankText = "";
                    const rank = livestock.productRank;
                    if (rank === Life.LivestockProductRank.L) {
                        rankText = "L";
                    }
                    else if (rank === Life.LivestockProductRank.M) {
                        rankText = "M";
                    }
                    else {
                        rankText = "S";
                    }
                    const format = Iz.Text.get("MENU_SHED_DETAIL_PRODUCT_RANK_FORMAT");
                    this._productRank.setText(Iz.String.format(format, rankText));
                }
                else {
                    this._productRank.setText("");
                }
            }
        }
        class ContentShed extends Life.MenuContentBase {
            constructor(w, h, shedId, getNameEdit) {
                super(new Rectangle(0, 0, w, h));
                this.shedList = [1, 2];
                this._shedIndex = -1;
                this.create();
                this._scroll.activate();
                this.setShed(shedId);
                this._getNameEdit = getNameEdit;
            }
            get shedId() {
                return this.shedList[this._shedIndex] ?? 0;
            }
            get nameEdit() {
                return this._getNameEdit();
            }
            create() {
                this.createHeader();
                this.createScroll();
                this.createDetail();
                this.createSubMenu();
            }
            createHeader() {
                this._header = new Header();
                this.addChild(this._header);
            }
            createScroll() {
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_MENU_SHED).getFrame(Life.FRAME_KEY_MENU_SHED_LIST_BASE);
                this._scroll = new Scroll({
                    height: 568,
                    itemContentWidth: frame.width,
                    itemContentHeight: frame.height,
                    maxCol: 2,
                    itemPad: { x: 0, y: 0 },
                    colSpacing: 6,
                    rowSpacing: 6,
                });
                this._scroll.setGetShedIdHandler(() => this.shedId);
                this._scroll.setSelectHandler((index) => {
                    this.onSelect(index);
                });
                this._scroll.x = 12;
                this._scroll.y = 76;
                this.addChild(this._scroll);
            }
            createDetail() {
                this._detail = new Detail();
                this._detail.x = 752;
                this._detail.y = 90;
                this.addChild(this._detail);
            }
            createSubMenu() {
                this._subMenu = new Life.SubMenuWindow();
                this.addChild(this._subMenu);
                this._subMenu.deactivate();
                this._subMenu.visible = false;
            }
            onStart() { }
            onUpdate() {
                // NOTE:
                // 小屋ページは他のページと切り替えることがない前提
                if (!this._scroll.active)
                    return;
                if (Input.isTriggered(Iz.IO.KEY_NAME_SLOT_RIGHT)) {
                    let index = this._shedIndex + 1;
                    if (index >= this.shedList.length) {
                        index = 0;
                    }
                    this.setShed(this.shedList[index]);
                }
                else if (Input.isTriggered(Iz.IO.KEY_NAME_SLOT_LEFT)) {
                    let index = this._shedIndex - 1;
                    if (index < 0) {
                        index = this.shedList.length - 1;
                    }
                    this.setShed(this.shedList[index]);
                }
                else if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_SUBMENU)) {
                    if (!this._scroll.livestock)
                        return;
                    this._scroll.deactivate();
                    if (this._scroll.livestock.forSale()) {
                        this._subMenu.setList(Life.SubMenutype.Sell, Life.SubMenutype.EditName, Life.SubMenutype.Cancel);
                        this._subMenu.grid.select(2);
                    }
                    else {
                        this._subMenu.setList(Life.SubMenutype.EditName, Life.SubMenutype.Cancel);
                        this._subMenu.grid.select(1);
                    }
                    this._subMenu.grid.setHandler(Iz.GridEventType.Ok, () => {
                        this._subMenu.deactivate();
                        this._subMenu.visible = false;
                        // 売却
                        if (this._subMenu.subMenuType === Life.SubMenutype.Sell && this._scroll.livestock) {
                            const res = this.openSellDialog(this._scroll.livestock);
                            if (res) {
                                this._scroll.deactivate();
                            }
                            else {
                                this._scroll.activate();
                            }
                        }
                        // 名前変更
                        else if (this._subMenu.subMenuType === Life.SubMenutype.EditName) {
                            this.openNameEditWindow();
                        }
                        else {
                            this._scroll.activate();
                        }
                    });
                    this._subMenu.grid.setHandler(Iz.GridEventType.Cancel, () => {
                        this._subMenu.deactivate();
                        this._subMenu.visible = false;
                        this._scroll.activate();
                    });
                    this._subMenu.visible = true;
                    this._subMenu.activate();
                    const rect = this._scroll.itemRectWithPadding(this._scroll.index());
                    this._subMenu.x = this._scroll.x + rect.x + 64;
                    this._subMenu.y = this._scroll.y + rect.y;
                }
            }
            openSellDialog(livestock) {
                const option = Life.createDialogOption("dairy_sell");
                if (!option)
                    return false;
                option.title = Iz.String.format(option.title, livestock.name);
                option.text = Iz.String.format(option.text, livestock.sellPrice);
                option.yesHandler = () => {
                    this.sell(livestock);
                    this._scroll.activate();
                };
                option.noHandler = () => {
                    this._scroll.activate();
                };
                Life.Dialog.open(option);
                return true;
            }
            openNameEditWindow() {
                this.nameEdit.clearName();
                this.nameEdit.setHandler(() => {
                    const livestock = this._scroll.livestock;
                    if (livestock) {
                        livestock.name = this.nameEdit.editName;
                    }
                    this.nameEdit.visible = false;
                    this.nameEdit.setActive(false);
                    this._scroll.activate();
                });
                this.nameEdit.visible = true;
                this.nameEdit.setActive(true);
            }
            sell(livestock) {
                $gameParty.gainGold(livestock.sellPrice);
                Life.Dairy.removeLivestock(livestock.index);
                Iz.System.playCoin();
                this.refreshPage();
            }
            onSelect(index) {
                this._detail.set(this._scroll.livestock);
            }
            setShed(shedId) {
                let index = this.shedList.findIndex((shed) => shed === shedId);
                if (index < 0) {
                    index = 0;
                }
                if (index === this._shedIndex) {
                    return;
                }
                this._shedIndex = index;
                this._header.set(this.shedId);
                this._scroll.refresh();
                this._detail.set(this._scroll.livestock);
            }
            backable() {
                return this._scroll.active && !this.isDialogOpen();
            }
            headerAtlas() {
                return {
                    atlasKey: Life.ATLAS_KEY_MENU_SHED,
                    frameKey: `title_${this.shedId}`,
                };
            }
            footerText() {
                return Iz.Text.get("MENU_SHED_FOOTER");
            }
            refreshPage() {
                this._scroll.refresh();
                this._detail.set(this._scroll.livestock);
            }
            isDialogOpen() {
                return Life.Dialog.isBusy();
            }
        }
        Life.ContentShed = ContentShed;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// 有効化
(function (Iz) {
    var Life;
    (function (Life) {
        const SwitchId_MenuPage = 1033;
        function isEnableMenuPage() {
            return $gameSwitches.value(SwitchId_MenuPage);
        }
        Life.isEnableMenuPage = isEnableMenuPage;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
// メニュー
(function (Iz) {
    var Life;
    (function (Life) {
        Life.MenuPage = {
            Quest: 0, // イベントリスト
            ItemSlot: 1, // アイテムスロット
            Residents: 2, // 住民一覧
            Minimap: 3, // ミニマップ
            WorkLevel: 4, // スキル
            Shed: 5,
        };
        const DefaultPages = [
            Life.MenuPage.Quest,
            Life.MenuPage.ItemSlot,
            Life.MenuPage.Residents,
            Life.MenuPage.Minimap,
            Life.MenuPage.WorkLevel,
        ];
        Life.MenuOptionParam = {
            page: 0,
            visiblePages: [],
            shedId: 1,
        };
        Life.requestMenuFlg = false;
        function setVisiblePages(pages) {
            Life.MenuOptionParam.visiblePages = [...pages];
        }
        Life.setVisiblePages = setVisiblePages;
        function setDefaultPages() {
            setVisiblePages(DefaultPages);
        }
        Life.setDefaultPages = setDefaultPages;
        // マップシーンから呼ばないと使えません
        function requestMenu(menuPage) {
            const scene = SceneManager._scene;
            if (scene instanceof Scene_Map) {
                Life.MenuOptionParam.page = menuPage;
                setDefaultPages();
                Life.requestMenuFlg = true;
            }
            return false;
        }
        Life.requestMenu = requestMenu;
        function requestShedMenu(shedId) {
            const scene = SceneManager._scene;
            if (scene instanceof Scene_Map) {
                Life.MenuOptionParam.page = Life.MenuPage.Shed;
                Life.MenuOptionParam.visiblePages = [Life.MenuPage.Shed];
                Life.MenuOptionParam.shedId = shedId;
                Life.requestMenuFlg = true;
            }
            return false;
        }
        Life.requestShedMenu = requestShedMenu;
        function initializeMenu() {
            Life.MenuOptionParam = {
                page: Life.MenuPage.ItemSlot,
                visiblePages: [...DefaultPages],
                shedId: 1,
            };
        }
        Life.initializeMenu = initializeMenu;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        class MenuScene extends Scene_Base {
            get content() {
                return this._contents[this._pageIndex].content;
            }
            start() {
                super.start();
                this._pageIndex = -1;
                this.createBackground();
                this.createFooter();
                this.createBaseWindow();
                this.createHeader();
                this.createContents();
                this.createNameEdit();
                this.createDialogUI();
                const index = this._contents.findIndex((c) => c.page === Iz.Life.MenuOptionParam.page);
                this.changePage(index >= 0 ? index : 0);
                this._baseWindow.open(true);
            }
            createBackground() {
                this._bg = new Sprite(SceneManager.backgroundBitmap());
                this._filter = new PIXI.filters.BlurFilter();
                this._bg.filters = [this._filter];
                this.addChild(this._bg);
            }
            createBaseWindow() {
                this._baseWindow = Iz.Life.createMenuWindow();
                this._baseWindow.y = Math.floor(this._baseWindow.y - 16);
                // this._baseWindow.bitmap?.fillAll("yellow"); // 領域確認用
                this.addChild(this._baseWindow);
            }
            createHeader() {
                this._headerBg = new Sprite();
                this._headerBg.setAtlas(Life.ATLAS_KEY_MENU_COMMON, Life.FRAME_KEY_MENU_COMMON_TITLE_BG);
                this._headerBg.anchor.set(0.5, 0.5);
                this._headerBg.relativeAnchor.enable = true;
                this._headerBg.relativeAnchor.ratio = { x: 0.5, y: 0 };
                this._headerBg.relativeAnchor.offset = { x: 0, y: 48 };
                this._baseWindow.addChild(this._headerBg);
                this._headerLeftArrow = new Life.InputSprite();
                this._headerLeftArrow.set([
                    { atlasKey: Life.ATLAS_KEY_MENU_COMMON, frameKey: Life.FRAME_KEY_MENU_COMMON_TITLE_Q },
                    { atlasKey: Life.ATLAS_KEY_MENU_COMMON, frameKey: Life.FRAME_KEY_MENU_COMMON_TITLE_L },
                ]);
                this._headerLeftArrow.x = -328;
                this._headerLeftArrow.y = -16;
                this._headerBg.addChild(this._headerLeftArrow);
                this._headerRightArrow = new Life.InputSprite();
                this._headerRightArrow.set([
                    { atlasKey: Life.ATLAS_KEY_MENU_COMMON, frameKey: Life.FRAME_KEY_MENU_COMMON_TITLE_E },
                    { atlasKey: Life.ATLAS_KEY_MENU_COMMON, frameKey: Life.FRAME_KEY_MENU_COMMON_TITLE_R },
                ]);
                this._headerRightArrow.x = 272;
                this._headerRightArrow.y = -16;
                this._headerBg.addChild(this._headerRightArrow);
                this._headerText = new Sprite();
                this._headerText.anchor.set(0.5, 0.5);
                this._headerBg.addChild(this._headerText);
            }
            createContents() {
                this._contents = [];
                for (let i = 0; i < Life.MenuOptionParam.visiblePages.length; i++) {
                    const visiblePage = Life.MenuOptionParam.visiblePages[i];
                    switch (visiblePage) {
                        case Life.MenuPage.ItemSlot:
                            this.createContent_ItemSlot();
                            break;
                        case Life.MenuPage.Residents:
                            this.createContent_Resident();
                            break;
                        case Life.MenuPage.Minimap:
                            this.createContent_MiniMap();
                            break;
                        case Life.MenuPage.Quest:
                            this.createContent_Quest();
                            break;
                        case Life.MenuPage.WorkLevel:
                            this.createContent_WorkLevel();
                            break;
                        case Life.MenuPage.Shed:
                            this.createContent_Shed();
                            break;
                    }
                }
                this._contents.forEach((c) => {
                    c.content.relativeAnchor.enable = true;
                    c.content.relativeAnchor.offset = { x: 16, y: 80 };
                    this._baseWindow.addChild(c.content);
                });
            }
            createContent_ItemSlot() {
                const rect = this.contentRect();
                const content = new Iz.Life.ContentItemSlot(rect.width, rect.height);
                this._contents.push({ page: Life.MenuPage.ItemSlot, content: content });
            }
            createContent_Resident() {
                const rect = this.contentRect();
                const content = new Iz.Life.ContentResident(rect.width, rect.height);
                this._contents.push({ page: Life.MenuPage.Residents, content: content });
            }
            createContent_MiniMap() {
                const rect = this.contentRect();
                const content = new Iz.Life.ContentMiniMap(rect.width, rect.height);
                this._contents.push({ page: Life.MenuPage.Minimap, content: content });
            }
            createContent_Quest() {
                const rect = this.contentRect();
                const content = new Iz.Life.ContentQuest(rect.width, rect.height);
                this._contents.push({ page: Life.MenuPage.Quest, content: content });
            }
            createContent_WorkLevel() {
                const rect = this.contentRect();
                const content = new Iz.Life.ContentWorkLevel(rect.width, rect.height);
                this._contents.push({ page: Life.MenuPage.WorkLevel, content: content });
            }
            createContent_Shed() {
                const rect = this.contentRect();
                const content = new Iz.Life.ContentShed(rect.width, rect.height, Life.MenuOptionParam.shedId, () => this._nameEdit);
                this._contents.push({ page: Life.MenuPage.Shed, content: content });
            }
            createNameEdit() {
                const w = new Iz.Life.NameEditWindow(8);
                const bitmap = new Bitmap(Graphics.width, Graphics.height);
                bitmap.fillAll("black");
                w.setBg(bitmap);
                w.bg.opacity = 192;
                w.setActive(false);
                w.visible = false;
                this.addChild(w);
                this._nameEdit = w;
            }
            createFooter() {
                this._footer = Life.createUIFooter();
                this.addChild(this._footer);
            }
            update() {
                this.updateFooter();
                super.update();
                this.updateHeader();
                if (this.content.backable()) {
                    if (Input.isCancelled(true)) {
                        SoundManager.playCancel();
                        Iz.Life.MenuOptionParam.page = Life.MenuPage.ItemSlot;
                        this.popScene();
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_SLOT_RIGHT)) {
                        this.changePage(this._pageIndex + 1);
                    }
                    else if (Input.isTriggered(Iz.IO.KEY_NAME_SLOT_LEFT)) {
                        this.changePage(this._pageIndex - 1);
                    }
                }
            }
            contentRect() {
                return new Rectangle(Math.floor(this._baseWindow.width * 0.01), 96, Math.floor(this._baseWindow.width * 0.98), Math.floor(this._baseWindow.height - 96));
            }
            changePage(pageIndex) {
                let index = pageIndex;
                if (pageIndex >= this._contents.length) {
                    index = 0;
                }
                else if (pageIndex < 0) {
                    index = this._contents.length - 1;
                }
                if (this._pageIndex !== index) {
                    // this.changeHeader(this._contents[index]);
                    this._contents.forEach((info, i) => {
                        const c = info.content;
                        if (i === index) {
                            c.activate();
                            c.onStart();
                            c.update(); // チラつき防止
                            c.visible = true;
                        }
                        else {
                            c.deactivate();
                            c.visible = false;
                        }
                    });
                    this._pageIndex = index;
                }
            }
            changeHeader(info) {
                let atlasKey = "";
                let frameKey = "";
                if (info) {
                    const atlas = info.content.headerAtlas();
                    atlasKey = atlas.atlasKey;
                    frameKey = atlas.frameKey;
                }
                this._headerText.setAtlas(atlasKey, Life.getFrameKey(frameKey));
            }
            updateHeader() {
                this.changeHeader(this._contents[this._pageIndex]);
            }
            updateFooter() {
                const text = this.content.footerText();
                this._footer.text.setText(text);
            }
            terminate() {
                super.terminate();
                Iz.Life.setDefaultPages();
            }
        }
        Life.MenuScene = MenuScene;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeMenu();
    };
    const _Window_MenuCommand_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
    Window_MenuCommand.prototype.addOriginalCommands = function () {
        _Window_MenuCommand_addOriginalCommands.call(this);
        this.addCommand("メニュー", "new_menu", true);
    };
    const _Scene_Menu_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
    Scene_Menu.prototype.createCommandWindow = function () {
        _Scene_Menu_createCommandWindow.call(this);
        this._commandWindow.setHandler("new_menu", () => SceneManager.push(Iz.Life.MenuScene));
    };
    const _Scene_Map_initialize = Scene_Map.prototype.initialize;
    Scene_Map.prototype.initialize = function (...args) {
        _Scene_Map_initialize.call(this, ...args);
        Iz.Life.requestMenuFlg = false;
    };
    const _Scene_Map_isMenuEnabled = Scene_Map.prototype.isMenuEnabled;
    Scene_Map.prototype.isMenuEnabled = function () {
        if (!Iz.Life.isEnableMenuPage())
            return false;
        return _Scene_Map_isMenuEnabled.call(this);
    };
    const _Scene_Map_callMenu = Scene_Map.prototype.callMenu;
    Scene_Map.prototype.callMenu = function () {
        if (Iz.System.isTestMode()) {
            _Scene_Map_callMenu.call(this);
        }
        else {
            SoundManager.playOk();
            SceneManager.push(Iz.Life.MenuScene);
            Window_MenuCommand.initCommandPosition();
            $gameTemp.clearDestination();
            this._mapNameWindow.hide();
            this._waitCount = 2;
        }
    };
    Scene_Map.prototype.isMenuCalled = function () {
        return Input.isTriggered(Iz.IO.KEY_NAME_MENU) || TouchInput.isMiddleTriggered();
    };
    Scene_Map.prototype.callMenuPage = function (menuPage) {
        if (!this.isMenuEnabled())
            return false;
        if ($gamePlayer.isMoving())
            return false;
        Iz.Life.MenuOptionParam.page = menuPage;
        SceneManager.push(Iz.Life.MenuScene);
        $gameTemp.clearDestination();
        this._mapNameWindow.hide();
        this._waitCount = 0;
        return true;
    };
    const _Scene_Map_updateScene = Scene_Map.prototype.updateScene;
    Scene_Map.prototype.updateScene = function () {
        _Scene_Map_updateScene.call(this);
        if (SceneManager.isSceneChanging())
            return;
        if (!this.isMenuEnabled())
            return;
        if (Iz.Life.requestMenuFlg) {
            const res = this.callMenuPage(Iz.Life.MenuOptionParam.page);
            if (res) {
                Iz.Life.requestMenuFlg = false;
            }
        }
        else {
            let menuPage = Iz.Life.MenuPage.ItemSlot;
            let changeScene = false;
            if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_PAGE_EVENTLIST)) {
                menuPage = Iz.Life.MenuPage.Quest;
                changeScene = true;
            }
            else if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_PAGE_RESIDENTS)) {
                menuPage = Iz.Life.MenuPage.Residents;
                changeScene = true;
            }
            else if (Input.isTriggered(Iz.IO.KEY_NAME_MENU_PAGE_SKILL)) {
                menuPage = Iz.Life.MenuPage.WorkLevel;
                changeScene = true;
            }
            if (!changeScene)
                return;
            Iz.Life.setDefaultPages();
            const res = this.callMenuPage(menuPage);
            if (res) {
                SoundManager.playOk();
            }
        }
    };
    const _Game_Chronus_isStop = Game_Chronus.prototype.isStop;
    Game_Chronus.prototype.isStop = function () {
        if (Iz.Life.requestMenuFlg) {
            return true;
        }
        return _Game_Chronus_isStop.call(this);
    };
    const _Scene_Map_isPlayerActive = Scene_Map.prototype.isPlayerActive;
    Scene_Map.prototype.isPlayerActive = function () {
        if (Iz.Life.requestMenuFlg)
            return false;
        return _Scene_Map_isPlayerActive.call(this);
    };
    const _Scene_Map_terminate = Scene_Map.prototype.terminate;
    Scene_Map.prototype.terminate = function () {
        _Scene_Map_terminate.call(this);
        Iz.Life.requestMenuFlg = false;
    };
})();
//# sourceMappingURL=Menu.js.map