var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        class ProfileProxy {
            constructor() {
                this._flags = [];
            }
            getFlags() {
                return this._flags;
            }
            getActorFlag(actorId) {
                return !!this._flags[actorId].actor;
            }
            setActorFlag(actorId, flag) {
                this._flags[actorId].actor = flag;
            }
            getBirthFlag(actorId) {
                return !!this._flags[actorId].birth;
            }
            setBirthFlag(actorId, flag) {
                this._flags[actorId].birth = flag;
            }
            getHeightFlag(actorId) {
                return !!this._flags[actorId].height;
            }
            setHeightFlag(actorId, flag) {
                this._flags[actorId].height = flag;
            }
            getThreeSizeFlag(actorId) {
                return !!this._flags[actorId].threeSize;
            }
            setThreeSizeFlag(actorId, flag) {
                this._flags[actorId].threeSize = flag;
            }
            getWeightFlag(actorId) {
                return !!this._flags[actorId].weight;
            }
            setWeightFlag(actorId, flag) {
                this._flags[actorId].weight = flag;
            }
            getInterestFlag(actorId) {
                return !!this._flags[actorId].interest;
            }
            setInterestFlag(actorId, flag) {
                this._flags[actorId].interest = flag;
            }
            getItemFlag(actorId, itemId) {
                return !!this._flags[actorId].items[itemId];
            }
            setItemFlag(actorId, itemId, flag) {
                this._flags[actorId].items[itemId] = flag;
            }
            getGroupFlag(actorId, itemGroupType) {
                return !!this._flags[actorId].groups[itemGroupType];
            }
            setGroupFlag(actorId, itemGroupType, flag) {
                this._flags[actorId].groups[itemGroupType] = flag;
            }
            clear() {
                this._flags = [];
                $dataActors
                    .filter((data) => !!data)
                    .forEach((data) => {
                    this._flags[data.id] = {
                        actor: false,
                        birth: true,
                        height: true,
                        threeSize: true,
                        weight: true,
                        interest: true,
                        items: [],
                        groups: [],
                    };
                });
            }
            unlockAllItems(actorId) {
                const data = this._flags[actorId];
                if (!data)
                    return;
                data.items = [...$dataItems.map((data) => !!data)];
            }
            unlockAllGroups(actorId) {
                const data = this._flags[actorId];
                if (!data)
                    return;
                data.groups = [...$dataItemGroup.map((data) => !!data)];
            }
            unlock(actorId) {
                const data = this._flags[actorId];
                if (!data)
                    return;
                data.actor = true;
                data.birth = true;
                data.height = true;
                data.threeSize = true;
                data.interest = true;
                data.weight = true;
                $dataProfileReaction
                    .filter((r) => r && r.id === actorId)
                    .filter((r) => r.type === Life.Data.ProfileItemType.Item)
                    .map((r) => r.type_id)
                    .forEach((itemId) => {
                    data.items[itemId] = true;
                });
                $dataProfileReaction
                    .filter((r) => r && r.id === actorId)
                    .filter((r) => r.type === Life.Data.ProfileItemType.ItemGroup)
                    .map((r) => r.type_id)
                    .forEach((groupId) => {
                    data.groups[groupId] = true;
                });
            }
            unlockAll(actorId) {
                this.unlock(actorId);
                this.unlockAllItems(actorId);
                this.unlockAllGroups(actorId);
            }
        }
        function getProfileActors() {
            return $dataProfile
                .filter((d) => d)
                .map((d) => d.id)
                .sort((a, b) => a - b);
        }
        Life.getProfileActors = getProfileActors;
        Life.Profile = new ProfileProxy();
        function initializeProfile() {
            Life.Profile.clear();
        }
        Life.initializeProfile = initializeProfile;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var ProfileUtil;
        (function (ProfileUtil) {
            function setActorFlag(actorId, flag) {
                Life.Profile.setActorFlag(actorId, flag);
            }
            ProfileUtil.setActorFlag = setActorFlag;
            function setItemFlag(actorId, itemId, flag) {
                Life.Profile.setItemFlag(actorId, itemId, flag);
            }
            ProfileUtil.setItemFlag = setItemFlag;
            function setGroupFlag(actorId, groupId, flag) {
                Life.Profile.setGroupFlag(actorId, groupId, flag);
            }
            ProfileUtil.setGroupFlag = setGroupFlag;
            function isBirthday(actorId, offsetDays) {
                const data = $dataProfile[actorId];
                if (!data)
                    return false;
                const month = data.birth_month;
                let day = data.birth_day;
                if (offsetDays) {
                    day += offsetDays;
                }
                const target = Iz.System.toDaysBase(month, day);
                const current = Iz.System.toDaysBase(Iz.System.getMonth(), Iz.System.getDay());
                return target === current;
            }
            ProfileUtil.isBirthday = isBirthday;
            function unlockAll() {
                Life.getProfileActors().forEach((actor) => {
                    Life.Profile.unlockAll(actor);
                });
            }
            ProfileUtil.unlockAll = unlockAll;
        })(ProfileUtil = Life.ProfileUtil || (Life.ProfileUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        const ReactionDefault = Life.Data.ProfileReactionType.Default;
        function getReaction(itemId, actorId) {
            const result = getReactionResult(itemId, actorId);
            return result.reaction;
        }
        Life.getReaction = getReaction;
        function getReactionResult(itemId, actorId) {
            // アイテム -> グループの順で優先
            const itemData = $dataProfileReaction
                .filter((data) => !!data && data.id === actorId)
                .filter((data) => data.type === Life.Data.ProfileItemType.Item)
                .find((data) => data.type_id === itemId);
            if (itemData) {
                return {
                    reaction: itemData.reaction,
                    isItemReaction: true,
                };
            }
            const groups = Life.getItemGroups(itemId);
            const groupData = $dataProfileReaction
                .filter((data) => !!data && data.id === actorId)
                .filter((data) => data.type === Life.Data.ProfileItemType.ItemGroup)
                .find((data) => groups.find((group) => group === data.type_id));
            if (groupData) {
                return {
                    reaction: groupData.reaction,
                    isItemReaction: false,
                };
            }
            return {
                reaction: ReactionDefault,
                isItemReaction: false,
            };
        }
        Life.getReactionResult = getReactionResult;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeProfile();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.profile = {
            flags: Iz.Life.Profile.getFlags(),
        };
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        contents.profile.flags.forEach((data, actorId) => {
            if (!data) {
                return;
            }
            Iz.Life.Profile.setActorFlag(actorId, data.actor);
            Iz.Life.Profile.setBirthFlag(actorId, data.birth);
            Iz.Life.Profile.setHeightFlag(actorId, data.height);
            Iz.Life.Profile.setThreeSizeFlag(actorId, data.threeSize);
            Iz.Life.Profile.setWeightFlag(actorId, data.weight);
            Iz.Life.Profile.setInterestFlag(actorId, data.interest);
            data.items.forEach((flag, itemId) => {
                Iz.Life.Profile.setItemFlag(actorId, itemId, flag);
            });
            data.groups.forEach((flag, itemGroupType) => {
                Iz.Life.Profile.setGroupFlag(actorId, itemGroupType, flag);
            });
        });
    };
})();
//# sourceMappingURL=Profile.js.map