/*:
 * @target MZ
 * @plugindesc モブ
 *
 * @help
 *
 *
 */
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        function getMapSchedule(mapId, schedule) {
            const schedules = $dataMob;
            const data = schedules.find((s) => s && s.mapId === mapId && s.schedule === schedule);
            return data;
        }
        Life.getMapSchedule = getMapSchedule;
        class MobProxy {
            constructor() {
                this.clear();
            }
            get schedule() {
                return this._schedule;
            }
            setSchedule(schedule) {
                this._schedule = schedule;
            }
            changeSchedule(schedule) {
                this.setSchedule(schedule);
                $gameMap.onChangeMapSchedule();
            }
            getRandom() {
                if (this._nearMobs.size <= 0) {
                    this.generateRandom();
                }
                return this._random;
            }
            addNearMob(mobId) {
                this._nearMobs.add(mobId);
            }
            removeNearMob(mobId) {
                this._nearMobs.delete(mobId);
            }
            onCreateEvents() {
                this._nearMobs.clear();
                this.generateRandom();
            }
            generateRandom() {
                this._random = Math.randomInt(100);
            }
            clear() {
                this._schedule = 999;
                this._nearMobs = new Set();
                this._random = 0;
            }
        }
        Life.Mob = new MobProxy();
        function initializeMob() {
            Life.Mob.clear();
        }
        Life.initializeMob = initializeMob;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        var MobUtil;
        (function (MobUtil) {
            function setSchedule(schedule, resetEvents = false) {
                if (resetEvents) {
                    Life.Mob.changeSchedule(schedule);
                }
                else {
                    Life.Mob.setSchedule(schedule);
                }
            }
            MobUtil.setSchedule = setSchedule;
        })(MobUtil = Life.MobUtil || (Life.MobUtil = {}));
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(function (Iz) {
    var Life;
    (function (Life) {
        Life.MobTemplateMapId = 97;
        const SelfMovementTemplateMapId = 98;
        function getSelfmovementData(id) {
            const idOrName = Number(id);
            let event = undefined;
            const events = TR.getTemplateMapEvents(SelfMovementTemplateMapId);
            if (idOrName) {
                event = events[idOrName];
            }
            else {
                event = events.find((e) => e && e.name === id);
            }
            if (!event)
                return undefined;
            return (({ moveFrequency, moveRoute, moveSpeed, moveType }) => ({
                moveFrequency,
                moveRoute,
                moveSpeed,
                moveType,
            }))(event.pages[0]);
        }
        Life.getSelfmovementData = getSelfmovementData;
        class Game_Mob extends Game_PrefabEvent {
            initMembers() {
                super.initMembers();
                this._mobId = 0;
                this._selfMovementId = "";
                this._tableId = 0;
                this._route = undefined;
                this._labels = [];
            }
            setupPageSettings() {
                super.setupPageSettings();
                this._selfMovementId = "";
            }
            setMob(mobId) {
                this._mobId = mobId;
                this.locateSchedule(this.getSchedule());
                this.updateChronus();
            }
            setLabels(labels) {
                this._labels = [...labels];
            }
            setupSelfmovement(selfMovementId) {
                const selfMovement = Iz.Life.getSelfmovementData(selfMovementId);
                if (selfMovement) {
                    this._selfMovementId = selfMovementId;
                    this.setMoveSpeed(selfMovement.moveSpeed);
                    this.setMoveFrequency(selfMovement.moveFrequency);
                    this.setMoveRoute(selfMovement.moveRoute);
                    this._moveType = selfMovement.moveType;
                }
            }
            update() {
                if ($gameMessage.isBusy()) {
                    return;
                }
                super.update();
                if (this.isVisible()) {
                    this.updateLabel();
                }
            }
            updateStop() {
                super.updateStop();
                if (!this.isMoving()) {
                    this.moveToDestination();
                }
            }
            updateSelfMovement() {
                if (this._route) {
                    return;
                }
                super.updateSelfMovement();
            }
            updateLabel() {
                const near = this.closeByCharacter($gamePlayer, 5);
                const mob = this.getMob(this.getSchedule(), this._mobId);
                if (mob) {
                    const isUsable = Life.Label.isUsable(this.eventId().toString());
                    if (isUsable) {
                        if (!near) {
                            this.removeNearMob();
                        }
                    }
                    else if (near && this.isVisible()) {
                        const labelId = this.getLabelId(mob);
                        const labelText = $dataCharacterLabel.get(labelId)?.value ?? labelId;
                        if (labelText) {
                            Iz.Life.Label.show(this.eventId().toString(), labelText, true);
                        }
                        Iz.Life.Mob.addNearMob(mob.id);
                    }
                }
            }
            moveToDestination() {
                const d = this.findDirectionTo(0, 0);
                if (d > 0) {
                    this.moveStraight(d);
                }
                else {
                    if (this._route) {
                        this._tableId++;
                        // テンプレートイベントの自律イベントを適用し直す
                        const page = this.page();
                        this.setMoveSpeed(page.moveSpeed);
                        this.setMoveFrequency(page.moveFrequency);
                        this.setMoveRoute(page.moveRoute);
                        this._moveType = page.moveType;
                    }
                    this._route = undefined;
                }
            }
            refresh() {
                super.refresh();
                this.updateChronus();
            }
            getSchedule() {
                return Iz.Life.Mob.schedule;
            }
            locateSchedule(schedule) {
                const chronus = this.getChronus();
                const timetable = this.getTimeTable(schedule, chronus.getHour(), chronus.getMinute());
                if (!timetable)
                    return;
                this.locate(timetable.x, timetable.y);
                this.setDirection(timetable.direction);
                this._tableId = timetable.id;
            }
            getTimeTable(schedule, hour, minute) {
                const mob = this.getMob(schedule, this._mobId);
                if (!mob)
                    return;
                let target = undefined;
                for (let i = 0; i < mob.tables.length; i++) {
                    const table = mob.tables[i];
                    if (!target) {
                        target = table;
                        continue;
                    }
                    if (table.hour < hour) {
                        target = table;
                        continue;
                    }
                    if (table.hour === hour && table.minute <= minute) {
                        target = table;
                    }
                }
                return target;
            }
            updateChronus() {
                const chronus = this.getChronus();
                // 目的地移動判定
                const schedule = this.getSchedule();
                const timetable = this.getTimeTable(schedule, chronus.getHour(), chronus.getMinute());
                if (!timetable)
                    return;
                if (timetable.id > this._tableId) {
                    // 自動で目的地まで移動する
                    if (!this.isMoving()) {
                        this.resetStopCount();
                        this.processRouteEnd();
                        const start = new Iz.GlobalMap.ExplorationNode(this._mapId, this.x, this.y);
                        const goal = new Iz.GlobalMap.ExplorationNode(this._mapId, timetable.x, timetable.y);
                        // const MobNotRegionCost = 3;
                        const MobNotRegionCost = Number.POSITIVE_INFINITY;
                        const route = new Iz.GlobalMap.RouteExploration(this._mapId, MobNotRegionCost);
                        route.start(start, goal);
                        this._route = route;
                    }
                    return;
                }
                // 自律移動
                const selfMovementId = timetable.self_movement_id;
                if (this._selfMovementId === selfMovementId)
                    return;
                this.setupSelfmovement(selfMovementId);
            }
            getChronus() {
                return $gameSystem.chronus();
            }
            findDirectionTo(goalX, goalY) {
                const postion = this._route?.nextNode();
                if (postion) {
                    const deltaX = postion.x - this._x;
                    if (deltaX < 0) {
                        return 4;
                    }
                    if (0 < deltaX) {
                        return 6;
                    }
                    const deltaY = postion.y - this._y;
                    if (deltaY < 0) {
                        return 8;
                    }
                    if (0 < deltaY) {
                        return 2;
                    }
                }
                return 0;
            }
            moveStraight(d) {
                super.moveStraight(d);
                if (this.isMovementSucceeded()) {
                    this._route?.shift();
                }
            }
            getMob(schedule, mobId) {
                const mapSchedule = Life.getMapSchedule(this._mapId, schedule);
                if (!mapSchedule)
                    return;
                const mob = mapSchedule.mobs.find((mob) => mob.id === mobId);
                if (!mob)
                    return;
                return mob;
            }
            getLabelId(mob) {
                let list = this._labels;
                if (list.length <= 0) {
                    list = mob.labels;
                }
                if (list.length <= 0) {
                    return "";
                }
                const index = Iz.Life.Mob.getRandom() % list.length;
                return list[index];
            }
            setTransparent(transparent) {
                super.setTransparent(transparent);
                if (transparent) {
                    this.removeNearMob();
                }
            }
            isVisible() {
                return !this.isTransparent();
            }
            removeNearMob() {
                Iz.Life.Mob.removeNearMob(this._mobId);
                Iz.Life.Label.hide(this.eventId().toString());
            }
            erase() {
                super.erase();
                this.removeNearMob();
            }
        }
        Life.Game_Mob = Game_Mob;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    class MobCreator extends TR.PrefabCreator {
        constructor(param) {
            super();
            this._param = param;
        }
        create() {
            const param = this.param();
            return new Iz.Life.Game_Mob($gameMap.mapId(), this.eventId(), param.originalEventId, param.x, param.y, param.isTemplate, param.templateMapId);
        }
        param() {
            return this._param;
        }
    }
    Game_Map.prototype.createMob = function (mobId, templateEventId) {
        const creator = new MobCreator({
            originalEventId: templateEventId,
            x: 0,
            y: 0,
            isTemplate: true,
            templateMapId: Iz.Life.MobTemplateMapId,
        });
        const event = this.spawnPrefab(creator);
        if (event) {
            event.setMob(mobId);
        }
        return event;
    };
})();
//
(() => {
    "use strict";
    let isLoadGame = false;
    DataManager._databaseFiles.push({
        name: "$dataMob",
        src: "Mob.json",
    });
    const _DataManager_loadDataFile = DataManager.loadDataFile;
    DataManager.loadDataFile = function (name, src_) {
        let src = src_;
        if (name === "$dataMob") {
            src = src.replace("Test_", "");
        }
        _DataManager_loadDataFile.call(this, name, src);
    };
    const _createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function () {
        _createGameObjects.call(this);
        Iz.Life.initializeMob();
    };
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function () {
        const contents = _DataManager_makeSaveContents.call(this);
        contents.mob = {
            schedule: Iz.Life.Mob.schedule,
        };
        return contents;
    };
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function (contents) {
        _DataManager_extractSaveContents.call(this, contents);
        Iz.Life.Mob.setSchedule(contents.mob.schedule);
        for (let i = 0; i < $gameMap._events.length; i++) {
            const e = $gameMap._events[i];
            if (!e)
                continue;
            if (!Object.hasOwn(e, "_mobId"))
                continue;
            // 正しくインスタンス化できていないモブは削除
            // NOTE:
            // セーブデータから新たにモブを生成するので_eventsに空のイベントが増えてしまうが、
            // モブがいるマップでセーブするのは開発時しかできないので許容する
            // $gameMap._events[i] = undefined;
            delete $gameMap._events[e._eventId];
        }
    };
    const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
    Scene_Map.prototype.createDisplayObjects = function () {
        if (isLoadGame) {
            $gameMap.setupMobEvents();
        }
        isLoadGame = false;
        _Scene_Map_createDisplayObjects.call(this);
    };
    const _Game_Map_setup = Game_Map.prototype.setup;
    Game_Map.prototype.setup = function (mapId) {
        _Game_Map_setup.call(this, mapId);
        this.setupMobEvents();
    };
    Game_Map.prototype.setupMobEvents = function () {
        Iz.Life.Mob.onCreateEvents();
        const mapSchedule = Iz.Life.getMapSchedule(this.mapId(), Iz.Life.Mob.schedule);
        if (!mapSchedule)
            return;
        mapSchedule.mobs.forEach((mob) => {
            const templateEventId = TR.getTemplateId(mob.template_event, Iz.Life.MobTemplateMapId);
            this.createMob(mob.id, templateEventId);
        });
    };
    Game_Map.prototype.onChangeMapSchedule = function () {
        for (let i = 0; i < this._events.length; i++) {
            const e = this._events[i];
            if (!e || !(e instanceof Iz.Life.Game_Mob))
                continue;
            this.eraseEvent(e.eventId());
        }
        this.setupMobEvents();
    };
    const _Game_System_OnAfterLoad = Game_System.prototype.onAfterLoad;
    Game_System.prototype.onAfterLoad = function () {
        _Game_System_OnAfterLoad.call(this);
        isLoadGame = true;
    };
})();
//# sourceMappingURL=Mob.js.map