/*:
 * @target MZ
 * @plugindesc アドオン
 *
 * @help
 * ・EventRespawn(イベントIDの重複を防止)
 *  https://raw.githubusercontent.com/triacontane/RPGMakerMV/master/EventReSpawn.js
 *
 * ・HalfMove
 * https://raw.githubusercontent.com/triacontane/RPGMakerMV/master/HalfMove.js
 *
 * ・Chronus
 * https://raw.githubusercontent.com/triacontane/RPGMakerMV/mz_master/Chronus.js
 *
 *
 * 以下の順番でプラグインを登録してください
 * Chronus.js
 * HalfMove.js
 * GlobalMapConfig.js
 * GlobalMap.js
 * EventRespawn.js
 * EventRespawnEx.js(あれば)
 * GlobalMapAddon.js
 *
 *
 */
(() => {
    // 関数有無で判断
    const existEventRespawn = !!Game_Map.prototype.getLastSpawnEventId;
    if (existEventRespawn) {
        Iz.GlobalMap.getLastEventId = () => {
            // return $gameMap.getLastSpawnEventId() || $gameMap._events.length-1;
            // NOTE:
            // $gameMap._events[]内が空の箇所を利用したいが、バグ回避のため一旦最後尾にしとく
            return $gameMap._events.length - 1;
        };
        Iz.GlobalMap.setLastEventId = (value) => {
            $gameMap._eventIdSequence = value + 1;
            $gameMap.setLastSpawnEventId(value);
        };
    }
    // biome-ignore lint:
    const existHalfMove = !!Game_Map.prototype.hasOwnProperty("isHalfPos");
    if (existHalfMove) {
        Iz.GlobalMap.isHalfMove = true;
        Game_Map.prototype.eventsXyNtInUnit = function (x, y) {
            return this.eventsXyUnitNt(x, y);
        };
        Iz.GlobalMap.applyInitEventPos = (e) => {
            let halfXTag = "";
            let halfYTag = "";
            if (Object.hasOwn(e.meta, "HM初期半歩X")) {
                // biome-ignore lint:
                halfXTag = e.meta["HM初期半歩X"];
            }
            else if (Object.hasOwn(e.meta, "HMInitialHalfX")) {
                // biome-ignore lint:
                halfXTag = e.meta["HMInitialHalfX"];
            }
            if (Object.hasOwn(e.meta, "HM初期半歩Y")) {
                // biome-ignore lint:
                halfYTag = e.meta["HM初期半歩Y"];
            }
            else if (Object.hasOwn(e.meta, "HMInitialHalfY")) {
                // biome-ignore lint:
                halfYTag = e.meta["HMInitialHalfY"];
            }
            const pos = { x: e.x, y: e.y };
            if (halfXTag === "+") {
                pos.x += Iz.GlobalMap.getUnitCost();
            }
            else if (halfXTag === "-") {
                pos.x -= Iz.GlobalMap.getUnitCost();
            }
            if (halfYTag === "+") {
                pos.y += Iz.GlobalMap.getUnitCost();
            }
            else if (halfYTag === "-") {
                pos.y -= Iz.GlobalMap.getUnitCost();
            }
            // return pos;
            e.x = pos.x;
            e.y = pos.y;
        };
    }
    // @ts-ignore
    // biome-ignore lint:
    const existChronus = !!window["Game_Chronus"];
    if (existChronus) {
        Iz.GlobalMap.getChronus = () => {
            return $gameSystem.chronus();
        };
    }
})();
//# sourceMappingURL=GlobalMapAddon.js.map