/*:ja
 * @target MZ
 * @plugindesc NPC自律移動の設定プラグイン
 * @author INAZUMA GAMES
 *
 * @help
 * NPC自律移動に必要な各種設定を行います
 *
 *
 *
 *
 * @param GlobalMapInfoJsonName
 * @text GlobalMapInfoのJson名
 * @desc
 *
 * @param GlobalMapInfoVariableName
 * @text GlobalMapInfoのグローバル変数名
 * @desc
 *
 * @param LocationJsonName
 * @text LocationのJson名
 * @desc
 *
 * @param LocationVariableName
 * @text Locationのグローバル変数名
 * @desc
 *
 * @param TimeTableJsonName
 * @text TimeTableのJson名
 * @desc
 *
 * @param TimeTableVariableName
 * @text TimeTableのグローバル変数名
 * @desc
 *
 * @param NPCJsonName
 * @text NPCのJson名
 * @desc
 *
 * @param NPCVariableName
 * @text NPCのグローバル変数名
 * @desc
 *
 */
var Iz;
(function (Iz) {
    var GlobalMap;
    (function (GlobalMap) {
        function applyLocationMap() {
            $dataLocationMap.clear();
            $dataLocation
                .filter((data) => !!data)
                .forEach((data) => {
                if (!$dataLocationMap.has(data.mapId)) {
                    $dataLocationMap.set(data.mapId, []);
                }
                const list = $dataLocationMap.get(data.mapId);
                if (list) {
                    list.push(data);
                }
            });
        }
        GlobalMap.applyLocationMap = applyLocationMap;
        function createGlobalMapParameterMaps() {
            GlobalMap.calcCosts.clear();
            $globalMapParameter.road_regions.forEach((data) => {
                GlobalMap.calcCosts.set(data.id, data.cost);
            });
        }
        GlobalMap.createGlobalMapParameterMaps = createGlobalMapParameterMaps;
        GlobalMap.calcCosts = new Map();
    })(GlobalMap = Iz.GlobalMap || (Iz.GlobalMap = {}));
})(Iz || (Iz = {}));
// biome-ignore lint:
window["$dataLocationMap"] = new Map();
(() => {
    "use strict";
    const parameterName = "GlobalMapConfig";
    const parameters = PluginManager.parameters(parameterName);
    function initGlobalMapParameters() {
        const fs = require("fs");
        window.$globalMapParameter = JSON.parse(fs.readFileSync("data/parameter_globalmap.json", "utf-8"));
        window.$globalMapParameter.npc_events.sort((a, b) => a.priority - b.priority);
        DataManager._databaseFiles.push({
            name: parameters.GlobalMapInfoVariableName,
            src: `${parameters.GlobalMapInfoJsonName}.json`,
        });
        DataManager._databaseFiles.push({
            name: parameters.LocationVariableName,
            src: `${parameters.LocationJsonName}.json`,
        });
        DataManager._databaseFiles.push({
            name: parameters.NPCVariableName,
            src: `${parameters.NPCJsonName}.json`,
        });
        DataManager._databaseFiles.push({
            name: parameters.TimeTableVariableName,
            src: `${parameters.TimeTableJsonName}.json`,
        });
        DataManager._databaseFiles.push({
            name: "$dataSchedule",
            src: "Schedule.json",
        });
    }
    const _DataManager_loadDataFile = DataManager.loadDataFile;
    DataManager.loadDataFile = function (name, src_) {
        let src = src_;
        if (name === parameters.GlobalMapInfoVariableName) {
            src = src.replace("Test_", "");
        }
        if (name === parameters.LocationVariableName) {
            src = src.replace("Test_", "");
        }
        if (name === parameters.NPCVariableName) {
            src = src.replace("Test_", "");
        }
        if (name === parameters.TimeTableVariableName) {
            src = src.replace("Test_", "");
        }
        if (name === "$dataSchedule") {
            src = src.replace("Test_", "");
        }
        _DataManager_loadDataFile.call(this, name, src);
    };
    const _onDatabaseLoaded = Scene_Boot.prototype.onDatabaseLoaded;
    Scene_Boot.prototype.onDatabaseLoaded = function () {
        _onDatabaseLoaded.call(this);
        const list = [];
        $dataNonPlayers.forEach((npc) => {
            if (npc) {
                list[npc.id] = npc;
            }
        });
        $dataNonPlayers = list.map((npc) => npc ?? null);
        Iz.GlobalMap.applyLocationMap();
        Iz.GlobalMap.createGlobalMapParameterMaps();
    };
    initGlobalMapParameters();
})();
//# sourceMappingURL=GlobalMapConfig.js.map