var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.OptionMenuType = {
            Menu: 0,
            Option: 1,
            Title: 2,
            Back: 3,
        };
        const OptionMenuTypeMax = 4;
        class OptionMenuWindow extends Iz.WindowBase {
            constructor() {
                super(new Rectangle(0, 0, 0, 0), new Iz.EasingOpenness(Iz.Easing.easeOutBack, Iz.Easing.easeOutQuint));
                this.createGrid();
                this.bitmap = new Bitmap(this._gridWindow.width, this._gridWindow.height);
                this.anchor.set(0.5, 0.5);
                this.position.set(Math.floor(Graphics.width / 2), Math.floor(Graphics.height / 2));
                this.opennessData.closeOffset = 0.2;
            }
            get grid() {
                return this._gridWindow.grid;
            }
            createGrid() {
                const frameWidth = 200;
                const frameHeight = 40;
                const option = {
                    emptyCellCreator: () => {
                        return new Iz.Life.CommonGridElement(frameWidth, frameHeight);
                    },
                    cellUpdater: (cell, index) => {
                        switch (index) {
                            case Life.OptionMenuType.Menu:
                                cell.set(Iz.Text.get("MAP_OPTION_MENU"));
                                break;
                            case Life.OptionMenuType.Option:
                                cell.set(Iz.Text.get("SYSTEM_JSON_TERMS_COMMANDS_11"));
                                break;
                            case Life.OptionMenuType.Title:
                                cell.set(Iz.Text.get("SYSTEM_JSON_TERMS_COMMANDS_10"));
                                break;
                            case Life.OptionMenuType.Back:
                                cell.set(Iz.Text.get("MAP_OPTION_BACK"));
                                break;
                        }
                    },
                    maxItems: OptionMenuTypeMax,
                    frameWidth: frameWidth,
                    frameHeight: frameHeight,
                    col: 1,
                    row: OptionMenuTypeMax,
                };
                const g = Iz.Life.createCommonGridWindow(option);
                g.relativeAnchor.enable = true;
                this._gridWindow = g;
                this.addChild(g);
            }
            update() {
                super.update();
                const cell = this.grid.cell();
                if (cell) {
                    cell.cursorSprite.alpha = this._gridWindow.cursorAlpha;
                }
            }
            activate() {
                this._gridWindow.activate();
            }
            deactivate() {
                this._gridWindow.deactivate();
            }
        }
        Life.OptionMenuWindow = OptionMenuWindow;
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    const _Scene_Map_createAllWindows = Scene_Map.prototype.createAllWindows;
    Scene_Map.prototype.createAllWindows = function () {
        _Scene_Map_createAllWindows.call(this);
        const cancel = () => {
            SoundManager.playCancel();
            this.setPause(false);
            this._optionMenu.deactivate();
            this._optionMenu.close();
        };
        const changeScene = (sceneClass) => {
            this._optionMenu.deactivate();
            SoundManager.playOk();
            SceneManager.push(sceneClass);
            $gameTemp.clearDestination();
            this._mapNameWindow.hide();
            this._waitCount = 1;
        };
        const onOk = () => {
            switch (this._optionMenu.grid.index) {
                case Iz.Life.OptionMenuType.Menu:
                    changeScene(Iz.Life.MenuScene);
                    break;
                case Iz.Life.OptionMenuType.Option:
                    changeScene(Scene_Options);
                    break;
                case Iz.Life.OptionMenuType.Title:
                    changeScene(Scene_GameEnd);
                    break;
                case Iz.Life.OptionMenuType.Back:
                    cancel();
                    break;
            }
        };
        this._optionMenu = new Iz.Life.OptionMenuWindow();
        this._optionMenu.grid.setHandler(Iz.GridEventType.Ok, onOk);
        this._optionMenu.grid.setHandler(Iz.GridEventType.Cancel, () => {
            cancel();
        });
        this._optionMenu.deactivate();
        this._optionMenu.closeImmediate();
        // チラつき防止
        this._optionMenu.visible = false;
        this.addChild(this._optionMenu);
    };
    Scene_Map.prototype.callOptionMenu = function () {
        if (SceneManager.isSceneChanging())
            return false;
        if (this.isEnableOptionMenu())
            return false;
        if (!this.isMenuEnabled())
            return false;
        if ($gamePlayer.isMoving())
            return false;
        this._optionMenu.open(true);
        this._optionMenu.activate();
        this._optionMenu.visible = true;
        this.setPause(true);
        return true;
    };
    const _Scene_Map_isActive = Scene_Map.prototype.isActive;
    Scene_Map.prototype.isActive = function () {
        if (this.isEnableOptionMenu())
            return false;
        return _Scene_Map_isActive.call(this);
    };
    Scene_Map.prototype.isEnableOptionMenu = function () {
        return !this._optionMenu.isClosed();
    };
})();
//# sourceMappingURL=Option.js.map