/*:
 * @target MZ
 * @plugindesc Chronus拡張
 *
 * @help
 * [機能]
 * ・Chronusによる画面効果（色調・天候）の有効・無効化
 * ・場所移動時に時間経過カウンタを初期化する処理の有効・無効化
 * ・カレンダー表示をSlowLife用にカスタム
 * ・月名配列と曜日配列を外部設定可能に
 * ・シーン変更中の時は時間停止
 * ・タイマーの処理を時間更新の後に行う機能
 *
 * ※このプラグインはChronus.jsより後に登録してください
 *
 */
(() => {
    const enableEffect = false;
    const disableInitFrameCountOnTransfer = true;
    const enableChronusStrings = false;
    const enableTimeStopInSceneChanging = true;
    const enablePostUpdateTimer = true;
    if (!enableEffect) {
        Game_Chronus.prototype.updateEffect = function () { };
        Game_Chronus.prototype.updateWeather = function () { };
        Game_Chronus.prototype.updateWeatherType = function () { };
        Game_Chronus.prototype.updateBatWeatherLevel = function () { };
        Game_Chronus.prototype.refreshTint = function (swift) { };
        Game_Chronus.prototype.refreshWeather = function (swift) { };
        Game_Chronus.prototype.disableWeather = function () { };
        Game_Chronus.prototype.enableWeather = function () { };
        Game_Chronus.prototype.disableTint = function () { };
        Game_Chronus.prototype.enableTint = function () { };
        Game_Chronus.prototype.setTint = function (timeId, swift) { };
        Game_Chronus.prototype.setWeatherType = function (value) { };
        Game_Chronus.prototype.setWeatherPower = function (value) { };
        Game_Chronus.prototype.setSnowLand = function () { };
        Game_Chronus.prototype.resetSnowLand = function () { };
        Game_Chronus.prototype.setScreenWeather = function (swift) { };
    }
    if (disableInitFrameCountOnTransfer) {
        // const _Game_Chronus_demandRefresh = Game_Chronus.prototype.demandRefresh;
        Game_Chronus.prototype.demandRefresh = function (effectRefreshFlg, 
        // biome-ignore lint:
        disableInitFrameCount = false) {
            this._demandRefresh = true;
            if (!disableInitFrameCount) {
                this._frameCount = 0;
            }
            this.setGameVariable();
            if (effectRefreshFlg) {
                this.refreshTint(true);
                this.updateWeather();
            }
        };
        Game_Chronus.prototype.transfer = function (realTransfer) {
            if (this.isStop())
                return;
            if (realTransfer) {
                this.addTime(this._timeTransferAdd, true);
            }
            this.demandRefresh(true, true);
        };
        Game_Chronus.prototype.addTime = function (value_, 
        // biome-ignore lint:
        disableInitFrameCount = false) {
            let value = value_;
            if (arguments.length === 0) {
                value = this._timeAutoAdd;
                // NOTE:
                // Game_Chronusにハンドラーの変数を保存すると
                // セーブデータにも残るため直接呼ぶようにする
                Iz.System.updateAutoAddTimeHandler(value);
            }
            this._timeMeter += value;
            while (this._timeMeter >= 60 * 24) {
                this.addDay();
                this._timeMeter -= 60 * 24;
            }
            this.demandRefresh(false, disableInitFrameCount);
        };
    }
    const _Window_Chronus_initialize = Window_Chronus.prototype.initialize;
    Window_Chronus.prototype.initialize = function (rect, ...args) {
        _Window_Chronus_initialize.call(this, rect, ...args);
        this._container.alpha = 0; // Window_Baseの枠は使わない
        const rootBitmap = new Bitmap(4, 64);
        // rootBitmap.fillAll("green");
        this._formatRoot = new Sprite(rootBitmap);
        this._formatRoot.anchor.set(1, 0);
        this._formatRoot.x = 178;
        this.addChild(this._formatRoot);
        const atlas = Iz.Atlas.getAtlas(Iz.Life.ATLAS_KEY_HUD);
        const bitmap = atlas.getBitmap();
        const f = atlas.getFrame(Iz.Life.FRAME_KEY_HUD_CLOCK_BG);
        this._formatTextBack = new NineSliceSprite(bitmap);
        this._formatTextBack.setBitmapRect(f.x, f.y, f.width, f.height);
        this._formatTextBack.setSlice(16, 16, 16, 16);
        this._formatTextBack.setSize(256, 32);
        this._formatTextBack.anchor.set(1, 0);
        this._formatRoot.addChild(this._formatTextBack);
        this._formatText1 = new Sprite_Text(512, 32);
        this._formatText1.anchor.set(1, 0);
        this._formatText1.setAlign("right");
        this._formatText1.setFontSetting(Iz.Life.FONT_KEY_HUD_CHRONUS);
        this._formatText1.setText(this.getDateFormat(1));
        this._formatText1.update();
        this._formatRoot.addChild(this._formatText1);
        const width = this._formatText1.measureTextWidth();
        this._formatTextBack.setSize(width, 32);
    };
    Window_Chronus.prototype.refresh = function () {
        if (this._formatText1) {
            this._formatText1.setText(this.getDateFormat(1), true);
            const width = this._formatText1.measureTextWidth();
            this._formatTextBack.setSize(width, 32);
        }
        this.update();
    };
    Game_Chronus.prototype.setDayOfWeekNames = function (names) {
        this._weekNames = names;
    };
    Game_Chronus.prototype.setMonthNames = function (names) {
        this._monthNames = names;
    };
    Game_Chronus.prototype.getDaysOfMonthList = function () {
        return this._daysOfMonth;
    };
    if (enableChronusStrings) {
        function setupChronusStrings() {
            const weekNames = [];
            for (let i = 0; i < Iz.System.DAY_OF_WEEK_MAX; i++) {
                weekNames.push(Iz.System.getDayOfWeekName(i));
            }
            $gameSystem.chronus().setDayOfWeekNames(weekNames);
            const monthNames = [];
            for (let i = 0; i < Iz.System.MONTH_MAX; i++) {
                monthNames.push(Iz.System.getMonthName(i));
            }
            $gameSystem.chronus().setMonthNames(monthNames);
        }
        const _createGameObjects = DataManager.createGameObjects;
        DataManager.createGameObjects = function () {
            _createGameObjects.call(this);
            setupChronusStrings();
        };
        const _Game_System_onAfterload = Game_System.prototype.onAfterLoad;
        Game_System.prototype.onAfterLoad = function () {
            _Game_System_onAfterload.call(this);
            setupChronusStrings();
        };
    }
    if (enableTimeStopInSceneChanging) {
        const _Game_Chronus_isStop = Game_Chronus.prototype.isStop;
        Game_Chronus.prototype.isStop = function () {
            if (SceneManager.isSceneChanging()) {
                return true;
            }
            return _Game_Chronus_isStop.call(this);
        };
    }
    if (enablePostUpdateTimer) {
        let enableUpdateTimer = false;
        const _Game_Chronus_update = Game_Chronus.prototype.update;
        Game_Chronus.prototype.update = function () {
            enableUpdateTimer = false;
            _Game_Chronus_update.call(this);
            enableUpdateTimer = true;
            this.updateTimer();
        };
        const _Game_Chronus_updateTimer = Game_Chronus.prototype.updateTimer;
        Game_Chronus.prototype.updateTimer = function () {
            if (!enableUpdateTimer)
                return;
            _Game_Chronus_updateTimer.call(this);
        };
    }
    Game_Chronus.prototype.getDateFormat = function (index) {
        const format = Iz.Text.get(`CHRONUS_CALENDAR_FORMAT_${index}`);
        return this.convertDateFormatText(format);
    };
    Game_Chronus.prototype.convertDateFormatText = function (format_) {
        // NOTE: 元実装との変更点
        // ・大文字小文字を区別するように
        // ・月名の取得処理を変更
        let format = format_;
        format = format.replace(/(YYYY)/g, () => {
            return this.getValuePadding(this.getYear(), arguments[1].length);
        });
        format = format.replace(/MON/g, () => {
            return Iz.System.getMonthName(this.getMonth());
        });
        format = format.replace(/MM/g, () => {
            return this.getValuePadding(this.getMonth(), String(this.getMonthOfYear()).length);
        });
        format = format.replace(/DDALL/g, () => {
            return this.getValuePadding(this.getTotalDay());
        });
        format = format.replace(/DD/g, () => {
            return this.getValuePadding(this.getDay(), String(this.getDaysOfMonth(this.getMonth())).length);
        });
        format = format.replace(/HH24/g, () => {
            return this.getValuePadding(this.getHour(), 2);
        });
        format = format.replace(/HH/g, () => {
            return this.getValuePadding(this.getHour() % 12, 2);
        });
        format = format.replace(/AM/g, () => {
            return Math.floor(this.getHour() / 12) === 0
                ? $gameSystem.isJapanese()
                    ? "午前"
                    : "Morning  "
                : $gameSystem.isJapanese()
                    ? "午後"
                    : "Afternoon";
        });
        format = format.replace(/MI/g, () => {
            return this.getValuePadding(this.getMinute(), 2);
        });
        format = format.replace(/DY/g, () => {
            return this.getWeekName();
        });
        format = format.replace(/TZ/g, () => {
            return this.getTimeZoneName();
        });
        return format;
    };
    Game_Chronus.prototype.getWeekName = function () {
        return Iz.System.getDayOfWeekName(this.getWeekIndex());
    };
})();
//# sourceMappingURL=ChronusEx.js.map