var HM;
(function (HM) {
    const metaTagPrefix = "HM";
    HM.AreaIndex = {
        Bottom: 0,
        Left: 1,
        Right: 2,
        Top: 3,
    };
    HM.DefaultArea = [0.5, 0.5, 0.5, 0.5];
    class Collider {
        constructor(data) {
            this._data = { x: data.x, y: data.y, expansionArea: [...data.expansionArea] };
        }
        get x() {
            return this._data.x;
        }
        get y() {
            return this._data.y;
        }
        get left() {
            return this._data.x - this._data.expansionArea[HM.AreaIndex.Left];
        }
        get right() {
            return this._data.x + this._data.expansionArea[HM.AreaIndex.Right];
        }
        get top() {
            return this._data.y - this._data.expansionArea[HM.AreaIndex.Top];
        }
        get bottom() {
            return this._data.y + this._data.expansionArea[HM.AreaIndex.Bottom];
        }
        get width() {
            return this._data.expansionArea[2] + this._data.expansionArea[1];
        }
        get height() {
            return this._data.expansionArea[0] + this._data.expansionArea[3];
        }
        get base() {
            return { x: this.x, y: this.y };
        }
        get leftTop() {
            return { x: this.left, y: this.top };
        }
        get leftBottom() {
            return { x: this.left, y: this.bottom };
        }
        get rightTop() {
            return { x: this.right, y: this.top };
        }
        get rightBottom() {
            return { x: this.right, y: this.bottom };
        }
    }
    HM.Collider = Collider;
    function isCollided(a, b) {
        return a.left <= b.right && a.right >= b.left && a.top <= b.bottom && a.bottom >= b.top;
    }
    HM.isCollided = isCollided;
    function isCollidedExcludeBorder(a, b) {
        return a.left < b.right && a.right > b.left && a.top < b.bottom && a.bottom > b.top;
    }
    HM.isCollidedExcludeBorder = isCollidedExcludeBorder;
    function isInCollider(col, x, y) {
        return x >= col.left && x <= col.right && y >= col.top && y <= col.bottom;
    }
    HM.isInCollider = isInCollider;
    function isInColliderExcludeBorder(col, x, y) {
        return x > col.left && x < col.right && y > col.top && y < col.bottom;
    }
    HM.isInColliderExcludeBorder = isInColliderExcludeBorder;
    function getMetaValue(meta, name) {
        const metaTagName = metaTagPrefix + (name ? name : "");
        return Object.hasOwn(meta, metaTagName) ? meta[metaTagName] : undefined;
    }
    function getMetaValues(meta, names) {
        if (!Array.isArray(names))
            return getMetaValue(meta, names);
        for (let i = 0, n = names.length; i < n; i++) {
            const value = getMetaValue(meta, names[i]);
            if (value !== undefined)
                return value;
        }
        return undefined;
    }
    function convertEscapeCharacters(text_) {
        let text = text_;
        if (text === null || text === undefined) {
            text = "";
        }
        const windowLayer = SceneManager._scene?._windowLayer;
        return windowLayer
            ? windowLayer.children[0].convertEscapeCharacters(text)
            : text;
    }
    function getArgString(arg_, upperFlg) {
        const arg = convertEscapeCharacters(arg_);
        return upperFlg ? arg.toUpperCase() : arg;
    }
    function getArgArrayString(args, upperFlg) {
        const values = getArgString(args, upperFlg).split(",");
        for (let i = 0; i < values.length; i++)
            values[i] = values[i].trim();
        return values;
    }
    function getArgArrayFloat(args, min, max) {
        // biome-ignore lint:
        if (arguments.length < 2)
            min = -Infinity;
        // biome-ignore lint:
        if (arguments.length < 3)
            max = Infinity;
        const values = getArgArrayString(args, false).map((s) => 
        // @ts-ignore
        (Number.parseFloat(s) || 0).clamp(min, max));
        return values;
    }
    function getExpansionArea(meta) {
        if (meta) {
            const metaValue = getMetaValues(meta, ["ExpansionArea", "拡大領域"]);
            if (metaValue && typeof metaValue === "string") {
                const aa = getArgArrayFloat(metaValue);
                return aa;
            }
        }
        return [...HM.DefaultArea];
    }
    HM.getExpansionArea = getExpansionArea;
})(HM || (HM = {}));
/*:
 * @target MZ
 * @plugindesc HalfMove拡張
 *
 * @help
 * [機能]
 * ・イベントとプレイヤーの接触判定が行われるように、半歩移動での判定を先に行う
 * ・当たり判定を可視化
 *
 * ※このプラグインはHalfMove.jsの直後に設定してください
 *
 *
 */
(() => {
    "use strict";
    const _Game_CharacterBase_isCollidedWithEvents = Game_CharacterBase.prototype.isCollidedWithEvents;
    Game_CharacterBase.prototype.isCollidedWithEvents = function (x, y) {
        const b = this.isCollidedWithEventsForHalfMove(x, y);
        if (b) {
            return b;
        }
        // NOTE:
        // isCollidedWithEventsForHalfMove()が再度呼び出される可能性もあるが許容
        return _Game_CharacterBase_isCollidedWithEvents.call(this, x, y);
    };
    const _Game_Player_updateNonmoving = Game_Player.prototype.updateNonmoving;
    Game_Player.prototype.updateNonmoving = function (wasMoving, sceneActive) {
        _Game_Player_updateNonmoving.call(this, wasMoving, sceneActive);
        if (wasMoving) {
            this.canPass(this.x, this.y, this.direction());
        }
    };
})();
(() => {
    "use strict";
    if (!Iz.System.isTestMode())
        return;
    const _Sprite_Character_initialize = Sprite_Character.prototype.initialize;
    Sprite_Character.prototype.initialize = function (...args) {
        _Sprite_Character_initialize.call(this, ...args);
        const e = this._character;
        if (e instanceof Game_Event) {
            const area = HM.getExpansionArea(e.event().meta);
            const collider = new HM.Collider({ x: 0.5, y: 0.5, expansionArea: area });
            const w = collider.width * $gameMap.tileWidth();
            const h = collider.height * $gameMap.tileHeight();
            const bitmap = new Bitmap(w, h);
            bitmap.fillAll("blue");
            this._collisionSprite = new Sprite(bitmap);
            this._collisionSprite.anchor.x = 0.5;
            this._collisionSprite.anchor.y = 1;
            this._collisionSprite.opacity = 64;
            this._collisionSprite.y = -(1 - collider.bottom) * $gameMap.tileHeight();
            this._collisionSprite.visible = Iz.Life.parallaxLayerDisable;
            this.addChild(this._collisionSprite);
        }
    };
    const _Sprite_Character_updateVisibility = Sprite_Character.prototype.updateVisibility;
    Sprite_Character.prototype.updateVisibility = function () {
        _Sprite_Character_updateVisibility.call(this);
        if (Iz.Life.parallaxLayerDisable) {
            const e = this._character;
            if (e instanceof Game_Event) {
                if (!e.isTransparent()) {
                    this.visible = true;
                }
            }
        }
    };
})();
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        Life.parallaxLayerDisable = false;
        function updateParallaxLayer(flg) {
            const scene = SceneManager._scene;
            if (!scene)
                return;
            const spriteSet = scene._spriteset;
            if (!spriteSet)
                return;
            const layerSprites = spriteSet._tilemap.children.filter(
            // @ts-ignore
            (c) => !!c.loadLayerBitmap);
            layerSprites.forEach((l) => {
                l._character._layerDisable = flg;
            });
        }
        function setParallaxLayerDisable(flg) {
            if (!Iz.System.isTestMode())
                return;
            Life.parallaxLayerDisable = flg;
            updateParallaxLayer(flg);
        }
        Life.setParallaxLayerDisable = setParallaxLayerDisable;
        if (Iz.System.isTestMode()) {
            const _Game_Event_existPage = Game_Event.prototype.existPage;
            Game_Event.prototype.existPage = function () {
                if (this._layerDisable) {
                    return false;
                }
                return _Game_Event_existPage.call(this);
            };
            const _Scene_Map_createDisplayObjects = Scene_Map.prototype.createDisplayObjects;
            Scene_Map.prototype.createDisplayObjects = function () {
                _Scene_Map_createDisplayObjects.call(this);
                updateParallaxLayer(Life.parallaxLayerDisable);
            };
        }
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
//# sourceMappingURL=HalfMoveEx.js.map