/*:
 * @target MZ
 * @plugindesc パーティクル拡張
 *
 * @help
 * [機能]
 * ・NPCにパーティクルを表示する
 *
 *
 */
(() => {
    const _Game_Particle_pluginCommand = Game_Particle.prototype.pluginCommand;
    Game_Particle.prototype.pluginCommand = function (interpreter, args, eventId) {
        const npcIndex = args.findIndex((data) => {
            if (typeof data === "string") {
                return data.startsWith("npc:");
            }
            return false;
        });
        if (npcIndex >= 0) {
            const splits = args[npcIndex].split(":");
            const characterId = Number(splits[1]);
            if (characterId) {
                const npc = $globalMap.nonPlayer(characterId);
                if (npc) {
                    args[npcIndex] = `event:${npc.eventId()}`;
                }
            }
        }
        _Game_Particle_pluginCommand.call(this, interpreter, args, eventId);
    };
})();
//# sourceMappingURL=TRP_ParticleMZEx.js.map