/*:
 * @target MZ
 * @plugindesc TRP_SkitMZ拡張
 *
 * @command fixedZOrder
 * @text 描画順固定設定
 * @desc 描画順を固定します　固定化中はフォーカス時の前面表示が無効化されます
 *
 * @arg list
 * @text list
 * @desc 指定リスト
 * @type struct<ZOrderData>[]
 *
 *
 * @command clearFixedZOrder
 * @text 描画順の設定を全て削除
 * @desc 描画順の設定を全て削除
 *
 *
 *
 * @help
 * [機能]
 * ・描画順の制御
 * ・Skit終了時にSprite_Pictureの画像読み込みを抑制
 *
 *
 */
/*~struct~ZOrderData:
 * @param actor
 * @text actor
 * @desc アクターID or Skit名
 *
 * @param enable
 * @text enable
 * @desc 描画順固定の有効化
 * @type boolean
 *
 * @param zOrder
 * @text zOrder
 * @desc 描画順(0~10の範囲で指定) 指定がない場合、描画順の変更は行いません
 * @type number
 *
 */
(() => {
    "use strict";
    Skit.prototype.setEnableFixedZOrder = function (actorIdOrName, flg) {
        const name = SkitEx.convertSkitActorName(actorIdOrName);
        const actor = this.actor(name);
        if (!actor)
            return;
        actor.setEnableFixedZOrder(flg);
    };
    Skit.prototype.clearFixedZOrder = function () {
        this.actors()
            .filter((a) => !!a)
            .forEach((a) => {
            a.setEnableFixedZOrder(false);
        });
    };
    const _Skit_end = Skit.prototype.end;
    Skit.prototype.end = function (noAnimation) {
        _Skit_end.call(this, noAnimation);
        this.clearFixedZOrder();
    };
    const _SkitActor_initialize = SkitActor.prototype.initialize;
    SkitActor.prototype.initialize = function (name, pictureId) {
        _SkitActor_initialize.call(this, name, pictureId);
        this._fixedZ = false;
    };
    SkitActor.prototype.setEnableFixedZOrder = function (flg) {
        this._fixedZ = flg;
    };
    const _SkitActor_setZOrder = SkitActor.prototype.setZOrder;
    SkitActor.prototype.setZOrder = function (z) {
        if (this._fixedZ)
            return;
        _SkitActor_setZOrder.call(this, z);
    };
    SkitActor.prototype.setFixedZOrder = function (z) {
        _SkitActor_setZOrder.call(this, z);
    };
    const _SkitActor_show = SkitActor.prototype.show;
    SkitActor.prototype.show = function (position, opacity) {
        const current = this._z;
        _SkitActor_show.call(this, position, opacity);
        if (this._fixedZ) {
            this.setFixedZOrder(current);
        }
    };
})();
var SkitEx;
(function (SkitEx) {
    function convertSkitActorName(actorIdOrName) {
        if (typeof actorIdOrName === "number") {
            return `\\N[${actorIdOrName}]`;
        }
        return actorIdOrName;
    }
    SkitEx.convertSkitActorName = convertSkitActorName;
    function setEnableFixedZOrder(actorIdOrName, flg) {
        $gameSkit.setEnableFixedZOrder(actorIdOrName, flg);
    }
    SkitEx.setEnableFixedZOrder = setEnableFixedZOrder;
    function setFixedZOrder(actorIdOrName, z) {
        const name = convertSkitActorName(actorIdOrName);
        const actor = $gameSkit.actor(name);
        if (!actor)
            return;
        if (z < 0 || z > SkitActor.MAX_Z_ORDER) {
            return;
        }
        actor.setFixedZOrder(z);
    }
    SkitEx.setFixedZOrder = setFixedZOrder;
    function clearFixedZOrder() {
        $gameSkit.clearFixedZOrder();
    }
    SkitEx.clearFixedZOrder = clearFixedZOrder;
})(SkitEx || (SkitEx = {}));
(() => {
    "use strict";
    PluginManagerEx.registerCommand(document.currentScript, "fixedZOrder", (args) => {
        const list = args.list;
        list.forEach((data) => {
            if (typeof data.enable === "boolean") {
                SkitEx.setEnableFixedZOrder(data.actor, data.enable);
            }
            if (typeof data.zOrder === "number") {
                SkitEx.setFixedZOrder(data.actor, data.zOrder);
            }
        });
    });
    PluginManagerEx.registerCommand(document.currentScript, "clearFixedZOrder", (args) => {
        SkitEx.clearFixedZOrder();
    });
})();
//
(() => {
    "use strict";
    function releaseBustPictureBitmaps() {
        for (const url in ImageManager._cache) {
            const starts = "img/pictures/busts/";
            if (!url.startsWith(starts))
                continue;
            const file = url.split(starts)[1];
            if (!file)
                continue;
            const splits = file.split("_");
            const bust = splits[0];
            const exp = splits[1];
            if (exp)
                continue;
            const bitmap = ImageManager._cache[url];
            bitmap._loadListeners = [];
        }
    }
    const _Skit_clear = Skit.prototype.clear;
    Skit.prototype.clear = function () {
        if (this._isSkitOn) {
            releaseBustPictureBitmaps();
        }
        _Skit_clear.call(this);
    };
})();
//# sourceMappingURL=TRP_SkitMZEx.js.map