/*:
 * @target MZ
 * @plugindesc
 *
 * @help
 * TemplateEvent.jsの拡張
 *
 * [機能]
 * ・コマンドでのテンプレートイベントの設定
 * ・\TE{条件}の負荷軽量版 \TEx{条件} を追加
 *
 *
 * [概要]
 * ・\TEx{条件}
 * \TEx{条件}は\TE{条件}の負荷軽量版です
 * eval()を用いた実装を廃止し、単純な数値・文字列比較のみに限定した機能になります
 *
 * \TEx{条件}内では比較対象のオペランドが２個必要です
 * \TEx{3 > 0}
 * \TEx{str1 === str2}
 *
 * １つだけの真偽値判定は使用できません
 * \TEx{3}
 *
 * AndとOr構文が使えます
 * TEx{\sv[grow] > 5 && \sv[hp] <= 0}
 * ※ &&か||のどちらかを１回のみ使えます  a && b && c のように３つ以上連結できません
 *
 * \TE{条件}と同じく制御文字の利用ができます
 * \TEx{\sv[\v[1031]] >= 1}
 *
 *
 * 透明度の判定も行えます
 * \TEx{this.opacity() === 0}
 *
 * ※透明度のように制御文字で表現できない機能は個別対応になります
 *
 *
 *
 * \TEx{条件}内で使える演算子は限定的です　以下が使用可能です
 *
 * 1.比較対象が数値の場合
 * ・ <
 * ・ >
 * ・ <=
 * ・ >=
 * ・ ===
 * ・ !==
 *
 * 2.比較対象が文字列の場合
 * ・ ===
 * ・ !==
 *
 *
 *
 * @command setupTemplate
 * @text setupTemplate
 * @desc テンプレートイベントを設定する
 *
 * @arg templateId
 * @text templateId
 * @desc テンプレートID
 * @type number
 *
 *
 */
(() => {
    "use strict";
    const pluginName = "TemplateEventEx";
    const param = PluginManager.parameters("TemplateEvent");
    function setupTemplateCommand(args) {
        const id = Number.parseInt(args.templateId);
        if (!id || id <= 0) {
            return;
        }
        // @ts-ignore
        const thisObj = this;
        thisObj.character(0).setupTemplate(id);
    }
    PluginManager.registerCommand(pluginName, "setupTemplate", setupTemplateCommand);
    Game_Event.prototype.setupTemplate = function (templateId) {
        const event = this.event();
        const templateEvent = this.getTemplateMapEvents()[templateId];
        if (templateEvent) {
            this._templateId = templateId;
            this._templateEvent = templateEvent;
            this._override =
                param.AutoOverride === "true" ||
                    !!PluginManagerEx.findMetaValue(event, ["TEOverRide", "TE上書き"]);
            const type = Number.parseInt(param.IntegrateNote);
            if (type > 0) {
                this.integrateNote(event, type);
            }
        }
        else {
            if (templateId) {
                console.error(`Invalid templateId : ${templateId}`);
            }
            this._templateId = 0;
            this._templateEvent = null;
            this._override = false;
        }
        // refresh()させるために_pageIndexを変更
        this._pageIndex = -2;
        this.refresh();
    };
    // 簡易な構文解析
    class Parser {
        parse(expr, thisArg) {
            let splits = expr.split(" ");
            if (splits.length < 3) {
                return false;
            }
            splits = splits.map((s) => this.convertString(s, thisArg));
            if (splits[3] === "&&") {
                return (this.evalute(splits[0], splits[2], splits[1]) &&
                    this.evalute(splits[4], splits[6], splits[5]));
            }
            if (splits[3] === "||") {
                return (this.evalute(splits[0], splits[2], splits[1]) ||
                    this.evalute(splits[4], splits[6], splits[5]));
            }
            return this.evalute(splits[0], splits[2], splits[1]);
        }
        // 変換対象の文字列
        convertString(operand_, thisArg) {
            let operand = operand_;
            switch (operand) {
                case "this.opacity()":
                    operand = String(thisArg.opacity());
                    break;
            }
            return operand;
        }
        evalute(lhs, rhs, operator) {
            const lhsNum = Number(lhs);
            const rhsNum = Number(rhs);
            if (Number.isFinite(lhsNum) && Number.isFinite(rhsNum)) {
                return this.evaluateNumbers(lhsNum, rhsNum, operator);
            }
            return this.evaluateStrings(lhs, rhs, operator);
        }
        evaluateNumbers(lhsNum, rhsNum, operator) {
            switch (operator) {
                case "<":
                    return lhsNum < rhsNum;
                case ">":
                    return lhsNum > rhsNum;
                case "<=":
                    return lhsNum <= rhsNum;
                case ">=":
                    return lhsNum >= rhsNum;
                case "===":
                    return lhsNum === rhsNum;
                case "!==":
                    return lhsNum !== rhsNum;
                default:
                    console.warn(`[Number] 未定義の演算子です: ${operator}`);
                    return false;
            }
        }
        evaluateStrings(lhs, rhs, operator) {
            switch (operator) {
                case "===":
                    return lhs === rhs;
                case "!==":
                    return lhs !== rhs;
                default:
                    console.warn(`[String] 未定義の演算子です: ${operator}`);
                    return false;
            }
        }
    }
    const parser = new Parser();
    const _Game_Event_execConditionScriptForSelfVariable = Game_Event.prototype.execConditionScriptForSelfVariable;
    Game_Event.prototype.execConditionScriptForSelfVariable = function (note) {
        const scripts = [];
        note.replace(/\\TEx{(.+?)}/gi, 
        // @ts-ignore
        function () {
            scripts.push(arguments[1]);
        }.bind(this));
        if (scripts.length > 0) {
            return scripts.every((script_) => {
                PluginManagerEx.generateSelfSwitchKey(this._eventId);
                const script = PluginManagerEx.convertVariables(script_, null);
                return parser.parse(script, this);
            });
        }
        return _Game_Event_execConditionScriptForSelfVariable.call(this, note);
    };
})();
//# sourceMappingURL=TemplateEventEx.js.map