// 汎用ダイアログ
var Iz;
(function (Iz) {
    var Life;
    (function (Life) {
        const TitleOffset = 48;
        Life.DialogEvent = {
            OnClickYes: 1,
            OnClickNo: 2,
            OnOpen: 3,
            OnClosed: 4,
        };
        class DialogWindow extends Sprite {
            constructor(option) {
                super();
                this._selectedYes = false;
                this.anchor.set(0.5, 0.5);
                this.create(option);
                this._content.onOpenHandler = () => {
                    this._handler?.(Life.DialogEvent.OnOpen);
                    this.setActive(true);
                };
                this._content.onClosedHandler = () => {
                    this._handler?.(Life.DialogEvent.OnClosed);
                };
                this._active = false;
            }
            create(option) {
                // title
                let titleHeight = 0;
                let title = undefined;
                title = this.createTitle(option.title);
                titleHeight = title.height + TitleOffset;
                // texts
                const texts = this.createTexts(option.text);
                let drawTextsHeight = 0;
                let textsHeight = 0;
                texts.forEach((t) => {
                    textsHeight += t.height;
                });
                const MinTextHeight = 120;
                const isMinOver = textsHeight > MinTextHeight;
                drawTextsHeight = Math.max(MinTextHeight, textsHeight);
                // button
                const buttons = [];
                if (option.no) {
                    const noButton = this.createButton(option.no);
                    buttons.push(noButton);
                    this._no = noButton;
                    this._no.setHandler(() => {
                        this.onClickNo();
                    });
                }
                const yesButton = this.createButton(option.yes);
                buttons.push(yesButton);
                this._yes = yesButton;
                this._yes.setHandler(() => {
                    this.onClickYes();
                });
                const buttonHeight = buttons[0].height;
                // dialog
                const cornerSize = 48;
                const w = option.width ?? 700; // TODO: 自動拡縮
                const h = cornerSize * 2 + titleHeight + drawTextsHeight + buttonHeight;
                const dialog = createCommonDialog(w, h);
                if (title !== undefined) {
                    dialog.addChild(title);
                }
                // Text
                let y = cornerSize + titleHeight; //+Math.floor(textsHeight/(texts.length+1));
                if (isMinOver) {
                    for (let i = 0; i < texts.length; i++) {
                        const t = texts[i];
                        t.relativeAnchor.offset.y = y;
                        dialog.addChild(t);
                        y += t.height;
                    }
                }
                else {
                    y += Math.floor((MinTextHeight - textsHeight) / 2);
                    for (let i = 0; i < texts.length; i++) {
                        const t = texts[i];
                        t.relativeAnchor.offset.y = y;
                        dialog.addChild(t);
                        y += t.height;
                    }
                }
                // Button
                for (let i = 0; i < buttons.length; i++) {
                    const button = buttons[i];
                    button.anchor.set(0.5, 1);
                    button.relativeAnchor.enable = true;
                    button.relativeAnchor.ratio.x = 0;
                    button.relativeAnchor.ratio.y = 1;
                    button.relativeAnchor.offset.y = -cornerSize;
                    button.relativeAnchor.offset.x =
                        Math.floor(dialog.width / (buttons.length + 1)) * (i + 1);
                    dialog.addChild(button);
                }
                this._content = dialog;
                this.addChild(dialog);
            }
            createTitle(title) {
                const base = new Sprite();
                base.setAtlas(Life.ATLAS_KEY_COMMON, Life.FRAME_KEY_COMMON_HEADER_POP);
                base.anchor.set(0.5, 0);
                base.relativeAnchor.enable = true;
                base.relativeAnchor.ratio.x = 0.5;
                base.relativeAnchor.ratio.y = 0;
                base.relativeAnchor.offset.y = TitleOffset;
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON).getFrame(Life.FRAME_KEY_COMMON_HEADER_POP);
                const text = new Sprite_TextEx(frame.width, frame.height);
                text.anchor.set(0.5, 0.5);
                text.relativeAnchor.enable = true;
                text.relativeAnchor.ratio.x = 0.5;
                text.relativeAnchor.ratio.y = 0.5;
                text.setFontSetting(Life.FONT_KEY_DIALOG_DAIRY_SELL_TITLE);
                text.setText(title);
                text.setTextAlign(0.5, 0.5);
                base.addChild(text);
                return base;
            }
            createTexts(text) {
                const texts = text.replaceAll("\\n", "\n").split("\n");
                const res = [];
                for (let i = 0; i < texts.length; i++) {
                    const size = this.textSize(texts[i]);
                    const t = new Sprite_TextEx(size.width, size.height);
                    t.relativeAnchor.enable = true;
                    t.relativeAnchor.ratio.x = 0.5;
                    t.relativeAnchor.ratio.y = 0;
                    t.setFontSetting(Life.FONT_KEY_DIALOG_DAIRY_SELL_TEXT);
                    t.setText(texts[i]);
                    t.setTextAlign(0.5, 0.5);
                    res.push(t);
                }
                return res;
            }
            createButton(param) {
                const off = `btn_${param.color.toString().padStart(2, "0")}`;
                const on = `${off}_on`;
                const b = Iz.ButtonCreator.createPushButton({
                    images: {
                        default: Iz.createButtonBitmapData(Life.ATLAS_KEY_COMMON, off),
                        hovered: Iz.createButtonBitmapData(Life.ATLAS_KEY_COMMON, on),
                        pressed: Iz.createButtonBitmapData(Life.ATLAS_KEY_COMMON, on),
                        selected: Iz.createButtonBitmapData(Life.ATLAS_KEY_COMMON, on),
                    },
                    inputKey: "ok", //param.inputKey,
                });
                const frame = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON).getFrame(Life.FRAME_KEY_COMMON_BTN_01);
                const text = new Sprite_TextEx(frame.width, frame.height);
                text.anchor.set(0.5, 0.5);
                text.relativeAnchor.enable = true;
                text.relativeAnchor.ratio.x = 0.5;
                text.relativeAnchor.ratio.y = 0.5;
                text.setFontSetting(Life.FONT_KEY_DIALOG_DAIRY_SELL_BUTTON);
                text.setText(`${param.text}`);
                text.setTextAlign(0.5, 0.5);
                b.addChild(text);
                return b;
            }
            textSize(text) {
                const t = new Sprite_TextEx();
                const size = t.textSizeEx(text);
                return size;
            }
            onClickYes() {
                this._handler?.(Life.DialogEvent.OnClickYes);
            }
            onClickNo() {
                this._handler?.(Life.DialogEvent.OnClickNo);
            }
            onClickSelected() {
                if (this._no) {
                    if (this._selectedYes) {
                        this.onClickYes();
                    }
                    else {
                        this.onClickNo();
                    }
                }
                else {
                    this.onClickYes();
                }
            }
            setHandler(handler) {
                this._handler = handler;
            }
            update() {
                this.updateInput();
                super.update();
            }
            updateInput() {
                if (!this._active)
                    return;
                if (Input.isTriggered(Iz.IO.KEY_NAME_RIGHT) || Input.isTriggered(Iz.IO.KEY_NAME_LEFT)) {
                    this.changeSelected();
                }
                else if (Input.isTriggered(Iz.IO.KEY_NAME_OK)) {
                    this.onClickSelected();
                }
                else if (Input.isCancelled()) {
                    this.onClickNo();
                }
                else if (this._yes.hovered) {
                    this.setSelected(true);
                }
                else if (this._no?.hovered) {
                    this.setSelected(false);
                }
            }
            refresh() {
                this._yes.selected = this._selectedYes;
                this._yes.opacity = this._selectedYes ? 256 : 192;
                if (this._no) {
                    this._no.selected = !this._selectedYes;
                    this._no.opacity = this._selectedYes ? 192 : 256;
                }
            }
            open() {
                this._content.open(true);
                this.refresh();
                this.setSelectedDefault();
                this.setActive(false);
            }
            close() {
                this._content.close();
                this.setActive(false);
            }
            isClosed() {
                return this._content.isClosed();
            }
            setSelected(yes) {
                this._selectedYes = yes;
                this.refresh();
            }
            setSelectedDefault() {
                this.setSelected(!this._no);
            }
            changeSelected() {
                if (this._no) {
                    this.setSelected(!this._selectedYes);
                }
                else {
                    // 1つしかなければ選択する
                    this.setSelected(true);
                }
            }
            setActive(flg) {
                this._active = flg;
                this._yes.enable = flg;
                if (this._no) {
                    this._no.enable = flg;
                }
            }
            activate() {
                this.setActive(true);
            }
            deactivate() {
                this.setActive(false);
            }
            isActive() {
                return this._active;
            }
        }
        function createCommonDialog(width, height) {
            const window = new Iz.WindowBase(new Rectangle(0, 0, width, height), new Iz.EasingOpenness(Iz.Easing.easeOutBack, Iz.Easing.easeInCubic));
            window.anchor.set(0.5, 0.5);
            // 9slice
            {
                const atlas = Iz.Atlas.getAtlas(Life.ATLAS_KEY_COMMON);
                const frame = atlas.getFrame(Life.FRAME_KEY_COMMON_POPUP_TEXT_BASE);
                const sprite = new NineSliceSprite(atlas.getBitmap());
                sprite.anchor.set(0.5, 0.5);
                sprite.setSlice(52, 52, 52, 52);
                sprite.setBitmapRect(frame.x, frame.y, frame.width, frame.height);
                sprite.setSize(width, height);
                window.addChild(sprite);
            }
            return window;
        }
        Life.createCommonDialog = createCommonDialog;
        class DialogProxy {
            constructor() {
                this.clear();
            }
            open(option) {
                const root = SceneManager._scene?._dialogUI;
                if (!root)
                    return;
                if (this.isBusy())
                    return;
                this._list.push(option);
                const dialog = new DialogWindow(option);
                dialog.setHandler((e) => {
                    this.onHandler(e);
                });
                root.setDialog(dialog);
                dialog.open();
                this._index++;
            }
            async openAsync(option) {
                this.open(option);
                const maxFps = 60;
                const interval = Math.floor(1000 / maxFps);
                await Iz.PromiseEx.waitUntil(() => this.isClosed(), interval);
                return !this._noClicked;
            }
            close() {
                this._accessor?.close();
            }
            isClosed() {
                return this._accessor?.isClosed() ?? true;
            }
            setAccessor(accessor) {
                this._accessor = accessor;
            }
            onHandler(e) {
                switch (e) {
                    case Life.DialogEvent.OnClickYes:
                        this.onClickYes();
                        break;
                    case Life.DialogEvent.OnClickNo:
                        this.onClickNo();
                        break;
                    case Life.DialogEvent.OnOpen:
                        this.onOpen();
                        break;
                    case Life.DialogEvent.OnClosed:
                        this.onClosed();
                        break;
                }
            }
            onClickYes() {
                this.close();
                this._noClicked = false;
                SoundManager.playOk();
            }
            onClickNo() {
                this.close();
                this._noClicked = true;
                SoundManager.playCancel();
            }
            onOpen() { }
            onClosed(no) {
                this._accessor?.clear();
                if (this._list.length <= 0)
                    return;
                const option = this._list.pop();
                if (option) {
                    if (this._noClicked) {
                        option.noHandler?.();
                    }
                    else {
                        option.yesHandler?.();
                    }
                }
                this._index--;
            }
            isBusy() {
                return this._index >= 0;
            }
            clear() {
                this._list = [];
                this._index = -1;
                this._noClicked = false;
            }
        }
        class DialogUI extends Sprite {
            constructor() {
                const bitmap = new Bitmap(16, 16);
                // bitmap.fillAll("red");   // 確認用
                super(bitmap);
                this.createBg();
            }
            createBg() {
                const bitmap = new Bitmap(Graphics.width, Graphics.height);
                bitmap.fillAll("black");
                this._bg = new Sprite(bitmap);
                this._bg.anchor.set(0.5, 0.5);
                this._bg.alpha = 0.5;
                this._bg.visible = false;
                this.addChild(this._bg);
            }
            setDialog(dialog) {
                this._dialog = dialog;
                this.addChild(dialog);
                this._bg.visible = true;
            }
            isClosed() {
                return this._dialog?.isClosed() ?? true;
            }
            close() {
                this._dialog?.close();
            }
            clear() {
                if (this._dialog) {
                    this.removeChild(this._dialog);
                }
                this._dialog = undefined;
                this._bg.visible = false;
            }
        }
        Life.DialogUI = DialogUI;
        function createDialogOption(dialogId) {
            const data = $dataDialog.get(dialogId);
            if (!data)
                return undefined;
            const option = {
                title: data.title,
                text: data.text,
                width: data.width,
                yes: {
                    color: data.yes_color,
                    text: data.yes_text,
                    inputKey: "",
                },
            };
            if (data.no_text && data.no_color) {
                option.no = {
                    color: data.no_color,
                    text: data.no_text,
                    inputKey: "",
                };
            }
            return option;
        }
        Life.createDialogOption = createDialogOption;
        Life.Dialog = new DialogProxy();
    })(Life = Iz.Life || (Iz.Life = {}));
})(Iz || (Iz = {}));
(() => {
    "use strict";
    Scene_Base.prototype.createDialogUI = function () {
        Iz.Life.Dialog.clear();
        const dialogUI = new Iz.Life.DialogUI();
        dialogUI.anchor.set(0.5, 0.5);
        dialogUI.x = Math.floor(Graphics.width / 2);
        dialogUI.y = Math.floor(Graphics.height / 2);
        this.addChild(dialogUI);
        this._dialogUI = dialogUI;
        Iz.Life.Dialog.setAccessor(dialogUI);
    };
    const _Scene_Map_onMapLoaded = Scene_Map.prototype.onMapLoaded;
    Scene_Map.prototype.onMapLoaded = function () {
        _Scene_Map_onMapLoaded.call(this);
        this.createDialogUI();
    };
    const _Scene_Base_terminate = Scene_Base.prototype.terminate;
    Scene_Base.prototype.terminate = function () {
        _Scene_Base_terminate.call(this);
        Iz.Life.Dialog.setAccessor(undefined);
    };
    const _Game_Interpreter_updatwWait = Game_Interpreter.prototype.updateWait;
    Game_Interpreter.prototype.updateWait = function () {
        if (Iz.Life.Dialog.isBusy()) {
            return true;
        }
        return _Game_Interpreter_updatwWait.call(this);
    };
})();
//# sourceMappingURL=Dialog.js.map